
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import Jama
import java.io
import java.lang
import java.util
import jpype
import jneqsim.neqsim.statistics.parameterfitting.nonlinearparameterfitting
import jneqsim.neqsim.thermo.system
import jneqsim.neqsim.thermodynamicoperations
import typing



class FunctionInterface(java.lang.Cloneable):
    def calcTrueValue(self, double: float) -> float: ...
    def calcValue(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> float: ...
    def clone(self) -> 'FunctionInterface': ...
    def getBounds(self) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    @typing.overload
    def getFittingParams(self, int: int) -> float: ...
    @typing.overload
    def getFittingParams(self) -> typing.MutableSequence[float]: ...
    def getLowerBound(self, int: int) -> float: ...
    def getNumberOfFittingParams(self) -> int: ...
    def getSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def getUpperBound(self, int: int) -> float: ...
    def setBounds(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def setDatabaseParameters(self) -> None: ...
    def setFittingParams(self, int: int, double: float) -> None: ...
    def setInitialGuess(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setThermodynamicSystem(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...

class NumericalDerivative(java.io.Serializable):
    @staticmethod
    def calcDerivative(statisticsBaseClass: 'StatisticsBaseClass', int: int, int2: int) -> float: ...

class SampleSet(java.lang.Cloneable):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, arrayList: java.util.ArrayList['SampleValue']): ...
    @typing.overload
    def __init__(self, sampleValueArray: typing.Union[typing.List['SampleValue'], jpype.JArray]): ...
    def add(self, sampleValue: 'SampleValue') -> None: ...
    def addSampleSet(self, sampleSet: 'SampleSet') -> None: ...
    def clone(self) -> 'SampleSet': ...
    def createNewNormalDistributedSet(self) -> 'SampleSet': ...
    def getLength(self) -> int: ...
    def getSample(self, int: int) -> 'SampleValue': ...

class SampleValue(java.lang.Cloneable):
    system: jneqsim.neqsim.thermo.system.SystemInterface = ...
    thermoOps: jneqsim.neqsim.thermodynamicoperations.ThermodynamicOperations = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float, doubleArray: typing.Union[typing.List[float], jpype.JArray]): ...
    @typing.overload
    def __init__(self, double: float, double2: float, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray]): ...
    def clone(self) -> 'SampleValue': ...
    def getDependentValue(self, int: int) -> float: ...
    def getDependentValues(self) -> typing.MutableSequence[float]: ...
    def getDescription(self) -> java.lang.String: ...
    def getFunction(self) -> FunctionInterface: ...
    def getReference(self) -> java.lang.String: ...
    def getSampleValue(self) -> float: ...
    @typing.overload
    def getStandardDeviation(self) -> float: ...
    @typing.overload
    def getStandardDeviation(self, int: int) -> float: ...
    def setDependentValue(self, int: int, double: float) -> None: ...
    def setDependentValues(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setDescription(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setFunction(self, baseFunction: 'BaseFunction') -> None: ...
    def setReference(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setThermodynamicSystem(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...

class StatisticsInterface:
    def createNewRandomClass(self) -> 'StatisticsBaseClass': ...
    def displayCurveFit(self) -> None: ...
    def displayResult(self) -> None: ...
    def getNumberOfTuningParameters(self) -> int: ...
    def getSampleSet(self) -> SampleSet: ...
    def init(self) -> None: ...
    def runMonteCarloSimulation(self, int: int) -> None: ...
    def setNumberOfTuningParameters(self, int: int) -> None: ...
    def solve(self) -> None: ...
    def writeToTextFile(self, string: typing.Union[java.lang.String, str]) -> None: ...

class BaseFunction(FunctionInterface):
    params: typing.MutableSequence[float] = ...
    bounds: typing.MutableSequence[typing.MutableSequence[float]] = ...
    system: jneqsim.neqsim.thermo.system.SystemInterface = ...
    thermoOps: jneqsim.neqsim.thermodynamicoperations.ThermodynamicOperations = ...
    def __init__(self): ...
    def calcTrueValue(self, double: float) -> float: ...
    def calcValue(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> float: ...
    def clone(self) -> 'BaseFunction': ...
    def getBounds(self) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    @typing.overload
    def getFittingParams(self, int: int) -> float: ...
    @typing.overload
    def getFittingParams(self) -> typing.MutableSequence[float]: ...
    def getLowerBound(self, int: int) -> float: ...
    def getNumberOfFittingParams(self) -> int: ...
    def getSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def getUpperBound(self, int: int) -> float: ...
    def setBounds(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def setDatabaseParameters(self) -> None: ...
    def setFittingParams(self, int: int, double: float) -> None: ...
    def setInitialGuess(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setThermodynamicSystem(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...

class StatisticsBaseClass(java.lang.Cloneable, StatisticsInterface):
    def __init__(self): ...
    def addSampleSet(self, sampleSet: SampleSet) -> None: ...
    def calcAbsDev(self) -> None: ...
    def calcAlphaMatrix(self) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def calcBetaMatrix(self) -> typing.MutableSequence[float]: ...
    def calcChiSquare(self) -> float: ...
    def calcCoVarianceMatrix(self) -> None: ...
    def calcCorrelationMatrix(self) -> None: ...
    def calcDerivatives(self) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def calcDeviation(self) -> None: ...
    def calcParameterStandardDeviation(self) -> None: ...
    def calcParameterUncertainty(self) -> None: ...
    @typing.overload
    def calcTrueValue(self, double: float, sampleValue: SampleValue) -> float: ...
    @typing.overload
    def calcTrueValue(self, sampleValue: SampleValue) -> float: ...
    def calcValue(self, sampleValue: SampleValue) -> float: ...
    def checkBounds(self, matrix: Jama.Matrix) -> None: ...
    def clone(self) -> 'StatisticsBaseClass': ...
    def createNewRandomClass(self) -> 'StatisticsBaseClass': ...
    def displayCurveFit(self) -> None: ...
    def displayMatrix(self, matrix: Jama.Matrix, string: typing.Union[java.lang.String, str], int: int) -> None: ...
    def displayResult(self) -> None: ...
    def displayResultWithDeviation(self) -> None: ...
    def displaySimple(self) -> None: ...
    def displayValues(self) -> None: ...
    def getNumberOfTuningParameters(self) -> int: ...
    def getSample(self, int: int) -> SampleValue: ...
    def getSampleSet(self) -> SampleSet: ...
    def init(self) -> None: ...
    @typing.overload
    def runMonteCarloSimulation(self) -> None: ...
    @typing.overload
    def runMonteCarloSimulation(self, int: int) -> None: ...
    def setFittingParameter(self, int: int, double: float) -> None: ...
    def setFittingParameters(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setNumberOfTuningParameters(self, int: int) -> None: ...
    def setSampleSet(self, sampleSet: SampleSet) -> None: ...
    def solve(self) -> None: ...
    def writeToTextFile(self, string: typing.Union[java.lang.String, str]) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.statistics.parameterfitting")``.

    BaseFunction: typing.Type[BaseFunction]
    FunctionInterface: typing.Type[FunctionInterface]
    NumericalDerivative: typing.Type[NumericalDerivative]
    SampleSet: typing.Type[SampleSet]
    SampleValue: typing.Type[SampleValue]
    StatisticsBaseClass: typing.Type[StatisticsBaseClass]
    StatisticsInterface: typing.Type[StatisticsInterface]
    nonlinearparameterfitting: jneqsim.neqsim.statistics.parameterfitting.nonlinearparameterfitting.__module_protocol__
