
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import jpype
import jneqsim.neqsim.statistics.parameterfitting
import typing



class LevenbergMarquardt(jneqsim.neqsim.statistics.parameterfitting.StatisticsBaseClass):
    def __init__(self): ...
    def clone(self) -> 'LevenbergMarquardt': ...
    def getMaxNumberOfIterations(self) -> int: ...
    def init(self) -> None: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def setMaxNumberOfIterations(self, int: int) -> None: ...
    def solve(self) -> None: ...

class LevenbergMarquardtFunction(jneqsim.neqsim.statistics.parameterfitting.BaseFunction):
    def __init__(self): ...
    def calcValue(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> float: ...
    @typing.overload
    def getFittingParams(self, int: int) -> float: ...
    @typing.overload
    def getFittingParams(self) -> typing.MutableSequence[float]: ...
    def getNumberOfFittingParams(self) -> int: ...
    def setFittingParam(self, int: int, double: float) -> None: ...
    @typing.overload
    def setFittingParams(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    @typing.overload
    def setFittingParams(self, int: int, double: float) -> None: ...

class LevenbergMarquardtAbsDev(LevenbergMarquardt):
    def __init__(self): ...
    def calcAlphaMatrix(self) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def calcBetaMatrix(self) -> typing.MutableSequence[float]: ...
    def calcChiSquare(self) -> float: ...
    def clone(self) -> 'LevenbergMarquardtAbsDev': ...

class LevenbergMarquardtBiasDev(LevenbergMarquardt):
    def __init__(self): ...
    def calcAlphaMatrix(self) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def calcBetaMatrix(self) -> typing.MutableSequence[float]: ...
    def calcChiSquare(self) -> float: ...
    def clone(self) -> 'LevenbergMarquardtBiasDev': ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.statistics.parameterfitting.nonlinearparameterfitting")``.

    LevenbergMarquardt: typing.Type[LevenbergMarquardt]
    LevenbergMarquardtAbsDev: typing.Type[LevenbergMarquardtAbsDev]
    LevenbergMarquardtBiasDev: typing.Type[LevenbergMarquardtBiasDev]
    LevenbergMarquardtFunction: typing.Type[LevenbergMarquardtFunction]
