
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import java.util
import jpype
import jneqsim.neqsim.thermo
import jneqsim.neqsim.thermo.atomelement
import jneqsim.neqsim.thermo.component.attractiveeosterm
import jneqsim.neqsim.thermo.component.repulsiveeosterm
import jneqsim.neqsim.thermo.phase
import typing



class ComponentInterface(jneqsim.neqsim.thermo.ThermodynamicConstantsInterface, java.lang.Cloneable):
    def Finit(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, double: float, double2: float, double3: float, double4: float, int: int, int2: int) -> None: ...
    def addMoles(self, double: float) -> None: ...
    @typing.overload
    def addMolesChemReac(self, double: float, double2: float) -> None: ...
    @typing.overload
    def addMolesChemReac(self, double: float) -> None: ...
    def calcActivity(self) -> bool: ...
    def clone(self) -> 'ComponentInterface': ...
    def createComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def doSolidCheck(self) -> bool: ...
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def fugcoefDiffPresNumeric(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def fugcoefDiffTempNumeric(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def getAcentricFactor(self) -> float: ...
    def getAntoineASolid(self) -> float: ...
    def getAntoineBSolid(self) -> float: ...
    def getAntoineCSolid(self) -> float: ...
    def getAntoineVaporPressure(self, double: float) -> float: ...
    def getAntoineVaporPressuredT(self, double: float) -> float: ...
    def getAntoineVaporTemperature(self, double: float) -> float: ...
    def getAssociationEnergy(self) -> float: ...
    def getAssociationEnergySAFT(self) -> float: ...
    def getAssociationScheme(self) -> java.lang.String: ...
    def getAssociationVolume(self) -> float: ...
    def getAssociationVolumeSAFT(self) -> float: ...
    def getAttractiveTerm(self) -> jneqsim.neqsim.thermo.component.attractiveeosterm.AttractiveTermInterface: ...
    def getAttractiveTermNumber(self) -> int: ...
    def getCASnumber(self) -> java.lang.String: ...
    def getCCsolidVaporPressure(self, double: float) -> float: ...
    def getCCsolidVaporPressuredT(self, double: float) -> float: ...
    @typing.overload
    def getChemicalPotential(self, double: float, double2: float) -> float: ...
    @typing.overload
    def getChemicalPotential(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getChemicalPotentialIdealReference(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getChemicalPotentialdN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getChemicalPotentialdNTV(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getChemicalPotentialdP(self) -> float: ...
    def getChemicalPotentialdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getChemicalPotentialdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getComponentName(self) -> java.lang.String: ...
    @staticmethod
    def getComponentNameFromAlias(string: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @staticmethod
    def getComponentNameMap() -> java.util.LinkedHashMap[java.lang.String, java.lang.String]: ...
    def getComponentNumber(self) -> int: ...
    def getComponentType(self) -> java.lang.String: ...
    def getCp0(self, double: float) -> float: ...
    def getCpA(self) -> float: ...
    def getCpB(self) -> float: ...
    def getCpC(self) -> float: ...
    def getCpD(self) -> float: ...
    def getCpE(self) -> float: ...
    def getCriticalCompressibilityFactor(self) -> float: ...
    def getCriticalViscosity(self) -> float: ...
    def getCriticalVolume(self) -> float: ...
    def getCv0(self, double: float) -> float: ...
    def getDebyeDipoleMoment(self) -> float: ...
    def getDiElectricConstant(self, double: float) -> float: ...
    def getDiElectricConstantdT(self, double: float) -> float: ...
    def getDiElectricConstantdTdT(self, double: float) -> float: ...
    def getElements(self) -> jneqsim.neqsim.thermo.atomelement.Element: ...
    def getEnthalpy(self, double: float) -> float: ...
    def getEntropy(self, double: float, double2: float) -> float: ...
    def getEpsikSAFT(self) -> float: ...
    def getFlowRate(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getFormulae(self) -> java.lang.String: ...
    def getFugacityCoefficient(self) -> float: ...
    def getGibbsEnergy(self, double: float, double2: float) -> float: ...
    def getGibbsEnergyOfFormation(self) -> float: ...
    def getGresTP(self, double: float) -> float: ...
    def getHID(self, double: float) -> float: ...
    def getHeatOfFusion(self) -> float: ...
    def getHeatOfVapourization(self, double: float) -> float: ...
    def getHenryCoef(self, double: float) -> float: ...
    def getHenryCoefParameter(self) -> typing.MutableSequence[float]: ...
    def getHenryCoefdT(self, double: float) -> float: ...
    def getHresTP(self, double: float) -> float: ...
    def getHsub(self) -> float: ...
    def getIdEntropy(self, double: float) -> float: ...
    def getIdealGasAbsoluteEntropy(self) -> float: ...
    def getIdealGasEnthalpyOfFormation(self) -> float: ...
    def getIdealGasGibbsEnergyOfFormation(self) -> float: ...
    def getIndex(self) -> int: ...
    def getIonicCharge(self) -> float: ...
    def getK(self) -> float: ...
    def getLennardJonesEnergyParameter(self) -> float: ...
    def getLennardJonesMolecularDiameter(self) -> float: ...
    def getLiquidConductivityParameter(self, int: int) -> float: ...
    def getLiquidViscosityModel(self) -> int: ...
    def getLiquidViscosityParameter(self, int: int) -> float: ...
    def getLogFugacityCoefficient(self) -> float: ...
    def getMatiascopemanParams(self) -> typing.MutableSequence[float]: ...
    def getMatiascopemanSolidParams(self) -> typing.MutableSequence[float]: ...
    def getMeltingPointTemperature(self) -> float: ...
    def getMolality(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    @typing.overload
    def getMolarMass(self) -> float: ...
    @typing.overload
    def getMolarMass(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getMolarity(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getName(self) -> java.lang.String: ...
    @typing.overload
    def getNormalBoilingPoint(self) -> float: ...
    @typing.overload
    def getNormalBoilingPoint(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getNormalLiquidDensity(self) -> float: ...
    @typing.overload
    def getNormalLiquidDensity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getNumberOfAssociationSites(self) -> int: ...
    def getNumberOfMolesInPhase(self) -> float: ...
    def getNumberOfmoles(self) -> float: ...
    def getOrginalNumberOfAssociationSites(self) -> int: ...
    @typing.overload
    def getPC(self) -> float: ...
    @typing.overload
    def getPC(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getParachorParameter(self) -> float: ...
    def getPaulingAnionicDiameter(self) -> float: ...
    def getPureComponentCpLiquid(self, double: float) -> float: ...
    def getPureComponentCpSolid(self, double: float) -> float: ...
    def getPureComponentHeatOfVaporization(self, double: float) -> float: ...
    def getPureComponentLiquidDensity(self, double: float) -> float: ...
    def getPureComponentSolidDensity(self, double: float) -> float: ...
    def getRacketZ(self) -> float: ...
    def getRacketZCPA(self) -> float: ...
    def getRate(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getReferencePotential(self) -> float: ...
    def getReferenceStateType(self) -> java.lang.String: ...
    def getSchwartzentruberParams(self) -> typing.MutableSequence[float]: ...
    def getSigmaSAFTi(self) -> float: ...
    def getSolidVaporPressure(self, double: float) -> float: ...
    def getSolidVaporPressuredT(self, double: float) -> float: ...
    def getSphericalCoreRadius(self) -> float: ...
    def getSresTP(self, double: float) -> float: ...
    def getStokesCationicDiameter(self) -> float: ...
    def getSurfTensInfluenceParam(self, int: int) -> float: ...
    def getSurfaceTenisionInfluenceParameter(self, double: float) -> float: ...
    @typing.overload
    def getTC(self) -> float: ...
    @typing.overload
    def getTC(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getTotalFlowRate(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getTriplePointDensity(self) -> float: ...
    def getTriplePointPressure(self) -> float: ...
    def getTriplePointTemperature(self) -> float: ...
    def getTwuCoonParams(self) -> typing.MutableSequence[float]: ...
    def getViscosityCorrectionFactor(self) -> float: ...
    def getVoli(self) -> float: ...
    def getVolumeCorrection(self) -> float: ...
    def getVolumeCorrectionConst(self) -> float: ...
    def getVolumeCorrectionT(self) -> float: ...
    def getVolumeCorrectionT_CPA(self) -> float: ...
    def getdfugdn(self, int: int) -> float: ...
    def getdfugdp(self) -> float: ...
    def getdfugdt(self) -> float: ...
    def getdfugdx(self, int: int) -> float: ...
    def getdrhodN(self) -> float: ...
    def getmSAFTi(self) -> float: ...
    def getx(self) -> float: ...
    def getz(self) -> float: ...
    def init(self, double: float, double2: float, double3: float, double4: float, int: int) -> None: ...
    def insertComponentIntoDatabase(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def isHydrateFormer(self) -> bool: ...
    def isHydrocarbon(self) -> bool: ...
    def isInert(self) -> bool: ...
    def isIsIon(self) -> bool: ...
    def isIsNormalComponent(self) -> bool: ...
    def isIsPlusFraction(self) -> bool: ...
    def isIsTBPfraction(self) -> bool: ...
    def isWaxFormer(self) -> bool: ...
    def logfugcoefdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> typing.MutableSequence[float]: ...
    def logfugcoefdNi(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int) -> float: ...
    def logfugcoefdP(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def logfugcoefdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def reducedPressure(self, double: float) -> float: ...
    def reducedTemperature(self, double: float) -> float: ...
    def setAcentricFactor(self, double: float) -> None: ...
    def setAntoineASolid(self, double: float) -> None: ...
    def setAntoineBSolid(self, double: float) -> None: ...
    def setAntoineCSolid(self, double: float) -> None: ...
    def setAssociationEnergy(self, double: float) -> None: ...
    def setAssociationEnergySAFT(self, double: float) -> None: ...
    def setAssociationScheme(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setAssociationVolume(self, double: float) -> None: ...
    def setAssociationVolumeSAFT(self, double: float) -> None: ...
    def setAttractiveTerm(self, int: int) -> None: ...
    def setCASnumber(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setComponentName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setComponentNumber(self, int: int) -> None: ...
    def setComponentType(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setCpA(self, double: float) -> None: ...
    def setCpB(self, double: float) -> None: ...
    def setCpC(self, double: float) -> None: ...
    def setCpD(self, double: float) -> None: ...
    def setCpE(self, double: float) -> None: ...
    def setCriticalCompressibilityFactor(self, double: float) -> None: ...
    def setCriticalViscosity(self, double: float) -> None: ...
    def setCriticalVolume(self, double: float) -> None: ...
    def setEpsikSAFT(self, double: float) -> None: ...
    def setFormulae(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setFugacityCoefficient(self, double: float) -> None: ...
    def setHeatOfFusion(self, double: float) -> None: ...
    def setHenryCoefParameter(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setIdealGasEnthalpyOfFormation(self, double: float) -> None: ...
    def setIsHydrateFormer(self, boolean: bool) -> None: ...
    def setIsIon(self, boolean: bool) -> None: ...
    def setIsNormalComponent(self, boolean: bool) -> None: ...
    def setIsPlusFraction(self, boolean: bool) -> None: ...
    def setIsTBPfraction(self, boolean: bool) -> None: ...
    def setK(self, double: float) -> None: ...
    def setLennardJonesEnergyParameter(self, double: float) -> None: ...
    def setLennardJonesMolecularDiameter(self, double: float) -> None: ...
    def setLiquidConductivityParameter(self, double: float, int: int) -> None: ...
    def setLiquidViscosityModel(self, int: int) -> None: ...
    def setLiquidViscosityParameter(self, double: float, int: int) -> None: ...
    @typing.overload
    def setMatiascopemanParams(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    @typing.overload
    def setMatiascopemanParams(self, int: int, double: float) -> None: ...
    @typing.overload
    def setMolarMass(self, double: float) -> None: ...
    @typing.overload
    def setMolarMass(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setNormalBoilingPoint(self, double: float) -> None: ...
    def setNormalLiquidDensity(self, double: float) -> None: ...
    def setNumberOfAssociationSites(self, int: int) -> None: ...
    def setNumberOfMolesInPhase(self, double: float) -> None: ...
    def setNumberOfmoles(self, double: float) -> None: ...
    @typing.overload
    def setPC(self, double: float) -> None: ...
    @typing.overload
    def setPC(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setParachorParameter(self, double: float) -> None: ...
    def setProperties(self, componentInterface: 'ComponentInterface') -> None: ...
    def setRacketZ(self, double: float) -> None: ...
    def setRacketZCPA(self, double: float) -> None: ...
    def setReferencePotential(self, double: float) -> None: ...
    def setSchwartzentruberParams(self, int: int, double: float) -> None: ...
    def setSigmaSAFTi(self, double: float) -> None: ...
    def setSolidCheck(self, boolean: bool) -> None: ...
    def setSphericalCoreRadius(self, double: float) -> None: ...
    def setStokesCationicDiameter(self, double: float) -> None: ...
    def setSurfTensInfluenceParam(self, int: int, double: float) -> None: ...
    @typing.overload
    def setTC(self, double: float) -> None: ...
    @typing.overload
    def setTC(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setTriplePointTemperature(self, double: float) -> None: ...
    def setTwuCoonParams(self, int: int, double: float) -> None: ...
    def setViscosityAssociationFactor(self, double: float) -> None: ...
    def setVolumeCorrectionConst(self, double: float) -> None: ...
    def setVolumeCorrectionT(self, double: float) -> None: ...
    def setVolumeCorrectionT_CPA(self, double: float) -> None: ...
    def setWaxFormer(self, boolean: bool) -> None: ...
    def seta(self, double: float) -> None: ...
    def setb(self, double: float) -> None: ...
    def setdfugdn(self, int: int, double: float) -> None: ...
    def setdfugdp(self, double: float) -> None: ...
    def setdfugdt(self, double: float) -> None: ...
    def setdfugdx(self, int: int, double: float) -> None: ...
    def setmSAFTi(self, double: float) -> None: ...
    def setx(self, double: float) -> None: ...
    def setz(self, double: float) -> None: ...

class Component(ComponentInterface):
    dfugdx: typing.MutableSequence[float] = ...
    @typing.overload
    def __init__(self, int: int, double: float, double2: float, double3: float, double4: float, double5: float): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def Finit(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, double: float, double2: float, double3: float, double4: float, int: int, int2: int) -> None: ...
    @typing.overload
    def addMolesChemReac(self, double: float) -> None: ...
    @typing.overload
    def addMolesChemReac(self, double: float, double2: float) -> None: ...
    def calcActivity(self) -> bool: ...
    def clone(self) -> 'Component': ...
    def createComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def doSolidCheck(self) -> bool: ...
    def equals(self, object: typing.Any) -> bool: ...
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def fugcoefDiffPresNumeric(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def fugcoefDiffTempNumeric(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def getAcentricFactor(self) -> float: ...
    def getAntoineASolid(self) -> float: ...
    def getAntoineBSolid(self) -> float: ...
    def getAntoineCSolid(self) -> float: ...
    def getAntoineVaporPressure(self, double: float) -> float: ...
    def getAntoineVaporPressuredT(self, double: float) -> float: ...
    def getAntoineVaporTemperature(self, double: float) -> float: ...
    def getAssociationEnergy(self) -> float: ...
    def getAssociationEnergySAFT(self) -> float: ...
    def getAssociationScheme(self) -> java.lang.String: ...
    def getAssociationVolume(self) -> float: ...
    def getAssociationVolumeSAFT(self) -> float: ...
    def getAttractiveTerm(self) -> jneqsim.neqsim.thermo.component.attractiveeosterm.AttractiveTermInterface: ...
    def getAttractiveTermNumber(self) -> int: ...
    def getCASnumber(self) -> java.lang.String: ...
    def getCCsolidVaporPressure(self, double: float) -> float: ...
    def getCCsolidVaporPressuredT(self, double: float) -> float: ...
    @typing.overload
    def getChemicalPotential(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    @typing.overload
    def getChemicalPotential(self, double: float, double2: float) -> float: ...
    def getChemicalPotentialIdealReference(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getChemicalPotentialdN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getChemicalPotentialdNTV(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    @typing.overload
    def getChemicalPotentialdP(self) -> float: ...
    @typing.overload
    def getChemicalPotentialdP(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getChemicalPotentialdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getChemicalPotentialdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getComponentName(self) -> java.lang.String: ...
    def getComponentNumber(self) -> int: ...
    def getComponentType(self) -> java.lang.String: ...
    def getCp0(self, double: float) -> float: ...
    def getCpA(self) -> float: ...
    def getCpB(self) -> float: ...
    def getCpC(self) -> float: ...
    def getCpD(self) -> float: ...
    def getCpE(self) -> float: ...
    def getCriticalCompressibilityFactor(self) -> float: ...
    def getCriticalViscosity(self) -> float: ...
    def getCriticalVolume(self) -> float: ...
    def getCv0(self, double: float) -> float: ...
    def getDebyeDipoleMoment(self) -> float: ...
    def getDiElectricConstant(self, double: float) -> float: ...
    def getDiElectricConstantdT(self, double: float) -> float: ...
    def getDiElectricConstantdTdT(self, double: float) -> float: ...
    def getElements(self) -> jneqsim.neqsim.thermo.atomelement.Element: ...
    def getEnthalpy(self, double: float) -> float: ...
    def getEntropy(self, double: float, double2: float) -> float: ...
    def getEpsikSAFT(self) -> float: ...
    def getFlowRate(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getFormulae(self) -> java.lang.String: ...
    def getFugacityCoefficient(self) -> float: ...
    def getFugacitydN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getGibbsEnergy(self, double: float, double2: float) -> float: ...
    def getGibbsEnergyOfFormation(self) -> float: ...
    def getGresTP(self, double: float) -> float: ...
    def getHID(self, double: float) -> float: ...
    def getHeatOfFusion(self) -> float: ...
    def getHeatOfVapourization(self, double: float) -> float: ...
    def getHenryCoef(self, double: float) -> float: ...
    def getHenryCoefParameter(self) -> typing.MutableSequence[float]: ...
    def getHenryCoefdT(self, double: float) -> float: ...
    def getHresTP(self, double: float) -> float: ...
    def getHsub(self) -> float: ...
    def getIdEntropy(self, double: float) -> float: ...
    def getIdealGasAbsoluteEntropy(self) -> float: ...
    def getIdealGasEnthalpyOfFormation(self) -> float: ...
    def getIdealGasGibbsEnergyOfFormation(self) -> float: ...
    def getIndex(self) -> int: ...
    def getIonicCharge(self) -> float: ...
    def getIonicDiameter(self) -> float: ...
    def getK(self) -> float: ...
    def getLennardJonesEnergyParameter(self) -> float: ...
    def getLennardJonesMolecularDiameter(self) -> float: ...
    def getLiquidConductivityParameter(self, int: int) -> float: ...
    def getLiquidViscosityModel(self) -> int: ...
    def getLiquidViscosityParameter(self, int: int) -> float: ...
    @typing.overload
    def getMatiascopemanParams(self, int: int) -> float: ...
    @typing.overload
    def getMatiascopemanParams(self) -> typing.MutableSequence[float]: ...
    def getMatiascopemanParamsPR(self) -> typing.MutableSequence[float]: ...
    def getMatiascopemanParamsUMRPRU(self) -> typing.MutableSequence[float]: ...
    def getMatiascopemanSolidParams(self) -> typing.MutableSequence[float]: ...
    def getMeltingPointTemperature(self) -> float: ...
    def getMolality(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    @typing.overload
    def getMolarMass(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getMolarMass(self) -> float: ...
    def getMolarity(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getName(self) -> java.lang.String: ...
    @typing.overload
    def getNormalBoilingPoint(self) -> float: ...
    @typing.overload
    def getNormalBoilingPoint(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getNormalLiquidDensity(self) -> float: ...
    @typing.overload
    def getNormalLiquidDensity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getNumberOfAssociationSites(self) -> int: ...
    def getNumberOfMolesInPhase(self) -> float: ...
    def getNumberOfmoles(self) -> float: ...
    def getOrginalNumberOfAssociationSites(self) -> int: ...
    @typing.overload
    def getPC(self) -> float: ...
    @typing.overload
    def getPC(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getParachorParameter(self) -> float: ...
    def getPaulingAnionicDiameter(self) -> float: ...
    def getPureComponentCpLiquid(self, double: float) -> float: ...
    def getPureComponentCpSolid(self, double: float) -> float: ...
    def getPureComponentHeatOfVaporization(self, double: float) -> float: ...
    def getPureComponentLiquidDensity(self, double: float) -> float: ...
    def getPureComponentSolidDensity(self, double: float) -> float: ...
    def getRacketZ(self) -> float: ...
    def getRacketZCPA(self) -> float: ...
    def getRate(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getReferenceEnthalpy(self) -> float: ...
    def getReferencePotential(self) -> float: ...
    def getReferenceStateType(self) -> java.lang.String: ...
    def getSchwartzentruberParams(self) -> typing.MutableSequence[float]: ...
    def getSigmaSAFTi(self) -> float: ...
    def getSolidVaporPressure(self, double: float) -> float: ...
    def getSolidVaporPressuredT(self, double: float) -> float: ...
    def getSphericalCoreRadius(self) -> float: ...
    def getSresTP(self, double: float) -> float: ...
    def getStandardDensity(self) -> float: ...
    def getStokesCationicDiameter(self) -> float: ...
    def getSurfTensInfluenceParam(self, int: int) -> float: ...
    def getSurfaceTenisionInfluenceParameter(self, double: float) -> float: ...
    @typing.overload
    def getTC(self) -> float: ...
    @typing.overload
    def getTC(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getTotalFlowRate(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getTriplePointDensity(self) -> float: ...
    def getTriplePointPressure(self) -> float: ...
    def getTriplePointTemperature(self) -> float: ...
    def getTwuCoonParams(self) -> typing.MutableSequence[float]: ...
    def getViscosityCorrectionFactor(self) -> float: ...
    def getVoli(self) -> float: ...
    def getVolumeCorrection(self) -> float: ...
    def getVolumeCorrectionConst(self) -> float: ...
    def getVolumeCorrectionT(self) -> float: ...
    def getVolumeCorrectionT_CPA(self) -> float: ...
    def getdfugdn(self, int: int) -> float: ...
    def getdfugdp(self) -> float: ...
    def getdfugdt(self) -> float: ...
    def getdfugdx(self, int: int) -> float: ...
    def getdrhodN(self) -> float: ...
    def getmSAFTi(self) -> float: ...
    def getx(self) -> float: ...
    def getz(self) -> float: ...
    def init(self, double: float, double2: float, double3: float, double4: float, int: int) -> None: ...
    def insertComponentIntoDatabase(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def isHydrateFormer(self) -> bool: ...
    def isHydrocarbon(self) -> bool: ...
    def isInert(self) -> bool: ...
    def isIsHydrateFormer(self) -> bool: ...
    def isIsIon(self) -> bool: ...
    def isIsNormalComponent(self) -> bool: ...
    def isIsPlusFraction(self) -> bool: ...
    def isIsTBPfraction(self) -> bool: ...
    def isWaxFormer(self) -> bool: ...
    def logfugcoefdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> typing.MutableSequence[float]: ...
    def logfugcoefdNi(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int) -> float: ...
    def logfugcoefdP(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def logfugcoefdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def reducedPressure(self, double: float) -> float: ...
    def reducedTemperature(self, double: float) -> float: ...
    def setAcentricFactor(self, double: float) -> None: ...
    def setAntoineASolid(self, double: float) -> None: ...
    def setAntoineBSolid(self, double: float) -> None: ...
    def setAntoineCSolid(self, double: float) -> None: ...
    def setAssociationEnergy(self, double: float) -> None: ...
    def setAssociationEnergySAFT(self, double: float) -> None: ...
    def setAssociationScheme(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setAssociationVolume(self, double: float) -> None: ...
    def setAssociationVolumeSAFT(self, double: float) -> None: ...
    def setAttractiveTerm(self, int: int) -> None: ...
    def setCASnumber(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setComponentName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setComponentNumber(self, int: int) -> None: ...
    def setComponentType(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setCpA(self, double: float) -> None: ...
    def setCpB(self, double: float) -> None: ...
    def setCpC(self, double: float) -> None: ...
    def setCpD(self, double: float) -> None: ...
    def setCpE(self, double: float) -> None: ...
    def setCriticalCompressibilityFactor(self, double: float) -> None: ...
    def setCriticalViscosity(self, double: float) -> None: ...
    def setCriticalVolume(self, double: float) -> None: ...
    def setEpsikSAFT(self, double: float) -> None: ...
    def setFormulae(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setFugacityCoefficient(self, double: float) -> None: ...
    def setHeatOfFusion(self, double: float) -> None: ...
    def setHenryCoefParameter(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setIdealGasEnthalpyOfFormation(self, double: float) -> None: ...
    def setIsHydrateFormer(self, boolean: bool) -> None: ...
    def setIsIon(self, boolean: bool) -> None: ...
    def setIsNormalComponent(self, boolean: bool) -> None: ...
    def setIsPlusFraction(self, boolean: bool) -> None: ...
    def setIsTBPfraction(self, boolean: bool) -> None: ...
    def setK(self, double: float) -> None: ...
    def setLennardJonesEnergyParameter(self, double: float) -> None: ...
    def setLennardJonesMolecularDiameter(self, double: float) -> None: ...
    def setLiquidConductivityParameter(self, double: float, int: int) -> None: ...
    def setLiquidViscosityModel(self, int: int) -> None: ...
    def setLiquidViscosityParameter(self, double: float, int: int) -> None: ...
    @typing.overload
    def setMatiascopemanParams(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    @typing.overload
    def setMatiascopemanParams(self, int: int, double: float) -> None: ...
    def setMatiascopemanParamsPR(self, int: int, double: float) -> None: ...
    def setMatiascopemanSolidParams(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    @typing.overload
    def setMolarMass(self, double: float) -> None: ...
    @typing.overload
    def setMolarMass(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setNormalBoilingPoint(self, double: float) -> None: ...
    def setNormalLiquidDensity(self, double: float) -> None: ...
    def setNumberOfAssociationSites(self, int: int) -> None: ...
    def setNumberOfMolesInPhase(self, double: float) -> None: ...
    def setNumberOfmoles(self, double: float) -> None: ...
    @typing.overload
    def setPC(self, double: float) -> None: ...
    @typing.overload
    def setPC(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setParachorParameter(self, double: float) -> None: ...
    def setPaulingAnionicDiameter(self, double: float) -> None: ...
    def setProperties(self, componentInterface: ComponentInterface) -> None: ...
    def setRacketZ(self, double: float) -> None: ...
    def setRacketZCPA(self, double: float) -> None: ...
    def setReferenceEnthalpy(self, double: float) -> None: ...
    def setReferencePotential(self, double: float) -> None: ...
    def setSchwartzentruberParams(self, int: int, double: float) -> None: ...
    def setSigmaSAFTi(self, double: float) -> None: ...
    def setSolidCheck(self, boolean: bool) -> None: ...
    def setSphericalCoreRadius(self, double: float) -> None: ...
    def setStandardDensity(self, double: float) -> None: ...
    def setStokesCationicDiameter(self, double: float) -> None: ...
    def setSurfTensInfluenceParam(self, int: int, double: float) -> None: ...
    @typing.overload
    def setTC(self, double: float) -> None: ...
    @typing.overload
    def setTC(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setTriplePointTemperature(self, double: float) -> None: ...
    def setTwuCoonParams(self, int: int, double: float) -> None: ...
    def setViscosityAssociationFactor(self, double: float) -> None: ...
    def setVoli(self, double: float) -> None: ...
    def setVolumeCorrectionConst(self, double: float) -> None: ...
    def setVolumeCorrectionT(self, double: float) -> None: ...
    def setVolumeCorrectionT_CPA(self, double: float) -> None: ...
    def setWaxFormer(self, boolean: bool) -> None: ...
    def seta(self, double: float) -> None: ...
    def setb(self, double: float) -> None: ...
    def setdfugdn(self, int: int, double: float) -> None: ...
    def setdfugdp(self, double: float) -> None: ...
    def setdfugdt(self, double: float) -> None: ...
    def setdfugdx(self, int: int, double: float) -> None: ...
    def setmSAFTi(self, double: float) -> None: ...
    def setx(self, double: float) -> None: ...
    def setz(self, double: float) -> None: ...

class ComponentEosInterface(ComponentInterface):
    def aT(self, double: float) -> float: ...
    def calca(self) -> float: ...
    def calcb(self) -> float: ...
    def dFdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def dFdNdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def diffaT(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def getAder(self) -> float: ...
    def getAi(self) -> float: ...
    def getAiT(self) -> float: ...
    def getAij(self, int: int) -> float: ...
    def getBder(self) -> float: ...
    def getBi(self) -> float: ...
    def getBij(self, int: int) -> float: ...
    def getDeltaEosParameters(self) -> typing.MutableSequence[float]: ...
    def geta(self) -> float: ...
    def getaDiffDiffT(self) -> float: ...
    def getaDiffT(self) -> float: ...
    def getaT(self) -> float: ...
    def getb(self) -> float: ...
    def getdAdT(self) -> float: ...
    def getdAdTdn(self) -> float: ...
    def getdAdndn(self, int: int) -> float: ...
    def getdBdT(self) -> float: ...
    def getdBdndT(self) -> float: ...
    def getdBdndn(self, int: int) -> float: ...
    def setAder(self, double: float) -> None: ...
    def setBder(self, double: float) -> None: ...
    def setdAdT(self, double: float) -> None: ...
    def setdAdTdT(self, double: float) -> None: ...
    def setdAdTdn(self, double: float) -> None: ...
    def setdAdndn(self, int: int, double: float) -> None: ...
    def setdBdTdT(self, double: float) -> None: ...
    def setdBdndT(self, double: float) -> None: ...
    def setdBdndn(self, int: int, double: float) -> None: ...

class ComponentGEInterface(ComponentInterface):
    @typing.overload
    def getGamma(self) -> float: ...
    @typing.overload
    def getGamma(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray]) -> float: ...
    def getGammaRefCor(self) -> float: ...
    def getlnGamma(self) -> float: ...
    def getlnGammadn(self, int: int) -> float: ...
    def getlnGammadt(self) -> float: ...
    def getlnGammadtdt(self) -> float: ...
    def setlnGammadn(self, int: int, double: float) -> None: ...

class ComponentCPAInterface(ComponentEosInterface):
    def dFCPAdNdXi(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFCPAdVdXi(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFCPAdXi(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFCPAdXidXj(self, int: int, int2: int, int3: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getXsite(self) -> typing.MutableSequence[float]: ...
    def getXsiteOld(self) -> typing.MutableSequence[float]: ...
    def getXsitedT(self) -> typing.MutableSequence[float]: ...
    def getXsitedTdT(self) -> typing.MutableSequence[float]: ...
    def getXsitedV(self) -> typing.MutableSequence[float]: ...
    def setXsite(self, int: int, double: float) -> None: ...
    def setXsiteOld(self, int: int, double: float) -> None: ...
    def setXsitedT(self, int: int, double: float) -> None: ...
    def setXsitedTdT(self, int: int, double: float) -> None: ...
    def setXsitedV(self, int: int, double: float) -> None: ...
    def setXsitedni(self, int: int, int2: int, double: float) -> None: ...

class ComponentEos(Component, ComponentEosInterface):
    a: float = ...
    b: float = ...
    m: float = ...
    alpha: float = ...
    aT: float = ...
    aDiffT: float = ...
    Bi: float = ...
    Ai: float = ...
    AiT: float = ...
    aDiffDiffT: float = ...
    Aij: typing.MutableSequence[float] = ...
    Bij: typing.MutableSequence[float] = ...
    @typing.overload
    def __init__(self, int: int, double: float, double2: float, double3: float, double4: float, double5: float): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def Finit(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, double: float, double2: float, double3: float, double4: float, int: int, int2: int) -> None: ...
    def aT(self, double: float) -> float: ...
    def alpha(self, double: float) -> float: ...
    def calca(self) -> float: ...
    def calcb(self) -> float: ...
    def clone(self) -> 'ComponentEos': ...
    def dFdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def dFdNdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def diffaT(self, double: float) -> float: ...
    def diffalphaT(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def diffdiffalphaT(self, double: float) -> float: ...
    def equals(self, object: typing.Any) -> bool: ...
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getAder(self) -> float: ...
    def getAi(self) -> float: ...
    def getAiT(self) -> float: ...
    def getAij(self, int: int) -> float: ...
    def getAresnTV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getAttractiveParameter(self) -> jneqsim.neqsim.thermo.component.attractiveeosterm.AttractiveTermInterface: ...
    def getAttractiveTerm(self) -> jneqsim.neqsim.thermo.component.attractiveeosterm.AttractiveTermInterface: ...
    def getBder(self) -> float: ...
    def getBi(self) -> float: ...
    def getBij(self, int: int) -> float: ...
    @typing.overload
    def getChemicalPotential(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    @typing.overload
    def getChemicalPotential(self, double: float, double2: float) -> float: ...
    def getDeltaEosParameters(self) -> typing.MutableSequence[float]: ...
    def getSurfaceTenisionInfluenceParameter(self, double: float) -> float: ...
    def geta(self) -> float: ...
    def getaDiffDiffT(self) -> float: ...
    def getaDiffT(self) -> float: ...
    def getaT(self) -> float: ...
    def getb(self) -> float: ...
    def getdAdT(self) -> float: ...
    def getdAdTdT(self) -> float: ...
    def getdAdTdn(self) -> float: ...
    def getdAdndn(self, int: int) -> float: ...
    def getdBdT(self) -> float: ...
    def getdBdndT(self) -> float: ...
    def getdBdndn(self, int: int) -> float: ...
    def getdUdSdnV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getdUdVdnS(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getdUdnSV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getdUdndnSV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, int2: int) -> float: ...
    def init(self, double: float, double2: float, double3: float, double4: float, int: int) -> None: ...
    def logfugcoefdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> typing.MutableSequence[float]: ...
    def logfugcoefdNi(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int) -> float: ...
    def logfugcoefdP(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def logfugcoefdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def setAder(self, double: float) -> None: ...
    def setAttractiveParameter(self, attractiveTermInterface: jneqsim.neqsim.thermo.component.attractiveeosterm.AttractiveTermInterface) -> None: ...
    def setAttractiveTerm(self, int: int) -> None: ...
    def setBder(self, double: float) -> None: ...
    def seta(self, double: float) -> None: ...
    def setb(self, double: float) -> None: ...
    def setdAdT(self, double: float) -> None: ...
    def setdAdTdT(self, double: float) -> None: ...
    def setdAdTdn(self, double: float) -> None: ...
    def setdAdndn(self, int: int, double: float) -> None: ...
    def setdBdTdT(self, double: float) -> None: ...
    def setdBdndT(self, double: float) -> None: ...
    def setdBdndn(self, int: int, double: float) -> None: ...

class ComponentGE(Component, ComponentGEInterface):
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def fugcoefDiffPres(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def fugcoefDiffTemp(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    @typing.overload
    def getGamma(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray]) -> float: ...
    @typing.overload
    def getGamma(self) -> float: ...
    def getGammaRefCor(self) -> float: ...
    def getlnGamma(self) -> float: ...
    def getlnGammadn(self, int: int) -> float: ...
    def getlnGammadt(self) -> float: ...
    def getlnGammadtdt(self) -> float: ...
    def setlnGammadn(self, int: int, double: float) -> None: ...

class ComponentHydrate(Component):
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def calcCKI(self, int: int, int2: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def calcChemPotEmpty(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, int2: int) -> float: ...
    def calcChemPotIdealWater(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, int2: int) -> float: ...
    def calcYKI(self, int: int, int2: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def delt(self, double: float, double2: float, int: int, int2: int, componentInterface: ComponentInterface) -> float: ...
    @typing.overload
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    @typing.overload
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    @typing.overload
    def getCavprwat(self, int: int, int2: int) -> float: ...
    @typing.overload
    def getCavprwat(self) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def getDGfHydrate(self) -> typing.MutableSequence[float]: ...
    def getDHfHydrate(self) -> typing.MutableSequence[float]: ...
    def getEmptyHydrateStructureVapourPressure(self, int: int, double: float) -> float: ...
    def getEmptyHydrateVapourPressureConstant(self, int: int, int2: int) -> float: ...
    def getHydrateStructure(self) -> int: ...
    def getLennardJonesEnergyParameterHydrate(self) -> float: ...
    def getLennardJonesMolecularDiameterHydrate(self) -> float: ...
    def getMolarVolumeHydrate(self, int: int, double: float) -> float: ...
    def getPot(self, double: float, int: int, int2: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getSphericalCoreRadiusHydrate(self) -> float: ...
    def potIntegral(self, int: int, int2: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def readHydrateParameters(self) -> None: ...
    @typing.overload
    def setDGfHydrate(self, double: float, int: int) -> None: ...
    @typing.overload
    def setDGfHydrate(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    @typing.overload
    def setDHfHydrate(self, double: float, int: int) -> None: ...
    @typing.overload
    def setDHfHydrate(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setEmptyHydrateVapourPressureConstant(self, int: int, int2: int, double: float) -> None: ...
    def setHydrateStructure(self, int: int) -> None: ...
    def setLennardJonesEnergyParameterHydrate(self, double: float) -> None: ...
    def setLennardJonesMolecularDiameterHydrate(self, double: float) -> None: ...
    def setRefFug(self, int: int, double: float) -> None: ...
    def setSolidRefFluidPhase(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> None: ...
    def setSphericalCoreRadiusHydrate(self, double: float) -> None: ...

class ComponentHydrateKluda(Component):
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def calcCKI(self, int: int, int2: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def calcYKI(self, int: int, int2: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def delt(self, int: int, double: float, double2: float, int2: int, int3: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dfugdt(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    @typing.overload
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    @typing.overload
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def getEmptyHydrateStructureVapourPressure(self, int: int, double: float) -> float: ...
    def getEmptyHydrateStructureVapourPressuredT(self, int: int, double: float) -> float: ...
    def getPot(self, int: int, double: float, int2: int, int3: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def potIntegral(self, int: int, int2: int, int3: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def setRefFug(self, int: int, double: float) -> None: ...
    def setStructure(self, int: int) -> None: ...

class ComponentIdealGas(Component):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def clone(self) -> 'ComponentIdealGas': ...
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def logfugcoefdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> typing.MutableSequence[float]: ...
    def logfugcoefdNi(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int) -> float: ...
    def logfugcoefdP(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def logfugcoefdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...

class ComponentAmmoniaEos(ComponentEos):
    @typing.overload
    def __init__(self, int: int, double: float, double2: float, double3: float, double4: float, double5: float): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def Finit(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, double: float, double2: float, double3: float, double4: float, int: int, int2: int) -> None: ...
    def alpha(self, double: float) -> float: ...
    def calca(self) -> float: ...
    def calcb(self) -> float: ...
    def clone(self) -> 'ComponentAmmoniaEos': ...
    def dFdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def dFdNdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def diffaT(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getVolumeCorrection(self) -> float: ...
    def logfugcoefdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> typing.MutableSequence[float]: ...
    def logfugcoefdP(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def logfugcoefdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...

class ComponentDesmukhMather(ComponentGE):
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    @typing.overload
    def getGamma(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> float: ...
    @typing.overload
    def getGamma(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray]) -> float: ...
    @typing.overload
    def getGamma(self) -> float: ...
    def getLngamma(self) -> float: ...
    def getMolality(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...

class ComponentGERG2004(ComponentEos):
    @typing.overload
    def __init__(self, int: int, double: float, double2: float, double3: float, double4: float, double5: float): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def alpha(self, double: float) -> float: ...
    def calca(self) -> float: ...
    def calcb(self) -> float: ...
    def clone(self) -> 'ComponentGERG2004': ...
    def diffaT(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getVolumeCorrection(self) -> float: ...

class ComponentGERG2008Eos(ComponentEos):
    @typing.overload
    def __init__(self, int: int, double: float, double2: float, double3: float, double4: float, double5: float): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def Finit(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, double: float, double2: float, double3: float, double4: float, int: int, int2: int) -> None: ...
    def alpha(self, double: float) -> float: ...
    def calca(self) -> float: ...
    def calcb(self) -> float: ...
    def clone(self) -> 'ComponentGERG2008Eos': ...
    def dFdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def dFdNdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def diffaT(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getVolumeCorrection(self) -> float: ...
    def logfugcoefdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> typing.MutableSequence[float]: ...
    def logfugcoefdNi(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int) -> float: ...
    def logfugcoefdP(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def logfugcoefdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...

class ComponentGEUniquac(ComponentGE):
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    @typing.overload
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    @typing.overload
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> float: ...
    @typing.overload
    def fugcoefDiffPres(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    @typing.overload
    def fugcoefDiffPres(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> float: ...
    @typing.overload
    def fugcoefDiffTemp(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    @typing.overload
    def fugcoefDiffTemp(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> float: ...
    @typing.overload
    def getGamma(self) -> float: ...
    @typing.overload
    def getGamma(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> float: ...
    @typing.overload
    def getGamma(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray]) -> float: ...
    def getlnGammadn(self, int: int) -> float: ...
    def getlnGammadt(self) -> float: ...
    def getq(self) -> float: ...
    def getr(self) -> float: ...

class ComponentGEWilson(ComponentGE):
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    @typing.overload
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    @typing.overload
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> float: ...
    def getCharEnergyParamter(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, int2: int) -> float: ...
    @typing.overload
    def getGamma(self) -> float: ...
    @typing.overload
    def getGamma(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> float: ...
    @typing.overload
    def getGamma(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray]) -> float: ...
    def getWilsonActivityCoefficient(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getWilsonInteractionEnergy(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...

class ComponentGeDuanSun(ComponentGE):
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    @typing.overload
    def getGamma(self) -> float: ...
    @typing.overload
    def getGamma(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> float: ...
    @typing.overload
    def getGamma(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray]) -> float: ...
    def getGammaNRTL(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> float: ...
    def getGammaPitzer(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType, double3: float) -> float: ...
    def getLngamma(self) -> float: ...
    def getq(self) -> float: ...
    def getr(self) -> float: ...

class ComponentGeNRTL(ComponentGE):
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    @typing.overload
    def getGamma(self) -> float: ...
    @typing.overload
    def getGamma(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray]) -> float: ...
    def getLngamma(self) -> float: ...
    def getq(self) -> float: ...
    def getr(self) -> float: ...

class ComponentGePitzer(ComponentGE):
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    @typing.overload
    def getGamma(self) -> float: ...
    @typing.overload
    def getGamma(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> float: ...
    @typing.overload
    def getGamma(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray]) -> float: ...
    def getMolality(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...

class ComponentHydrateBallard(ComponentHydrate):
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def calcCKI(self, int: int, int2: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def calcYKI(self, int: int, int2: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    @typing.overload
    def delt(self, double: float, double2: float, int: int, int2: int, componentInterface: ComponentInterface) -> float: ...
    @typing.overload
    def delt(self, double: float, double2: float, int: int, int2: int) -> float: ...
    @typing.overload
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    @typing.overload
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def getPot(self, double: float, int: int, int2: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def potIntegral(self, int: int, int2: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...

class ComponentHydrateGF(ComponentHydrate):
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def calcCKI(self, int: int, int2: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def calcYKI(self, int: int, int2: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    @typing.overload
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    @typing.overload
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def fugcoef2(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...

class ComponentHydratePVTsim(ComponentHydrate):
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def calcCKI(self, int: int, int2: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def calcDeltaChemPot(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, int2: int) -> float: ...
    def calcYKI(self, int: int, int2: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    @typing.overload
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    @typing.overload
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...

class ComponentHydrateStatoil(ComponentHydrate):
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def calcCKI(self, int: int, int2: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def calcYKI(self, int: int, int2: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    @typing.overload
    def delt(self, double: float, double2: float, int: int, int2: int, componentInterface: ComponentInterface) -> float: ...
    @typing.overload
    def delt(self, double: float, double2: float, int: int, int2: int) -> float: ...
    @typing.overload
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    @typing.overload
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def getPot(self, double: float, int: int, int2: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def potIntegral(self, int: int, int2: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...

class ComponentLeachmanEos(ComponentEos):
    @typing.overload
    def __init__(self, int: int, double: float, double2: float, double3: float, double4: float, double5: float): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def Finit(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, double: float, double2: float, double3: float, double4: float, int: int, int2: int) -> None: ...
    def alpha(self, double: float) -> float: ...
    def calca(self) -> float: ...
    def calcb(self) -> float: ...
    def clone(self) -> 'ComponentLeachmanEos': ...
    def dFdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def dFdNdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def diffaT(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getVolumeCorrection(self) -> float: ...

class ComponentPR(ComponentEos):
    @typing.overload
    def __init__(self, int: int, double: float, double2: float, double3: float, double4: float, double5: float): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def calca(self) -> float: ...
    def calcb(self) -> float: ...
    def clone(self) -> 'ComponentPR': ...
    def getQpure(self, double: float) -> float: ...
    def getSurfaceTenisionInfluenceParameter(self, double: float) -> float: ...
    def getVolumeCorrection(self) -> float: ...
    def getdQpuredT(self, double: float) -> float: ...
    def getdQpuredTdT(self, double: float) -> float: ...

class ComponentRK(ComponentEos):
    @typing.overload
    def __init__(self, int: int, double: float, double2: float, double3: float, double4: float, double5: float): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def calca(self) -> float: ...
    def calcb(self) -> float: ...
    def clone(self) -> 'ComponentRK': ...
    def getQpure(self, double: float) -> float: ...
    def getVolumeCorrection(self) -> float: ...
    def getdQpuredT(self, double: float) -> float: ...
    def getdQpuredTdT(self, double: float) -> float: ...

class ComponentSpanWagnerEos(ComponentEos):
    @typing.overload
    def __init__(self, int: int, double: float, double2: float, double3: float, double4: float, double5: float): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def Finit(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, double: float, double2: float, double3: float, double4: float, int: int, int2: int) -> None: ...
    def alpha(self, double: float) -> float: ...
    def calca(self) -> float: ...
    def calcb(self) -> float: ...
    def clone(self) -> 'ComponentSpanWagnerEos': ...
    def dFdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def dFdNdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def diffaT(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getVolumeCorrection(self) -> float: ...

class ComponentSrk(ComponentEos):
    @typing.overload
    def __init__(self, int: int, double: float, double2: float, double3: float, double4: float, double5: float): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def calca(self) -> float: ...
    def calcb(self) -> float: ...
    def clone(self) -> 'ComponentSrk': ...
    def getQpure(self, double: float) -> float: ...
    def getSurfaceTenisionInfluenceParameter(self, double: float) -> float: ...
    def getVolumeCorrection(self) -> float: ...
    def getdQpuredT(self, double: float) -> float: ...
    def getdQpuredTdT(self, double: float) -> float: ...

class ComponentTST(ComponentEos):
    @typing.overload
    def __init__(self, int: int, double: float, double2: float, double3: float, double4: float, double5: float): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def calca(self) -> float: ...
    def calcb(self) -> float: ...
    def clone(self) -> 'ComponentTST': ...
    def getQpure(self, double: float) -> float: ...
    def getVolumeCorrection(self) -> float: ...
    def getdQpuredT(self, double: float) -> float: ...
    def getdQpuredTdT(self, double: float) -> float: ...

class ComponentVegaEos(ComponentEos):
    @typing.overload
    def __init__(self, int: int, double: float, double2: float, double3: float, double4: float, double5: float): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def Finit(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, double: float, double2: float, double3: float, double4: float, int: int, int2: int) -> None: ...
    def alpha(self, double: float) -> float: ...
    def calca(self) -> float: ...
    def calcb(self) -> float: ...
    def clone(self) -> 'ComponentVegaEos': ...
    def dFdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def dFdNdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def diffaT(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getVolumeCorrection(self) -> float: ...

class ComponentWater(ComponentEos):
    @typing.overload
    def __init__(self, int: int, double: float, double2: float, double3: float, double4: float, double5: float): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def Finit(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, double: float, double2: float, double3: float, double4: float, int: int, int2: int) -> None: ...
    def alpha(self, double: float) -> float: ...
    def calca(self) -> float: ...
    def calcb(self) -> float: ...
    def clone(self) -> 'ComponentWater': ...
    def dFdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def dFdNdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def diffaT(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getVolumeCorrection(self) -> float: ...

class ComponentBNS(ComponentPR):
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int, double3: float, double4: float, double5: float, double6: float, double7: float, double8: float, double9: float): ...
    def calca(self) -> float: ...
    def calcb(self) -> float: ...
    def clone(self) -> 'ComponentBNS': ...

class ComponentBWRS(ComponentSrk):
    @typing.overload
    def __init__(self, int: int, double: float, double2: float, double3: float, double4: float, double5: float): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def clone(self) -> 'ComponentBWRS': ...
    def dFdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def equals(self, object: typing.Any) -> bool: ...
    @typing.overload
    def getABWRS(self, int: int) -> float: ...
    @typing.overload
    def getABWRS(self) -> typing.MutableSequence[float]: ...
    @typing.overload
    def getBE(self, int: int) -> float: ...
    @typing.overload
    def getBE(self) -> typing.MutableSequence[float]: ...
    @typing.overload
    def getBEdT(self, int: int) -> float: ...
    @typing.overload
    def getBEdT(self) -> typing.MutableSequence[float]: ...
    def getBP(self, int: int) -> float: ...
    @typing.overload
    def getBPdT(self, int: int) -> float: ...
    @typing.overload
    def getBPdT(self) -> typing.MutableSequence[float]: ...
    def getELdn(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def getFexpdn(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def getFpoldn(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def getGammaBWRS(self) -> float: ...
    def getRhoc(self) -> float: ...
    def getdRhodn(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def init(self, double: float, double2: float, double3: float, double4: float, int: int) -> None: ...
    def setABWRS(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setBE(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setBEdT(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setBP(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setBPdT(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setGammaBWRS(self, double: float) -> None: ...
    def setRefPhaseBWRS(self, phaseBWRSEos: jneqsim.neqsim.thermo.phase.PhaseBWRSEos) -> None: ...
    def setRhoc(self, double: float) -> None: ...

class ComponentCSPsrk(ComponentSrk):
    @typing.overload
    def __init__(self, int: int, double: float, double2: float, double3: float, double4: float, double5: float): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def clone(self) -> 'ComponentCSPsrk': ...
    def dFdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def getF_scale_mix_i(self) -> float: ...
    def getH_scale_mix_i(self) -> float: ...
    def getRefPhaseBWRS(self) -> jneqsim.neqsim.thermo.phase.PhaseCSPsrkEos: ...
    def init(self, double: float, double2: float, double3: float, double4: float, int: int) -> None: ...
    def setF_scale_mix_i(self, double: float) -> None: ...
    def setH_scale_mix_i(self, double: float) -> None: ...
    def setRefPhaseBWRS(self, phaseCSPsrkEos: jneqsim.neqsim.thermo.phase.PhaseCSPsrkEos) -> None: ...

class ComponentGENRTLmodifiedHV(ComponentGeNRTL):
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    @typing.overload
    def getGamma(self) -> float: ...
    @typing.overload
    def getGamma(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray4: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray]) -> float: ...
    @typing.overload
    def getGamma(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray]) -> float: ...

class ComponentGENRTLmodifiedWS(ComponentGeNRTL):
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    @typing.overload
    def getGamma(self) -> float: ...
    @typing.overload
    def getGamma(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray4: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray]) -> float: ...
    @typing.overload
    def getGamma(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray]) -> float: ...
    def getlnGammadn(self, int: int) -> float: ...
    def getlnGammadt(self) -> float: ...

class ComponentGEUnifac(ComponentGEUniquac):
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def addUNIFACgroup(self, int: int, int2: int) -> None: ...
    def calclnGammak(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> None: ...
    @typing.overload
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    @typing.overload
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> float: ...
    @typing.overload
    def fugcoefDiffPres(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    @typing.overload
    def fugcoefDiffPres(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> float: ...
    @typing.overload
    def fugcoefDiffTemp(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    @typing.overload
    def fugcoefDiffTemp(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> float: ...
    @typing.overload
    def getGamma(self) -> float: ...
    @typing.overload
    def getGamma(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> float: ...
    @typing.overload
    def getGamma(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray]) -> float: ...
    def getNumberOfUNIFACgroups(self) -> int: ...
    def getQ(self) -> float: ...
    def getR(self) -> float: ...
    def getUnifacGroup(self, int: int) -> jneqsim.neqsim.thermo.atomelement.UNIFACgroup: ...
    def getUnifacGroup2(self, int: int) -> jneqsim.neqsim.thermo.atomelement.UNIFACgroup: ...
    def getUnifacGroups(self) -> typing.MutableSequence[jneqsim.neqsim.thermo.atomelement.UNIFACgroup]: ...
    def getUnifacGroups2(self) -> java.util.ArrayList[jneqsim.neqsim.thermo.atomelement.UNIFACgroup]: ...
    def setQ(self, double: float) -> None: ...
    def setR(self, double: float) -> None: ...
    def setUnifacGroups(self, arrayList: java.util.ArrayList[jneqsim.neqsim.thermo.atomelement.UNIFACgroup]) -> None: ...

class ComponentGEUniquacmodifiedHV(ComponentGEUniquac):
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    @typing.overload
    def getGamma(self) -> float: ...
    @typing.overload
    def getGamma(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray]) -> float: ...
    @typing.overload
    def getGamma(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> float: ...

class ComponentKentEisenberg(ComponentGeNRTL):
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...

class ComponentModifiedFurstElectrolyteEos(ComponentSrk):
    @typing.overload
    def __init__(self, int: int, double: float, double2: float, double3: float, double4: float, double5: float): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def FLRN(self) -> float: ...
    def Finit(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, double: float, double2: float, double3: float, double4: float, int: int, int2: int) -> None: ...
    def calcGammaLRdn(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def calcSolventdiElectricdn(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def calcSolventdiElectricdndT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def calcSolventdiElectricdndn(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def calcXLRdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def calca(self) -> float: ...
    def calcb(self) -> float: ...
    def calcdiElectricdn(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def calcdiElectricdndT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def calcdiElectricdndV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def calcdiElectricdndn(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def clone(self) -> 'ComponentModifiedFurstElectrolyteEos': ...
    def dAlphaLRdndn(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def dEpsIonicdNi(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dEpsIonicdNidV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dEpsdNi(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dEpsdNidV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFBorndN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFBorndNdN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def dFBorndNdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFLRdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFLRdNdN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def dFLRdNdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFLRdNdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFSR2dN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFSR2dNdN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def dFSR2dNdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFSR2dNdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def dFdNdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def getAlphai(self) -> float: ...
    def getBornVal(self) -> float: ...
    def getDiElectricConstantdn(self) -> float: ...
    def getEpsIonici(self) -> float: ...
    def getEpsi(self) -> float: ...
    def getIonicCoVolume(self) -> float: ...
    def getSolventDiElectricConstantdn(self) -> float: ...
    def getXBorni(self) -> float: ...
    def getXLRi(self) -> float: ...
    def initFurstParam(self) -> None: ...

class ComponentModifiedFurstElectrolyteEosMod2004(ComponentSrk):
    @typing.overload
    def __init__(self, int: int, double: float, double2: float, double3: float, double4: float, double5: float): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def FLRN(self) -> float: ...
    def Finit(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, double: float, double2: float, double3: float, double4: float, int: int, int2: int) -> None: ...
    def calcGammaLRdn(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def calcSolventdiElectricdn(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def calcSolventdiElectricdndT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def calcSolventdiElectricdndn(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def calcXLRdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def calca(self) -> float: ...
    def calcb(self) -> float: ...
    def calcdiElectricdn(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def calcdiElectricdndT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def calcdiElectricdndV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def calcdiElectricdndn(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def clone(self) -> 'ComponentModifiedFurstElectrolyteEosMod2004': ...
    def dAlphaLRdndn(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def dEpsIonicdNi(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dEpsIonicdNidV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dEpsdNi(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dEpsdNidV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFBorndN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFBorndNdN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def dFBorndNdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFLRdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFLRdNdN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def dFLRdNdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFLRdNdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFSR2dN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFSR2dNdN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def dFSR2dNdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFSR2dNdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def dFdNdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def getAlphai(self) -> float: ...
    def getBornVal(self) -> float: ...
    def getDiElectricConstantdn(self) -> float: ...
    def getEpsIonici(self) -> float: ...
    def getEpsi(self) -> float: ...
    def getIonicCoVolume(self) -> float: ...
    def getSolventDiElectricConstantdn(self) -> float: ...
    def getXBorni(self) -> float: ...
    def getXLRi(self) -> float: ...
    def initFurstParam(self) -> None: ...

class ComponentPCSAFT(ComponentSrk):
    @typing.overload
    def __init__(self, int: int, double: float, double2: float, double3: float, double4: float, double5: float): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def Finit(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, double: float, double2: float, double3: float, double4: float, int: int, int2: int) -> None: ...
    def calcF1dispSumTermdn(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def calcF2dispSumTermdn(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def calcdahsSAFTdi(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def calcdghsSAFTdi(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def calcdmSAFTdi(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def calcdnSAFTdi(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def clone(self) -> 'ComponentPCSAFT': ...
    def dF_DISP1_SAFTdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dF_DISP2_SAFTdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dF_HC_SAFTdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def getDghsSAFTdi(self) -> float: ...
    def getDlogghsSAFTdi(self) -> float: ...
    def getDmSAFTdi(self) -> float: ...
    def getDnSAFTdi(self) -> float: ...
    def getdSAFTi(self) -> float: ...
    def getdahsSAFTdi(self) -> float: ...
    def init(self, double: float, double2: float, double3: float, double4: float, int: int) -> None: ...
    def setDghsSAFTdi(self, double: float) -> None: ...
    def setDlogghsSAFTdi(self, double: float) -> None: ...
    def setDmSAFTdi(self, double: float) -> None: ...
    def setDnSAFTdi(self, double: float) -> None: ...
    def setdSAFTi(self, double: float) -> None: ...
    def setdahsSAFTdi(self, double: float) -> None: ...

class ComponentPRvolcor(ComponentPR):
    Cij: typing.MutableSequence[float] = ...
    Ci: float = ...
    @typing.overload
    def __init__(self, int: int, double: float, double2: float, double3: float, double4: float, double5: float): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def Finit(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, double: float, double2: float, double3: float, double4: float, int: int, int2: int) -> None: ...
    def calcc(self) -> float: ...
    def calccT(self) -> float: ...
    def calccTT(self) -> float: ...
    def dFdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def dFdNdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def getCi(self) -> float: ...
    def getCiT(self) -> float: ...
    def getCij(self, int: int) -> float: ...
    def getFC(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def getc(self) -> float: ...
    def getcT(self) -> float: ...
    def getcTT(self) -> float: ...
    def init(self, double: float, double2: float, double3: float, double4: float, int: int) -> None: ...

class ComponentPrCPA(ComponentPR, ComponentCPAInterface):
    @typing.overload
    def __init__(self, int: int, double: float, double2: float, double3: float, double4: float, double5: float): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def calc_lngi(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def calc_lngi2(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def calca(self) -> float: ...
    def calcb(self) -> float: ...
    def clone(self) -> 'ComponentPrCPA': ...
    def dFCPAdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def dFdNdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def getVolumeCorrection(self) -> float: ...
    def getXsite(self) -> typing.MutableSequence[float]: ...
    def setAttractiveTerm(self, int: int) -> None: ...
    @typing.overload
    def setXsite(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    @typing.overload
    def setXsite(self, int: int, double: float) -> None: ...

class ComponentSolid(ComponentSrk):
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    @typing.overload
    def fugcoef(self, double: float, double2: float) -> float: ...
    @typing.overload
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def fugcoef2(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getMolarVolumeSolid(self) -> float: ...
    def getVolumeCorrection2(self) -> float: ...
    def setSolidRefFluidPhase(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> None: ...

class ComponentSoreideWhitson(ComponentPR):
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def clone(self) -> 'ComponentSoreideWhitson': ...

class ComponentSrkCPA(ComponentSrk, ComponentCPAInterface):
    @typing.overload
    def __init__(self, int: int, double: float, double2: float, double3: float, double4: float, double5: float, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface): ...
    def calc_hCPAdn(self) -> float: ...
    def calc_lngi(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def calc_lngidV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def calc_lngij(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def calca(self) -> float: ...
    def calcb(self) -> float: ...
    def clone(self) -> 'ComponentSrkCPA': ...
    def dFCPAdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFCPAdNdN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def dFCPAdNdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFCPAdNdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFCPAdNdXi(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFCPAdNdXidXdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFCPAdVdXi(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFCPAdXi(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFCPAdXidXj(self, int: int, int2: int, int3: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFCPAdXidni(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def dFdNdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def getSurfaceTenisionInfluenceParameter(self, double: float) -> float: ...
    def getVolumeCorrection(self) -> float: ...
    def getXsite(self) -> typing.MutableSequence[float]: ...
    def getXsiteOld(self) -> typing.MutableSequence[float]: ...
    def getXsitedT(self) -> typing.MutableSequence[float]: ...
    def getXsitedTdT(self) -> typing.MutableSequence[float]: ...
    def getXsitedV(self) -> typing.MutableSequence[float]: ...
    @typing.overload
    def getXsitedni(self, int: int, int2: int) -> float: ...
    @typing.overload
    def getXsitedni(self) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def resizeXsitedni(self, int: int) -> None: ...
    def setAttractiveTerm(self, int: int) -> None: ...
    @typing.overload
    def setXsite(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    @typing.overload
    def setXsite(self, int: int, double: float) -> None: ...
    @typing.overload
    def setXsiteOld(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    @typing.overload
    def setXsiteOld(self, int: int, double: float) -> None: ...
    def setXsitedT(self, int: int, double: float) -> None: ...
    def setXsitedTdT(self, int: int, double: float) -> None: ...
    def setXsitedV(self, int: int, double: float) -> None: ...
    @typing.overload
    def setXsitedni(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    @typing.overload
    def setXsitedni(self, int: int, int2: int, double: float) -> None: ...
    def seta(self, double: float) -> None: ...
    def setb(self, double: float) -> None: ...

class ComponentSrkPeneloux(ComponentSrk):
    @typing.overload
    def __init__(self, int: int, double: float, double2: float, double3: float, double4: float, double5: float): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def calcb(self) -> float: ...
    def clone(self) -> 'ComponentSrkPeneloux': ...
    def getVolumeCorrection(self) -> float: ...

class ComponentUMRCPA(ComponentPR, ComponentCPAInterface):
    @typing.overload
    def __init__(self, int: int, double: float, double2: float, double3: float, double4: float, double5: float): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def calc_hCPAdn(self) -> float: ...
    def calc_lngi(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def calc_lngidV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def calc_lngij(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def calca(self) -> float: ...
    def calcb(self) -> float: ...
    def clone(self) -> 'ComponentUMRCPA': ...
    def createComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def dFCPAdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFCPAdNdN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def dFCPAdNdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFCPAdNdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFCPAdNdXi(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFCPAdNdXidXdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFCPAdVdXi(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFCPAdXi(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFCPAdXidXj(self, int: int, int2: int, int3: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFCPAdXidni(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def dFdNdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def getSurfaceTenisionInfluenceParameter(self, double: float) -> float: ...
    def getVolumeCorrection(self) -> float: ...
    def getXsite(self) -> typing.MutableSequence[float]: ...
    def getXsiteOld(self) -> typing.MutableSequence[float]: ...
    def getXsitedT(self) -> typing.MutableSequence[float]: ...
    def getXsitedTdT(self) -> typing.MutableSequence[float]: ...
    def getXsitedV(self) -> typing.MutableSequence[float]: ...
    @typing.overload
    def getXsitedni(self, int: int, int2: int) -> float: ...
    @typing.overload
    def getXsitedni(self) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def setAttractiveTerm(self, int: int) -> None: ...
    @typing.overload
    def setXsite(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    @typing.overload
    def setXsite(self, int: int, double: float) -> None: ...
    @typing.overload
    def setXsiteOld(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    @typing.overload
    def setXsiteOld(self, int: int, double: float) -> None: ...
    def setXsitedT(self, int: int, double: float) -> None: ...
    def setXsitedTdT(self, int: int, double: float) -> None: ...
    def setXsitedV(self, int: int, double: float) -> None: ...
    @typing.overload
    def setXsitedni(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    @typing.overload
    def setXsitedni(self, int: int, int2: int, double: float) -> None: ...
    def seta(self, double: float) -> None: ...
    def setb(self, double: float) -> None: ...

class ComponentElectrolyteCPA(ComponentModifiedFurstElectrolyteEos, ComponentCPAInterface):
    @typing.overload
    def __init__(self, int: int, double: float, double2: float, double3: float, double4: float, double5: float): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def calc_hCPAdn(self) -> float: ...
    def calc_lngi(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def calc_lngidV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def calc_lngij(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def calca(self) -> float: ...
    def calcb(self) -> float: ...
    def clone(self) -> 'ComponentElectrolyteCPA': ...
    def dFCPAdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFCPAdNdN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def dFCPAdNdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFCPAdNdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFCPAdNdXi(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFCPAdNdXidXdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFCPAdVdXi(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFCPAdXi(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFCPAdXidXj(self, int: int, int2: int, int3: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFCPAdXidni(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def dFdNdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def getSurfaceTenisionInfluenceParameter(self, double: float) -> float: ...
    def getVolumeCorrection(self) -> float: ...
    def getXsite(self) -> typing.MutableSequence[float]: ...
    def getXsiteOld(self) -> typing.MutableSequence[float]: ...
    def getXsitedT(self) -> typing.MutableSequence[float]: ...
    def getXsitedTdT(self) -> typing.MutableSequence[float]: ...
    def getXsitedV(self) -> typing.MutableSequence[float]: ...
    @typing.overload
    def getXsitedni(self, int: int, int2: int) -> float: ...
    @typing.overload
    def getXsitedni(self) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def setAttractiveTerm(self, int: int) -> None: ...
    @typing.overload
    def setXsite(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    @typing.overload
    def setXsite(self, int: int, double: float) -> None: ...
    @typing.overload
    def setXsiteOld(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    @typing.overload
    def setXsiteOld(self, int: int, double: float) -> None: ...
    def setXsitedT(self, int: int, double: float) -> None: ...
    def setXsitedTdT(self, int: int, double: float) -> None: ...
    def setXsitedV(self, int: int, double: float) -> None: ...
    @typing.overload
    def setXsitedni(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    @typing.overload
    def setXsitedni(self, int: int, int2: int, double: float) -> None: ...
    def seta(self, double: float) -> None: ...
    def setb(self, double: float) -> None: ...

class ComponentElectrolyteCPAOld(ComponentModifiedFurstElectrolyteEos, ComponentCPAInterface):
    @typing.overload
    def __init__(self, int: int, double: float, double2: float, double3: float, double4: float, double5: float): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def calc_lngi(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def calc_lngidV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def calca(self) -> float: ...
    def calcb(self) -> float: ...
    def clone(self) -> 'ComponentElectrolyteCPAOld': ...
    def dFCPAdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFCPAdNdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFCPAdNdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFCPAdNdXi(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFCPAdNdXidXdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFCPAdVdXi(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFCPAdXi(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFCPAdXidXj(self, int: int, int2: int, int3: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def dFdNdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def getVolumeCorrection(self) -> float: ...
    def getXsite(self) -> typing.MutableSequence[float]: ...
    def getXsiteOld(self) -> typing.MutableSequence[float]: ...
    def getXsitedT(self) -> typing.MutableSequence[float]: ...
    def getXsitedTdT(self) -> typing.MutableSequence[float]: ...
    def getXsitedV(self) -> typing.MutableSequence[float]: ...
    def setAttractiveTerm(self, int: int) -> None: ...
    @typing.overload
    def setXsite(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    @typing.overload
    def setXsite(self, int: int, double: float) -> None: ...
    @typing.overload
    def setXsiteOld(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    @typing.overload
    def setXsiteOld(self, int: int, double: float) -> None: ...
    def setXsitedT(self, int: int, double: float) -> None: ...
    def setXsitedTdT(self, int: int, double: float) -> None: ...
    def setXsitedV(self, int: int, double: float) -> None: ...
    def setXsitedni(self, int: int, int2: int, double: float) -> None: ...
    def seta(self, double: float) -> None: ...
    def setb(self, double: float) -> None: ...

class ComponentGEUnifacPSRK(ComponentGEUnifac):
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def calcaij(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, int2: int) -> float: ...
    def calcaijdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, int2: int) -> float: ...
    def calclnGammak(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> None: ...
    def calclnGammakdT(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> None: ...
    @typing.overload
    def getGamma(self) -> float: ...
    @typing.overload
    def getGamma(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> float: ...
    @typing.overload
    def getGamma(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray]) -> float: ...

class ComponentGEUnifacUMRPRU(ComponentGEUnifac):
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def calcGammaNumericalDerivatives(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> None: ...
    def calcSum2Comp(self) -> None: ...
    def calcSum2CompdTdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> None: ...
    def calcTempExpaij(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> None: ...
    def calcUnifacGroupParams(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> None: ...
    def calcUnifacGroupParamsdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> None: ...
    def calcaij(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, int2: int) -> float: ...
    def calcaijdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, int2: int) -> float: ...
    def calcaijdTdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, int2: int) -> float: ...
    def calclnGammak(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> None: ...
    def calclnGammakdTdT(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> None: ...
    def calclnGammakdn(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int) -> None: ...
    @typing.overload
    def getGamma(self) -> float: ...
    @typing.overload
    def getGamma(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> float: ...
    @typing.overload
    def getGamma(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float, phaseType: jneqsim.neqsim.thermo.phase.PhaseType, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray]) -> float: ...
    def getaij(self, int: int, int2: int) -> float: ...
    def getaijdT(self, int: int, int2: int) -> float: ...
    def getaijdTdT(self, int: int, int2: int) -> float: ...

class ComponentPCSAFTa(ComponentPCSAFT, ComponentCPAInterface):
    @typing.overload
    def __init__(self, int: int, double: float, double2: float, double3: float, double4: float, double5: float): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def calc_lngi(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def calc_lngidV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def clone(self) -> 'ComponentPCSAFTa': ...
    def dFCPAdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFCPAdNdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFCPAdNdXi(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFCPAdNdXidXdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFCPAdVdXi(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFCPAdXi(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFCPAdXidXj(self, int: int, int2: int, int3: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def dFdN(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdN(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int2: int, double: float, double2: float) -> float: ...
    def dFdNdT(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def dFdNdV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, double: float, double2: float) -> float: ...
    def getXsite(self) -> typing.MutableSequence[float]: ...
    def getXsiteOld(self) -> typing.MutableSequence[float]: ...
    def getXsitedT(self) -> typing.MutableSequence[float]: ...
    def getXsitedTdT(self) -> typing.MutableSequence[float]: ...
    def getXsitedV(self) -> typing.MutableSequence[float]: ...
    @typing.overload
    def setXsite(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    @typing.overload
    def setXsite(self, int: int, double: float) -> None: ...
    @typing.overload
    def setXsiteOld(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    @typing.overload
    def setXsiteOld(self, int: int, double: float) -> None: ...
    def setXsitedT(self, int: int, double: float) -> None: ...
    def setXsitedTdT(self, int: int, double: float) -> None: ...
    def setXsitedV(self, int: int, double: float) -> None: ...
    def setXsitedni(self, int: int, int2: int, double: float) -> None: ...

class ComponentSrkCPAs(ComponentSrkCPA):
    @typing.overload
    def __init__(self, int: int, double: float, double2: float, double3: float, double4: float, double5: float, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface): ...
    def calc_lngi(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def calc_lngidV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def calc_lngij(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def clone(self) -> 'ComponentSrkCPAs': ...

class ComponentWax(ComponentSolid):
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    @typing.overload
    def fugcoef(self, double: float, double2: float) -> float: ...
    @typing.overload
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def fugcoef2(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...

class ComponentWaxWilson(ComponentSolid):
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    @typing.overload
    def fugcoef(self, double: float, double2: float) -> float: ...
    @typing.overload
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def fugcoef2(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getCharEnergyParamter(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int, int2: int) -> float: ...
    def getWilsonActivityCoefficient(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getWilsonInteractionEnergy(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...

class ComponentWonWax(ComponentSolid):
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    @typing.overload
    def fugcoef(self, double: float, double2: float) -> float: ...
    @typing.overload
    def fugcoef(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def fugcoef2(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getWonActivityCoefficient(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getWonParam(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def getWonVolume(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...

class ComponentElectrolyteCPAstatoil(ComponentElectrolyteCPA):
    @typing.overload
    def __init__(self, int: int, double: float, double2: float, double3: float, double4: float, double5: float): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int): ...
    def calc_lngi(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def calc_lngidV(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def calc_lngij(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> float: ...
    def clone(self) -> 'ComponentElectrolyteCPAstatoil': ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.thermo.component")``.

    Component: typing.Type[Component]
    ComponentAmmoniaEos: typing.Type[ComponentAmmoniaEos]
    ComponentBNS: typing.Type[ComponentBNS]
    ComponentBWRS: typing.Type[ComponentBWRS]
    ComponentCPAInterface: typing.Type[ComponentCPAInterface]
    ComponentCSPsrk: typing.Type[ComponentCSPsrk]
    ComponentDesmukhMather: typing.Type[ComponentDesmukhMather]
    ComponentElectrolyteCPA: typing.Type[ComponentElectrolyteCPA]
    ComponentElectrolyteCPAOld: typing.Type[ComponentElectrolyteCPAOld]
    ComponentElectrolyteCPAstatoil: typing.Type[ComponentElectrolyteCPAstatoil]
    ComponentEos: typing.Type[ComponentEos]
    ComponentEosInterface: typing.Type[ComponentEosInterface]
    ComponentGE: typing.Type[ComponentGE]
    ComponentGEInterface: typing.Type[ComponentGEInterface]
    ComponentGENRTLmodifiedHV: typing.Type[ComponentGENRTLmodifiedHV]
    ComponentGENRTLmodifiedWS: typing.Type[ComponentGENRTLmodifiedWS]
    ComponentGERG2004: typing.Type[ComponentGERG2004]
    ComponentGERG2008Eos: typing.Type[ComponentGERG2008Eos]
    ComponentGEUnifac: typing.Type[ComponentGEUnifac]
    ComponentGEUnifacPSRK: typing.Type[ComponentGEUnifacPSRK]
    ComponentGEUnifacUMRPRU: typing.Type[ComponentGEUnifacUMRPRU]
    ComponentGEUniquac: typing.Type[ComponentGEUniquac]
    ComponentGEUniquacmodifiedHV: typing.Type[ComponentGEUniquacmodifiedHV]
    ComponentGEWilson: typing.Type[ComponentGEWilson]
    ComponentGeDuanSun: typing.Type[ComponentGeDuanSun]
    ComponentGeNRTL: typing.Type[ComponentGeNRTL]
    ComponentGePitzer: typing.Type[ComponentGePitzer]
    ComponentHydrate: typing.Type[ComponentHydrate]
    ComponentHydrateBallard: typing.Type[ComponentHydrateBallard]
    ComponentHydrateGF: typing.Type[ComponentHydrateGF]
    ComponentHydrateKluda: typing.Type[ComponentHydrateKluda]
    ComponentHydratePVTsim: typing.Type[ComponentHydratePVTsim]
    ComponentHydrateStatoil: typing.Type[ComponentHydrateStatoil]
    ComponentIdealGas: typing.Type[ComponentIdealGas]
    ComponentInterface: typing.Type[ComponentInterface]
    ComponentKentEisenberg: typing.Type[ComponentKentEisenberg]
    ComponentLeachmanEos: typing.Type[ComponentLeachmanEos]
    ComponentModifiedFurstElectrolyteEos: typing.Type[ComponentModifiedFurstElectrolyteEos]
    ComponentModifiedFurstElectrolyteEosMod2004: typing.Type[ComponentModifiedFurstElectrolyteEosMod2004]
    ComponentPCSAFT: typing.Type[ComponentPCSAFT]
    ComponentPCSAFTa: typing.Type[ComponentPCSAFTa]
    ComponentPR: typing.Type[ComponentPR]
    ComponentPRvolcor: typing.Type[ComponentPRvolcor]
    ComponentPrCPA: typing.Type[ComponentPrCPA]
    ComponentRK: typing.Type[ComponentRK]
    ComponentSolid: typing.Type[ComponentSolid]
    ComponentSoreideWhitson: typing.Type[ComponentSoreideWhitson]
    ComponentSpanWagnerEos: typing.Type[ComponentSpanWagnerEos]
    ComponentSrk: typing.Type[ComponentSrk]
    ComponentSrkCPA: typing.Type[ComponentSrkCPA]
    ComponentSrkCPAs: typing.Type[ComponentSrkCPAs]
    ComponentSrkPeneloux: typing.Type[ComponentSrkPeneloux]
    ComponentTST: typing.Type[ComponentTST]
    ComponentUMRCPA: typing.Type[ComponentUMRCPA]
    ComponentVegaEos: typing.Type[ComponentVegaEos]
    ComponentWater: typing.Type[ComponentWater]
    ComponentWax: typing.Type[ComponentWax]
    ComponentWaxWilson: typing.Type[ComponentWaxWilson]
    ComponentWonWax: typing.Type[ComponentWonWax]
    attractiveeosterm: jneqsim.neqsim.thermo.component.attractiveeosterm.__module_protocol__
    repulsiveeosterm: jneqsim.neqsim.thermo.component.repulsiveeosterm.__module_protocol__
