
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.io
import java.lang
import jpype
import jneqsim.neqsim.thermo.component
import typing



class AttractiveTermInterface(java.lang.Cloneable, java.io.Serializable):
    def aT(self, double: float) -> float: ...
    def alpha(self, double: float) -> float: ...
    def clone(self) -> 'AttractiveTermInterface': ...
    def diffaT(self, double: float) -> float: ...
    def diffalphaT(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def diffdiffalphaT(self, double: float) -> float: ...
    def getParameters(self, int: int) -> float: ...
    def getm(self) -> float: ...
    def init(self) -> None: ...
    def setParameters(self, int: int, double: float) -> None: ...
    def setm(self, double: float) -> None: ...

class AttractiveTermBaseClass(AttractiveTermInterface):
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface): ...
    def aT(self, double: float) -> float: ...
    def alpha(self, double: float) -> float: ...
    def clone(self) -> 'AttractiveTermBaseClass': ...
    def diffaT(self, double: float) -> float: ...
    def diffalphaT(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def diffdiffalphaT(self, double: float) -> float: ...
    def equals(self, object: typing.Any) -> bool: ...
    def getParameters(self, int: int) -> float: ...
    def getm(self) -> float: ...
    def setParameters(self, int: int, double: float) -> None: ...
    def setm(self, double: float) -> None: ...

class AttractiveTermMollerup(AttractiveTermBaseClass):
    @typing.overload
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface): ...
    @typing.overload
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface, doubleArray: typing.Union[typing.List[float], jpype.JArray]): ...
    def aT(self, double: float) -> float: ...
    def alpha(self, double: float) -> float: ...
    def clone(self) -> 'AttractiveTermMollerup': ...
    def diffaT(self, double: float) -> float: ...
    def diffalphaT(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def diffdiffalphaT(self, double: float) -> float: ...
    def init(self) -> None: ...

class AttractiveTermPr(AttractiveTermBaseClass):
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface): ...
    def aT(self, double: float) -> float: ...
    def alpha(self, double: float) -> float: ...
    def clone(self) -> 'AttractiveTermPr': ...
    def diffaT(self, double: float) -> float: ...
    def diffalphaT(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def diffdiffalphaT(self, double: float) -> float: ...
    def init(self) -> None: ...
    def setm(self, double: float) -> None: ...

class AttractiveTermRk(AttractiveTermBaseClass):
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface): ...
    def aT(self, double: float) -> float: ...
    def alpha(self, double: float) -> float: ...
    def clone(self) -> 'AttractiveTermRk': ...
    def diffaT(self, double: float) -> float: ...
    def diffalphaT(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def diffdiffalphaT(self, double: float) -> float: ...
    def init(self) -> None: ...

class AttractiveTermSchwartzentruber(AttractiveTermBaseClass):
    @typing.overload
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface): ...
    @typing.overload
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface, doubleArray: typing.Union[typing.List[float], jpype.JArray]): ...
    def aT(self, double: float) -> float: ...
    def alpha(self, double: float) -> float: ...
    def clone(self) -> 'AttractiveTermSchwartzentruber': ...
    def diffaT(self, double: float) -> float: ...
    def diffalphaT(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def diffdiffalphaT(self, double: float) -> float: ...
    def init(self) -> None: ...

class AttractiveTermSrk(AttractiveTermBaseClass):
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface): ...
    def aT(self, double: float) -> float: ...
    def alpha(self, double: float) -> float: ...
    def clone(self) -> 'AttractiveTermSrk': ...
    def diffaT(self, double: float) -> float: ...
    def diffalphaT(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def diffdiffalphaT(self, double: float) -> float: ...
    def init(self) -> None: ...
    def setm(self, double: float) -> None: ...

class AttractiveTermTwuCoon(AttractiveTermBaseClass):
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface): ...
    def aT(self, double: float) -> float: ...
    def alpha(self, double: float) -> float: ...
    def clone(self) -> 'AttractiveTermTwuCoon': ...
    def diffaT(self, double: float) -> float: ...
    def diffalphaT(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def diffdiffalphaT(self, double: float) -> float: ...
    def init(self) -> None: ...

class AttractiveTermTwuCoonParam(AttractiveTermBaseClass):
    @typing.overload
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface): ...
    @typing.overload
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface, doubleArray: typing.Union[typing.List[float], jpype.JArray]): ...
    def aT(self, double: float) -> float: ...
    def alpha(self, double: float) -> float: ...
    def clone(self) -> 'AttractiveTermTwuCoonParam': ...
    def diffaT(self, double: float) -> float: ...
    def diffalphaT(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def diffdiffalphaT(self, double: float) -> float: ...
    def init(self) -> None: ...

class AttractiveTermTwuCoonStatoil(AttractiveTermBaseClass):
    @typing.overload
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface): ...
    @typing.overload
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface, doubleArray: typing.Union[typing.List[float], jpype.JArray]): ...
    def aT(self, double: float) -> float: ...
    def alpha(self, double: float) -> float: ...
    def clone(self) -> 'AttractiveTermTwuCoonStatoil': ...
    def diffaT(self, double: float) -> float: ...
    def diffalphaT(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def diffdiffalphaT(self, double: float) -> float: ...
    def init(self) -> None: ...

class AttractiveTermCPAstatoil(AttractiveTermSrk):
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface): ...
    def aT(self, double: float) -> float: ...
    def alpha(self, double: float) -> float: ...
    def clone(self) -> 'AttractiveTermCPAstatoil': ...
    def diffaT(self, double: float) -> float: ...
    def diffalphaT(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def diffdiffalphaT(self, double: float) -> float: ...
    def init(self) -> None: ...

class AttractiveTermGERG(AttractiveTermPr):
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface): ...
    def AttractiveTermGERG(self) -> typing.Any: ...
    def aT(self, double: float) -> float: ...
    def alpha(self, double: float) -> float: ...
    def diffaT(self, double: float) -> float: ...
    def diffalphaTGERG(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def diffdiffalphaTGERG(self, double: float) -> float: ...

class AttractiveTermMatCop(AttractiveTermSrk):
    @typing.overload
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface): ...
    @typing.overload
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface, doubleArray: typing.Union[typing.List[float], jpype.JArray]): ...
    def aT(self, double: float) -> float: ...
    def alpha(self, double: float) -> float: ...
    def clone(self) -> 'AttractiveTermMatCop': ...
    def diffaT(self, double: float) -> float: ...
    def diffalphaT(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def diffdiffalphaT(self, double: float) -> float: ...
    def init(self) -> None: ...

class AttractiveTermMatCopPR(AttractiveTermPr):
    @typing.overload
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface): ...
    @typing.overload
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface, doubleArray: typing.Union[typing.List[float], jpype.JArray]): ...
    def aT(self, double: float) -> float: ...
    def alpha(self, double: float) -> float: ...
    def clone(self) -> 'AttractiveTermMatCopPR': ...
    def diffaT(self, double: float) -> float: ...
    def diffalphaT(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def diffdiffalphaT(self, double: float) -> float: ...

class AttractiveTermMatCopPRUMR(AttractiveTermPr):
    @typing.overload
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface): ...
    @typing.overload
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface, doubleArray: typing.Union[typing.List[float], jpype.JArray]): ...
    def aT(self, double: float) -> float: ...
    def alpha(self, double: float) -> float: ...
    def clone(self) -> 'AttractiveTermMatCopPRUMR': ...
    def diffaT(self, double: float) -> float: ...
    def diffalphaT(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def diffdiffalphaT(self, double: float) -> float: ...

class AttractiveTermPr1978(AttractiveTermPr):
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface): ...
    def clone(self) -> 'AttractiveTermPr1978': ...
    def init(self) -> None: ...
    def setm(self, double: float) -> None: ...

class AttractiveTermPrGassem2001(AttractiveTermPr):
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface): ...
    def aT(self, double: float) -> float: ...
    def alpha(self, double: float) -> float: ...
    def clone(self) -> 'AttractiveTermPrGassem2001': ...
    def diffaT(self, double: float) -> float: ...
    def diffalphaT(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def diffdiffalphaT(self, double: float) -> float: ...
    def init(self) -> None: ...

class AttractiveTermTwu(AttractiveTermSrk):
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface): ...
    def aT(self, double: float) -> float: ...
    def alpha(self, double: float) -> float: ...
    def clone(self) -> 'AttractiveTermTwu': ...
    def diffaT(self, double: float) -> float: ...
    def diffalphaT(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def diffdiffalphaT(self, double: float) -> float: ...
    def init(self) -> None: ...

class AttractiveTermUMRPRU(AttractiveTermPr):
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface): ...
    def clone(self) -> 'AttractiveTermUMRPRU': ...
    def init(self) -> None: ...

class AtractiveTermMatCopPRUMRNew(AttractiveTermMatCopPRUMR):
    @typing.overload
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface): ...
    @typing.overload
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface, doubleArray: typing.Union[typing.List[float], jpype.JArray]): ...
    def aT(self, double: float) -> float: ...
    def alpha(self, double: float) -> float: ...
    def clone(self) -> 'AtractiveTermMatCopPRUMRNew': ...
    def diffaT(self, double: float) -> float: ...
    def diffalphaT(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def diffdiffalphaT(self, double: float) -> float: ...

class AttractiveTermPrDanesh(AttractiveTermPr1978):
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface): ...
    def aT(self, double: float) -> float: ...
    def alpha(self, double: float) -> float: ...
    def clone(self) -> 'AttractiveTermPrDanesh': ...
    def diffaT(self, double: float) -> float: ...
    def diffalphaT(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def diffdiffalphaT(self, double: float) -> float: ...
    def init(self) -> None: ...

class AttractiveTermPrDelft1998(AttractiveTermPr1978):
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface): ...
    def aT(self, double: float) -> float: ...
    def alpha(self, double: float) -> float: ...
    def clone(self) -> 'AttractiveTermPrDelft1998': ...
    def diffaT(self, double: float) -> float: ...
    def diffalphaT(self, double: float) -> float: ...
    def diffdiffaT(self, double: float) -> float: ...
    def diffdiffalphaT(self, double: float) -> float: ...

class AttractiveTermSoreideWhitson(AttractiveTermPr1978):
    def __init__(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface): ...
    def alpha(self, double: float) -> float: ...
    def diffalphaT(self, double: float) -> float: ...
    def diffdiffalphaT(self, double: float) -> float: ...
    def setSalinityFromPhase(self, double: float) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.thermo.component.attractiveeosterm")``.

    AtractiveTermMatCopPRUMRNew: typing.Type[AtractiveTermMatCopPRUMRNew]
    AttractiveTermBaseClass: typing.Type[AttractiveTermBaseClass]
    AttractiveTermCPAstatoil: typing.Type[AttractiveTermCPAstatoil]
    AttractiveTermGERG: typing.Type[AttractiveTermGERG]
    AttractiveTermInterface: typing.Type[AttractiveTermInterface]
    AttractiveTermMatCop: typing.Type[AttractiveTermMatCop]
    AttractiveTermMatCopPR: typing.Type[AttractiveTermMatCopPR]
    AttractiveTermMatCopPRUMR: typing.Type[AttractiveTermMatCopPRUMR]
    AttractiveTermMollerup: typing.Type[AttractiveTermMollerup]
    AttractiveTermPr: typing.Type[AttractiveTermPr]
    AttractiveTermPr1978: typing.Type[AttractiveTermPr1978]
    AttractiveTermPrDanesh: typing.Type[AttractiveTermPrDanesh]
    AttractiveTermPrDelft1998: typing.Type[AttractiveTermPrDelft1998]
    AttractiveTermPrGassem2001: typing.Type[AttractiveTermPrGassem2001]
    AttractiveTermRk: typing.Type[AttractiveTermRk]
    AttractiveTermSchwartzentruber: typing.Type[AttractiveTermSchwartzentruber]
    AttractiveTermSoreideWhitson: typing.Type[AttractiveTermSoreideWhitson]
    AttractiveTermSrk: typing.Type[AttractiveTermSrk]
    AttractiveTermTwu: typing.Type[AttractiveTermTwu]
    AttractiveTermTwuCoon: typing.Type[AttractiveTermTwuCoon]
    AttractiveTermTwuCoonParam: typing.Type[AttractiveTermTwuCoonParam]
    AttractiveTermTwuCoonStatoil: typing.Type[AttractiveTermTwuCoonStatoil]
    AttractiveTermUMRPRU: typing.Type[AttractiveTermUMRPRU]
