
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import jpype
import jneqsim.neqsim.physicalproperties
import jneqsim.neqsim.physicalproperties.system
import jneqsim.neqsim.thermo
import jneqsim.neqsim.thermo.component
import jneqsim.neqsim.thermo.mixingrule
import jneqsim.neqsim.thermo.system
import org.netlib.util
import typing



class PhaseGEInterface:
    def getExcessGibbsEnergy(self, phaseInterface: 'PhaseInterface', int: int, double: float, double2: float, phaseType: 'PhaseType') -> float: ...
    def setAlpha(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def setDij(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def setDijT(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...

class PhaseInterface(jneqsim.neqsim.thermo.ThermodynamicConstantsInterface, java.lang.Cloneable):
    def FB(self) -> float: ...
    def FBB(self) -> float: ...
    def FBD(self) -> float: ...
    def FBT(self) -> float: ...
    def FBV(self) -> float: ...
    def FD(self) -> float: ...
    def FDT(self) -> float: ...
    def FDV(self) -> float: ...
    def FT(self) -> float: ...
    def FTT(self) -> float: ...
    def FTV(self) -> float: ...
    def FV(self) -> float: ...
    def FVV(self) -> float: ...
    def Fn(self) -> float: ...
    def FnB(self) -> float: ...
    def FnV(self) -> float: ...
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def addMoles(self, int: int, double: float) -> None: ...
    @typing.overload
    def addMolesChemReac(self, int: int, double: float, double2: float) -> None: ...
    @typing.overload
    def addMolesChemReac(self, int: int, double: float) -> None: ...
    def calcA(self, phaseInterface: 'PhaseInterface', double: float, double2: float, int: int) -> float: ...
    def calcAT(self, int: int, phaseInterface: 'PhaseInterface', double: float, double2: float, int2: int) -> float: ...
    def calcAi(self, int: int, phaseInterface: 'PhaseInterface', double: float, double2: float, int2: int) -> float: ...
    def calcAiT(self, int: int, phaseInterface: 'PhaseInterface', double: float, double2: float, int2: int) -> float: ...
    def calcAij(self, int: int, int2: int, phaseInterface: 'PhaseInterface', double: float, double2: float, int3: int) -> float: ...
    def calcB(self, phaseInterface: 'PhaseInterface', double: float, double2: float, int: int) -> float: ...
    def calcBi(self, int: int, phaseInterface: 'PhaseInterface', double: float, double2: float, int2: int) -> float: ...
    def calcBij(self, int: int, int2: int, phaseInterface: 'PhaseInterface', double: float, double2: float, int3: int) -> float: ...
    def calcMolarVolume(self, boolean: bool) -> None: ...
    def calcR(self) -> float: ...
    def clone(self) -> 'PhaseInterface': ...
    def dFdT(self) -> float: ...
    def dFdTdT(self) -> float: ...
    def dFdTdV(self) -> float: ...
    def dFdV(self) -> float: ...
    def dFdVdV(self) -> float: ...
    def fBB(self) -> float: ...
    def fBV(self) -> float: ...
    def fVV(self) -> float: ...
    def fb(self) -> float: ...
    def fv(self) -> float: ...
    def gBB(self) -> float: ...
    def gBV(self) -> float: ...
    def gV(self) -> float: ...
    def gVV(self) -> float: ...
    def gb(self) -> float: ...
    def getA(self) -> float: ...
    def getAT(self) -> float: ...
    def getATT(self) -> float: ...
    @typing.overload
    def getActivityCoefficient(self, int: int) -> float: ...
    @typing.overload
    def getActivityCoefficient(self, int: int, int2: int) -> float: ...
    def getActivityCoefficientSymetric(self, int: int) -> float: ...
    def getActivityCoefficientUnSymetric(self, int: int) -> float: ...
    def getAlpha0_GERG2008(self) -> typing.MutableSequence[org.netlib.util.doubleW]: ...
    @typing.overload
    def getAlpha0_Leachman(self) -> typing.MutableSequence[org.netlib.util.doubleW]: ...
    @typing.overload
    def getAlpha0_Leachman(self, string: typing.Union[java.lang.String, str]) -> typing.MutableSequence[org.netlib.util.doubleW]: ...
    def getAlpha0_Vega(self) -> typing.MutableSequence[org.netlib.util.doubleW]: ...
    def getAlphares_GERG2008(self) -> typing.MutableSequence[typing.MutableSequence[org.netlib.util.doubleW]]: ...
    @typing.overload
    def getAlphares_Leachman(self) -> typing.MutableSequence[typing.MutableSequence[org.netlib.util.doubleW]]: ...
    @typing.overload
    def getAlphares_Leachman(self, string: typing.Union[java.lang.String, str]) -> typing.MutableSequence[typing.MutableSequence[org.netlib.util.doubleW]]: ...
    def getAlphares_Vega(self) -> typing.MutableSequence[typing.MutableSequence[org.netlib.util.doubleW]]: ...
    def getAntoineVaporPressure(self, double: float) -> float: ...
    def getB(self) -> float: ...
    def getBeta(self) -> float: ...
    @typing.overload
    def getComponent(self, int: int) -> jneqsim.neqsim.thermo.component.ComponentInterface: ...
    @typing.overload
    def getComponent(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.thermo.component.ComponentInterface: ...
    def getComponentNames(self) -> typing.MutableSequence[java.lang.String]: ...
    def getComponentWithIndex(self, int: int) -> jneqsim.neqsim.thermo.component.ComponentInterface: ...
    def getComponents(self) -> typing.MutableSequence[jneqsim.neqsim.thermo.component.ComponentInterface]: ...
    def getComposition(self, string: typing.Union[java.lang.String, str]) -> typing.MutableSequence[float]: ...
    def getCompressibilityX(self) -> float: ...
    def getCompressibilityY(self) -> float: ...
    def getCorrectedVolume(self) -> float: ...
    @typing.overload
    def getCp(self) -> float: ...
    @typing.overload
    def getCp(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getCp0(self) -> float: ...
    def getCpres(self) -> float: ...
    @typing.overload
    def getCv(self) -> float: ...
    @typing.overload
    def getCv(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getDensity(self) -> float: ...
    @typing.overload
    def getDensity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getDensity_AGA8(self) -> float: ...
    def getDensity_GERG2008(self) -> float: ...
    @typing.overload
    def getDensity_Leachman(self) -> float: ...
    @typing.overload
    def getDensity_Leachman(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getDensity_Vega(self) -> float: ...
    @typing.overload
    def getEnthalpy(self) -> float: ...
    @typing.overload
    def getEnthalpy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getEnthalpydP(self) -> float: ...
    def getEnthalpydT(self) -> float: ...
    @typing.overload
    def getEntropy(self) -> float: ...
    @typing.overload
    def getEntropy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getEntropydP(self) -> float: ...
    def getEntropydT(self) -> float: ...
    def getExcessGibbsEnergy(self) -> float: ...
    def getExcessGibbsEnergySymetric(self) -> float: ...
    def getFlowRate(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getFugacity(self, int: int) -> float: ...
    @typing.overload
    def getFugacity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getGamma(self) -> float: ...
    def getGamma2(self) -> float: ...
    def getGibbsEnergy(self) -> float: ...
    def getGresTP(self) -> float: ...
    def getHelmholtzEnergy(self) -> float: ...
    def getHresTP(self) -> float: ...
    def getInfiniteDiluteFugacity(self, int: int, int2: int) -> float: ...
    def getInitType(self) -> int: ...
    @typing.overload
    def getInternalEnergy(self) -> float: ...
    @typing.overload
    def getInternalEnergy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getIsobaricThermalExpansivity(self) -> float: ...
    def getIsothermalCompressibility(self) -> float: ...
    @typing.overload
    def getJouleThomsonCoefficient(self) -> float: ...
    @typing.overload
    def getJouleThomsonCoefficient(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getKappa(self) -> float: ...
    def getLogActivityCoefficient(self, int: int, int2: int) -> float: ...
    @typing.overload
    def getLogInfiniteDiluteFugacity(self, int: int) -> float: ...
    @typing.overload
    def getLogInfiniteDiluteFugacity(self, int: int, int2: int) -> float: ...
    def getLogPureComponentFugacity(self, int: int) -> float: ...
    def getMass(self) -> float: ...
    def getMeanIonicActivity(self, int: int, int2: int) -> float: ...
    def getMixGibbsEnergy(self) -> float: ...
    def getMixingRule(self) -> jneqsim.neqsim.thermo.mixingrule.MixingRulesInterface: ...
    def getMixingRuleType(self) -> jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface: ...
    def getModelName(self) -> java.lang.String: ...
    def getMolalMeanIonicActivity(self, int: int, int2: int) -> float: ...
    def getMolarComposition(self) -> typing.MutableSequence[float]: ...
    @typing.overload
    def getMolarMass(self) -> float: ...
    @typing.overload
    def getMolarMass(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getMolarVolume(self) -> float: ...
    @typing.overload
    def getMolarVolume(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getMoleFraction(self) -> float: ...
    def getNumberOfComponents(self) -> int: ...
    def getNumberOfIonicComponents(self) -> int: ...
    def getNumberOfMolecularComponents(self) -> int: ...
    def getNumberOfMolesInPhase(self) -> float: ...
    def getOsmoticCoefficient(self, int: int) -> float: ...
    def getOsmoticCoefficientOfWater(self) -> float: ...
    def getPhase(self) -> 'PhaseInterface': ...
    def getPhaseFraction(self) -> float: ...
    def getPhaseTypeName(self) -> java.lang.String: ...
    def getPhysicalProperties(self) -> jneqsim.neqsim.physicalproperties.system.PhysicalProperties: ...
    def getPhysicalPropertyModel(self) -> jneqsim.neqsim.physicalproperties.system.PhysicalPropertyModel: ...
    @typing.overload
    def getPressure(self) -> float: ...
    @typing.overload
    def getPressure(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getProperties_GERG2008(self) -> typing.MutableSequence[float]: ...
    @typing.overload
    def getProperties_Leachman(self) -> typing.MutableSequence[float]: ...
    @typing.overload
    def getProperties_Leachman(self, string: typing.Union[java.lang.String, str]) -> typing.MutableSequence[float]: ...
    def getProperties_Vega(self) -> typing.MutableSequence[float]: ...
    def getPseudoCriticalPressure(self) -> float: ...
    def getPseudoCriticalTemperature(self) -> float: ...
    @typing.overload
    def getPureComponentFugacity(self, int: int) -> float: ...
    @typing.overload
    def getPureComponentFugacity(self, int: int, boolean: bool) -> float: ...
    @typing.overload
    def getRefPhase(self, int: int) -> 'PhaseInterface': ...
    @typing.overload
    def getRefPhase(self) -> typing.MutableSequence['PhaseInterface']: ...
    @typing.overload
    def getSoundSpeed(self) -> float: ...
    @typing.overload
    def getSoundSpeed(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getSresTP(self) -> float: ...
    @typing.overload
    def getTemperature(self) -> float: ...
    @typing.overload
    def getTemperature(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getThermalConductivity(self) -> float: ...
    @typing.overload
    def getThermalConductivity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getTotalVolume(self) -> float: ...
    def getType(self) -> 'PhaseType': ...
    @typing.overload
    def getViscosity(self) -> float: ...
    @typing.overload
    def getViscosity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getVolume(self) -> float: ...
    @typing.overload
    def getVolume(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getWaterDensity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getWtFrac(self, int: int) -> float: ...
    @typing.overload
    def getWtFrac(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getWtFraction(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> float: ...
    def getWtFractionOfWaxFormingComponents(self) -> float: ...
    def getZ(self) -> float: ...
    def getZvolcorr(self) -> float: ...
    def geta(self, phaseInterface: 'PhaseInterface', double: float, double2: float, int: int) -> float: ...
    def getb(self, phaseInterface: 'PhaseInterface', double: float, double2: float, int: int) -> float: ...
    def getcomponentArray(self) -> typing.MutableSequence[jneqsim.neqsim.thermo.component.ComponentInterface]: ...
    def getdPdTVn(self) -> float: ...
    def getdPdVTn(self) -> float: ...
    def getdPdrho(self) -> float: ...
    def getdrhodN(self) -> float: ...
    def getdrhodP(self) -> float: ...
    def getdrhodT(self) -> float: ...
    def getg(self) -> float: ...
    def getpH(self) -> float: ...
    @typing.overload
    def hasComponent(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def hasComponent(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    def hasPlusFraction(self) -> bool: ...
    def hasTBPFraction(self) -> bool: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: 'PhaseType', double2: float) -> None: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def initPhysicalProperties(self) -> None: ...
    @typing.overload
    def initPhysicalProperties(self, physicalPropertyType: jneqsim.neqsim.physicalproperties.PhysicalPropertyType) -> None: ...
    @typing.overload
    def initPhysicalProperties(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def initRefPhases(self, boolean: bool) -> None: ...
    def isConstantPhaseVolume(self) -> bool: ...
    def isMixingRuleDefined(self) -> bool: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: 'PhaseType') -> float: ...
    def normalize(self) -> None: ...
    def removeComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float) -> None: ...
    def resetMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...
    def resetPhysicalProperties(self) -> None: ...
    def setAttractiveTerm(self, int: int) -> None: ...
    def setBeta(self, double: float) -> None: ...
    def setComponentArray(self, componentInterfaceArray: typing.Union[typing.List[jneqsim.neqsim.thermo.component.ComponentInterface], jpype.JArray]) -> None: ...
    def setConstantPhaseVolume(self, boolean: bool) -> None: ...
    def setEmptyFluid(self) -> None: ...
    def setInitType(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...
    @typing.overload
    def setMixingRule(self, int: int) -> None: ...
    def setMixingRuleGEModel(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setMolarVolume(self, double: float) -> None: ...
    def setMoleFractions(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setNumberOfComponents(self, int: int) -> None: ...
    def setParams(self, phaseInterface: 'PhaseInterface', doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray], doubleArray4: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def setPhaseTypeName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setPhysicalProperties(self, physicalPropertyModel: jneqsim.neqsim.physicalproperties.system.PhysicalPropertyModel) -> None: ...
    @typing.overload
    def setPhysicalProperties(self) -> None: ...
    def setPhysicalPropertyModel(self, physicalPropertyModel: jneqsim.neqsim.physicalproperties.system.PhysicalPropertyModel) -> None: ...
    def setPpm(self, physicalPropertyModel: jneqsim.neqsim.physicalproperties.system.PhysicalPropertyModel) -> None: ...
    def setPressure(self, double: float) -> None: ...
    def setProperties(self, phaseInterface: 'PhaseInterface') -> None: ...
    @typing.overload
    def setRefPhase(self, int: int, phaseInterface: 'PhaseInterface') -> None: ...
    @typing.overload
    def setRefPhase(self, phaseInterfaceArray: typing.Union[typing.List['PhaseInterface'], jpype.JArray]) -> None: ...
    def setTemperature(self, double: float) -> None: ...
    def setTotalVolume(self, double: float) -> None: ...
    def setType(self, phaseType: 'PhaseType') -> None: ...
    @typing.overload
    def useVolumeCorrection(self) -> bool: ...
    @typing.overload
    def useVolumeCorrection(self, boolean: bool) -> None: ...

class PhaseType(java.lang.Enum['PhaseType']):
    LIQUID: typing.ClassVar['PhaseType'] = ...
    GAS: typing.ClassVar['PhaseType'] = ...
    OIL: typing.ClassVar['PhaseType'] = ...
    AQUEOUS: typing.ClassVar['PhaseType'] = ...
    HYDRATE: typing.ClassVar['PhaseType'] = ...
    WAX: typing.ClassVar['PhaseType'] = ...
    SOLID: typing.ClassVar['PhaseType'] = ...
    SOLIDCOMPLEX: typing.ClassVar['PhaseType'] = ...
    @staticmethod
    def byDesc(string: typing.Union[java.lang.String, str]) -> 'PhaseType': ...
    @staticmethod
    def byName(string: typing.Union[java.lang.String, str]) -> 'PhaseType': ...
    @staticmethod
    def byValue(int: int) -> 'PhaseType': ...
    def getDesc(self) -> java.lang.String: ...
    def getValue(self) -> int: ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: typing.Union[java.lang.String, str]) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(string: typing.Union[java.lang.String, str]) -> 'PhaseType': ...
    @staticmethod
    def values() -> typing.MutableSequence['PhaseType']: ...

class StateOfMatter(java.lang.Enum['StateOfMatter']):
    GAS: typing.ClassVar['StateOfMatter'] = ...
    LIQUID: typing.ClassVar['StateOfMatter'] = ...
    SOLID: typing.ClassVar['StateOfMatter'] = ...
    @staticmethod
    def fromPhaseType(phaseType: PhaseType) -> 'StateOfMatter': ...
    @staticmethod
    def isGas(phaseType: PhaseType) -> bool: ...
    @staticmethod
    def isLiquid(phaseType: PhaseType) -> bool: ...
    @staticmethod
    def isSolid(phaseType: PhaseType) -> bool: ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: typing.Union[java.lang.String, str]) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(string: typing.Union[java.lang.String, str]) -> 'StateOfMatter': ...
    @staticmethod
    def values() -> typing.MutableSequence['StateOfMatter']: ...

class Phase(PhaseInterface):
    numberOfComponents: int = ...
    componentArray: typing.MutableSequence[jneqsim.neqsim.thermo.component.ComponentInterface] = ...
    calcMolarVolume: bool = ...
    physicalPropertyHandler: jneqsim.neqsim.physicalproperties.PhysicalPropertyHandler = ...
    chemSyst: bool = ...
    thermoPropertyModelName: java.lang.String = ...
    numberOfMolesInPhase: float = ...
    def __init__(self): ...
    def FB(self) -> float: ...
    def FBB(self) -> float: ...
    def FBD(self) -> float: ...
    def FBT(self) -> float: ...
    def FBV(self) -> float: ...
    def FD(self) -> float: ...
    def FDT(self) -> float: ...
    def FDV(self) -> float: ...
    def FT(self) -> float: ...
    def FTT(self) -> float: ...
    def FTV(self) -> float: ...
    def FV(self) -> float: ...
    def FVV(self) -> float: ...
    def Fn(self) -> float: ...
    def FnB(self) -> float: ...
    def FnV(self) -> float: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    def addMoles(self, int: int, double: float) -> None: ...
    @typing.overload
    def addMolesChemReac(self, int: int, double: float) -> None: ...
    @typing.overload
    def addMolesChemReac(self, int: int, double: float, double2: float) -> None: ...
    @typing.overload
    def calcA(self, int: int, phaseInterface: PhaseInterface, double: float, double2: float, int2: int) -> float: ...
    @typing.overload
    def calcA(self, phaseInterface: PhaseInterface, double: float, double2: float, int: int) -> float: ...
    def calcAT(self, int: int, phaseInterface: PhaseInterface, double: float, double2: float, int2: int) -> float: ...
    def calcAi(self, int: int, phaseInterface: PhaseInterface, double: float, double2: float, int2: int) -> float: ...
    def calcAiT(self, int: int, phaseInterface: PhaseInterface, double: float, double2: float, int2: int) -> float: ...
    def calcAij(self, int: int, int2: int, phaseInterface: PhaseInterface, double: float, double2: float, int3: int) -> float: ...
    def calcB(self, phaseInterface: PhaseInterface, double: float, double2: float, int: int) -> float: ...
    def calcBi(self, int: int, phaseInterface: PhaseInterface, double: float, double2: float, int2: int) -> float: ...
    def calcBij(self, int: int, int2: int, phaseInterface: PhaseInterface, double: float, double2: float, int3: int) -> float: ...
    def calcDiElectricConstant(self, double: float) -> float: ...
    def calcDiElectricConstantdT(self, double: float) -> float: ...
    def calcDiElectricConstantdTdT(self, double: float) -> float: ...
    def calcMolarVolume(self, boolean: bool) -> None: ...
    def calcR(self) -> float: ...
    def clone(self) -> 'Phase': ...
    def dFdT(self) -> float: ...
    def dFdTdT(self) -> float: ...
    def dFdTdV(self) -> float: ...
    def dFdV(self) -> float: ...
    def dFdVdV(self) -> float: ...
    def equals(self, object: typing.Any) -> bool: ...
    def fBB(self) -> float: ...
    def fBV(self) -> float: ...
    def fVV(self) -> float: ...
    def fb(self) -> float: ...
    def fv(self) -> float: ...
    def gBB(self) -> float: ...
    def gBV(self) -> float: ...
    def gV(self) -> float: ...
    def gVV(self) -> float: ...
    def gb(self) -> float: ...
    def getA(self) -> float: ...
    def getAT(self) -> float: ...
    def getATT(self) -> float: ...
    @typing.overload
    def getActivityCoefficient(self, int: int) -> float: ...
    @typing.overload
    def getActivityCoefficient(self, int: int, int2: int) -> float: ...
    def getActivityCoefficientSymetric(self, int: int) -> float: ...
    def getActivityCoefficientUnSymetric(self, int: int) -> float: ...
    def getAiT(self) -> float: ...
    def getAlpha0_GERG2008(self) -> typing.MutableSequence[org.netlib.util.doubleW]: ...
    @typing.overload
    def getAlpha0_Leachman(self) -> typing.MutableSequence[org.netlib.util.doubleW]: ...
    @typing.overload
    def getAlpha0_Leachman(self, string: typing.Union[java.lang.String, str]) -> typing.MutableSequence[org.netlib.util.doubleW]: ...
    def getAlpha0_Vega(self) -> typing.MutableSequence[org.netlib.util.doubleW]: ...
    def getAlphares_GERG2008(self) -> typing.MutableSequence[typing.MutableSequence[org.netlib.util.doubleW]]: ...
    @typing.overload
    def getAlphares_Leachman(self) -> typing.MutableSequence[typing.MutableSequence[org.netlib.util.doubleW]]: ...
    @typing.overload
    def getAlphares_Leachman(self, string: typing.Union[java.lang.String, str]) -> typing.MutableSequence[typing.MutableSequence[org.netlib.util.doubleW]]: ...
    def getAlphares_Vega(self) -> typing.MutableSequence[typing.MutableSequence[org.netlib.util.doubleW]]: ...
    def getAntoineVaporPressure(self, double: float) -> float: ...
    def getB(self) -> float: ...
    def getBeta(self) -> float: ...
    def getBi(self) -> float: ...
    @typing.overload
    def getComponent(self, int: int) -> jneqsim.neqsim.thermo.component.ComponentInterface: ...
    @typing.overload
    def getComponent(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.thermo.component.ComponentInterface: ...
    def getComponentNames(self) -> typing.MutableSequence[java.lang.String]: ...
    def getComponentWithIndex(self, int: int) -> jneqsim.neqsim.thermo.component.ComponentInterface: ...
    def getComponents(self) -> typing.MutableSequence[jneqsim.neqsim.thermo.component.ComponentInterface]: ...
    def getComposition(self, string: typing.Union[java.lang.String, str]) -> typing.MutableSequence[float]: ...
    def getCompressibilityX(self) -> float: ...
    def getCompressibilityY(self) -> float: ...
    def getCorrectedVolume(self) -> float: ...
    @typing.overload
    def getCp(self) -> float: ...
    @typing.overload
    def getCp(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getCp0(self) -> float: ...
    def getCpres(self) -> float: ...
    @typing.overload
    def getCv(self) -> float: ...
    @typing.overload
    def getCv(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getCvres(self) -> float: ...
    @typing.overload
    def getDensity(self) -> float: ...
    @typing.overload
    def getDensity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getDensity_AGA8(self) -> float: ...
    def getDensity_GERG2008(self) -> float: ...
    @typing.overload
    def getDensity_Leachman(self) -> float: ...
    @typing.overload
    def getDensity_Leachman(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getDensity_Vega(self) -> float: ...
    def getDiElectricConstant(self) -> float: ...
    @typing.overload
    def getEnthalpy(self) -> float: ...
    @typing.overload
    def getEnthalpy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getEnthalpydP(self) -> float: ...
    def getEnthalpydT(self) -> float: ...
    @typing.overload
    def getEntropy(self) -> float: ...
    @typing.overload
    def getEntropy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getEntropydP(self) -> float: ...
    def getEntropydT(self) -> float: ...
    def getExcessGibbsEnergy(self) -> float: ...
    def getExcessGibbsEnergySymetric(self) -> float: ...
    def getFlowRate(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getFugacity(self, int: int) -> float: ...
    @typing.overload
    def getFugacity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getGamma(self) -> float: ...
    def getGibbsEnergy(self) -> float: ...
    def getGresTP(self) -> float: ...
    def getHID(self) -> float: ...
    def getHelmholtzEnergy(self) -> float: ...
    def getHresTP(self) -> float: ...
    def getHresdP(self) -> float: ...
    @typing.overload
    def getInfiniteDiluteFugacity(self, int: int) -> float: ...
    @typing.overload
    def getInfiniteDiluteFugacity(self, int: int, int2: int) -> float: ...
    def getInitType(self) -> int: ...
    @typing.overload
    def getInternalEnergy(self) -> float: ...
    @typing.overload
    def getInternalEnergy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getIsobaricThermalExpansivity(self) -> float: ...
    def getIsothermalCompressibility(self) -> float: ...
    @typing.overload
    def getJouleThomsonCoefficient(self) -> float: ...
    @typing.overload
    def getJouleThomsonCoefficient(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getKappa(self) -> float: ...
    def getLogActivityCoefficient(self, int: int, int2: int) -> float: ...
    @typing.overload
    def getLogInfiniteDiluteFugacity(self, int: int) -> float: ...
    @typing.overload
    def getLogInfiniteDiluteFugacity(self, int: int, int2: int) -> float: ...
    @typing.overload
    def getLogPureComponentFugacity(self, int: int) -> float: ...
    @typing.overload
    def getLogPureComponentFugacity(self, int: int, boolean: bool) -> float: ...
    def getMass(self) -> float: ...
    def getMeanIonicActivity(self, int: int, int2: int) -> float: ...
    def getMixGibbsEnergy(self) -> float: ...
    def getMixingRuleType(self) -> jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface: ...
    def getModelName(self) -> java.lang.String: ...
    def getMolalMeanIonicActivity(self, int: int, int2: int) -> float: ...
    def getMolarComposition(self) -> typing.MutableSequence[float]: ...
    @typing.overload
    def getMolarMass(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getMolarMass(self) -> float: ...
    @typing.overload
    def getMolarVolume(self) -> float: ...
    @typing.overload
    def getMolarVolume(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getMoleFraction(self) -> float: ...
    def getNumberOfComponents(self) -> int: ...
    def getNumberOfIonicComponents(self) -> int: ...
    def getNumberOfMolecularComponents(self) -> int: ...
    def getNumberOfMolesInPhase(self) -> float: ...
    def getOsmoticCoefficient(self, int: int) -> float: ...
    def getOsmoticCoefficientOfWater(self) -> float: ...
    def getPhase(self) -> PhaseInterface: ...
    def getPhysicalProperties(self) -> jneqsim.neqsim.physicalproperties.system.PhysicalProperties: ...
    def getPhysicalPropertyModel(self) -> jneqsim.neqsim.physicalproperties.system.PhysicalPropertyModel: ...
    @typing.overload
    def getPressure(self) -> float: ...
    @typing.overload
    def getPressure(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getProperties_GERG2008(self) -> typing.MutableSequence[float]: ...
    @typing.overload
    def getProperties_Leachman(self) -> typing.MutableSequence[float]: ...
    @typing.overload
    def getProperties_Leachman(self, string: typing.Union[java.lang.String, str]) -> typing.MutableSequence[float]: ...
    def getProperties_Vega(self) -> typing.MutableSequence[float]: ...
    def getPseudoCriticalPressure(self) -> float: ...
    def getPseudoCriticalTemperature(self) -> float: ...
    @typing.overload
    def getPureComponentFugacity(self, int: int) -> float: ...
    @typing.overload
    def getPureComponentFugacity(self, int: int, boolean: bool) -> float: ...
    @typing.overload
    def getRefPhase(self, int: int) -> PhaseInterface: ...
    @typing.overload
    def getRefPhase(self) -> typing.MutableSequence[PhaseInterface]: ...
    @typing.overload
    def getSoundSpeed(self) -> float: ...
    @typing.overload
    def getSoundSpeed(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getSresTP(self) -> float: ...
    def getSresTV(self) -> float: ...
    @typing.overload
    def getTemperature(self) -> float: ...
    @typing.overload
    def getTemperature(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getThermalConductivity(self) -> float: ...
    @typing.overload
    def getThermalConductivity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getThermoPropertyModelName(self) -> java.lang.String: ...
    def getTotalVolume(self) -> float: ...
    def getType(self) -> PhaseType: ...
    @typing.overload
    def getViscosity(self) -> float: ...
    @typing.overload
    def getViscosity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getVolume(self) -> float: ...
    @typing.overload
    def getVolume(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getWaterDensity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getWtFrac(self, int: int) -> float: ...
    @typing.overload
    def getWtFrac(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getWtFraction(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> float: ...
    def getWtFractionOfWaxFormingComponents(self) -> float: ...
    def getZ(self) -> float: ...
    def getZvolcorr(self) -> float: ...
    def geta(self, phaseInterface: PhaseInterface, double: float, double2: float, int: int) -> float: ...
    def getb(self, phaseInterface: PhaseInterface, double: float, double2: float, int: int) -> float: ...
    def getcomponentArray(self) -> typing.MutableSequence[jneqsim.neqsim.thermo.component.ComponentInterface]: ...
    def getdPdTVn(self) -> float: ...
    def getdPdVTn(self) -> float: ...
    def getdPdrho(self) -> float: ...
    def getdrhodN(self) -> float: ...
    def getdrhodP(self) -> float: ...
    def getdrhodT(self) -> float: ...
    def getg(self) -> float: ...
    def getpH(self) -> float: ...
    def getpH_old(self) -> float: ...
    def groupTBPfractions(self) -> typing.MutableSequence[float]: ...
    @typing.overload
    def hasComponent(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def hasComponent(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    def hasPlusFraction(self) -> bool: ...
    def hasTBPFraction(self) -> bool: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    @typing.overload
    def initPhysicalProperties(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def initPhysicalProperties(self) -> None: ...
    @typing.overload
    def initPhysicalProperties(self, physicalPropertyType: jneqsim.neqsim.physicalproperties.PhysicalPropertyType) -> None: ...
    @typing.overload
    def initRefPhases(self, boolean: bool) -> None: ...
    @typing.overload
    def initRefPhases(self, boolean: bool, string: typing.Union[java.lang.String, str]) -> None: ...
    def isConstantPhaseVolume(self) -> bool: ...
    def isMixingRuleDefined(self) -> bool: ...
    def normalize(self) -> None: ...
    def removeComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float) -> None: ...
    def resetPhysicalProperties(self) -> None: ...
    def setAttractiveTerm(self, int: int) -> None: ...
    def setBeta(self, double: float) -> None: ...
    def setComponentArray(self, componentInterfaceArray: typing.Union[typing.List[jneqsim.neqsim.thermo.component.ComponentInterface], jpype.JArray]) -> None: ...
    def setConstantPhaseVolume(self, boolean: bool) -> None: ...
    def setEmptyFluid(self) -> None: ...
    def setInitType(self, int: int) -> None: ...
    def setMolarVolume(self, double: float) -> None: ...
    def setMoleFractions(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setNumberOfComponents(self, int: int) -> None: ...
    def setParams(self, phaseInterface: PhaseInterface, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray], doubleArray4: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    @typing.overload
    def setPhysicalProperties(self) -> None: ...
    @typing.overload
    def setPhysicalProperties(self, physicalPropertyModel: jneqsim.neqsim.physicalproperties.system.PhysicalPropertyModel) -> None: ...
    def setPhysicalPropertyModel(self, physicalPropertyModel: jneqsim.neqsim.physicalproperties.system.PhysicalPropertyModel) -> None: ...
    def setPpm(self, physicalPropertyModel: jneqsim.neqsim.physicalproperties.system.PhysicalPropertyModel) -> None: ...
    def setPressure(self, double: float) -> None: ...
    def setProperties(self, phaseInterface: PhaseInterface) -> None: ...
    @typing.overload
    def setRefPhase(self, int: int, phaseInterface: PhaseInterface) -> None: ...
    @typing.overload
    def setRefPhase(self, phaseInterfaceArray: typing.Union[typing.List[PhaseInterface], jpype.JArray]) -> None: ...
    def setTemperature(self, double: float) -> None: ...
    def setTotalVolume(self, double: float) -> None: ...
    def setType(self, phaseType: PhaseType) -> None: ...
    @typing.overload
    def useVolumeCorrection(self) -> bool: ...
    @typing.overload
    def useVolumeCorrection(self, boolean: bool) -> None: ...

class PhaseEosInterface(PhaseInterface):
    def F(self) -> float: ...
    def calcPressure(self) -> float: ...
    def calcPressuredV(self) -> float: ...
    def dFdN(self, int: int) -> float: ...
    def dFdNdN(self, int: int, int2: int) -> float: ...
    def dFdNdT(self, int: int) -> float: ...
    def dFdNdV(self, int: int) -> float: ...
    def displayInteractionCoefficients(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def getAresTV(self) -> float: ...
    def getEosMixingRule(self) -> jneqsim.neqsim.thermo.mixingrule.EosMixingRulesInterface: ...
    def getMixingRuleName(self) -> java.lang.String: ...
    @typing.overload
    def getMolarVolume(self) -> float: ...
    @typing.overload
    def getMolarVolume(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getPressureAttractive(self) -> float: ...
    def getPressureRepulsive(self) -> float: ...
    def getSresTV(self) -> float: ...

class PhaseCPAInterface(PhaseEosInterface):
    def getCpaMixingRule(self) -> jneqsim.neqsim.thermo.mixingrule.CPAMixingRulesInterface: ...
    def getCrossAssosiationScheme(self, int: int, int2: int, int3: int, int4: int) -> int: ...
    def getGcpa(self) -> float: ...
    def getGcpav(self) -> float: ...
    def getHcpatot(self) -> float: ...
    def getTotalNumberOfAccociationSites(self) -> int: ...
    def setTotalNumberOfAccociationSites(self, int: int) -> None: ...

class PhaseDefault(Phase):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, componentInterface: jneqsim.neqsim.thermo.component.ComponentInterface): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def getGibbsEnergy(self) -> float: ...
    def getMixingRule(self) -> jneqsim.neqsim.thermo.mixingrule.EosMixingRulesInterface: ...
    @typing.overload
    def getMolarVolume(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getMolarVolume(self) -> float: ...
    @typing.overload
    def getSoundSpeed(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getSoundSpeed(self) -> float: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def resetMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...
    def setComponentType(self, componentInterface: jneqsim.neqsim.thermo.component.ComponentInterface) -> None: ...
    @typing.overload
    def setMixingRule(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...
    def setMixingRuleGEModel(self, string: typing.Union[java.lang.String, str]) -> None: ...

class PhaseEos(Phase, PhaseEosInterface):
    delta1: float = ...
    delta2: float = ...
    def __init__(self): ...
    def F(self) -> float: ...
    def FB(self) -> float: ...
    def FBB(self) -> float: ...
    def FBD(self) -> float: ...
    def FBT(self) -> float: ...
    def FBV(self) -> float: ...
    def FD(self) -> float: ...
    def FDT(self) -> float: ...
    def FDV(self) -> float: ...
    def FT(self) -> float: ...
    def FTT(self) -> float: ...
    def FTV(self) -> float: ...
    def FV(self) -> float: ...
    def FVV(self) -> float: ...
    def FVVV(self) -> float: ...
    def Fn(self) -> float: ...
    def FnB(self) -> float: ...
    def FnV(self) -> float: ...
    @typing.overload
    def calcA(self, int: int, phaseInterface: PhaseInterface, double: float, double2: float, int2: int) -> float: ...
    @typing.overload
    def calcA(self, phaseInterface: PhaseInterface, double: float, double2: float, int: int) -> float: ...
    @typing.overload
    def calcAT(self, int: int, phaseInterface: PhaseInterface, double: float, double2: float, int2: int) -> float: ...
    @typing.overload
    def calcAT(self, phaseInterface: PhaseInterface, double: float, double2: float, int: int) -> float: ...
    def calcATT(self, phaseInterface: PhaseInterface, double: float, double2: float, int: int) -> float: ...
    def calcAi(self, int: int, phaseInterface: PhaseInterface, double: float, double2: float, int2: int) -> float: ...
    def calcAiT(self, int: int, phaseInterface: PhaseInterface, double: float, double2: float, int2: int) -> float: ...
    def calcAij(self, int: int, int2: int, phaseInterface: PhaseInterface, double: float, double2: float, int3: int) -> float: ...
    def calcB(self, phaseInterface: PhaseInterface, double: float, double2: float, int: int) -> float: ...
    def calcBi(self, int: int, phaseInterface: PhaseInterface, double: float, double2: float, int2: int) -> float: ...
    def calcBij(self, int: int, int2: int, phaseInterface: PhaseInterface, double: float, double2: float, int3: int) -> float: ...
    def calcPressure(self) -> float: ...
    def calcPressuredV(self) -> float: ...
    def calcf(self) -> float: ...
    def calcg(self) -> float: ...
    def clone(self) -> 'PhaseEos': ...
    def dFdN(self, int: int) -> float: ...
    def dFdNdN(self, int: int, int2: int) -> float: ...
    def dFdNdT(self, int: int) -> float: ...
    def dFdNdV(self, int: int) -> float: ...
    def dFdT(self) -> float: ...
    def dFdTdT(self) -> float: ...
    def dFdTdV(self) -> float: ...
    def dFdV(self) -> float: ...
    def dFdVdV(self) -> float: ...
    def dFdVdVdV(self) -> float: ...
    def dFdxMatrix(self) -> typing.MutableSequence[float]: ...
    def dFdxMatrixSimple(self) -> typing.MutableSequence[float]: ...
    def dFdxdxMatrix(self) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def dFdxdxMatrixSimple(self) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def displayInteractionCoefficients(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def equals(self, object: typing.Any) -> bool: ...
    def fBB(self) -> float: ...
    def fBV(self) -> float: ...
    def fVV(self) -> float: ...
    def fVVV(self) -> float: ...
    def fb(self) -> float: ...
    def fv(self) -> float: ...
    def gBB(self) -> float: ...
    def gBV(self) -> float: ...
    def gV(self) -> float: ...
    def gVV(self) -> float: ...
    def gVVV(self) -> float: ...
    def gb(self) -> float: ...
    def getA(self) -> float: ...
    def getAT(self) -> float: ...
    def getATT(self) -> float: ...
    def getAresTV(self) -> float: ...
    def getB(self) -> float: ...
    def getCpres(self) -> float: ...
    def getCvres(self) -> float: ...
    def getEosMixingRule(self) -> jneqsim.neqsim.thermo.mixingrule.EosMixingRulesInterface: ...
    def getF(self) -> float: ...
    def getGradientVector(self) -> typing.MutableSequence[float]: ...
    def getGresTP(self) -> float: ...
    def getHresTP(self) -> float: ...
    def getHresdP(self) -> float: ...
    @typing.overload
    def getJouleThomsonCoefficient(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getJouleThomsonCoefficient(self) -> float: ...
    def getKappa(self) -> float: ...
    def getMixingRule(self) -> jneqsim.neqsim.thermo.mixingrule.EosMixingRulesInterface: ...
    def getMixingRuleName(self) -> java.lang.String: ...
    def getPressureAttractive(self) -> float: ...
    def getPressureRepulsive(self) -> float: ...
    @typing.overload
    def getSoundSpeed(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getSoundSpeed(self) -> float: ...
    def getSresTP(self) -> float: ...
    def getSresTV(self) -> float: ...
    def getUSVHessianMatrix(self) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def geta(self, phaseInterface: PhaseInterface, double: float, double2: float, int: int) -> float: ...
    def getb(self, phaseInterface: PhaseInterface, double: float, double2: float, int: int) -> float: ...
    def getdPdTVn(self) -> float: ...
    def getdPdVTn(self) -> float: ...
    def getdPdrho(self) -> float: ...
    def getdTVndSVnJaobiMatrix(self) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def getdUdSVn(self) -> float: ...
    def getdUdSdSVn(self) -> float: ...
    def getdUdSdVn(self, phaseInterface: PhaseInterface) -> float: ...
    def getdUdVSn(self) -> float: ...
    def getdUdVdVSn(self, phaseInterface: PhaseInterface) -> float: ...
    def getdVdrho(self) -> float: ...
    def getdrhodN(self) -> float: ...
    def getdrhodP(self) -> float: ...
    def getdrhodT(self) -> float: ...
    def getf_loc(self) -> float: ...
    def getg(self) -> float: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def molarVolume2(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def resetMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...
    @typing.overload
    def setMixingRule(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...
    def setMixingRuleGEModel(self, string: typing.Union[java.lang.String, str]) -> None: ...

class PhaseGE(Phase, PhaseGEInterface):
    def __init__(self): ...
    @typing.overload
    def getActivityCoefficient(self, int: int, int2: int) -> float: ...
    @typing.overload
    def getActivityCoefficient(self, int: int) -> float: ...
    def getActivityCoefficientInfDil(self, int: int) -> float: ...
    def getActivityCoefficientInfDilWater(self, int: int, int2: int) -> float: ...
    def getActivityCoefficientSymetric(self, int: int) -> float: ...
    @typing.overload
    def getCp(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getCp(self) -> float: ...
    @typing.overload
    def getCv(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getCv(self) -> float: ...
    @typing.overload
    def getDensity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getDensity(self) -> float: ...
    @typing.overload
    def getEnthalpy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getEnthalpy(self) -> float: ...
    @typing.overload
    def getEntropy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getEntropy(self) -> float: ...
    @typing.overload
    def getJouleThomsonCoefficient(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getJouleThomsonCoefficient(self) -> float: ...
    def getMixingRule(self) -> jneqsim.neqsim.thermo.mixingrule.EosMixingRulesInterface: ...
    @typing.overload
    def getMolarVolume(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getMolarVolume(self) -> float: ...
    @typing.overload
    def getSoundSpeed(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getSoundSpeed(self) -> float: ...
    def getZ(self) -> float: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, double2: float, double3: float, double4: float, int: int, phaseType: PhaseType, int2: int) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    def resetMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...
    @typing.overload
    def setMixingRule(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...
    def setMixingRuleGEModel(self, string: typing.Union[java.lang.String, str]) -> None: ...

class PhaseHydrate(Phase):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: typing.Union[java.lang.String, str]): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def clone(self) -> 'PhaseHydrate': ...
    def getMixingRule(self) -> jneqsim.neqsim.thermo.mixingrule.MixingRulesInterface: ...
    @typing.overload
    def getSoundSpeed(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getSoundSpeed(self) -> float: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def resetMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...
    @typing.overload
    def setMixingRule(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...
    def setMixingRuleGEModel(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setSolidRefFluidPhase(self, phaseInterface: PhaseInterface) -> None: ...

class PhaseIdealGas(Phase, jneqsim.neqsim.thermo.ThermodynamicConstantsInterface):
    def __init__(self): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def clone(self) -> 'PhaseIdealGas': ...
    def getCpres(self) -> float: ...
    def getCvres(self) -> float: ...
    @typing.overload
    def getDensity(self) -> float: ...
    @typing.overload
    def getDensity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getHresTP(self) -> float: ...
    @typing.overload
    def getJouleThomsonCoefficient(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getJouleThomsonCoefficient(self) -> float: ...
    def getMixingRule(self) -> jneqsim.neqsim.thermo.mixingrule.EosMixingRulesInterface: ...
    @typing.overload
    def getSoundSpeed(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getSoundSpeed(self) -> float: ...
    def getSresTP(self) -> float: ...
    def getZ(self) -> float: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def resetMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...
    @typing.overload
    def setMixingRule(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...
    def setMixingRuleGEModel(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setPressure(self, double: float) -> None: ...
    def setTemperature(self, double: float) -> None: ...

class PhaseAmmoniaEos(PhaseEos):
    def __init__(self): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def calcPressure(self) -> float: ...
    def calcPressuredV(self) -> float: ...
    def clone(self) -> 'PhaseAmmoniaEos': ...
    def dFdN(self, int: int) -> float: ...
    def dFdNdN(self, int: int, int2: int) -> float: ...
    def dFdNdT(self, int: int) -> float: ...
    def dFdNdV(self, int: int) -> float: ...
    def getAlpha0(self) -> typing.MutableSequence[org.netlib.util.doubleW]: ...
    def getAlphares(self) -> typing.MutableSequence[typing.MutableSequence[org.netlib.util.doubleW]]: ...
    @typing.overload
    def getCp(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getCp(self) -> float: ...
    @typing.overload
    def getCv(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getCv(self) -> float: ...
    @typing.overload
    def getDensity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getDensity(self) -> float: ...
    @typing.overload
    def getEnthalpy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getEnthalpy(self) -> float: ...
    @typing.overload
    def getEntropy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getEntropy(self) -> float: ...
    def getGibbsEnergy(self) -> float: ...
    def getHresTP(self) -> float: ...
    @typing.overload
    def getInternalEnergy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getInternalEnergy(self) -> float: ...
    def getIsothermalCompressibility(self) -> float: ...
    @typing.overload
    def getJouleThomsonCoefficient(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getJouleThomsonCoefficient(self) -> float: ...
    @typing.overload
    def getSoundSpeed(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getSoundSpeed(self) -> float: ...
    @typing.overload
    def getThermalConductivity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getThermalConductivity(self) -> float: ...
    @typing.overload
    def getViscosity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getViscosity(self) -> float: ...
    def getdPdTVn(self) -> float: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...

class PhaseDesmukhMather(PhaseGE):
    def __init__(self): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    @typing.overload
    def getActivityCoefficient(self, int: int) -> float: ...
    @typing.overload
    def getActivityCoefficient(self, int: int, int2: int) -> float: ...
    def getAij(self, int: int, int2: int) -> float: ...
    def getBetaDesMatij(self, int: int, int2: int) -> float: ...
    def getBij(self, int: int, int2: int) -> float: ...
    @typing.overload
    def getExcessGibbsEnergy(self) -> float: ...
    @typing.overload
    def getExcessGibbsEnergy(self, phaseInterface: PhaseInterface, int: int, double: float, double2: float, phaseType: PhaseType) -> float: ...
    def getGibbsEnergy(self) -> float: ...
    def getIonicStrength(self) -> float: ...
    def getSolventDensity(self) -> float: ...
    def getSolventMolarMass(self) -> float: ...
    def getSolventWeight(self) -> float: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, double2: float, double3: float, double4: float, int: int, phaseType: PhaseType, int2: int) -> None: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def setAij(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def setAlpha(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def setBij(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def setDij(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def setDijT(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    @typing.overload
    def setMixingRule(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...

class PhaseDuanSun(PhaseGE):
    def __init__(self): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    @typing.overload
    def getExcessGibbsEnergy(self) -> float: ...
    @typing.overload
    def getExcessGibbsEnergy(self, phaseInterface: PhaseInterface, int: int, double: float, double2: float, phaseType: PhaseType) -> float: ...
    def getGibbsEnergy(self) -> float: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def setAlpha(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def setDij(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def setDijT(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    @typing.overload
    def setMixingRule(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...

class PhaseGENRTL(PhaseGE):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, phaseInterface: PhaseInterface, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    @typing.overload
    def getExcessGibbsEnergy(self) -> float: ...
    @typing.overload
    def getExcessGibbsEnergy(self, phaseInterface: PhaseInterface, int: int, double: float, double2: float, phaseType: PhaseType) -> float: ...
    def getGibbsEnergy(self) -> float: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def setAlpha(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def setDij(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def setDijT(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    @typing.overload
    def setMixingRule(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...

class PhaseGERG2004Eos(PhaseEos):
    def __init__(self): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def clone(self) -> 'PhaseGERG2004Eos': ...
    @typing.overload
    def getCp(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getCp(self) -> float: ...
    @typing.overload
    def getCv(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getCv(self) -> float: ...
    @typing.overload
    def getEnthalpy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getEnthalpy(self) -> float: ...
    @typing.overload
    def getEntropy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getEntropy(self) -> float: ...
    def getGibbsEnergy(self) -> float: ...
    @typing.overload
    def getInternalEnergy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getInternalEnergy(self) -> float: ...
    @typing.overload
    def getJouleThomsonCoefficient(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getJouleThomsonCoefficient(self) -> float: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def setxFracGERG(self) -> None: ...

class PhaseGERG2008Eos(PhaseEos):
    def __init__(self): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def calcPressure(self) -> float: ...
    def calcPressuredV(self) -> float: ...
    def clone(self) -> 'PhaseGERG2008Eos': ...
    def dFdN(self, int: int) -> float: ...
    def dFdNdN(self, int: int, int2: int) -> float: ...
    def dFdNdT(self, int: int) -> float: ...
    def dFdNdV(self, int: int) -> float: ...
    def dFdTdV(self) -> float: ...
    def dFdVdV(self) -> float: ...
    def getAlpha0(self) -> typing.MutableSequence[org.netlib.util.doubleW]: ...
    def getAlphaRes(self) -> typing.MutableSequence[typing.MutableSequence[org.netlib.util.doubleW]]: ...
    @typing.overload
    def getCp(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getCp(self) -> float: ...
    @typing.overload
    def getCv(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getCv(self) -> float: ...
    @typing.overload
    def getDensity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getDensity(self) -> float: ...
    @typing.overload
    def getEnthalpy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getEnthalpy(self) -> float: ...
    @typing.overload
    def getEntropy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getEntropy(self) -> float: ...
    def getGibbsEnergy(self) -> float: ...
    def getGresTP(self) -> float: ...
    def getHresTP(self) -> float: ...
    @typing.overload
    def getInternalEnergy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getInternalEnergy(self) -> float: ...
    @typing.overload
    def getJouleThomsonCoefficient(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getJouleThomsonCoefficient(self) -> float: ...
    def getZ(self) -> float: ...
    def getdPdTVn(self) -> float: ...
    def getdPdVTn(self) -> float: ...
    def getdPdrho(self) -> float: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...

class PhaseGEUniquac(PhaseGE):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, phaseInterface: PhaseInterface, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    @typing.overload
    def getExcessGibbsEnergy(self) -> float: ...
    @typing.overload
    def getExcessGibbsEnergy(self, phaseInterface: PhaseInterface, int: int, double: float, double2: float, phaseType: PhaseType) -> float: ...
    def getGibbsEnergy(self) -> float: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def setAlpha(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def setDij(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def setDijT(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...

class PhaseGEWilson(PhaseGE):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, phaseInterface: PhaseInterface, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    @typing.overload
    def getExcessGibbsEnergy(self) -> float: ...
    @typing.overload
    def getExcessGibbsEnergy(self, phaseInterface: PhaseInterface, int: int, double: float, double2: float, phaseType: PhaseType) -> float: ...
    def getGibbsEnergy(self) -> float: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def setAlpha(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def setDij(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def setDijT(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    @typing.overload
    def setMixingRule(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...

class PhaseLeachmanEos(PhaseEos):
    def __init__(self): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def calcPressure(self) -> float: ...
    def calcPressuredV(self) -> float: ...
    def clone(self) -> 'PhaseLeachmanEos': ...
    def dFdN(self, int: int) -> float: ...
    def dFdNdN(self, int: int, int2: int) -> float: ...
    def dFdNdT(self, int: int) -> float: ...
    def dFdNdV(self, int: int) -> float: ...
    @typing.overload
    def getCp(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getCp(self) -> float: ...
    @typing.overload
    def getCv(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getCv(self) -> float: ...
    @typing.overload
    def getDensity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getDensity(self) -> float: ...
    @typing.overload
    def getEnthalpy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getEnthalpy(self) -> float: ...
    @typing.overload
    def getEntropy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getEntropy(self) -> float: ...
    def getGibbsEnergy(self) -> float: ...
    @typing.overload
    def getInternalEnergy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getInternalEnergy(self) -> float: ...
    @typing.overload
    def getJouleThomsonCoefficient(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getJouleThomsonCoefficient(self) -> float: ...
    def getZ(self) -> float: ...
    def getdPdTVn(self) -> float: ...
    def getdPdVTn(self) -> float: ...
    def getdPdrho(self) -> float: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...

class PhasePitzer(PhaseGE):
    def __init__(self): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    @typing.overload
    def getActivityCoefficient(self, int: int, int2: int) -> float: ...
    @typing.overload
    def getActivityCoefficient(self, int: int) -> float: ...
    def getBeta0ij(self, int: int, int2: int) -> float: ...
    def getBeta1ij(self, int: int, int2: int) -> float: ...
    @typing.overload
    def getCp(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getCp(self) -> float: ...
    def getCphiij(self, int: int, int2: int) -> float: ...
    def getCpres(self) -> float: ...
    @typing.overload
    def getCv(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getCv(self) -> float: ...
    def getCvres(self) -> float: ...
    @typing.overload
    def getExcessGibbsEnergy(self) -> float: ...
    @typing.overload
    def getExcessGibbsEnergy(self, phaseInterface: PhaseInterface, int: int, double: float, double2: float, phaseType: PhaseType) -> float: ...
    def getHresTP(self) -> float: ...
    def getHresdP(self) -> float: ...
    def getIonicStrength(self) -> float: ...
    def getSolventWeight(self) -> float: ...
    def getSresTP(self) -> float: ...
    def getSresTV(self) -> float: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def setAlpha(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def setBinaryParameters(self, int: int, int2: int, double: float, double2: float, double3: float) -> None: ...
    def setDij(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def setDijT(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    @typing.overload
    def setMixingRule(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...

class PhasePrEos(PhaseEos):
    def __init__(self): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def clone(self) -> 'PhasePrEos': ...

class PhaseRK(PhaseEos):
    def __init__(self): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def clone(self) -> 'PhaseRK': ...

class PhaseSpanWagnerEos(PhaseEos):
    def __init__(self): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def clone(self) -> 'PhaseSpanWagnerEos': ...
    @typing.overload
    def getCp(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getCp(self) -> float: ...
    @typing.overload
    def getCv(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getCv(self) -> float: ...
    @typing.overload
    def getEnthalpy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getEnthalpy(self) -> float: ...
    @typing.overload
    def getEntropy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getEntropy(self) -> float: ...
    def getGibbsEnergy(self) -> float: ...
    @typing.overload
    def getInternalEnergy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getInternalEnergy(self) -> float: ...
    @typing.overload
    def getSoundSpeed(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getSoundSpeed(self) -> float: ...
    def getZ(self) -> float: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...

class PhaseSrkEos(PhaseEos):
    def __init__(self): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def clone(self) -> 'PhaseSrkEos': ...

class PhaseTSTEos(PhaseEos):
    def __init__(self): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def clone(self) -> 'PhaseTSTEos': ...

class PhaseVegaEos(PhaseEos):
    def __init__(self): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def calcPressure(self) -> float: ...
    def calcPressuredV(self) -> float: ...
    def clone(self) -> 'PhaseVegaEos': ...
    def dFdN(self, int: int) -> float: ...
    def dFdNdN(self, int: int, int2: int) -> float: ...
    def dFdNdT(self, int: int) -> float: ...
    def dFdNdV(self, int: int) -> float: ...
    @typing.overload
    def getCp(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getCp(self) -> float: ...
    @typing.overload
    def getCv(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getCv(self) -> float: ...
    @typing.overload
    def getDensity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getDensity(self) -> float: ...
    @typing.overload
    def getEnthalpy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getEnthalpy(self) -> float: ...
    @typing.overload
    def getEntropy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getEntropy(self) -> float: ...
    def getGibbsEnergy(self) -> float: ...
    @typing.overload
    def getInternalEnergy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getInternalEnergy(self) -> float: ...
    @typing.overload
    def getJouleThomsonCoefficient(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getJouleThomsonCoefficient(self) -> float: ...
    def getZ(self) -> float: ...
    def getdPdTVn(self) -> float: ...
    def getdPdVTn(self) -> float: ...
    def getdPdrho(self) -> float: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...

class PhaseWaterIAPWS(PhaseEos):
    def __init__(self): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def calcPressure(self) -> float: ...
    def calcPressuredV(self) -> float: ...
    def clone(self) -> 'PhaseWaterIAPWS': ...
    @typing.overload
    def getCp(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getCp(self) -> float: ...
    @typing.overload
    def getCv(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getCv(self) -> float: ...
    @typing.overload
    def getEnthalpy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getEnthalpy(self) -> float: ...
    @typing.overload
    def getEntropy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getEntropy(self) -> float: ...
    def getGibbsEnergy(self) -> float: ...
    @typing.overload
    def getInternalEnergy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getInternalEnergy(self) -> float: ...
    @typing.overload
    def getSoundSpeed(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getSoundSpeed(self) -> float: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...

class PhaseBNS(PhasePrEos):
    def __init__(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray], doubleArray4: typing.Union[typing.List[float], jpype.JArray], doubleArray5: typing.Union[typing.List[float], jpype.JArray], doubleArray6: typing.Union[typing.List[float], jpype.JArray], doubleArray7: typing.Union[typing.List[float], jpype.JArray]): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def clone(self) -> 'PhaseBNS': ...
    def setBnsBips(self, double: float) -> None: ...
    @typing.overload
    def setMixingRule(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...

class PhaseBWRSEos(PhaseSrkEos):
    def __init__(self): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def calcPVT(self) -> None: ...
    def calcPressure2(self) -> float: ...
    def clone(self) -> 'PhaseBWRSEos': ...
    def dFdT(self) -> float: ...
    def dFdTdT(self) -> float: ...
    def dFdTdV(self) -> float: ...
    def dFdV(self) -> float: ...
    def dFdVdV(self) -> float: ...
    def dFdVdVdV(self) -> float: ...
    def getEL(self) -> float: ...
    def getELdRho(self) -> float: ...
    def getELdRhodedRho(self) -> float: ...
    def getELdRhodedRhodedRho(self) -> float: ...
    def getF(self) -> float: ...
    def getFdRho(self) -> float: ...
    def getFexp(self) -> float: ...
    def getFexpdT(self) -> float: ...
    def getFexpdV(self) -> float: ...
    def getFexpdVdV(self) -> float: ...
    def getFexpdVdVdV(self) -> float: ...
    def getFpol(self) -> float: ...
    def getFpoldRho(self) -> float: ...
    def getFpoldT(self) -> float: ...
    def getFpoldV(self) -> float: ...
    def getFpoldVdV(self) -> float: ...
    def getFpoldVdVdV(self) -> float: ...
    def getGammadRho(self) -> float: ...
    @typing.overload
    def getJouleThomsonCoefficient(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getJouleThomsonCoefficient(self) -> float: ...
    def getMolarDensity(self) -> float: ...
    def getdFdN(self) -> float: ...
    def getdRhodV(self) -> float: ...
    def getdRhodVdV(self) -> float: ...
    def getdRhodVdVdV(self) -> float: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    def molarVolume2(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...

class PhaseCSPsrkEos(PhaseSrkEos):
    def __init__(self): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def clone(self) -> 'PhaseCSPsrkEos': ...
    def dFdV(self) -> float: ...
    def dFdVdV(self) -> float: ...
    def dFdVdVdV(self) -> float: ...
    def getAcrefBWRSPhase(self) -> float: ...
    def getBrefBWRSPhase(self) -> float: ...
    def getF(self) -> float: ...
    def getF_scale_mix(self) -> float: ...
    def getH_scale_mix(self) -> float: ...
    def getRefBWRSPhase(self) -> PhaseSrkEos: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def setAcrefBWRSPhase(self, double: float) -> None: ...
    def setBrefBWRSPhase(self, double: float) -> None: ...
    def setF_scale_mix(self, double: float) -> None: ...
    def setH_scale_mix(self, double: float) -> None: ...
    def setRefBWRSPhase(self, phaseBWRSEos: PhaseBWRSEos) -> None: ...

class PhaseGENRTLmodifiedHV(PhaseGENRTL):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, phaseInterface: PhaseInterface, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray], doubleArray4: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]): ...
    @typing.overload
    def __init__(self, phaseInterface: PhaseInterface, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    @typing.overload
    def getExcessGibbsEnergy(self) -> float: ...
    @typing.overload
    def getExcessGibbsEnergy(self, phaseInterface: PhaseInterface, int: int, double: float, double2: float, phaseType: PhaseType) -> float: ...
    def getGibbsEnergy(self) -> float: ...
    def getHresTP(self) -> float: ...
    def setDijT(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    @typing.overload
    def setMixingRule(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...
    def setParams(self, phaseInterface: PhaseInterface, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray], doubleArray4: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...

class PhaseGEUnifac(PhaseGEUniquac):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, phaseInterface: PhaseInterface, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def calcaij(self) -> None: ...
    def checkGroups(self) -> None: ...
    def getAij(self, int: int, int2: int) -> float: ...
    def getBij(self, int: int, int2: int) -> float: ...
    def getCij(self, int: int, int2: int) -> float: ...
    @typing.overload
    def getExcessGibbsEnergy(self) -> float: ...
    @typing.overload
    def getExcessGibbsEnergy(self, phaseInterface: PhaseInterface, int: int, double: float, double2: float, phaseType: PhaseType) -> float: ...
    def getGibbsEnergy(self) -> float: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, double2: float, double3: float, double4: float, int: int, phaseType: PhaseType, int2: int) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    def setAij(self, int: int, int2: int, double: float) -> None: ...
    def setBij(self, int: int, int2: int, double: float) -> None: ...
    def setCij(self, int: int, int2: int, double: float) -> None: ...
    @typing.overload
    def setMixingRule(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...

class PhaseGEUniquacmodifiedHV(PhaseGEUniquac):
    def __init__(self): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    @typing.overload
    def getExcessGibbsEnergy(self) -> float: ...
    @typing.overload
    def getExcessGibbsEnergy(self, phaseInterface: PhaseInterface, int: int, double: float, double2: float, phaseType: PhaseType) -> float: ...

class PhaseKentEisenberg(PhaseGENRTL):
    def __init__(self): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    @typing.overload
    def getActivityCoefficient(self, int: int) -> float: ...
    @typing.overload
    def getActivityCoefficient(self, int: int, int2: int) -> float: ...

class PhaseModifiedFurstElectrolyteEos(PhaseSrkEos):
    def __init__(self): ...
    def FBorn(self) -> float: ...
    def FBornD(self) -> float: ...
    def FBornDD(self) -> float: ...
    def FBornDX(self) -> float: ...
    def FBornT(self) -> float: ...
    def FBornTD(self) -> float: ...
    def FBornTT(self) -> float: ...
    def FBornTX(self) -> float: ...
    def FBornX(self) -> float: ...
    def FBornXX(self) -> float: ...
    def FLR(self) -> float: ...
    def FLRGammaLR(self) -> float: ...
    def FLRV(self) -> float: ...
    def FLRVV(self) -> float: ...
    def FLRXLR(self) -> float: ...
    def FSR2(self) -> float: ...
    def FSR2T(self) -> float: ...
    def FSR2TT(self) -> float: ...
    def FSR2TV(self) -> float: ...
    def FSR2TW(self) -> float: ...
    def FSR2Teps(self) -> float: ...
    def FSR2Tn(self) -> float: ...
    def FSR2V(self) -> float: ...
    def FSR2VV(self) -> float: ...
    def FSR2VVV(self) -> float: ...
    def FSR2VVeps(self) -> float: ...
    def FSR2VW(self) -> float: ...
    def FSR2W(self) -> float: ...
    def FSR2WW(self) -> float: ...
    def FSR2eps(self) -> float: ...
    def FSR2epsV(self) -> float: ...
    def FSR2epsW(self) -> float: ...
    def FSR2epseps(self) -> float: ...
    def FSR2epsepsV(self) -> float: ...
    def FSR2epsepseps(self) -> float: ...
    def FSR2n(self) -> float: ...
    def FSR2nT(self) -> float: ...
    def FSR2nV(self) -> float: ...
    def FSR2nW(self) -> float: ...
    def FSR2neps(self) -> float: ...
    def FSR2nn(self) -> float: ...
    def XBorndndn(self, int: int, int2: int) -> float: ...
    def XLRdGammaLR(self) -> float: ...
    def XLRdndn(self, int: int, int2: int) -> float: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def calcBornX(self) -> float: ...
    def calcDiElectricConstant(self, double: float) -> float: ...
    def calcDiElectricConstantdT(self, double: float) -> float: ...
    def calcDiElectricConstantdTdT(self, double: float) -> float: ...
    def calcDiElectricConstantdTdV(self, double: float) -> float: ...
    def calcDiElectricConstantdV(self, double: float) -> float: ...
    def calcDiElectricConstantdVdV(self, double: float) -> float: ...
    def calcEps(self) -> float: ...
    def calcEpsIonic(self) -> float: ...
    def calcEpsIonicdV(self) -> float: ...
    def calcEpsIonicdVdV(self) -> float: ...
    def calcEpsV(self) -> float: ...
    def calcEpsVV(self) -> float: ...
    def calcGammaLRdV(self) -> float: ...
    def calcShieldingParameter(self) -> float: ...
    def calcSolventDiElectricConstant(self, double: float) -> float: ...
    def calcSolventDiElectricConstantdT(self, double: float) -> float: ...
    def calcSolventDiElectricConstantdTdT(self, double: float) -> float: ...
    def calcW(self, phaseInterface: PhaseInterface, double: float, double2: float, int: int) -> float: ...
    def calcWi(self, int: int, phaseInterface: PhaseInterface, double: float, double2: float, int2: int) -> float: ...
    def calcWiT(self, int: int, phaseInterface: PhaseInterface, double: float, double2: float, int2: int) -> float: ...
    def calcWij(self, int: int, int2: int, phaseInterface: PhaseInterface, double: float, double2: float, int3: int) -> float: ...
    def calcXLR(self) -> float: ...
    def clone(self) -> 'PhaseModifiedFurstElectrolyteEos': ...
    def dFBorndT(self) -> float: ...
    def dFBorndTdT(self) -> float: ...
    def dFLRdT(self) -> float: ...
    def dFLRdTdT(self) -> float: ...
    def dFLRdTdV(self) -> float: ...
    def dFLRdV(self) -> float: ...
    def dFLRdVdV(self) -> float: ...
    def dFLRdVdVdV(self) -> float: ...
    def dFSR2dT(self) -> float: ...
    def dFSR2dTdT(self) -> float: ...
    def dFSR2dTdV(self) -> float: ...
    def dFSR2dV(self) -> float: ...
    def dFSR2dVdV(self) -> float: ...
    def dFSR2dVdVdV(self) -> float: ...
    def dFdAlphaLR(self) -> float: ...
    def dFdAlphaLRdAlphaLR(self) -> float: ...
    def dFdAlphaLRdGamma(self) -> float: ...
    def dFdAlphaLRdV(self) -> float: ...
    def dFdAlphaLRdX(self) -> float: ...
    def dFdT(self) -> float: ...
    def dFdTdT(self) -> float: ...
    def dFdTdV(self) -> float: ...
    def dFdV(self) -> float: ...
    def dFdVdV(self) -> float: ...
    def dFdVdVdV(self) -> float: ...
    def getAlphaLR2(self) -> float: ...
    def getAlphaLRT(self) -> float: ...
    def getAlphaLRV(self) -> float: ...
    def getDiElectricConstantdT(self) -> float: ...
    def getDiElectricConstantdV(self) -> float: ...
    def getDielectricConstant(self) -> float: ...
    def getDielectricT(self) -> float: ...
    def getDielectricV(self) -> float: ...
    def getElectrolyteMixingRule(self) -> jneqsim.neqsim.thermo.mixingrule.ElectrolyteMixingRulesInterface: ...
    def getEps(self) -> float: ...
    def getEpsIonic(self) -> float: ...
    def getEpsIonicdV(self) -> float: ...
    def getEpsIonicdVdV(self) -> float: ...
    def getEpsdV(self) -> float: ...
    def getEpsdVdV(self) -> float: ...
    def getF(self) -> float: ...
    def getShieldingParameter(self) -> float: ...
    def getSolventDiElectricConstant(self) -> float: ...
    def getSolventDiElectricConstantdT(self) -> float: ...
    def getSolventDiElectricConstantdTdT(self) -> float: ...
    def getW(self) -> float: ...
    def getWT(self) -> float: ...
    def getXLR(self) -> float: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def reInitFurstParam(self) -> None: ...
    def setFurstIonicCoefficient(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def volInit(self) -> None: ...

class PhaseModifiedFurstElectrolyteEosMod2004(PhaseSrkEos):
    def __init__(self): ...
    def FBorn(self) -> float: ...
    def FBornD(self) -> float: ...
    def FBornDD(self) -> float: ...
    def FBornDX(self) -> float: ...
    def FBornT(self) -> float: ...
    def FBornTD(self) -> float: ...
    def FBornTT(self) -> float: ...
    def FBornTX(self) -> float: ...
    def FBornX(self) -> float: ...
    def FBornXX(self) -> float: ...
    def FLR(self) -> float: ...
    def FLRGammaLR(self) -> float: ...
    def FLRV(self) -> float: ...
    def FLRVV(self) -> float: ...
    def FLRXLR(self) -> float: ...
    def FSR2(self) -> float: ...
    def FSR2T(self) -> float: ...
    def FSR2TT(self) -> float: ...
    def FSR2TV(self) -> float: ...
    def FSR2TW(self) -> float: ...
    def FSR2Teps(self) -> float: ...
    def FSR2Tn(self) -> float: ...
    def FSR2V(self) -> float: ...
    def FSR2VV(self) -> float: ...
    def FSR2VVV(self) -> float: ...
    def FSR2VVeps(self) -> float: ...
    def FSR2VW(self) -> float: ...
    def FSR2W(self) -> float: ...
    def FSR2WW(self) -> float: ...
    def FSR2eps(self) -> float: ...
    def FSR2epsV(self) -> float: ...
    def FSR2epsW(self) -> float: ...
    def FSR2epseps(self) -> float: ...
    def FSR2epsepsV(self) -> float: ...
    def FSR2epsepseps(self) -> float: ...
    def FSR2n(self) -> float: ...
    def FSR2nT(self) -> float: ...
    def FSR2nV(self) -> float: ...
    def FSR2nW(self) -> float: ...
    def FSR2neps(self) -> float: ...
    def FSR2nn(self) -> float: ...
    def XBorndndn(self, int: int, int2: int) -> float: ...
    def XLRdGammaLR(self) -> float: ...
    def XLRdndn(self, int: int, int2: int) -> float: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def calcBornX(self) -> float: ...
    def calcDiElectricConstant(self, double: float) -> float: ...
    def calcDiElectricConstantdT(self, double: float) -> float: ...
    def calcDiElectricConstantdTdT(self, double: float) -> float: ...
    def calcDiElectricConstantdTdV(self, double: float) -> float: ...
    def calcDiElectricConstantdV(self, double: float) -> float: ...
    def calcDiElectricConstantdVdV(self, double: float) -> float: ...
    def calcEps(self) -> float: ...
    def calcEpsIonic(self) -> float: ...
    def calcEpsIonicdV(self) -> float: ...
    def calcEpsIonicdVdV(self) -> float: ...
    def calcEpsV(self) -> float: ...
    def calcEpsVV(self) -> float: ...
    def calcGammaLRdV(self) -> float: ...
    def calcShieldingParameter(self) -> float: ...
    def calcSolventDiElectricConstant(self, double: float) -> float: ...
    def calcSolventDiElectricConstantdT(self, double: float) -> float: ...
    def calcSolventDiElectricConstantdTdT(self, double: float) -> float: ...
    def calcW(self, phaseInterface: PhaseInterface, double: float, double2: float, int: int) -> float: ...
    def calcWi(self, int: int, phaseInterface: PhaseInterface, double: float, double2: float, int2: int) -> float: ...
    def calcWiT(self, int: int, phaseInterface: PhaseInterface, double: float, double2: float, int2: int) -> float: ...
    def calcWij(self, int: int, int2: int, phaseInterface: PhaseInterface, double: float, double2: float, int3: int) -> float: ...
    def calcXLR(self) -> float: ...
    def clone(self) -> 'PhaseModifiedFurstElectrolyteEosMod2004': ...
    def dFBorndT(self) -> float: ...
    def dFBorndTdT(self) -> float: ...
    def dFLRdT(self) -> float: ...
    def dFLRdTdT(self) -> float: ...
    def dFLRdTdV(self) -> float: ...
    def dFLRdV(self) -> float: ...
    def dFLRdVdV(self) -> float: ...
    def dFLRdVdVdV(self) -> float: ...
    def dFSR2dT(self) -> float: ...
    def dFSR2dTdT(self) -> float: ...
    def dFSR2dTdV(self) -> float: ...
    def dFSR2dV(self) -> float: ...
    def dFSR2dVdV(self) -> float: ...
    def dFSR2dVdVdV(self) -> float: ...
    def dFdAlphaLR(self) -> float: ...
    def dFdAlphaLRdAlphaLR(self) -> float: ...
    def dFdAlphaLRdGamma(self) -> float: ...
    def dFdAlphaLRdV(self) -> float: ...
    def dFdAlphaLRdX(self) -> float: ...
    def dFdT(self) -> float: ...
    def dFdTdT(self) -> float: ...
    def dFdTdV(self) -> float: ...
    def dFdV(self) -> float: ...
    def dFdVdV(self) -> float: ...
    def dFdVdVdV(self) -> float: ...
    def getAlphaLR2(self) -> float: ...
    def getAlphaLRT(self) -> float: ...
    def getAlphaLRV(self) -> float: ...
    def getDiElectricConstantdT(self) -> float: ...
    def getDiElectricConstantdV(self) -> float: ...
    def getDielectricConstant(self) -> float: ...
    def getDielectricT(self) -> float: ...
    def getDielectricV(self) -> float: ...
    def getElectrolyteMixingRule(self) -> jneqsim.neqsim.thermo.mixingrule.ElectrolyteMixingRulesInterface: ...
    def getEps(self) -> float: ...
    def getEpsIonic(self) -> float: ...
    def getEpsIonicdV(self) -> float: ...
    def getEpsIonicdVdV(self) -> float: ...
    def getEpsdV(self) -> float: ...
    def getEpsdVdV(self) -> float: ...
    def getF(self) -> float: ...
    def getShieldingParameter(self) -> float: ...
    def getSolventDiElectricConstant(self) -> float: ...
    def getSolventDiElectricConstantdT(self) -> float: ...
    def getSolventDiElectricConstantdTdT(self) -> float: ...
    def getW(self) -> float: ...
    def getWT(self) -> float: ...
    def getXLR(self) -> float: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def reInitFurstParam(self) -> None: ...
    def setFurstIonicCoefficient(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def volInit(self) -> None: ...

class PhasePCSAFT(PhaseSrkEos):
    def __init__(self): ...
    def F_DISP1_SAFT(self) -> float: ...
    def F_DISP2_SAFT(self) -> float: ...
    def F_HC_SAFT(self) -> float: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def calcF1dispI1(self) -> float: ...
    def calcF1dispI1dN(self) -> float: ...
    def calcF1dispI1dNdN(self) -> float: ...
    def calcF1dispI1dm(self) -> float: ...
    def calcF1dispSumTerm(self) -> float: ...
    def calcF2dispI2(self) -> float: ...
    def calcF2dispI2dN(self) -> float: ...
    def calcF2dispI2dNdN(self) -> float: ...
    def calcF2dispI2dm(self) -> float: ...
    def calcF2dispSumTerm(self) -> float: ...
    def calcF2dispZHC(self) -> float: ...
    def calcF2dispZHCdN(self) -> float: ...
    def calcF2dispZHCdNdN(self) -> float: ...
    def calcF2dispZHCdm(self) -> float: ...
    def calcdF1dispI1dT(self) -> float: ...
    def calcdF1dispI1dTdT(self) -> float: ...
    def calcdF1dispI1dTdV(self) -> float: ...
    def calcdF1dispSumTermdT(self) -> float: ...
    def calcdF1dispSumTermdTdT(self) -> float: ...
    def calcdF2dispI2dT(self) -> float: ...
    def calcdF2dispI2dTdT(self) -> float: ...
    def calcdF2dispI2dTdV(self) -> float: ...
    def calcdF2dispSumTermdT(self) -> float: ...
    def calcdF2dispSumTermdTdT(self) -> float: ...
    def calcdF2dispZHCdT(self) -> float: ...
    def calcdF2dispZHCdTdT(self) -> float: ...
    def calcdF2dispZHCdTdV(self) -> float: ...
    def calcdSAFT(self) -> float: ...
    def calcdmeanSAFT(self) -> float: ...
    def calcmSAFT(self) -> float: ...
    def calcmdSAFT(self) -> float: ...
    def calcmmin1SAFT(self) -> float: ...
    def clone(self) -> 'PhasePCSAFT': ...
    def dF_DISP1_SAFTdT(self) -> float: ...
    def dF_DISP1_SAFTdTdT(self) -> float: ...
    def dF_DISP1_SAFTdTdV(self) -> float: ...
    def dF_DISP1_SAFTdV(self) -> float: ...
    def dF_DISP1_SAFTdVdV(self) -> float: ...
    def dF_DISP2_SAFTdT(self) -> float: ...
    def dF_DISP2_SAFTdTdT(self) -> float: ...
    def dF_DISP2_SAFTdTdV(self) -> float: ...
    def dF_DISP2_SAFTdV(self) -> float: ...
    def dF_DISP2_SAFTdVdV(self) -> float: ...
    def dF_HC_SAFTdT(self) -> float: ...
    def dF_HC_SAFTdTdT(self) -> float: ...
    def dF_HC_SAFTdTdV(self) -> float: ...
    def dF_HC_SAFTdV(self) -> float: ...
    def dF_HC_SAFTdVdV(self) -> float: ...
    def dF_HC_SAFTdVdVdV(self) -> float: ...
    def dFdT(self) -> float: ...
    def dFdTdT(self) -> float: ...
    def dFdTdV(self) -> float: ...
    def dFdV(self) -> float: ...
    def dFdVdV(self) -> float: ...
    def getAHSSAFT(self) -> float: ...
    def getDSAFT(self) -> float: ...
    def getDgHSSAFTdN(self) -> float: ...
    def getDmeanSAFT(self) -> float: ...
    def getDnSAFTdV(self) -> float: ...
    def getF(self) -> float: ...
    def getF1dispI1(self) -> float: ...
    def getF1dispSumTerm(self) -> float: ...
    def getF1dispVolTerm(self) -> float: ...
    def getF2dispI2(self) -> float: ...
    def getF2dispSumTerm(self) -> float: ...
    def getF2dispZHC(self) -> float: ...
    def getF2dispZHCdN(self) -> float: ...
    def getF2dispZHCdm(self) -> float: ...
    def getGhsSAFT(self) -> float: ...
    def getMmin1SAFT(self) -> float: ...
    def getNSAFT(self) -> float: ...
    def getNmSAFT(self) -> float: ...
    def getVolumeSAFT(self) -> float: ...
    def getaSAFT(self, int: int, double: float, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> float: ...
    def getaSAFTdm(self, int: int, double: float, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> float: ...
    def getd2DSAFTdTdT(self) -> float: ...
    def getdDSAFTdT(self) -> float: ...
    def getmSAFT(self) -> float: ...
    def getmdSAFT(self) -> float: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def molarVolume22(self, double: float, double2: float, double3: float, double4: float, int: int) -> float: ...
    def setAHSSAFT(self, double: float) -> None: ...
    def setDSAFT(self, double: float) -> None: ...
    def setDgHSSAFTdN(self, double: float) -> None: ...
    def setDmeanSAFT(self, double: float) -> None: ...
    def setDnSAFTdV(self, double: float) -> None: ...
    def setF1dispVolTerm(self, double: float) -> None: ...
    def setF2dispI2(self, double: float) -> None: ...
    def setF2dispSumTerm(self, double: float) -> None: ...
    def setF2dispZHC(self, double: float) -> None: ...
    def setF2dispZHCdm(self, double: float) -> None: ...
    def setGhsSAFT(self, double: float) -> None: ...
    def setMmin1SAFT(self, double: float) -> None: ...
    def setNSAFT(self, double: float) -> None: ...
    def setNmSAFT(self, double: float) -> None: ...
    def setVolumeSAFT(self, double: float) -> None: ...
    def setmSAFT(self, double: float) -> None: ...
    def setmdSAFT(self, double: float) -> None: ...
    def volInit(self) -> None: ...

class PhasePrCPA(PhasePrEos, PhaseCPAInterface):
    cpaSelect: jneqsim.neqsim.thermo.mixingrule.CPAMixingRuleHandler = ...
    cpamix: jneqsim.neqsim.thermo.mixingrule.CPAMixingRulesInterface = ...
    def __init__(self): ...
    def FCPA(self) -> float: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def calc_g(self) -> float: ...
    def calc_hCPA(self) -> float: ...
    def calc_hCPAdT(self) -> float: ...
    def calc_hCPAdTdT(self) -> float: ...
    def calc_lngV(self) -> float: ...
    def calc_lngVV(self) -> float: ...
    def calc_lngVVV(self) -> float: ...
    def calc_lngni(self, int: int) -> float: ...
    def clone(self) -> 'PhasePrCPA': ...
    def dFCPAdT(self) -> float: ...
    def dFCPAdTdT(self) -> float: ...
    def dFCPAdV(self) -> float: ...
    def dFCPAdVdV(self) -> float: ...
    def dFCPAdVdVdV(self) -> float: ...
    def dFdT(self) -> float: ...
    def dFdTdT(self) -> float: ...
    def dFdTdV(self) -> float: ...
    def dFdV(self) -> float: ...
    def dFdVdV(self) -> float: ...
    def dFdVdVdV(self) -> float: ...
    def getCpaMixingRule(self) -> jneqsim.neqsim.thermo.mixingrule.CPAMixingRulesInterface: ...
    def getCrossAssosiationScheme(self, int: int, int2: int, int3: int, int4: int) -> int: ...
    def getF(self) -> float: ...
    def getGcpa(self) -> float: ...
    def getGcpav(self) -> float: ...
    def getHcpatot(self) -> float: ...
    def getTotalNumberOfAccociationSites(self) -> int: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    def setHcpatot(self, double: float) -> None: ...
    def setTotalNumberOfAccociationSites(self, int: int) -> None: ...
    def solveX(self) -> bool: ...

class PhasePrEosvolcor(PhasePrEos):
    C: float = ...
    Ctot: float = ...
    def __init__(self): ...
    def F(self) -> float: ...
    def FBC(self) -> float: ...
    def FC(self) -> float: ...
    def FCC(self) -> float: ...
    def FCD(self) -> float: ...
    def FCV(self) -> float: ...
    def FTC(self) -> float: ...
    def FnC(self) -> float: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def calcC(self, phaseInterface: PhaseInterface, double: float, double2: float, int: int) -> float: ...
    def calcCT(self, phaseInterface: PhaseInterface, double: float, double2: float, int: int) -> float: ...
    def calcCi(self, int: int, phaseInterface: PhaseInterface, double: float, double2: float, int2: int) -> float: ...
    def calcCiT(self, int: int, phaseInterface: PhaseInterface, double: float, double2: float, int2: int) -> float: ...
    def calcCij(self, int: int, int2: int, phaseInterface: PhaseInterface, double: float, double2: float, int3: int) -> float: ...
    def calcf(self) -> float: ...
    def calcg(self) -> float: ...
    def clone(self) -> 'PhasePrEosvolcor': ...
    def dFdT(self) -> float: ...
    def dFdTdT(self) -> float: ...
    def dFdTdV(self) -> float: ...
    def dFdV(self) -> float: ...
    def dFdVdV(self) -> float: ...
    def dFdVdVdV(self) -> float: ...
    def fBB(self) -> float: ...
    def fBV(self) -> float: ...
    def fVV(self) -> float: ...
    def fVVV(self) -> float: ...
    def fb(self) -> float: ...
    def fbc(self) -> float: ...
    def fc(self) -> float: ...
    def fcc(self) -> float: ...
    def fcv(self) -> float: ...
    def fv(self) -> float: ...
    def gBB(self) -> float: ...
    def gBC(self) -> float: ...
    def gBV(self) -> float: ...
    def gCC(self) -> float: ...
    def gCV(self) -> float: ...
    def gV(self) -> float: ...
    def gVV(self) -> float: ...
    def gVVV(self) -> float: ...
    def gb(self) -> float: ...
    def gc(self) -> float: ...
    def getC(self) -> float: ...
    def getCT(self) -> float: ...
    def getCTT(self) -> float: ...
    def getc(self) -> float: ...
    def getcij(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface, componentEosInterface2: jneqsim.neqsim.thermo.component.ComponentEosInterface) -> float: ...
    def getcijT(self, componentEosInterface: jneqsim.neqsim.thermo.component.ComponentEosInterface, componentEosInterface2: jneqsim.neqsim.thermo.component.ComponentEosInterface) -> float: ...
    def getcijTT(self, componentPRvolcor: jneqsim.neqsim.thermo.component.ComponentPRvolcor, componentPRvolcor2: jneqsim.neqsim.thermo.component.ComponentPRvolcor) -> float: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...

class PhaseSolid(PhaseSrkEos):
    def __init__(self): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def clone(self) -> 'PhaseSolid': ...
    def getDensityTemp(self) -> float: ...
    @typing.overload
    def getEnthalpy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getEnthalpy(self) -> float: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    def setSolidRefFluidPhase(self, phaseInterface: PhaseInterface) -> None: ...

class PhaseSoreideWhitson(PhasePrEos):
    def __init__(self): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def addSalinity(self, double: float) -> None: ...
    def clone(self) -> 'PhaseSoreideWhitson': ...
    def getSalinity(self, double: float) -> float: ...
    def getSalinityConcentration(self) -> float: ...
    def setSalinityConcentration(self, double: float) -> None: ...

class PhaseSrkCPA(PhaseSrkEos, PhaseCPAInterface):
    cpaSelect: jneqsim.neqsim.thermo.mixingrule.CPAMixingRuleHandler = ...
    cpamix: jneqsim.neqsim.thermo.mixingrule.CPAMixingRulesInterface = ...
    def __init__(self): ...
    def FCPA(self) -> float: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def calcDelta(self) -> None: ...
    def calcPressure(self) -> float: ...
    def calcRootVolFinder(self, phaseType: PhaseType) -> float: ...
    def calcXsitedV(self) -> None: ...
    def calc_g(self) -> float: ...
    def calc_hCPA(self) -> float: ...
    def calc_lngV(self) -> float: ...
    def calc_lngVV(self) -> float: ...
    def calc_lngVVV(self) -> float: ...
    def clone(self) -> 'PhaseSrkCPA': ...
    def croeneckerProduct(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def dFCPAdT(self) -> float: ...
    def dFCPAdTdT(self) -> float: ...
    def dFCPAdTdV(self) -> float: ...
    def dFCPAdV(self) -> float: ...
    def dFCPAdVdV(self) -> float: ...
    def dFCPAdVdVdV(self) -> float: ...
    def dFdT(self) -> float: ...
    def dFdTdT(self) -> float: ...
    def dFdTdV(self) -> float: ...
    def dFdV(self) -> float: ...
    def dFdVdV(self) -> float: ...
    def dFdVdVdV(self) -> float: ...
    def getCpaMixingRule(self) -> jneqsim.neqsim.thermo.mixingrule.CPAMixingRulesInterface: ...
    def getCrossAssosiationScheme(self, int: int, int2: int, int3: int, int4: int) -> int: ...
    def getF(self) -> float: ...
    def getGcpa(self) -> float: ...
    def getGcpav(self) -> float: ...
    def getHcpatot(self) -> float: ...
    def getTotalNumberOfAccociationSites(self) -> int: ...
    def getdFdNtemp(self) -> typing.MutableSequence[float]: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    def initCPAMatrix(self, int: int) -> None: ...
    def initCPAMatrixOld(self, int: int) -> None: ...
    def initOld2(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def molarVolume2(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def molarVolumeChangePhase(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def molarVolumeOld(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def setGcpav(self, double: float) -> None: ...
    def setHcpatot(self, double: float) -> None: ...
    @typing.overload
    def setMixingRule(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...
    def setTotalNumberOfAccociationSites(self, int: int) -> None: ...
    def solveX(self) -> bool: ...
    def solveX2(self, int: int) -> bool: ...
    def solveX2Old(self, int: int) -> bool: ...
    def solveXOld(self) -> bool: ...

class PhaseSrkCPA_proceduralMatrices(PhaseSrkEos, PhaseCPAInterface):
    cpaSelect: jneqsim.neqsim.thermo.mixingrule.CPAMixingRuleHandler = ...
    cpamix: jneqsim.neqsim.thermo.mixingrule.CPAMixingRulesInterface = ...
    def __init__(self): ...
    def FCPA(self) -> float: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def calcDelta(self) -> None: ...
    def calcPressure(self) -> float: ...
    def calcRootVolFinder(self, phaseType: PhaseType) -> float: ...
    def calcXsitedV(self) -> None: ...
    def calc_g(self) -> float: ...
    def calc_hCPA(self) -> float: ...
    def calc_lngV(self) -> float: ...
    def calc_lngVV(self) -> float: ...
    def calc_lngVVV(self) -> float: ...
    def clone(self) -> PhaseSrkCPA: ...
    def croeneckerProduct(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def dFCPAdT(self) -> float: ...
    def dFCPAdTdT(self) -> float: ...
    def dFCPAdTdV(self) -> float: ...
    def dFCPAdV(self) -> float: ...
    def dFCPAdVdV(self) -> float: ...
    def dFCPAdVdVdV(self) -> float: ...
    def dFdT(self) -> float: ...
    def dFdTdT(self) -> float: ...
    def dFdTdV(self) -> float: ...
    def dFdV(self) -> float: ...
    def dFdVdV(self) -> float: ...
    def dFdVdVdV(self) -> float: ...
    def getCpaMixingRule(self) -> jneqsim.neqsim.thermo.mixingrule.CPAMixingRulesInterface: ...
    def getCrossAssosiationScheme(self, int: int, int2: int, int3: int, int4: int) -> int: ...
    def getF(self) -> float: ...
    def getGcpa(self) -> float: ...
    def getGcpav(self) -> float: ...
    def getHcpatot(self) -> float: ...
    def getTotalNumberOfAccociationSites(self) -> int: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    def initCPAMatrix(self, int: int) -> None: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def molarVolume2(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def molarVolumeChangePhase(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def setGcpav(self, double: float) -> None: ...
    def setHcpatot(self, double: float) -> None: ...
    @typing.overload
    def setMixingRule(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...
    def setTotalNumberOfAccociationSites(self, int: int) -> None: ...
    def solveX(self) -> bool: ...
    def solveX2(self, int: int) -> bool: ...

class PhaseSrkPenelouxEos(PhaseSrkEos):
    def __init__(self): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def clone(self) -> 'PhaseSrkPenelouxEos': ...

class PhaseUMRCPA(PhasePrEos, PhaseCPAInterface):
    cpaSelect: jneqsim.neqsim.thermo.mixingrule.CPAMixingRuleHandler = ...
    cpamix: jneqsim.neqsim.thermo.mixingrule.CPAMixingRulesInterface = ...
    def __init__(self): ...
    def FCPA(self) -> float: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def calcDelta(self) -> None: ...
    def calcPressure(self) -> float: ...
    def calcRootVolFinder(self, phaseType: PhaseType) -> float: ...
    def calcXsitedV(self) -> None: ...
    def calc_g(self) -> float: ...
    def calc_hCPA(self) -> float: ...
    def calc_lngV(self) -> float: ...
    def calc_lngVV(self) -> float: ...
    def calc_lngVVV(self) -> float: ...
    def clone(self) -> 'PhaseUMRCPA': ...
    def croeneckerProduct(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def dFCPAdT(self) -> float: ...
    def dFCPAdTdT(self) -> float: ...
    def dFCPAdTdV(self) -> float: ...
    def dFCPAdV(self) -> float: ...
    def dFCPAdVdV(self) -> float: ...
    def dFCPAdVdVdV(self) -> float: ...
    def dFdT(self) -> float: ...
    def dFdTdT(self) -> float: ...
    def dFdTdV(self) -> float: ...
    def dFdV(self) -> float: ...
    def dFdVdV(self) -> float: ...
    def dFdVdVdV(self) -> float: ...
    def getCpaMixingRule(self) -> jneqsim.neqsim.thermo.mixingrule.CPAMixingRulesInterface: ...
    def getCrossAssosiationScheme(self, int: int, int2: int, int3: int, int4: int) -> int: ...
    def getF(self) -> float: ...
    def getGcpa(self) -> float: ...
    def getGcpav(self) -> float: ...
    def getHcpatot(self) -> float: ...
    def getTotalNumberOfAccociationSites(self) -> int: ...
    def getdFdNtemp(self) -> typing.MutableSequence[float]: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    def initCPAMatrix(self, int: int) -> None: ...
    def initCPAMatrixOld(self, int: int) -> None: ...
    def initOld2(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def molarVolume2(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def molarVolumeChangePhase(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def molarVolumeOld(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def setGcpav(self, double: float) -> None: ...
    def setHcpatot(self, double: float) -> None: ...
    @typing.overload
    def setMixingRule(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...
    def setTotalNumberOfAccociationSites(self, int: int) -> None: ...
    def solveX(self) -> bool: ...
    def solveX2(self, int: int) -> bool: ...
    def solveX2Old(self, int: int) -> bool: ...
    def solveXOld(self) -> bool: ...

class PhaseElectrolyteCPA(PhaseModifiedFurstElectrolyteEos, PhaseCPAInterface):
    cpaSelect: jneqsim.neqsim.thermo.mixingrule.CPAMixingRuleHandler = ...
    cpamix: jneqsim.neqsim.thermo.mixingrule.CPAMixingRulesInterface = ...
    def __init__(self): ...
    def FCPA(self) -> float: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def calcDelta(self) -> None: ...
    def calcPressure(self) -> float: ...
    def calcRootVolFinder(self, phaseType: PhaseType) -> float: ...
    def calcXsitedV(self) -> None: ...
    def calc_g(self) -> float: ...
    def calc_hCPA(self) -> float: ...
    def calc_lngV(self) -> float: ...
    def calc_lngVV(self) -> float: ...
    def calc_lngVVV(self) -> float: ...
    def clone(self) -> 'PhaseElectrolyteCPA': ...
    def croeneckerProduct(self, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def dFCPAdT(self) -> float: ...
    def dFCPAdTdT(self) -> float: ...
    def dFCPAdTdV(self) -> float: ...
    def dFCPAdV(self) -> float: ...
    def dFCPAdVdV(self) -> float: ...
    def dFCPAdVdVdV(self) -> float: ...
    def dFdT(self) -> float: ...
    def dFdTdT(self) -> float: ...
    def dFdTdV(self) -> float: ...
    def dFdV(self) -> float: ...
    def dFdVdV(self) -> float: ...
    def dFdVdVdV(self) -> float: ...
    def getCpaMixingRule(self) -> jneqsim.neqsim.thermo.mixingrule.CPAMixingRulesInterface: ...
    def getCrossAssosiationScheme(self, int: int, int2: int, int3: int, int4: int) -> int: ...
    def getF(self) -> float: ...
    def getGcpa(self) -> float: ...
    def getGcpav(self) -> float: ...
    def getHcpatot(self) -> float: ...
    def getTotalNumberOfAccociationSites(self) -> int: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    def initCPAMatrix(self, int: int) -> None: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def molarVolume2(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def molarVolumeChangePhase(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def setGcpav(self, double: float) -> None: ...
    def setHcpatot(self, double: float) -> None: ...
    @typing.overload
    def setMixingRule(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...
    def setTotalNumberOfAccociationSites(self, int: int) -> None: ...
    def solveX(self) -> bool: ...
    def solveX2(self, int: int) -> bool: ...

class PhaseElectrolyteCPAOld(PhaseModifiedFurstElectrolyteEos, PhaseCPAInterface):
    cpaSelect: jneqsim.neqsim.thermo.mixingrule.CPAMixingRuleHandler = ...
    cpamix: jneqsim.neqsim.thermo.mixingrule.CPAMixingRulesInterface = ...
    def __init__(self): ...
    def FCPA(self) -> float: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def calcXsitedT(self) -> None: ...
    def calc_g(self) -> float: ...
    def calc_hCPA(self) -> float: ...
    def calc_hCPAdT(self) -> float: ...
    def calc_hCPAdTdT(self) -> float: ...
    def calc_lngV(self) -> float: ...
    def calc_lngVV(self) -> float: ...
    def calc_lngVVV(self) -> float: ...
    def calc_lngni(self, int: int) -> float: ...
    def clone(self) -> 'PhaseElectrolyteCPAOld': ...
    def dFCPAdT(self) -> float: ...
    def dFCPAdTdT(self) -> float: ...
    def dFCPAdV(self) -> float: ...
    def dFCPAdVdV(self) -> float: ...
    def dFCPAdVdVdV(self) -> float: ...
    def dFdT(self) -> float: ...
    def dFdTdT(self) -> float: ...
    def dFdTdV(self) -> float: ...
    def dFdV(self) -> float: ...
    def dFdVdV(self) -> float: ...
    def dFdVdVdV(self) -> float: ...
    def getCpaMixingRule(self) -> jneqsim.neqsim.thermo.mixingrule.CPAMixingRulesInterface: ...
    def getCrossAssosiationScheme(self, int: int, int2: int, int3: int, int4: int) -> int: ...
    def getF(self) -> float: ...
    def getGcpa(self) -> float: ...
    def getGcpav(self) -> float: ...
    def getHcpatot(self) -> float: ...
    def getTotalNumberOfAccociationSites(self) -> int: ...
    def getdFdVdXdXdVtotal(self) -> float: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def molarVolume2(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def molarVolume3(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def setGcpav(self, double: float) -> None: ...
    def setHcpatot(self, double: float) -> None: ...
    @typing.overload
    def setMixingRule(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...
    def setTotalNumberOfAccociationSites(self, int: int) -> None: ...
    def setXsiteOld(self) -> None: ...
    def setXsitedV(self, double: float) -> None: ...
    def solveX(self) -> bool: ...

class PhaseGENRTLmodifiedWS(PhaseGENRTLmodifiedHV):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, phaseInterface: PhaseInterface, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray], doubleArray4: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]): ...
    @typing.overload
    def __init__(self, phaseInterface: PhaseInterface, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    @typing.overload
    def getExcessGibbsEnergy(self) -> float: ...
    @typing.overload
    def getExcessGibbsEnergy(self, phaseInterface: PhaseInterface, int: int, double: float, double2: float, phaseType: PhaseType) -> float: ...
    @typing.overload
    def setMixingRule(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...

class PhaseGEUnifacPSRK(PhaseGEUnifac):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, phaseInterface: PhaseInterface, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def calcbij(self) -> None: ...
    def calccij(self) -> None: ...
    @typing.overload
    def getExcessGibbsEnergy(self) -> float: ...
    @typing.overload
    def getExcessGibbsEnergy(self, phaseInterface: PhaseInterface, int: int, double: float, double2: float, phaseType: PhaseType) -> float: ...
    @typing.overload
    def setMixingRule(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...

class PhaseGEUnifacUMRPRU(PhaseGEUnifac):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, phaseInterface: PhaseInterface, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def calcCommontemp(self, phaseInterface: PhaseInterface, int: int, double: float, double2: float, phaseType: PhaseType) -> None: ...
    def calcaij(self) -> None: ...
    def calcbij(self) -> None: ...
    def calccij(self) -> None: ...
    @typing.overload
    def getExcessGibbsEnergy(self) -> float: ...
    @typing.overload
    def getExcessGibbsEnergy(self, phaseInterface: PhaseInterface, int: int, double: float, double2: float, phaseType: PhaseType) -> float: ...
    def getFCommontemp(self) -> float: ...
    def getQmix(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getQmixdN(self, string: typing.Union[java.lang.String, str]) -> typing.MutableSequence[float]: ...
    def getVCommontemp(self) -> float: ...
    def initQmix(self) -> None: ...
    def initQmixdN(self) -> None: ...
    @typing.overload
    def setMixingRule(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...

class PhasePCSAFTRahmat(PhasePCSAFT):
    def __init__(self): ...
    def F_DISP1_SAFT(self) -> float: ...
    def F_DISP2_SAFT(self) -> float: ...
    def F_HC_SAFT(self) -> float: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def calcF1dispI1(self) -> float: ...
    def calcF1dispI1dN(self) -> float: ...
    def calcF1dispI1dNdN(self) -> float: ...
    def calcF1dispI1dNdNdN(self) -> float: ...
    def calcF1dispI1dm(self) -> float: ...
    def calcF1dispSumTerm(self) -> float: ...
    def calcF2dispI2(self) -> float: ...
    def calcF2dispI2dN(self) -> float: ...
    def calcF2dispI2dNdN(self) -> float: ...
    def calcF2dispI2dNdNdN(self) -> float: ...
    def calcF2dispI2dm(self) -> float: ...
    def calcF2dispSumTerm(self) -> float: ...
    def calcF2dispZHC(self) -> float: ...
    def calcF2dispZHCdN(self) -> float: ...
    def calcF2dispZHCdNdN(self) -> float: ...
    def calcF2dispZHCdNdNdN(self) -> float: ...
    def calcF2dispZHCdm(self) -> float: ...
    def calcdF1dispI1dT(self) -> float: ...
    def calcdF1dispSumTermdT(self) -> float: ...
    def calcdF2dispI2dT(self) -> float: ...
    def calcdF2dispSumTermdT(self) -> float: ...
    def calcdF2dispZHCdT(self) -> float: ...
    def calcdSAFT(self) -> float: ...
    def calcdmeanSAFT(self) -> float: ...
    def calcmSAFT(self) -> float: ...
    def calcmdSAFT(self) -> float: ...
    def calcmmin1SAFT(self) -> float: ...
    def clone(self) -> 'PhasePCSAFTRahmat': ...
    def dF_DISP1_SAFTdT(self) -> float: ...
    def dF_DISP1_SAFTdV(self) -> float: ...
    def dF_DISP1_SAFTdVdV(self) -> float: ...
    def dF_DISP1_SAFTdVdVdV(self) -> float: ...
    def dF_DISP2_SAFTdT(self) -> float: ...
    def dF_DISP2_SAFTdV(self) -> float: ...
    def dF_DISP2_SAFTdVdV(self) -> float: ...
    def dF_DISP2_SAFTdVdVdV(self) -> float: ...
    def dF_HC_SAFTdT(self) -> float: ...
    def dF_HC_SAFTdV(self) -> float: ...
    def dF_HC_SAFTdVdV(self) -> float: ...
    def dF_HC_SAFTdVdVdV(self) -> float: ...
    def dFdT(self) -> float: ...
    def dFdV(self) -> float: ...
    def dFdVdV(self) -> float: ...
    def dFdVdVdV(self) -> float: ...
    def getF(self) -> float: ...
    def getaSAFT(self, int: int, double: float, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> float: ...
    def getaSAFTdm(self, int: int, double: float, doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> float: ...
    def getdDSAFTdT(self) -> float: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def volInit(self) -> None: ...

class PhasePCSAFTa(PhasePCSAFT, PhaseCPAInterface):
    cpaSelect: jneqsim.neqsim.thermo.mixingrule.CPAMixingRuleHandler = ...
    cpamix: jneqsim.neqsim.thermo.mixingrule.CPAMixingRulesInterface = ...
    def __init__(self): ...
    def FCPA(self) -> float: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def calc_hCPA(self) -> float: ...
    def calc_hCPAdT(self) -> float: ...
    def calc_hCPAdTdT(self) -> float: ...
    def calc_lngni(self, int: int) -> float: ...
    def clone(self) -> 'PhasePCSAFTa': ...
    def dFCPAdT(self) -> float: ...
    def dFCPAdTdT(self) -> float: ...
    def dFCPAdV(self) -> float: ...
    def dFCPAdVdV(self) -> float: ...
    def dFCPAdVdVdV(self) -> float: ...
    def dFdT(self) -> float: ...
    def dFdTdT(self) -> float: ...
    def dFdTdV(self) -> float: ...
    def dFdV(self) -> float: ...
    def dFdVdV(self) -> float: ...
    def dFdVdVdV(self) -> float: ...
    def getCpaMixingRule(self) -> jneqsim.neqsim.thermo.mixingrule.CPAMixingRulesInterface: ...
    def getCrossAssosiationScheme(self, int: int, int2: int, int3: int, int4: int) -> int: ...
    def getF(self) -> float: ...
    def getGcpa(self) -> float: ...
    def getGcpav(self) -> float: ...
    def getHcpatot(self) -> float: ...
    def getTotalNumberOfAccociationSites(self) -> int: ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...
    def molarVolume(self, double: float, double2: float, double3: float, double4: float, phaseType: PhaseType) -> float: ...
    def setHcpatot(self, double: float) -> None: ...
    @typing.overload
    def setMixingRule(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...
    def setTotalNumberOfAccociationSites(self, int: int) -> None: ...
    def solveX(self) -> bool: ...
    def volInit(self) -> None: ...

class PhasePureComponentSolid(PhaseSolid):
    def __init__(self): ...
    def clone(self) -> 'PhasePureComponentSolid': ...

class PhaseSolidComplex(PhaseSolid):
    def __init__(self): ...
    def clone(self) -> 'PhaseSolidComplex': ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...

class PhaseSrkCPAs(PhaseSrkCPA):
    def __init__(self): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def calc_g(self) -> float: ...
    def calc_lngV(self) -> float: ...
    def calc_lngVV(self) -> float: ...
    def calc_lngVVV(self) -> float: ...
    def clone(self) -> 'PhaseSrkCPAs': ...

class PhaseWax(PhaseSolid):
    def __init__(self): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def clone(self) -> 'PhaseWax': ...
    @typing.overload
    def init(self) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, double2: float) -> None: ...
    @typing.overload
    def init(self, double: float, int: int, int2: int, phaseType: PhaseType, double2: float) -> None: ...

class PhaseElectrolyteCPAstatoil(PhaseElectrolyteCPA):
    def __init__(self): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def calc_g(self) -> float: ...
    def calc_lngV(self) -> float: ...
    def calc_lngVV(self) -> float: ...
    def calc_lngVVV(self) -> float: ...
    def clone(self) -> 'PhaseElectrolyteCPAstatoil': ...

class PhaseSrkCPAsOld(PhaseSrkCPAs):
    def __init__(self): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, int: int) -> None: ...
    def calc_g(self) -> float: ...
    def calc_lngV(self) -> float: ...
    def calc_lngVV(self) -> float: ...
    def calc_lngVVV(self) -> float: ...
    def clone(self) -> 'PhaseSrkCPAsOld': ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.thermo.phase")``.

    Phase: typing.Type[Phase]
    PhaseAmmoniaEos: typing.Type[PhaseAmmoniaEos]
    PhaseBNS: typing.Type[PhaseBNS]
    PhaseBWRSEos: typing.Type[PhaseBWRSEos]
    PhaseCPAInterface: typing.Type[PhaseCPAInterface]
    PhaseCSPsrkEos: typing.Type[PhaseCSPsrkEos]
    PhaseDefault: typing.Type[PhaseDefault]
    PhaseDesmukhMather: typing.Type[PhaseDesmukhMather]
    PhaseDuanSun: typing.Type[PhaseDuanSun]
    PhaseElectrolyteCPA: typing.Type[PhaseElectrolyteCPA]
    PhaseElectrolyteCPAOld: typing.Type[PhaseElectrolyteCPAOld]
    PhaseElectrolyteCPAstatoil: typing.Type[PhaseElectrolyteCPAstatoil]
    PhaseEos: typing.Type[PhaseEos]
    PhaseEosInterface: typing.Type[PhaseEosInterface]
    PhaseGE: typing.Type[PhaseGE]
    PhaseGEInterface: typing.Type[PhaseGEInterface]
    PhaseGENRTL: typing.Type[PhaseGENRTL]
    PhaseGENRTLmodifiedHV: typing.Type[PhaseGENRTLmodifiedHV]
    PhaseGENRTLmodifiedWS: typing.Type[PhaseGENRTLmodifiedWS]
    PhaseGERG2004Eos: typing.Type[PhaseGERG2004Eos]
    PhaseGERG2008Eos: typing.Type[PhaseGERG2008Eos]
    PhaseGEUnifac: typing.Type[PhaseGEUnifac]
    PhaseGEUnifacPSRK: typing.Type[PhaseGEUnifacPSRK]
    PhaseGEUnifacUMRPRU: typing.Type[PhaseGEUnifacUMRPRU]
    PhaseGEUniquac: typing.Type[PhaseGEUniquac]
    PhaseGEUniquacmodifiedHV: typing.Type[PhaseGEUniquacmodifiedHV]
    PhaseGEWilson: typing.Type[PhaseGEWilson]
    PhaseHydrate: typing.Type[PhaseHydrate]
    PhaseIdealGas: typing.Type[PhaseIdealGas]
    PhaseInterface: typing.Type[PhaseInterface]
    PhaseKentEisenberg: typing.Type[PhaseKentEisenberg]
    PhaseLeachmanEos: typing.Type[PhaseLeachmanEos]
    PhaseModifiedFurstElectrolyteEos: typing.Type[PhaseModifiedFurstElectrolyteEos]
    PhaseModifiedFurstElectrolyteEosMod2004: typing.Type[PhaseModifiedFurstElectrolyteEosMod2004]
    PhasePCSAFT: typing.Type[PhasePCSAFT]
    PhasePCSAFTRahmat: typing.Type[PhasePCSAFTRahmat]
    PhasePCSAFTa: typing.Type[PhasePCSAFTa]
    PhasePitzer: typing.Type[PhasePitzer]
    PhasePrCPA: typing.Type[PhasePrCPA]
    PhasePrEos: typing.Type[PhasePrEos]
    PhasePrEosvolcor: typing.Type[PhasePrEosvolcor]
    PhasePureComponentSolid: typing.Type[PhasePureComponentSolid]
    PhaseRK: typing.Type[PhaseRK]
    PhaseSolid: typing.Type[PhaseSolid]
    PhaseSolidComplex: typing.Type[PhaseSolidComplex]
    PhaseSoreideWhitson: typing.Type[PhaseSoreideWhitson]
    PhaseSpanWagnerEos: typing.Type[PhaseSpanWagnerEos]
    PhaseSrkCPA: typing.Type[PhaseSrkCPA]
    PhaseSrkCPA_proceduralMatrices: typing.Type[PhaseSrkCPA_proceduralMatrices]
    PhaseSrkCPAs: typing.Type[PhaseSrkCPAs]
    PhaseSrkCPAsOld: typing.Type[PhaseSrkCPAsOld]
    PhaseSrkEos: typing.Type[PhaseSrkEos]
    PhaseSrkPenelouxEos: typing.Type[PhaseSrkPenelouxEos]
    PhaseTSTEos: typing.Type[PhaseTSTEos]
    PhaseType: typing.Type[PhaseType]
    PhaseUMRCPA: typing.Type[PhaseUMRCPA]
    PhaseVegaEos: typing.Type[PhaseVegaEos]
    PhaseWaterIAPWS: typing.Type[PhaseWaterIAPWS]
    PhaseWax: typing.Type[PhaseWax]
    StateOfMatter: typing.Type[StateOfMatter]
