
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.io
import java.lang
import java.util
import jpype
import jneqsim.neqsim.chemicalreactions
import jneqsim.neqsim.physicalproperties
import jneqsim.neqsim.physicalproperties.interfaceproperties
import jneqsim.neqsim.physicalproperties.system
import jneqsim.neqsim.standards
import jneqsim.neqsim.thermo.characterization
import jneqsim.neqsim.thermo.component
import jneqsim.neqsim.thermo.mixingrule
import jneqsim.neqsim.thermo.phase
import typing



class SystemInterface(java.lang.Cloneable, java.io.Serializable):
    def addCapeOpenProperty(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def addCharacterized(self, stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray], doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    @typing.overload
    def addComponent(self, int: int, double: float) -> None: ...
    @typing.overload
    def addComponent(self, int: int, double: float, int2: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, double3: float, double4: float) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str], int: int) -> None: ...
    @typing.overload
    def addComponent(self, componentInterface: jneqsim.neqsim.thermo.component.ComponentInterface) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def addComponents(self, stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    @typing.overload
    def addComponents(self, stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray], doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    @typing.overload
    def addFluid(self, systemInterface: 'SystemInterface') -> 'SystemInterface': ...
    @typing.overload
    def addFluid(self, systemInterface: 'SystemInterface', int: int) -> 'SystemInterface': ...
    @staticmethod
    def addFluids(systemInterface: 'SystemInterface', systemInterface2: 'SystemInterface') -> 'SystemInterface': ...
    def addGasToLiquid(self, double: float) -> None: ...
    def addLiquidToGas(self, double: float) -> None: ...
    @typing.overload
    def addOilFractions(self, stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray], doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray], boolean: bool) -> None: ...
    @typing.overload
    def addOilFractions(self, stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray], doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray], boolean: bool, boolean2: bool, int: int) -> None: ...
    def addPhase(self) -> None: ...
    @typing.overload
    def addPhaseFractionToPhase(self, double: float, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def addPhaseFractionToPhase(self, double: float, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str], string4: typing.Union[java.lang.String, str]) -> None: ...
    def addPlusFraction(self, string: typing.Union[java.lang.String, str], double: float, double2: float, double3: float) -> None: ...
    def addSalt(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...
    def addSolidComplexPhase(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def addTBPfraction(self, string: typing.Union[java.lang.String, str], double: float, double2: float, double3: float) -> None: ...
    @typing.overload
    def addTBPfraction(self, string: typing.Union[java.lang.String, str], double: float, double2: float, double3: float, double4: float, double5: float, double6: float) -> None: ...
    def addTBPfraction2(self, string: typing.Union[java.lang.String, str], double: float, double2: float, double3: float) -> None: ...
    def addTBPfraction3(self, string: typing.Union[java.lang.String, str], double: float, double2: float, double3: float) -> None: ...
    def addTBPfraction4(self, string: typing.Union[java.lang.String, str], double: float, double2: float, double3: float, double4: float) -> None: ...
    def addToComponentNames(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def allowPhaseShift(self) -> bool: ...
    @typing.overload
    def allowPhaseShift(self, boolean: bool) -> None: ...
    def autoSelectMixingRule(self) -> None: ...
    def autoSelectModel(self) -> 'SystemInterface': ...
    def calcHenrysConstant(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def calcInterfaceProperties(self) -> None: ...
    def calcKIJ(self, boolean: bool) -> None: ...
    def calcResultTable(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def calc_x_y(self) -> None: ...
    def calc_x_y_nonorm(self) -> None: ...
    def calculateDensityFromBoilingPoint(self, double: float, double2: float) -> float: ...
    def calculateMolarMassFromDensityAndBoilingPoint(self, double: float, double2: float) -> float: ...
    def changeComponentName(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def checkStability(self) -> bool: ...
    @typing.overload
    def checkStability(self, boolean: bool) -> None: ...
    def chemicalReactionInit(self) -> None: ...
    def clearAll(self) -> None: ...
    def clone(self) -> 'SystemInterface': ...
    def createDatabase(self, boolean: bool) -> None: ...
    def createTable(self, string: typing.Union[java.lang.String, str]) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def deleteFluidPhase(self, int: int) -> None: ...
    @typing.overload
    def display(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def display(self) -> None: ...
    def doMultiPhaseCheck(self) -> bool: ...
    def doSolidPhaseCheck(self) -> bool: ...
    def equals(self, object: typing.Any) -> bool: ...
    @typing.overload
    def getBeta(self) -> float: ...
    @typing.overload
    def getBeta(self, int: int) -> float: ...
    def getCASNumbers(self) -> typing.MutableSequence[java.lang.String]: ...
    def getCapeOpenProperties10(self) -> typing.MutableSequence[java.lang.String]: ...
    def getCapeOpenProperties11(self) -> typing.MutableSequence[java.lang.String]: ...
    def getCharacterization(self) -> jneqsim.neqsim.thermo.characterization.Characterise: ...
    def getChemicalReactionOperations(self) -> jneqsim.neqsim.chemicalreactions.ChemicalReactionOperations: ...
    def getCompFormulaes(self) -> typing.MutableSequence[java.lang.String]: ...
    def getCompIDs(self) -> typing.MutableSequence[java.lang.String]: ...
    def getCompNames(self) -> typing.MutableSequence[java.lang.String]: ...
    @typing.overload
    def getComponent(self, int: int) -> jneqsim.neqsim.thermo.component.ComponentInterface: ...
    @typing.overload
    def getComponent(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.thermo.component.ComponentInterface: ...
    def getComponentNameTag(self) -> java.lang.String: ...
    def getComponentNames(self) -> typing.MutableSequence[java.lang.String]: ...
    def getCorrectedVolume(self) -> float: ...
    def getCorrectedVolumeFraction(self, int: int) -> float: ...
    @typing.overload
    def getCp(self) -> float: ...
    @typing.overload
    def getCp(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getCv(self) -> float: ...
    @typing.overload
    def getCv(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getDensity(self) -> float: ...
    @typing.overload
    def getDensity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getEmptySystemClone(self) -> 'SystemInterface': ...
    @typing.overload
    def getEnthalpy(self) -> float: ...
    @typing.overload
    def getEnthalpy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getEntropy(self) -> float: ...
    @typing.overload
    def getEntropy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getExergy(self, double: float) -> float: ...
    @typing.overload
    def getExergy(self, double: float, string: typing.Union[java.lang.String, str]) -> float: ...
    def getFlowRate(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getFluidInfo(self) -> java.lang.String: ...
    def getFluidName(self) -> java.lang.String: ...
    def getGamma(self) -> float: ...
    def getGamma2(self) -> float: ...
    def getGasPhase(self) -> jneqsim.neqsim.thermo.phase.PhaseInterface: ...
    def getGibbsEnergy(self) -> float: ...
    def getHeatOfVaporization(self) -> float: ...
    def getHelmholtzEnergy(self) -> float: ...
    def getHydrateCheck(self) -> bool: ...
    def getIdealLiquidDensity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getInterfacialTension(self, int: int, int2: int) -> float: ...
    @typing.overload
    def getInterfacialTension(self, int: int, int2: int, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getInterfacialTension(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getInternalEnergy(self) -> float: ...
    @typing.overload
    def getInternalEnergy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getInterphaseProperties(self) -> jneqsim.neqsim.physicalproperties.interfaceproperties.InterphasePropertiesInterface: ...
    @typing.overload
    def getJouleThomsonCoefficient(self) -> float: ...
    @typing.overload
    def getJouleThomsonCoefficient(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getKappa(self) -> float: ...
    @typing.overload
    def getKinematicViscosity(self) -> float: ...
    @typing.overload
    def getKinematicViscosity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getKvector(self) -> typing.MutableSequence[float]: ...
    def getLiquidPhase(self) -> jneqsim.neqsim.thermo.phase.PhaseInterface: ...
    def getLiquidVolume(self) -> float: ...
    def getLowestGibbsEnergyPhase(self) -> jneqsim.neqsim.thermo.phase.PhaseInterface: ...
    def getMass(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getMaxNumberOfPhases(self) -> int: ...
    def getMixingRule(self) -> jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface: ...
    def getMixingRuleName(self) -> java.lang.String: ...
    def getModelName(self) -> java.lang.String: ...
    def getMolarComposition(self) -> typing.MutableSequence[float]: ...
    @typing.overload
    def getMolarMass(self) -> float: ...
    @typing.overload
    def getMolarMass(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getMolarRate(self) -> typing.MutableSequence[float]: ...
    @typing.overload
    def getMolarVolume(self) -> float: ...
    @typing.overload
    def getMolarVolume(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getMoleFraction(self, int: int) -> float: ...
    def getMoleFractionsSum(self) -> float: ...
    def getMolecularWeights(self) -> typing.MutableSequence[float]: ...
    def getNormalBoilingPointTemperatures(self) -> typing.MutableSequence[float]: ...
    def getNumberOfComponents(self) -> int: ...
    def getNumberOfMoles(self) -> float: ...
    def getNumberOfOilFractionComponents(self) -> int: ...
    def getNumberOfPhases(self) -> int: ...
    def getOilFractionIDs(self) -> typing.MutableSequence[int]: ...
    def getOilFractionLiquidDensityAt25C(self) -> typing.MutableSequence[float]: ...
    def getOilFractionMolecularMass(self) -> typing.MutableSequence[float]: ...
    def getOilFractionNormalBoilingPoints(self) -> typing.MutableSequence[float]: ...
    def getPC(self) -> float: ...
    @typing.overload
    def getPhase(self, int: int) -> jneqsim.neqsim.thermo.phase.PhaseInterface: ...
    @typing.overload
    def getPhase(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.thermo.phase.PhaseInterface: ...
    @typing.overload
    def getPhase(self, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> jneqsim.neqsim.thermo.phase.PhaseInterface: ...
    def getPhaseFraction(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getPhaseIndex(self, int: int) -> int: ...
    @typing.overload
    def getPhaseIndex(self, string: typing.Union[java.lang.String, str]) -> int: ...
    @typing.overload
    def getPhaseIndex(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> int: ...
    @typing.overload
    def getPhaseNumberOfPhase(self, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> int: ...
    @typing.overload
    def getPhaseNumberOfPhase(self, string: typing.Union[java.lang.String, str]) -> int: ...
    def getPhaseOfType(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.thermo.phase.PhaseInterface: ...
    def getPhases(self) -> typing.MutableSequence[jneqsim.neqsim.thermo.phase.PhaseInterface]: ...
    @typing.overload
    def getPressure(self) -> float: ...
    @typing.overload
    def getPressure(self, int: int) -> float: ...
    @typing.overload
    def getPressure(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getProperties(self) -> 'SystemProperties': ...
    @typing.overload
    def getProperty(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getProperty(self, string: typing.Union[java.lang.String, str], int: int) -> float: ...
    @typing.overload
    def getProperty(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], int: int) -> float: ...
    def getResultTable(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    @typing.overload
    def getSoundSpeed(self) -> float: ...
    @typing.overload
    def getSoundSpeed(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getStandard(self) -> jneqsim.neqsim.standards.StandardInterface: ...
    @typing.overload
    def getStandard(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.standards.StandardInterface: ...
    def getTC(self) -> float: ...
    @typing.overload
    def getTemperature(self) -> float: ...
    @typing.overload
    def getTemperature(self, int: int) -> float: ...
    @typing.overload
    def getTemperature(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getThermalConductivity(self) -> float: ...
    @typing.overload
    def getThermalConductivity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getTotalNumberOfMoles(self) -> float: ...
    @typing.overload
    def getViscosity(self) -> float: ...
    @typing.overload
    def getViscosity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getVolume(self) -> float: ...
    @typing.overload
    def getVolume(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getVolumeFraction(self, int: int) -> float: ...
    def getWaxCharacterisation(self) -> jneqsim.neqsim.thermo.characterization.WaxCharacterise: ...
    def getWaxModel(self) -> jneqsim.neqsim.thermo.characterization.WaxModelInterface: ...
    def getWtFraction(self, int: int) -> float: ...
    def getZ(self) -> float: ...
    def getZvolcorr(self) -> float: ...
    def getdVdPtn(self) -> float: ...
    def getdVdTpn(self) -> float: ...
    def getzvector(self) -> typing.MutableSequence[float]: ...
    @typing.overload
    def hasComponent(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    @typing.overload
    def hasComponent(self, string: typing.Union[java.lang.String, str], boolean: bool) -> bool: ...
    @typing.overload
    def hasPhaseType(self, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> bool: ...
    @typing.overload
    def hasPhaseType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    def hasPlusFraction(self) -> bool: ...
    def hasSolidPhase(self) -> bool: ...
    def hashCode(self) -> int: ...
    @typing.overload
    def init(self, int: int) -> None: ...
    @typing.overload
    def init(self, int: int, int2: int) -> None: ...
    def initBeta(self) -> None: ...
    def initNumeric(self) -> None: ...
    @typing.overload
    def initPhysicalProperties(self) -> None: ...
    @typing.overload
    def initPhysicalProperties(self, physicalPropertyType: jneqsim.neqsim.physicalproperties.PhysicalPropertyType) -> None: ...
    @typing.overload
    def initPhysicalProperties(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def initProperties(self) -> None: ...
    def initRefPhases(self) -> None: ...
    def initThermoProperties(self) -> None: ...
    def initTotalNumberOfMoles(self, double: float) -> None: ...
    def init_x_y(self) -> None: ...
    def invertPhaseTypes(self) -> None: ...
    @typing.overload
    def isChemicalSystem(self) -> bool: ...
    @typing.overload
    def isChemicalSystem(self, boolean: bool) -> None: ...
    def isForcePhaseTypes(self) -> bool: ...
    @typing.overload
    def isImplementedCompositionDeriativesofFugacity(self) -> bool: ...
    @typing.overload
    def isImplementedCompositionDeriativesofFugacity(self, boolean: bool) -> None: ...
    def isImplementedPressureDeriativesofFugacity(self) -> bool: ...
    def isImplementedTemperatureDeriativesofFugacity(self) -> bool: ...
    def isInitialized(self) -> bool: ...
    def isMultiphaseWaxCheck(self) -> bool: ...
    def isNumericDerivatives(self) -> bool: ...
    def isPhase(self, int: int) -> bool: ...
    def normalizeBeta(self) -> None: ...
    def orderByDensity(self) -> None: ...
    @typing.overload
    def phaseToSystem(self, int: int) -> 'SystemInterface': ...
    @typing.overload
    def phaseToSystem(self, int: int, int2: int) -> 'SystemInterface': ...
    @typing.overload
    def phaseToSystem(self, string: typing.Union[java.lang.String, str]) -> 'SystemInterface': ...
    @typing.overload
    def phaseToSystem(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> 'SystemInterface': ...
    def prettyPrint(self) -> None: ...
    def reInitPhaseType(self) -> None: ...
    def readFluid(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def readObject(self, int: int) -> 'SystemInterface': ...
    def readObjectFromFile(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> 'SystemInterface': ...
    def removeComponent(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def removePhase(self, int: int) -> None: ...
    def removePhaseKeepTotalComposition(self, int: int) -> None: ...
    def renameComponent(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    def replacePhase(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> None: ...
    def reset(self) -> None: ...
    def resetCharacterisation(self) -> None: ...
    def resetDatabase(self) -> None: ...
    def resetPhysicalProperties(self) -> None: ...
    def reset_x_y(self) -> None: ...
    def save(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def saveFluid(self, int: int) -> None: ...
    @typing.overload
    def saveFluid(self, int: int, string: typing.Union[java.lang.String, str]) -> None: ...
    def saveObject(self, int: int, string: typing.Union[java.lang.String, str]) -> None: ...
    def saveObjectToFile(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    def saveToDataBase(self) -> None: ...
    def setAllComponentsInPhase(self, int: int) -> None: ...
    def setAllPhaseType(self, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> None: ...
    def setAttractiveTerm(self, int: int) -> None: ...
    @typing.overload
    def setBeta(self, double: float) -> None: ...
    @typing.overload
    def setBeta(self, int: int, double: float) -> None: ...
    def setBmixType(self, int: int) -> None: ...
    def setComponentFlowRates(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], string: typing.Union[java.lang.String, str]) -> None: ...
    def setComponentNameTag(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setComponentNameTagOnNormalComponents(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setComponentNames(self, stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def setEmptyFluid(self) -> None: ...
    def setFluidInfo(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setFluidName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setForcePhaseTypes(self, boolean: bool) -> None: ...
    @typing.overload
    def setForceSinglePhase(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setForceSinglePhase(self, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> None: ...
    def setHeavyTBPfractionAsPlusFraction(self) -> bool: ...
    def setHydrateCheck(self, boolean: bool) -> None: ...
    def setImplementedCompositionDeriativesofFugacity(self, boolean: bool) -> None: ...
    def setImplementedPressureDeriativesofFugacity(self, boolean: bool) -> None: ...
    def setImplementedTemperatureDeriativesofFugacity(self, boolean: bool) -> None: ...
    def setMaxNumberOfPhases(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...
    @typing.overload
    def setMixingRule(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setModel(self, string: typing.Union[java.lang.String, str]) -> 'SystemInterface': ...
    def setMolarComposition(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setMolarCompositionOfNamedComponents(self, string: typing.Union[java.lang.String, str], doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setMolarCompositionOfPlusFluid(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setMolarCompositionPlus(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setMolarFlowRates(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setMultiPhaseCheck(self, boolean: bool) -> None: ...
    def setMultiphaseWaxCheck(self, boolean: bool) -> None: ...
    def setNumberOfPhases(self, int: int) -> None: ...
    def setNumericDerivatives(self, boolean: bool) -> None: ...
    def setPC(self, double: float) -> None: ...
    def setPhase(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int) -> None: ...
    def setPhaseIndex(self, int: int, int2: int) -> None: ...
    @typing.overload
    def setPhaseType(self, int: int, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setPhaseType(self, int: int, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> None: ...
    @typing.overload
    def setPhysicalPropertyModel(self, int: int) -> None: ...
    @typing.overload
    def setPhysicalPropertyModel(self, physicalPropertyModel: jneqsim.neqsim.physicalproperties.system.PhysicalPropertyModel) -> None: ...
    @typing.overload
    def setPressure(self, double: float) -> None: ...
    @typing.overload
    def setPressure(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setSolidPhaseCheck(self, boolean: bool) -> None: ...
    @typing.overload
    def setSolidPhaseCheck(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setStandard(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setTC(self, double: float) -> None: ...
    @typing.overload
    def setTemperature(self, double: float) -> None: ...
    @typing.overload
    def setTemperature(self, double: float, int: int) -> None: ...
    @typing.overload
    def setTemperature(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setTotalFlowRate(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setTotalNumberOfMoles(self, double: float) -> None: ...
    def setUseTVasIndependentVariables(self, boolean: bool) -> None: ...
    def toCompJson(self) -> java.lang.String: ...
    def toJson(self) -> java.lang.String: ...
    def tuneModel(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    def useVolumeCorrection(self, boolean: bool) -> None: ...
    def write(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], boolean: bool) -> None: ...

class SystemProperties:
    nCols: typing.ClassVar[int] = ...
    def __init__(self, systemInterface: SystemInterface): ...
    def getProperties(self) -> java.util.HashMap[java.lang.String, float]: ...
    @staticmethod
    def getPropertyNames() -> typing.MutableSequence[java.lang.String]: ...
    def getValues(self) -> typing.MutableSequence[float]: ...

class SystemThermo(SystemInterface):
    characterization: jneqsim.neqsim.thermo.characterization.Characterise = ...
    componentNameTag: java.lang.String = ...
    maxNumberOfPhases: int = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def addCapeOpenProperty(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def addCharacterized(self, stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray], doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def addComponent(self, int: int, double: float) -> None: ...
    @typing.overload
    def addComponent(self, int: int, double: float, int2: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, double3: float, double4: float) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str], int: int) -> None: ...
    @typing.overload
    def addComponent(self, componentInterface: jneqsim.neqsim.thermo.component.ComponentInterface) -> None: ...
    @typing.overload
    def addFluid(self, systemInterface: SystemInterface) -> SystemInterface: ...
    @typing.overload
    def addFluid(self, systemInterface: SystemInterface, int: int) -> SystemInterface: ...
    def addGasToLiquid(self, double: float) -> None: ...
    def addHydratePhase(self) -> None: ...
    def addHydratePhase2(self) -> None: ...
    def addLiquidToGas(self, double: float) -> None: ...
    @typing.overload
    def addOilFractions(self, stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray], doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray], boolean: bool) -> None: ...
    @typing.overload
    def addOilFractions(self, stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray], doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray], boolean: bool, boolean2: bool, int: int) -> None: ...
    def addPhase(self) -> None: ...
    @typing.overload
    def addPhaseFractionToPhase(self, double: float, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def addPhaseFractionToPhase(self, double: float, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str], string4: typing.Union[java.lang.String, str]) -> None: ...
    def addPlusFraction(self, string: typing.Union[java.lang.String, str], double: float, double2: float, double3: float) -> None: ...
    def addSalt(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...
    def addSolidComplexPhase(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def addSolidPhase(self) -> None: ...
    @typing.overload
    def addTBPfraction(self, string: typing.Union[java.lang.String, str], double: float, double2: float, double3: float) -> None: ...
    @typing.overload
    def addTBPfraction(self, string: typing.Union[java.lang.String, str], double: float, double2: float, double3: float, double4: float, double5: float, double6: float) -> None: ...
    def addTBPfraction2(self, string: typing.Union[java.lang.String, str], double: float, double2: float, double3: float) -> None: ...
    def addTBPfraction3(self, string: typing.Union[java.lang.String, str], double: float, double2: float, double3: float) -> None: ...
    def addTBPfraction4(self, string: typing.Union[java.lang.String, str], double: float, double2: float, double3: float, double4: float) -> None: ...
    def addToComponentNames(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def allowPhaseShift(self) -> bool: ...
    @typing.overload
    def allowPhaseShift(self, boolean: bool) -> None: ...
    def autoSelectMixingRule(self) -> None: ...
    def autoSelectModel(self) -> SystemInterface: ...
    def calcHenrysConstant(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def calcInterfaceProperties(self) -> None: ...
    def calcKIJ(self, boolean: bool) -> None: ...
    def calc_x_y(self) -> None: ...
    def calc_x_y_nonorm(self) -> None: ...
    def calculateDensityFromBoilingPoint(self, double: float, double2: float) -> float: ...
    def calculateMolarMassFromDensityAndBoilingPoint(self, double: float, double2: float) -> float: ...
    def changeComponentName(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def checkStability(self) -> bool: ...
    @typing.overload
    def checkStability(self, boolean: bool) -> None: ...
    def chemicalReactionInit(self) -> None: ...
    def clearAll(self) -> None: ...
    def clone(self) -> 'SystemThermo': ...
    def createDatabase(self, boolean: bool) -> None: ...
    def createTable(self, string: typing.Union[java.lang.String, str]) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def deleteFluidPhase(self, int: int) -> None: ...
    @typing.overload
    def display(self) -> None: ...
    @typing.overload
    def display(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def doMultiPhaseCheck(self) -> bool: ...
    def doSolidPhaseCheck(self) -> bool: ...
    def equals(self, object: typing.Any) -> bool: ...
    def getAntoineVaporPressure(self, double: float) -> float: ...
    @typing.overload
    def getBeta(self) -> float: ...
    @typing.overload
    def getBeta(self, int: int) -> float: ...
    def getCASNumbers(self) -> typing.MutableSequence[java.lang.String]: ...
    def getCapeOpenProperties10(self) -> typing.MutableSequence[java.lang.String]: ...
    def getCapeOpenProperties11(self) -> typing.MutableSequence[java.lang.String]: ...
    def getCharacterization(self) -> jneqsim.neqsim.thermo.characterization.Characterise: ...
    def getChemicalReactionOperations(self) -> jneqsim.neqsim.chemicalreactions.ChemicalReactionOperations: ...
    def getCompFormulaes(self) -> typing.MutableSequence[java.lang.String]: ...
    def getCompIDs(self) -> typing.MutableSequence[java.lang.String]: ...
    def getCompNames(self) -> typing.MutableSequence[java.lang.String]: ...
    def getComponentNameTag(self) -> java.lang.String: ...
    def getCorrectedVolume(self) -> float: ...
    def getCorrectedVolumeFraction(self, int: int) -> float: ...
    @typing.overload
    def getCp(self) -> float: ...
    @typing.overload
    def getCp(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getCv(self) -> float: ...
    @typing.overload
    def getCv(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getDensity(self) -> float: ...
    @typing.overload
    def getDensity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getEmptySystemClone(self) -> SystemInterface: ...
    @typing.overload
    def getEnthalpy(self) -> float: ...
    @typing.overload
    def getEnthalpy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getEntropy(self) -> float: ...
    @typing.overload
    def getEntropy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getExergy(self, double: float) -> float: ...
    @typing.overload
    def getExergy(self, double: float, string: typing.Union[java.lang.String, str]) -> float: ...
    def getFlowRate(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getFluidInfo(self) -> java.lang.String: ...
    def getFluidName(self) -> java.lang.String: ...
    def getGamma(self) -> float: ...
    def getGasPhase(self) -> jneqsim.neqsim.thermo.phase.PhaseInterface: ...
    def getGibbsEnergy(self) -> float: ...
    def getHeatOfVaporization(self) -> float: ...
    def getHelmholtzEnergy(self) -> float: ...
    def getHydrateCheck(self) -> bool: ...
    def getIdealLiquidDensity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getInterfacialTension(self, int: int, int2: int) -> float: ...
    @typing.overload
    def getInterfacialTension(self, int: int, int2: int, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getInterfacialTension(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getInternalEnergy(self) -> float: ...
    @typing.overload
    def getInternalEnergy(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getInterphaseProperties(self) -> jneqsim.neqsim.physicalproperties.interfaceproperties.InterphasePropertiesInterface: ...
    @typing.overload
    def getJouleThomsonCoefficient(self) -> float: ...
    @typing.overload
    def getJouleThomsonCoefficient(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getKappa(self) -> float: ...
    @typing.overload
    def getKinematicViscosity(self) -> float: ...
    @typing.overload
    def getKinematicViscosity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getKvector(self) -> typing.MutableSequence[float]: ...
    def getLiquidPhase(self) -> jneqsim.neqsim.thermo.phase.PhaseInterface: ...
    def getLiquidVolume(self) -> float: ...
    def getLowestGibbsEnergyPhase(self) -> jneqsim.neqsim.thermo.phase.PhaseInterface: ...
    def getMass(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getMaxNumberOfPhases(self) -> int: ...
    def getMixingRule(self) -> jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface: ...
    def getMixingRuleName(self) -> java.lang.String: ...
    def getModelName(self) -> java.lang.String: ...
    def getMolarComposition(self) -> typing.MutableSequence[float]: ...
    @typing.overload
    def getMolarMass(self) -> float: ...
    @typing.overload
    def getMolarMass(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getMolarRate(self) -> typing.MutableSequence[float]: ...
    @typing.overload
    def getMolarVolume(self) -> float: ...
    @typing.overload
    def getMolarVolume(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getMoleFraction(self, int: int) -> float: ...
    def getMoleFractionsSum(self) -> float: ...
    def getMolecularWeights(self) -> typing.MutableSequence[float]: ...
    def getNormalBoilingPointTemperatures(self) -> typing.MutableSequence[float]: ...
    def getNumberOfComponents(self) -> int: ...
    def getNumberOfOilFractionComponents(self) -> int: ...
    def getNumberOfPhases(self) -> int: ...
    def getOilFractionIDs(self) -> typing.MutableSequence[int]: ...
    def getOilFractionLiquidDensityAt25C(self) -> typing.MutableSequence[float]: ...
    def getOilFractionMolecularMass(self) -> typing.MutableSequence[float]: ...
    def getOilFractionNormalBoilingPoints(self) -> typing.MutableSequence[float]: ...
    def getPC(self) -> float: ...
    @typing.overload
    def getPhase(self, int: int) -> jneqsim.neqsim.thermo.phase.PhaseInterface: ...
    @typing.overload
    def getPhase(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.thermo.phase.PhaseInterface: ...
    @typing.overload
    def getPhase(self, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> jneqsim.neqsim.thermo.phase.PhaseInterface: ...
    def getPhaseFraction(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getPhaseIndex(self, int: int) -> int: ...
    @typing.overload
    def getPhaseIndex(self, string: typing.Union[java.lang.String, str]) -> int: ...
    @typing.overload
    def getPhaseIndex(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> int: ...
    @typing.overload
    def getPhaseNumberOfPhase(self, string: typing.Union[java.lang.String, str]) -> int: ...
    @typing.overload
    def getPhaseNumberOfPhase(self, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> int: ...
    def getPhaseOfType(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.thermo.phase.PhaseInterface: ...
    def getPhases(self) -> typing.MutableSequence[jneqsim.neqsim.thermo.phase.PhaseInterface]: ...
    @typing.overload
    def getPressure(self) -> float: ...
    @typing.overload
    def getPressure(self, int: int) -> float: ...
    @typing.overload
    def getPressure(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getProperties(self) -> SystemProperties: ...
    @typing.overload
    def getProperty(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getProperty(self, string: typing.Union[java.lang.String, str], int: int) -> float: ...
    @typing.overload
    def getProperty(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], int: int) -> float: ...
    def getResultTable(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    @typing.overload
    def getSoundSpeed(self) -> float: ...
    @typing.overload
    def getSoundSpeed(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getStandard(self) -> jneqsim.neqsim.standards.StandardInterface: ...
    @typing.overload
    def getStandard(self, string: typing.Union[java.lang.String, str]) -> jneqsim.neqsim.standards.StandardInterface: ...
    def getSumBeta(self) -> float: ...
    def getTC(self) -> float: ...
    @typing.overload
    def getTemperature(self, int: int) -> float: ...
    @typing.overload
    def getTemperature(self) -> float: ...
    @typing.overload
    def getTemperature(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getThermalConductivity(self) -> float: ...
    @typing.overload
    def getThermalConductivity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    def getTotalNumberOfMoles(self) -> float: ...
    @typing.overload
    def getViscosity(self) -> float: ...
    @typing.overload
    def getViscosity(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getVolume(self, string: typing.Union[java.lang.String, str]) -> float: ...
    @typing.overload
    def getVolume(self) -> float: ...
    def getVolumeFraction(self, int: int) -> float: ...
    def getWaxCharacterisation(self) -> jneqsim.neqsim.thermo.characterization.WaxCharacterise: ...
    def getWaxModel(self) -> jneqsim.neqsim.thermo.characterization.WaxModelInterface: ...
    def getWtFraction(self, int: int) -> float: ...
    def getZ(self) -> float: ...
    def getZvolcorr(self) -> float: ...
    def getdPdVtn(self) -> float: ...
    def getdVdPtn(self) -> float: ...
    def getdVdTpn(self) -> float: ...
    def getzvector(self) -> typing.MutableSequence[float]: ...
    @typing.overload
    def hasPhaseType(self, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> bool: ...
    @typing.overload
    def hasPhaseType(self, string: typing.Union[java.lang.String, str]) -> bool: ...
    def hasPlusFraction(self) -> bool: ...
    def hasTBPFraction(self) -> bool: ...
    @typing.overload
    def init(self, int: int) -> None: ...
    @typing.overload
    def init(self, int: int, int2: int) -> None: ...
    @typing.overload
    def initAnalytic(self, int: int) -> None: ...
    @typing.overload
    def initAnalytic(self, int: int, int2: int) -> None: ...
    def initBeta(self) -> None: ...
    @typing.overload
    def initNumeric(self) -> None: ...
    @typing.overload
    def initNumeric(self, int: int) -> None: ...
    @typing.overload
    def initNumeric(self, int: int, int2: int) -> None: ...
    @typing.overload
    def initPhysicalProperties(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def initPhysicalProperties(self) -> None: ...
    @typing.overload
    def initPhysicalProperties(self, physicalPropertyType: jneqsim.neqsim.physicalproperties.PhysicalPropertyType) -> None: ...
    def initRefPhases(self) -> None: ...
    def initTotalNumberOfMoles(self, double: float) -> None: ...
    def init_x_y(self) -> None: ...
    def invertPhaseTypes(self) -> None: ...
    def isBetaValid(self) -> bool: ...
    @typing.overload
    def isChemicalSystem(self) -> bool: ...
    @typing.overload
    def isChemicalSystem(self, boolean: bool) -> None: ...
    def isForcePhaseTypes(self) -> bool: ...
    @typing.overload
    def isImplementedCompositionDeriativesofFugacity(self) -> bool: ...
    @typing.overload
    def isImplementedCompositionDeriativesofFugacity(self, boolean: bool) -> None: ...
    def isImplementedPressureDeriativesofFugacity(self) -> bool: ...
    def isImplementedTemperatureDeriativesofFugacity(self) -> bool: ...
    def isInitialized(self) -> bool: ...
    def isMultiphaseWaxCheck(self) -> bool: ...
    def isNumericDerivatives(self) -> bool: ...
    def isPhase(self, int: int) -> bool: ...
    def normalizeBeta(self) -> None: ...
    def orderByDensity(self) -> None: ...
    @typing.overload
    def phaseToSystem(self, int: int) -> SystemInterface: ...
    @typing.overload
    def phaseToSystem(self, int: int, int2: int) -> SystemInterface: ...
    @typing.overload
    def phaseToSystem(self, string: typing.Union[java.lang.String, str]) -> SystemInterface: ...
    @typing.overload
    def phaseToSystem(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> SystemInterface: ...
    def reInitPhaseInformation(self) -> None: ...
    def reInitPhaseType(self) -> None: ...
    def readFluid(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def readObject(self, int: int) -> SystemInterface: ...
    def readObjectFromFile(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> SystemInterface: ...
    def removeComponent(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def removePhase(self, int: int) -> None: ...
    def removePhaseKeepTotalComposition(self, int: int) -> None: ...
    def renameComponent(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    def replacePhase(self, int: int, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> None: ...
    def reset(self) -> None: ...
    def resetCharacterisation(self) -> None: ...
    def resetDatabase(self) -> None: ...
    def resetPhysicalProperties(self) -> None: ...
    def reset_x_y(self) -> None: ...
    def save(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def saveFluid(self, int: int) -> None: ...
    @typing.overload
    def saveFluid(self, int: int, string: typing.Union[java.lang.String, str]) -> None: ...
    def saveObject(self, int: int, string: typing.Union[java.lang.String, str]) -> None: ...
    def saveObjectToFile(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    def saveToDataBase(self) -> None: ...
    def setAllComponentsInPhase(self, int: int) -> None: ...
    def setAllPhaseType(self, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> None: ...
    def setAttractiveTerm(self, int: int) -> None: ...
    @typing.overload
    def setBeta(self, double: float) -> None: ...
    @typing.overload
    def setBeta(self, int: int, double: float) -> None: ...
    def setBmixType(self, int: int) -> None: ...
    def setComponentFlowRates(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], string: typing.Union[java.lang.String, str]) -> None: ...
    def setComponentNameTag(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setComponentNameTagOnNormalComponents(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setComponentNames(self, stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def setEmptyFluid(self) -> None: ...
    def setFluidInfo(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setFluidName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setForcePhaseTypes(self, boolean: bool) -> None: ...
    @typing.overload
    def setForceSinglePhase(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setForceSinglePhase(self, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> None: ...
    def setHeavyTBPfractionAsPlusFraction(self) -> bool: ...
    def setHydrateCheck(self, boolean: bool) -> None: ...
    def setImplementedCompositionDeriativesofFugacity(self, boolean: bool) -> None: ...
    def setImplementedPressureDeriativesofFugacity(self, boolean: bool) -> None: ...
    def setImplementedTemperatureDeriativesofFugacity(self, boolean: bool) -> None: ...
    def setLastTBPasPlus(self) -> bool: ...
    def setMaxNumberOfPhases(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...
    @typing.overload
    def setMixingRule(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    def setMixingRuleGEmodel(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setMixingRuleParametersForComponent(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setModel(self, string: typing.Union[java.lang.String, str]) -> SystemInterface: ...
    def setModelName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setMolarComposition(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setMolarCompositionOfNamedComponents(self, string: typing.Union[java.lang.String, str], doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setMolarCompositionOfPlusFluid(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setMolarCompositionPlus(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setMolarFlowRates(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def setMultiPhaseCheck(self, boolean: bool) -> None: ...
    def setMultiphaseWaxCheck(self, boolean: bool) -> None: ...
    def setNumberOfPhases(self, int: int) -> None: ...
    def setNumericDerivatives(self, boolean: bool) -> None: ...
    def setPC(self, double: float) -> None: ...
    def setPhase(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface, int: int) -> None: ...
    def setPhaseIndex(self, int: int, int2: int) -> None: ...
    @typing.overload
    def setPhaseType(self, int: int, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setPhaseType(self, int: int, phaseType: jneqsim.neqsim.thermo.phase.PhaseType) -> None: ...
    @typing.overload
    def setPressure(self, double: float) -> None: ...
    @typing.overload
    def setPressure(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setSolidPhaseCheck(self, boolean: bool) -> None: ...
    @typing.overload
    def setSolidPhaseCheck(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setStandard(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setTC(self, double: float) -> None: ...
    @typing.overload
    def setTemperature(self, double: float, int: int) -> None: ...
    @typing.overload
    def setTemperature(self, double: float) -> None: ...
    @typing.overload
    def setTemperature(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setTotalFlowRate(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def setTotalNumberOfMoles(self, double: float) -> None: ...
    def setUseTVasIndependentVariables(self, boolean: bool) -> None: ...
    def toCompJson(self) -> java.lang.String: ...
    def toJson(self) -> java.lang.String: ...
    def tuneModel(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    def useTVasIndependentVariables(self) -> bool: ...
    def useVolumeCorrection(self, boolean: bool) -> None: ...
    @typing.overload
    def write(self) -> java.lang.String: ...
    @typing.overload
    def write(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], boolean: bool) -> None: ...

class SystemEos(SystemThermo):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def equals(self, object: typing.Any) -> bool: ...

class SystemIdealGas(SystemThermo):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemIdealGas': ...

class SystemAmmoniaEos(SystemEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...
    @typing.overload
    def addComponent(self, componentInterface: jneqsim.neqsim.thermo.component.ComponentInterface) -> None: ...
    @typing.overload
    def addComponent(self, int: int, double: float) -> None: ...
    @typing.overload
    def addComponent(self, int: int, double: float, int2: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, double3: float, double4: float) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str], int: int) -> None: ...
    def clone(self) -> 'SystemAmmoniaEos': ...

class SystemBWRSEos(SystemEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemBWRSEos': ...

class SystemBnsEos(SystemEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, double3: float, double4: float, double5: float, double6: float, double7: float, boolean: bool): ...
    def clone(self) -> 'SystemBnsEos': ...
    def setAssociatedGas(self, boolean: bool) -> None: ...
    @typing.overload
    def setComposition(self, double: float, double2: float, double3: float, double4: float) -> None: ...
    @typing.overload
    def setComposition(self, double: float, double2: float, double3: float, double4: float, double5: float, boolean: bool) -> None: ...
    @typing.overload
    def setMixingRule(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...
    @typing.overload
    def setMixingRule(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    def setRelativeDensity(self, double: float) -> None: ...

class SystemDesmukhMather(SystemEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemDesmukhMather': ...

class SystemDuanSun(SystemEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...
    @typing.overload
    def addComponent(self, componentInterface: jneqsim.neqsim.thermo.component.ComponentInterface) -> None: ...
    @typing.overload
    def addComponent(self, int: int, double: float) -> None: ...
    @typing.overload
    def addComponent(self, int: int, double: float, int2: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, double3: float, double4: float) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str], int: int) -> None: ...
    def clone(self) -> 'SystemDuanSun': ...

class SystemGERG2004Eos(SystemEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemGERG2004Eos': ...
    def commonInitialization(self) -> None: ...

class SystemGERG2008Eos(SystemEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemGERG2008Eos': ...
    def commonInitialization(self) -> None: ...

class SystemGEWilson(SystemEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemGEWilson': ...

class SystemKentEisenberg(SystemEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemKentEisenberg': ...

class SystemLeachmanEos(SystemEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...
    @typing.overload
    def addComponent(self, componentInterface: jneqsim.neqsim.thermo.component.ComponentInterface) -> None: ...
    @typing.overload
    def addComponent(self, int: int, double: float) -> None: ...
    @typing.overload
    def addComponent(self, int: int, double: float, int2: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, double3: float, double4: float) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str], int: int) -> None: ...
    def clone(self) -> 'SystemLeachmanEos': ...
    def commonInitialization(self) -> None: ...

class SystemNRTL(SystemEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemNRTL': ...

class SystemPitzer(SystemEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemPitzer': ...
    @typing.overload
    def setMixingRule(self, int: int) -> None: ...
    @typing.overload
    def setMixingRule(self, mixingRuleTypeInterface: typing.Union[jneqsim.neqsim.thermo.mixingrule.MixingRuleTypeInterface, typing.Callable]) -> None: ...
    @typing.overload
    def setMixingRule(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def setMixingRule(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...

class SystemPrEos(SystemEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemPrEos': ...

class SystemRKEos(SystemEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemRKEos': ...

class SystemSpanWagnerEos(SystemEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...
    @typing.overload
    def addComponent(self, componentInterface: jneqsim.neqsim.thermo.component.ComponentInterface) -> None: ...
    @typing.overload
    def addComponent(self, int: int, double: float) -> None: ...
    @typing.overload
    def addComponent(self, int: int, double: float, int2: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, double3: float, double4: float) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str], int: int) -> None: ...
    def clone(self) -> 'SystemSpanWagnerEos': ...
    def commonInitialization(self) -> None: ...

class SystemSrkEos(SystemEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemSrkEos': ...

class SystemTSTEos(SystemEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemTSTEos': ...

class SystemUNIFAC(SystemEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemUNIFAC': ...

class SystemUNIFACpsrk(SystemEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemUNIFACpsrk': ...

class SystemVegaEos(SystemEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def addComponent(self, int: int, double: float) -> None: ...
    @typing.overload
    def addComponent(self, int: int, double: float, int2: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, double3: float, double4: float) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str], int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...
    @typing.overload
    def addComponent(self, componentInterface: jneqsim.neqsim.thermo.component.ComponentInterface) -> None: ...
    def clone(self) -> 'SystemVegaEos': ...
    def commonInitialization(self) -> None: ...

class SystemWaterIF97(SystemEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def addComponent(self, int: int, double: float) -> None: ...
    @typing.overload
    def addComponent(self, int: int, double: float, int2: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, double3: float, double4: float) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str], int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...
    @typing.overload
    def addComponent(self, componentInterface: jneqsim.neqsim.thermo.component.ComponentInterface) -> None: ...
    def clone(self) -> 'SystemWaterIF97': ...
    def commonInitialization(self) -> None: ...

class SystemCSPsrkEos(SystemSrkEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemCSPsrkEos': ...

class SystemFurstElectrolyteEos(SystemSrkEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    def clone(self) -> 'SystemFurstElectrolyteEos': ...

class SystemFurstElectrolyteEosMod2004(SystemSrkEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    def clone(self) -> 'SystemFurstElectrolyteEosMod2004': ...

class SystemGERGwaterEos(SystemPrEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemGERGwaterEos': ...

class SystemPCSAFT(SystemSrkEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    @typing.overload
    def addTBPfraction(self, string: typing.Union[java.lang.String, str], double: float, double2: float, double3: float) -> None: ...
    @typing.overload
    def addTBPfraction(self, string: typing.Union[java.lang.String, str], double: float, double2: float, double3: float, double4: float, double5: float, double6: float) -> None: ...
    def clone(self) -> 'SystemPCSAFT': ...
    def commonInitialization(self) -> None: ...

class SystemPCSAFTa(SystemSrkEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemPCSAFTa': ...

class SystemPrCPA(SystemPrEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemPrCPA': ...

class SystemPrDanesh(SystemPrEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemPrDanesh': ...

class SystemPrEos1978(SystemPrEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemPrEos1978': ...

class SystemPrEosDelft1998(SystemPrEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemPrEosDelft1998': ...

class SystemPrGassemEos(SystemPrEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemPrGassemEos': ...

class SystemPrMathiasCopeman(SystemPrEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemPrMathiasCopeman': ...

class SystemPsrkEos(SystemSrkEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemPsrkEos': ...

class SystemSrkCPA(SystemSrkEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...
    @typing.overload
    def addComponent(self, int: int, double: float) -> None: ...
    @typing.overload
    def addComponent(self, int: int, double: float, int2: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, double2: float, double3: float, double4: float) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, int: int) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def addComponent(self, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str], int: int) -> None: ...
    @typing.overload
    def addComponent(self, componentInterface: jneqsim.neqsim.thermo.component.ComponentInterface) -> None: ...
    def clone(self) -> 'SystemSrkCPA': ...
    def commonInitialization(self) -> None: ...

class SystemSrkMathiasCopeman(SystemSrkEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemSrkMathiasCopeman': ...

class SystemSrkPenelouxEos(SystemSrkEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemSrkPenelouxEos': ...

class SystemSrkSchwartzentruberEos(SystemSrkEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemSrkSchwartzentruberEos': ...

class SystemSrkTwuCoonEos(SystemSrkEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemSrkTwuCoonEos': ...

class SystemSrkTwuCoonParamEos(SystemSrkEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemSrkTwuCoonParamEos': ...

class SystemSrkTwuCoonStatoilEos(SystemSrkEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemSrkTwuCoonStatoilEos': ...

class SystemUMRCPAEoS(SystemPrEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...

class SystemUMRPRUEos(SystemPrEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemUMRPRUEos': ...
    def commonInitialization(self) -> None: ...

class SystemElectrolyteCPA(SystemFurstElectrolyteEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    def clone(self) -> 'SystemElectrolyteCPA': ...

class SystemElectrolyteCPAstatoil(SystemFurstElectrolyteEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    def clone(self) -> 'SystemElectrolyteCPAstatoil': ...

class SystemSoreideWhitson(SystemPrEos1978):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    @typing.overload
    def addSalinity(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def addSalinity(self, string: typing.Union[java.lang.String, str], double: float, string2: typing.Union[java.lang.String, str]) -> None: ...
    def calcSalinity(self) -> bool: ...
    def clone(self) -> 'SystemSoreideWhitson': ...
    def getSalinity(self) -> float: ...
    def setSalinity(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...

class SystemSrkCPAs(SystemSrkCPA):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemSrkCPAs': ...

class SystemUMRPRUMCEos(SystemUMRPRUEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemUMRPRUMCEos': ...

class SystemSrkCPAstatoil(SystemSrkCPAs):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...
    @typing.overload
    def __init__(self, double: float, double2: float, boolean: bool): ...
    def clone(self) -> 'SystemSrkCPAstatoil': ...

class SystemUMRPRUMCEosNew(SystemUMRPRUMCEos):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, double: float, double2: float): ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.thermo.system")``.

    SystemAmmoniaEos: typing.Type[SystemAmmoniaEos]
    SystemBWRSEos: typing.Type[SystemBWRSEos]
    SystemBnsEos: typing.Type[SystemBnsEos]
    SystemCSPsrkEos: typing.Type[SystemCSPsrkEos]
    SystemDesmukhMather: typing.Type[SystemDesmukhMather]
    SystemDuanSun: typing.Type[SystemDuanSun]
    SystemElectrolyteCPA: typing.Type[SystemElectrolyteCPA]
    SystemElectrolyteCPAstatoil: typing.Type[SystemElectrolyteCPAstatoil]
    SystemEos: typing.Type[SystemEos]
    SystemFurstElectrolyteEos: typing.Type[SystemFurstElectrolyteEos]
    SystemFurstElectrolyteEosMod2004: typing.Type[SystemFurstElectrolyteEosMod2004]
    SystemGERG2004Eos: typing.Type[SystemGERG2004Eos]
    SystemGERG2008Eos: typing.Type[SystemGERG2008Eos]
    SystemGERGwaterEos: typing.Type[SystemGERGwaterEos]
    SystemGEWilson: typing.Type[SystemGEWilson]
    SystemIdealGas: typing.Type[SystemIdealGas]
    SystemInterface: typing.Type[SystemInterface]
    SystemKentEisenberg: typing.Type[SystemKentEisenberg]
    SystemLeachmanEos: typing.Type[SystemLeachmanEos]
    SystemNRTL: typing.Type[SystemNRTL]
    SystemPCSAFT: typing.Type[SystemPCSAFT]
    SystemPCSAFTa: typing.Type[SystemPCSAFTa]
    SystemPitzer: typing.Type[SystemPitzer]
    SystemPrCPA: typing.Type[SystemPrCPA]
    SystemPrDanesh: typing.Type[SystemPrDanesh]
    SystemPrEos: typing.Type[SystemPrEos]
    SystemPrEos1978: typing.Type[SystemPrEos1978]
    SystemPrEosDelft1998: typing.Type[SystemPrEosDelft1998]
    SystemPrGassemEos: typing.Type[SystemPrGassemEos]
    SystemPrMathiasCopeman: typing.Type[SystemPrMathiasCopeman]
    SystemProperties: typing.Type[SystemProperties]
    SystemPsrkEos: typing.Type[SystemPsrkEos]
    SystemRKEos: typing.Type[SystemRKEos]
    SystemSoreideWhitson: typing.Type[SystemSoreideWhitson]
    SystemSpanWagnerEos: typing.Type[SystemSpanWagnerEos]
    SystemSrkCPA: typing.Type[SystemSrkCPA]
    SystemSrkCPAs: typing.Type[SystemSrkCPAs]
    SystemSrkCPAstatoil: typing.Type[SystemSrkCPAstatoil]
    SystemSrkEos: typing.Type[SystemSrkEos]
    SystemSrkMathiasCopeman: typing.Type[SystemSrkMathiasCopeman]
    SystemSrkPenelouxEos: typing.Type[SystemSrkPenelouxEos]
    SystemSrkSchwartzentruberEos: typing.Type[SystemSrkSchwartzentruberEos]
    SystemSrkTwuCoonEos: typing.Type[SystemSrkTwuCoonEos]
    SystemSrkTwuCoonParamEos: typing.Type[SystemSrkTwuCoonParamEos]
    SystemSrkTwuCoonStatoilEos: typing.Type[SystemSrkTwuCoonStatoilEos]
    SystemTSTEos: typing.Type[SystemTSTEos]
    SystemThermo: typing.Type[SystemThermo]
    SystemUMRCPAEoS: typing.Type[SystemUMRCPAEoS]
    SystemUMRPRUEos: typing.Type[SystemUMRPRUEos]
    SystemUMRPRUMCEos: typing.Type[SystemUMRPRUMCEos]
    SystemUMRPRUMCEosNew: typing.Type[SystemUMRPRUMCEosNew]
    SystemUNIFAC: typing.Type[SystemUNIFAC]
    SystemUNIFACpsrk: typing.Type[SystemUNIFACpsrk]
    SystemVegaEos: typing.Type[SystemVegaEos]
    SystemWaterIF97: typing.Type[SystemWaterIF97]
