
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import jpype
import jneqsim.neqsim.thermo.phase
import org.netlib.util
import typing



class Ammonia2023:
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface): ...
    def getAlpha0(self) -> typing.MutableSequence[org.netlib.util.doubleW]: ...
    def getAlphaRes(self) -> typing.MutableSequence[typing.MutableSequence[org.netlib.util.doubleW]]: ...
    def getDensity(self) -> float: ...
    def getThermalConductivity(self) -> float: ...
    def getViscosity(self) -> float: ...
    def properties(self) -> typing.MutableSequence[float]: ...
    def setPhase(self, phaseInterface: jneqsim.neqsim.thermo.phase.PhaseInterface) -> None: ...

class methaneBWR32:
    def __init__(self): ...
    def calcPressure(self, double: float, double2: float) -> float: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def molDens(self, double: float, double2: float, boolean: bool) -> float: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.thermo.util.referenceequations")``.

    Ammonia2023: typing.Type[Ammonia2023]
    methaneBWR32: typing.Type[methaneBWR32]
