
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.io
import java.lang
import java.util
import jpype
import jneqsim.neqsim.api.ioc
import jneqsim.neqsim.thermo.system
import jneqsim.neqsim.thermodynamicoperations.chemicalequilibrium
import jneqsim.neqsim.thermodynamicoperations.flashops
import jneqsim.neqsim.thermodynamicoperations.phaseenvelopeops
import jneqsim.neqsim.thermodynamicoperations.propertygenerator
import org.jfree.chart
import typing



class OperationInterface(java.lang.Runnable, java.io.Serializable):
    def addData(self, string: typing.Union[java.lang.String, str], doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def displayResult(self) -> None: ...
    def get(self, string: typing.Union[java.lang.String, str]) -> typing.MutableSequence[float]: ...
    def getJFreeChart(self, string: typing.Union[java.lang.String, str]) -> org.jfree.chart.JFreeChart: ...
    def getPoints(self, int: int) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def getResultTable(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def getThermoSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...

class ThermodynamicOperations(java.io.Serializable, java.lang.Cloneable):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def OLGApropTable(self, double: float, double2: float, int: int, double3: float, double4: float, int2: int, string: typing.Union[java.lang.String, str], int3: int) -> None: ...
    def OLGApropTablePH(self, double: float, double2: float, int: int, double3: float, double4: float, int2: int, string: typing.Union[java.lang.String, str], int3: int) -> None: ...
    @typing.overload
    def PHflash(self, double: float) -> None: ...
    @typing.overload
    def PHflash(self, double: float, int: int) -> None: ...
    @typing.overload
    def PHflash(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def PHflash2(self, double: float, int: int) -> None: ...
    def PHflashGERG2008(self, double: float) -> None: ...
    def PHflashLeachman(self, double: float) -> None: ...
    def PHflashVega(self, double: float) -> None: ...
    def PHsolidFlash(self, double: float) -> None: ...
    @typing.overload
    def PSflash(self, double: float) -> None: ...
    @typing.overload
    def PSflash(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def PSflash2(self, double: float) -> None: ...
    def PSflashGERG2008(self, double: float) -> None: ...
    def PSflashLeachman(self, double: float) -> None: ...
    def PSflashVega(self, double: float) -> None: ...
    @typing.overload
    def PUflash(self, double: float) -> None: ...
    @typing.overload
    def PUflash(self, double: float, double2: float, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def PUflash(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def PVrefluxFlash(self, double: float, int: int) -> None: ...
    def TPSolidflash(self) -> None: ...
    def TPVflash(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def TPflash(self) -> None: ...
    @typing.overload
    def TPflash(self, boolean: bool) -> None: ...
    def TPflashSoreideWhitson(self) -> None: ...
    def TPgradientFlash(self, double: float, double2: float) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    @typing.overload
    def TSflash(self, double: float) -> None: ...
    @typing.overload
    def TSflash(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def TVflash(self, double: float) -> None: ...
    @typing.overload
    def TVflash(self, double: float, string: typing.Union[java.lang.String, str]) -> None: ...
    def TVfractionFlash(self, double: float) -> None: ...
    @typing.overload
    def VHflash(self, double: float, double2: float) -> None: ...
    @typing.overload
    def VHflash(self, double: float, double2: float, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def VSflash(self, double: float, double2: float) -> None: ...
    @typing.overload
    def VSflash(self, double: float, double2: float, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def VUflash(self, double: float, double2: float) -> None: ...
    @typing.overload
    def VUflash(self, double: float, double2: float, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    def addData(self, string: typing.Union[java.lang.String, str], doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def addIonToScaleSaturation(self, int: int, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def bubblePointPressureFlash(self) -> None: ...
    @typing.overload
    def bubblePointPressureFlash(self, boolean: bool) -> None: ...
    def bubblePointTemperatureFlash(self) -> None: ...
    def calcCricoP(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def calcCricoT(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray], doubleArray3: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def calcCricondenBar(self) -> float: ...
    def calcHPTphaseEnvelope(self) -> None: ...
    def calcImobilePhaseHydrateTemperature(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray]) -> typing.MutableSequence[float]: ...
    def calcIonComposition(self, int: int) -> None: ...
    @typing.overload
    def calcPTphaseEnvelope(self) -> None: ...
    @typing.overload
    def calcPTphaseEnvelope(self, boolean: bool) -> None: ...
    @typing.overload
    def calcPTphaseEnvelope(self, boolean: bool, double: float) -> None: ...
    @typing.overload
    def calcPTphaseEnvelope(self, double: float) -> None: ...
    @typing.overload
    def calcPTphaseEnvelope(self, double: float, double2: float) -> None: ...
    def calcPTphaseEnvelope2(self) -> None: ...
    def calcPTphaseEnvelopeNew(self) -> None: ...
    def calcPTphaseEnvelopeNew3(self, double: float, double2: float, double3: float, double4: float, double5: float, double6: float) -> None: ...
    def calcPloadingCurve(self) -> None: ...
    def calcSaltSaturation(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def calcSolidComlexTemperature(self) -> None: ...
    @typing.overload
    def calcSolidComlexTemperature(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    def calcTOLHydrateFormationTemperature(self) -> float: ...
    def calcWAT(self) -> None: ...
    def checkScalePotential(self, int: int) -> None: ...
    def chemicalEquilibrium(self) -> None: ...
    def constantPhaseFractionPressureFlash(self, double: float) -> None: ...
    def constantPhaseFractionTemperatureFlash(self, double: float) -> None: ...
    def criticalPointFlash(self) -> None: ...
    def dTPflash(self, stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def dewPointMach(self, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str], double: float) -> None: ...
    def dewPointPressureFlash(self) -> None: ...
    def dewPointPressureFlashHC(self) -> None: ...
    def dewPointTemperatureCondensationRate(self) -> float: ...
    @typing.overload
    def dewPointTemperatureFlash(self) -> None: ...
    @typing.overload
    def dewPointTemperatureFlash(self, boolean: bool) -> None: ...
    def display(self) -> None: ...
    def displayResult(self) -> None: ...
    def flash(self, flashType: 'ThermodynamicOperations.FlashType', double: float, double2: float, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def freezingPointTemperatureFlash(self) -> None: ...
    @typing.overload
    def freezingPointTemperatureFlash(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def get(self, string: typing.Union[java.lang.String, str]) -> typing.MutableSequence[float]: ...
    def getData(self) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def getDataPoints(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def getJfreeChart(self) -> org.jfree.chart.JFreeChart: ...
    def getOperation(self) -> OperationInterface: ...
    def getResultTable(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def getSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def getThermoOperationThread(self) -> java.lang.Thread: ...
    def hydrateEquilibriumLine(self, double: float, double2: float) -> None: ...
    def hydrateFormationPressure(self) -> None: ...
    @typing.overload
    def hydrateFormationTemperature(self) -> None: ...
    @typing.overload
    def hydrateFormationTemperature(self, double: float) -> None: ...
    @typing.overload
    def hydrateFormationTemperature(self, int: int) -> None: ...
    def hydrateInhibitorConcentration(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...
    def hydrateInhibitorConcentrationSet(self, string: typing.Union[java.lang.String, str], double: float) -> None: ...
    def isRunAsThread(self) -> bool: ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def propertyFlash(self, list: java.util.List[float], list2: java.util.List[float], int: int, list3: java.util.List[typing.Union[java.lang.String, str]], list4: java.util.List[java.util.List[float]]) -> jneqsim.neqsim.api.ioc.CalculationResult: ...
    def run(self) -> None: ...
    def saturateWithWater(self) -> None: ...
    def setResultTable(self, stringArray: typing.Union[typing.List[typing.MutableSequence[java.lang.String]], jpype.JArray]) -> None: ...
    def setRunAsThread(self, boolean: bool) -> None: ...
    def setSystem(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> None: ...
    def setThermoOperationThread(self, thread: java.lang.Thread) -> None: ...
    def waitAndCheckForFinishedCalculation(self, int: int) -> bool: ...
    def waitToFinishCalculation(self) -> None: ...
    def waterDewPointLine(self, double: float, double2: float) -> None: ...
    def waterDewPointTemperatureFlash(self) -> None: ...
    def waterDewPointTemperatureMultiphaseFlash(self) -> None: ...
    def waterPrecipitationTemperature(self) -> None: ...
    class FlashType(java.lang.Enum['ThermodynamicOperations.FlashType']):
        TP: typing.ClassVar['ThermodynamicOperations.FlashType'] = ...
        PT: typing.ClassVar['ThermodynamicOperations.FlashType'] = ...
        PH: typing.ClassVar['ThermodynamicOperations.FlashType'] = ...
        PS: typing.ClassVar['ThermodynamicOperations.FlashType'] = ...
        TV: typing.ClassVar['ThermodynamicOperations.FlashType'] = ...
        TS: typing.ClassVar['ThermodynamicOperations.FlashType'] = ...
        _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_0__T], string: typing.Union[java.lang.String, str]) -> _valueOf_0__T: ...
        @typing.overload
        @staticmethod
        def valueOf(string: typing.Union[java.lang.String, str]) -> 'ThermodynamicOperations.FlashType': ...
        @staticmethod
        def values() -> typing.MutableSequence['ThermodynamicOperations.FlashType']: ...

class BaseOperation(OperationInterface):
    def __init__(self): ...
    def addData(self, string: typing.Union[java.lang.String, str], doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def get(self, string: typing.Union[java.lang.String, str]) -> typing.MutableSequence[float]: ...
    def getJFreeChart(self, string: typing.Union[java.lang.String, str]) -> org.jfree.chart.JFreeChart: ...
    def getPoints(self, int: int) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def getResultTable(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def getThermoSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.thermodynamicoperations")``.

    BaseOperation: typing.Type[BaseOperation]
    OperationInterface: typing.Type[OperationInterface]
    ThermodynamicOperations: typing.Type[ThermodynamicOperations]
    chemicalequilibrium: jneqsim.neqsim.thermodynamicoperations.chemicalequilibrium.__module_protocol__
    flashops: jneqsim.neqsim.thermodynamicoperations.flashops.__module_protocol__
    phaseenvelopeops: jneqsim.neqsim.thermodynamicoperations.phaseenvelopeops.__module_protocol__
    propertygenerator: jneqsim.neqsim.thermodynamicoperations.propertygenerator.__module_protocol__
