
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.io
import java.lang
import jpype
import jneqsim.neqsim.thermo
import jneqsim.neqsim.thermo.system
import jneqsim.neqsim.thermodynamicoperations
import jneqsim.neqsim.thermodynamicoperations.flashops.saturationops
import org.jfree.chart
import typing



class Flash(jneqsim.neqsim.thermodynamicoperations.BaseOperation):
    minGibsPhaseLogZ: typing.MutableSequence[float] = ...
    minGibsLogFugCoef: typing.MutableSequence[float] = ...
    def __init__(self): ...
    def addData(self, string: typing.Union[java.lang.String, str], doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def displayResult(self) -> None: ...
    def findLowestGibbsEnergyPhase(self) -> int: ...
    def getPoints(self, int: int) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def getResultTable(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def solidPhaseFlash(self) -> None: ...
    def stabilityAnalysis(self) -> None: ...
    def stabilityCheck(self) -> bool: ...

class RachfordRice(java.io.Serializable):
    def __init__(self): ...
    def calcBeta(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray]) -> float: ...
    def calcBetaMichelsen2001(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray]) -> float: ...
    def calcBetaNielsen2023(self, doubleArray: typing.Union[typing.List[float], jpype.JArray], doubleArray2: typing.Union[typing.List[float], jpype.JArray]) -> float: ...
    def calcBetaS(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface) -> float: ...
    def getBeta(self) -> typing.MutableSequence[float]: ...
    @staticmethod
    def getMethod() -> java.lang.String: ...
    @staticmethod
    def setMethod(string: typing.Union[java.lang.String, str]) -> None: ...

class SysNewtonRhapsonPHflash(jneqsim.neqsim.thermo.ThermodynamicConstantsInterface):
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, int: int, int2: int): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, int: int, int2: int, int3: int): ...
    def init(self) -> None: ...
    def setJac(self) -> None: ...
    def setSpec(self, double: float) -> None: ...
    def setfvec(self) -> None: ...
    def setu(self) -> None: ...
    def solve(self, int: int) -> int: ...

class SysNewtonRhapsonTPflash(java.io.Serializable):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, int: int, int2: int): ...
    def init(self) -> None: ...
    def setJac(self) -> None: ...
    def setfvec(self) -> None: ...
    def setu(self) -> None: ...
    def solve(self) -> float: ...

class SysNewtonRhapsonTPflashNew(java.io.Serializable):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, int: int, int2: int): ...
    def init(self) -> None: ...
    def setJac(self) -> None: ...
    def setfvec(self) -> None: ...
    def setu(self) -> None: ...
    def solve(self, int: int) -> None: ...

class CalcIonicComposition(Flash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, int: int): ...
    def getJFreeChart(self, string: typing.Union[java.lang.String, str]) -> org.jfree.chart.JFreeChart: ...
    def getResultTable(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def run(self) -> None: ...

class CriticalPointFlash(Flash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calcMmatrix(self) -> None: ...
    def calcMmatrixHeidemann(self) -> None: ...
    def calcdpd(self) -> float: ...
    def run(self) -> None: ...

class PHflash(Flash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float, int: int): ...
    def calcdQdT(self) -> float: ...
    def calcdQdTT(self) -> float: ...
    def getJFreeChart(self, string: typing.Union[java.lang.String, str]) -> org.jfree.chart.JFreeChart: ...
    def run(self) -> None: ...
    def solveQ(self) -> float: ...
    def solveQ2(self) -> float: ...

class PHflashGERG2008(Flash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float): ...
    def calcdQdT(self) -> float: ...
    def calcdQdTT(self) -> float: ...
    def getJFreeChart(self, string: typing.Union[java.lang.String, str]) -> org.jfree.chart.JFreeChart: ...
    def run(self) -> None: ...
    def solveQ(self) -> float: ...
    def solveQ2(self) -> float: ...

class PHflashLeachman(Flash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float): ...
    def calcdQdT(self) -> float: ...
    def calcdQdTT(self) -> float: ...
    def getJFreeChart(self, string: typing.Union[java.lang.String, str]) -> org.jfree.chart.JFreeChart: ...
    def run(self) -> None: ...
    def solveQ(self) -> float: ...

class PHflashSingleComp(Flash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float, int: int): ...
    def getJFreeChart(self, string: typing.Union[java.lang.String, str]) -> org.jfree.chart.JFreeChart: ...
    def run(self) -> None: ...

class PHflashVega(Flash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float): ...
    def calcdQdT(self) -> float: ...
    def calcdQdTT(self) -> float: ...
    def getJFreeChart(self, string: typing.Union[java.lang.String, str]) -> org.jfree.chart.JFreeChart: ...
    def run(self) -> None: ...
    def solveQ(self) -> float: ...

class PHsolidFlash(Flash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float): ...
    def getJFreeChart(self, string: typing.Union[java.lang.String, str]) -> org.jfree.chart.JFreeChart: ...
    def run(self) -> None: ...

class PSflashSingleComp(Flash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float, int: int): ...
    def getJFreeChart(self, string: typing.Union[java.lang.String, str]) -> org.jfree.chart.JFreeChart: ...
    def run(self) -> None: ...

class PUflash(Flash):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float): ...
    def calcdQdT(self) -> float: ...
    def calcdQdTT(self) -> float: ...
    def getJFreeChart(self, string: typing.Union[java.lang.String, str]) -> org.jfree.chart.JFreeChart: ...
    def run(self) -> None: ...
    def solveQ(self) -> float: ...

class PVrefluxflash(Flash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float, int: int): ...
    def getJFreeChart(self, string: typing.Union[java.lang.String, str]) -> org.jfree.chart.JFreeChart: ...
    def run(self) -> None: ...

class QfuncFlash(Flash):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float, int: int): ...
    def calcdQdT(self) -> float: ...
    def calcdQdTT(self) -> float: ...
    def getJFreeChart(self, string: typing.Union[java.lang.String, str]) -> org.jfree.chart.JFreeChart: ...
    def run(self) -> None: ...
    def solveQ(self) -> float: ...

class TPflash(Flash):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, boolean: bool): ...
    def accselerateSucsSubs(self) -> None: ...
    def equals(self, object: typing.Any) -> bool: ...
    def getJFreeChart(self, string: typing.Union[java.lang.String, str]) -> org.jfree.chart.JFreeChart: ...
    def resetK(self) -> None: ...
    def run(self) -> None: ...
    def setNewK(self) -> None: ...
    def sucsSubs(self) -> None: ...

class TPgradientFlash(Flash):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float, double2: float): ...
    def getThermoSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def run(self) -> None: ...
    def setJac(self) -> None: ...
    def setNewX(self) -> None: ...
    def setfvec(self) -> None: ...

class TVflash(Flash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float): ...
    def calcdQdV(self) -> float: ...
    def calcdQdVdP(self) -> float: ...
    def getJFreeChart(self, string: typing.Union[java.lang.String, str]) -> org.jfree.chart.JFreeChart: ...
    def run(self) -> None: ...
    def solveQ(self) -> float: ...

class TVfractionFlash(Flash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float): ...
    def calcdQdV(self) -> float: ...
    def calcdQdVdP(self) -> float: ...
    def getJFreeChart(self, string: typing.Union[java.lang.String, str]) -> org.jfree.chart.JFreeChart: ...
    def run(self) -> None: ...
    def solveQ(self) -> float: ...

class VHflash(Flash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float, double2: float): ...
    def getJFreeChart(self, string: typing.Union[java.lang.String, str]) -> org.jfree.chart.JFreeChart: ...
    def run(self) -> None: ...

class VHflashQfunc(Flash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float, double2: float): ...
    def calcdQdP(self) -> float: ...
    def calcdQdPP(self) -> float: ...
    def calcdQdT(self) -> float: ...
    def calcdQdTT(self) -> float: ...
    def getJFreeChart(self, string: typing.Union[java.lang.String, str]) -> org.jfree.chart.JFreeChart: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def run(self) -> None: ...
    def solveQ(self) -> float: ...

class VSflash(Flash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float, double2: float): ...
    def calcdQdP(self) -> float: ...
    def calcdQdPP(self) -> float: ...
    def calcdQdT(self) -> float: ...
    def calcdQdTT(self) -> float: ...
    def getJFreeChart(self, string: typing.Union[java.lang.String, str]) -> org.jfree.chart.JFreeChart: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def run(self) -> None: ...
    def solveQ(self) -> float: ...

class VUflash(Flash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float, double2: float): ...
    def getJFreeChart(self, string: typing.Union[java.lang.String, str]) -> org.jfree.chart.JFreeChart: ...
    def run(self) -> None: ...

class VUflashQfunc(Flash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float, double2: float): ...
    def calcdQdP(self) -> float: ...
    def calcdQdPP(self) -> float: ...
    def calcdQdT(self) -> float: ...
    def calcdQdTT(self) -> float: ...
    def getJFreeChart(self, string: typing.Union[java.lang.String, str]) -> org.jfree.chart.JFreeChart: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def run(self) -> None: ...
    def solveQ(self) -> float: ...

class VUflashSingleComp(Flash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float, double2: float): ...
    def getJFreeChart(self, string: typing.Union[java.lang.String, str]) -> org.jfree.chart.JFreeChart: ...
    def run(self) -> None: ...

class PSFlash(QfuncFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float, int: int): ...
    def calcdQdT(self) -> float: ...
    def calcdQdTT(self) -> float: ...
    def onPhaseSolve(self) -> None: ...
    def run(self) -> None: ...
    def solveQ(self) -> float: ...

class PSFlashGERG2008(QfuncFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float): ...
    def calcdQdT(self) -> float: ...
    def calcdQdTT(self) -> float: ...
    def run(self) -> None: ...
    def solveQ(self) -> float: ...

class PSFlashLeachman(QfuncFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float): ...
    def calcdQdT(self) -> float: ...
    def calcdQdTT(self) -> float: ...
    def run(self) -> None: ...
    def solveQ(self) -> float: ...

class PSFlashVega(QfuncFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float): ...
    def calcdQdT(self) -> float: ...
    def calcdQdTT(self) -> float: ...
    def run(self) -> None: ...
    def solveQ(self) -> float: ...

class SaturateWithWater(QfuncFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def run(self) -> None: ...

class SolidFlash(TPflash):
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, boolean: bool): ...
    def calcE(self) -> None: ...
    def calcMultiPhaseBeta(self) -> None: ...
    def calcQ(self) -> float: ...
    def calcSolidBeta(self) -> None: ...
    def checkGibbs(self) -> None: ...
    def checkX(self) -> None: ...
    def run(self) -> None: ...
    def setSolidComponent(self, int: int) -> None: ...
    def setXY(self) -> None: ...
    def solveBeta(self, boolean: bool) -> None: ...

class SolidFlash1(TPflash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calcE(self) -> None: ...
    def calcGradientAndHesian(self) -> None: ...
    def calcMultiPhaseBeta(self) -> None: ...
    def calcQ(self) -> float: ...
    def calcQbeta(self) -> None: ...
    def calcSolidBeta(self) -> float: ...
    def checkAndAddSolidPhase(self) -> int: ...
    def checkGibbs(self) -> None: ...
    def checkX(self) -> None: ...
    def run(self) -> None: ...
    def setXY(self) -> None: ...
    def solveBeta(self) -> None: ...
    def solvebeta1(self) -> float: ...

class SolidFlash12(TPflash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calcE(self) -> None: ...
    def calcMultiPhaseBeta(self) -> None: ...
    def calcQ(self) -> float: ...
    def calcSolidBeta(self) -> None: ...
    def checkAndAddSolidPhase(self) -> int: ...
    def checkGibbs(self) -> None: ...
    def checkX(self) -> None: ...
    def run(self) -> None: ...
    def setXY(self) -> None: ...
    def solveBeta(self) -> None: ...
    def solvebeta1(self) -> float: ...

class TPmultiflash(TPflash):
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, boolean: bool): ...
    def calcE(self) -> None: ...
    def calcMultiPhaseBeta(self) -> None: ...
    def calcQ(self) -> float: ...
    def run(self) -> None: ...
    def setDoubleArrays(self) -> None: ...
    def setXY(self) -> None: ...
    def solveBeta(self) -> float: ...
    def stabilityAnalysis(self) -> None: ...
    def stabilityAnalysis2(self) -> None: ...
    def stabilityAnalysis3(self) -> None: ...

class TPmultiflashWAX(TPflash):
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, boolean: bool): ...
    def calcE(self) -> None: ...
    def calcMultiPhaseBeta(self) -> None: ...
    def calcQ(self) -> float: ...
    def run(self) -> None: ...
    def setXY(self) -> None: ...
    def solveBeta(self, boolean: bool) -> None: ...
    def stabilityAnalysis(self) -> None: ...

class TSFlash(QfuncFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float): ...
    def calcdQdT(self) -> float: ...
    def calcdQdTT(self) -> float: ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def onPhaseSolve(self) -> None: ...
    def run(self) -> None: ...
    def solveQ(self) -> float: ...

class dTPflash(TPflash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]): ...
    def run(self) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.thermodynamicoperations.flashops")``.

    CalcIonicComposition: typing.Type[CalcIonicComposition]
    CriticalPointFlash: typing.Type[CriticalPointFlash]
    Flash: typing.Type[Flash]
    PHflash: typing.Type[PHflash]
    PHflashGERG2008: typing.Type[PHflashGERG2008]
    PHflashLeachman: typing.Type[PHflashLeachman]
    PHflashSingleComp: typing.Type[PHflashSingleComp]
    PHflashVega: typing.Type[PHflashVega]
    PHsolidFlash: typing.Type[PHsolidFlash]
    PSFlash: typing.Type[PSFlash]
    PSFlashGERG2008: typing.Type[PSFlashGERG2008]
    PSFlashLeachman: typing.Type[PSFlashLeachman]
    PSFlashVega: typing.Type[PSFlashVega]
    PSflashSingleComp: typing.Type[PSflashSingleComp]
    PUflash: typing.Type[PUflash]
    PVrefluxflash: typing.Type[PVrefluxflash]
    QfuncFlash: typing.Type[QfuncFlash]
    RachfordRice: typing.Type[RachfordRice]
    SaturateWithWater: typing.Type[SaturateWithWater]
    SolidFlash: typing.Type[SolidFlash]
    SolidFlash1: typing.Type[SolidFlash1]
    SolidFlash12: typing.Type[SolidFlash12]
    SysNewtonRhapsonPHflash: typing.Type[SysNewtonRhapsonPHflash]
    SysNewtonRhapsonTPflash: typing.Type[SysNewtonRhapsonTPflash]
    SysNewtonRhapsonTPflashNew: typing.Type[SysNewtonRhapsonTPflashNew]
    TPflash: typing.Type[TPflash]
    TPgradientFlash: typing.Type[TPgradientFlash]
    TPmultiflash: typing.Type[TPmultiflash]
    TPmultiflashWAX: typing.Type[TPmultiflashWAX]
    TSFlash: typing.Type[TSFlash]
    TVflash: typing.Type[TVflash]
    TVfractionFlash: typing.Type[TVfractionFlash]
    VHflash: typing.Type[VHflash]
    VHflashQfunc: typing.Type[VHflashQfunc]
    VSflash: typing.Type[VSflash]
    VUflash: typing.Type[VUflash]
    VUflashQfunc: typing.Type[VUflashQfunc]
    VUflashSingleComp: typing.Type[VUflashSingleComp]
    dTPflash: typing.Type[dTPflash]
    saturationops: jneqsim.neqsim.thermodynamicoperations.flashops.saturationops.__module_protocol__
