
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.io
import java.lang
import jpype
import jneqsim.neqsim.thermo
import jneqsim.neqsim.thermo.system
import jneqsim.neqsim.thermodynamicoperations
import org.jfree.chart
import typing



class ConstantDutyFlashInterface(jneqsim.neqsim.thermodynamicoperations.OperationInterface):
    def isSuperCritical(self) -> bool: ...

class CricondenBarTemp(java.io.Serializable):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, int: int, int2: int): ...
    def init(self) -> None: ...
    def setJac(self) -> None: ...
    def setfvec(self) -> None: ...
    def setu(self) -> None: ...
    def solve(self) -> float: ...

class CricondenBarTemp1(java.io.Serializable):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def displayResult(self) -> None: ...
    def get(self, string: typing.Union[java.lang.String, str]) -> typing.MutableSequence[float]: ...
    def getJFreeChart(self, string: typing.Union[java.lang.String, str]) -> org.jfree.chart.JFreeChart: ...
    def getPoints(self, int: int) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def getResultTable(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def getThermoSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def init(self) -> None: ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def run(self) -> None: ...
    def setJac(self) -> None: ...
    def setfvec(self) -> None: ...
    def setu(self) -> None: ...
    def solve(self) -> float: ...

class ConstantDutyFlash(ConstantDutyFlashInterface):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def addData(self, string: typing.Union[java.lang.String, str], doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]) -> None: ...
    def displayResult(self) -> None: ...
    def get(self, string: typing.Union[java.lang.String, str]) -> typing.MutableSequence[float]: ...
    def getPoints(self, int: int) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def getResultTable(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def isSuperCritical(self) -> bool: ...
    def run(self) -> None: ...
    def setSuperCritical(self, boolean: bool) -> None: ...

class ConstantDutyPressureFlash(ConstantDutyFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def getJFreeChart(self, string: typing.Union[java.lang.String, str]) -> org.jfree.chart.JFreeChart: ...
    def getThermoSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def run(self) -> None: ...

class ConstantDutyTemperatureFlash(ConstantDutyFlash):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def getJFreeChart(self, string: typing.Union[java.lang.String, str]) -> org.jfree.chart.JFreeChart: ...
    def getThermoSystem(self) -> jneqsim.neqsim.thermo.system.SystemInterface: ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def run(self) -> None: ...

class AddIonToScaleSaturation(ConstantDutyTemperatureFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, int: int, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]): ...
    def getResultTable(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def run(self) -> None: ...

class BubblePointPressureFlash(ConstantDutyPressureFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def run(self) -> None: ...

class BubblePointPressureFlashDer(ConstantDutyPressureFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def run(self) -> None: ...

class BubblePointTemperatureFlash(ConstantDutyTemperatureFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def run(self) -> None: ...

class BubblePointTemperatureNoDer(ConstantDutyTemperatureFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def run(self) -> None: ...

class CalcSaltSatauration(ConstantDutyTemperatureFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, string: typing.Union[java.lang.String, str]): ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def run(self) -> None: ...

class CheckScalePotential(ConstantDutyTemperatureFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, int: int): ...
    def getResultTable(self) -> typing.MutableSequence[typing.MutableSequence[java.lang.String]]: ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def run(self) -> None: ...

class CricondebarFlash(ConstantDutyPressureFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calcx(self) -> float: ...
    def initMoleFraction(self) -> float: ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def run(self) -> None: ...
    def run2(self) -> None: ...
    def setJac(self) -> None: ...
    def setfvec(self) -> None: ...

class DewPointPressureFlash(ConstantDutyTemperatureFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def run(self) -> None: ...

class DewPointTemperatureFlash(ConstantDutyTemperatureFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def run(self) -> None: ...

class DewPointTemperatureFlashDer(ConstantDutyTemperatureFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def run(self) -> None: ...

class FreezeOut(ConstantDutyTemperatureFlash, jneqsim.neqsim.thermo.ThermodynamicConstantsInterface):
    FCompTemp: typing.MutableSequence[float] = ...
    FCompNames: typing.MutableSequence[java.lang.String] = ...
    noFreezeFlash: bool = ...
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def run(self) -> None: ...

class FreezingPointTemperatureFlash(ConstantDutyTemperatureFlash, jneqsim.neqsim.thermo.ThermodynamicConstantsInterface):
    noFreezeFlash: bool = ...
    Niterations: int = ...
    name: java.lang.String = ...
    phaseName: java.lang.String = ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, boolean: bool): ...
    def calcFunc(self) -> float: ...
    @typing.overload
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    @typing.overload
    def printToFile(self, string: typing.Union[java.lang.String, str], stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray], doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> None: ...
    def run(self) -> None: ...

class FreezingPointTemperatureFlashOld(ConstantDutyTemperatureFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def run(self) -> None: ...

class FreezingPointTemperatureFlashTR(ConstantDutyTemperatureFlash, jneqsim.neqsim.thermo.ThermodynamicConstantsInterface):
    noFreezeFlash: bool = ...
    Niterations: int = ...
    FCompNames: typing.MutableSequence[java.lang.String] = ...
    FCompTemp: typing.MutableSequence[float] = ...
    compnr: int = ...
    name: java.lang.String = ...
    CCequation: bool = ...
    @typing.overload
    def __init__(self, boolean: bool): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, boolean: bool): ...
    def getNiterations(self) -> int: ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def run(self) -> None: ...

class FugTestConstP(ConstantDutyTemperatureFlash, jneqsim.neqsim.thermo.ThermodynamicConstantsInterface):
    temp: float = ...
    pres: float = ...
    testSystem: jneqsim.neqsim.thermo.system.SystemInterface = ...
    testSystem2: jneqsim.neqsim.thermo.system.SystemInterface = ...
    testOps: jneqsim.neqsim.thermodynamicoperations.ThermodynamicOperations = ...
    testOps2: jneqsim.neqsim.thermodynamicoperations.ThermodynamicOperations = ...
    compNumber: int = ...
    compName: java.lang.String = ...
    compNameGiven: bool = ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float): ...
    def PrintToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def initTestSystem2(self, int: int) -> None: ...
    def run(self) -> None: ...

class HCdewPointPressureFlash(ConstantDutyTemperatureFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def run(self) -> None: ...

class HydrateEquilibriumLine(ConstantDutyTemperatureFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float, double2: float): ...
    def getPoints(self, int: int) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def run(self) -> None: ...

class HydrateFormationPressureFlash(ConstantDutyTemperatureFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def run(self) -> None: ...
    def setFug(self) -> None: ...

class HydrateFormationTemperatureFlash(ConstantDutyTemperatureFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def run(self) -> None: ...
    def run2(self) -> None: ...
    def setFug(self) -> None: ...
    def stop(self) -> None: ...

class HydrateInhibitorConcentrationFlash(ConstantDutyTemperatureFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, string: typing.Union[java.lang.String, str], double: float): ...
    @staticmethod
    def main(stringArray: typing.Union[typing.List[java.lang.String], jpype.JArray]) -> None: ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def run(self) -> None: ...
    def stop(self) -> None: ...

class HydrateInhibitorwtFlash(ConstantDutyTemperatureFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, string: typing.Union[java.lang.String, str], double: float): ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def run(self) -> None: ...
    def stop(self) -> None: ...

class SolidComplexTemperatureCalc(ConstantDutyTemperatureFlash):
    Kcomplex: typing.ClassVar[float] = ...
    HrefComplex: typing.ClassVar[float] = ...
    TrefComplex: typing.ClassVar[float] = ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    @typing.overload
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]): ...
    def getHrefComplex(self) -> float: ...
    def getKcomplex(self) -> float: ...
    def getTrefComplex(self) -> float: ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def run(self) -> None: ...
    def runOld(self) -> None: ...
    def setHrefComplex(self, double: float) -> None: ...
    def setKcomplex(self, double: float) -> None: ...
    def setTrefComplex(self, double: float) -> None: ...

class WATcalc(ConstantDutyTemperatureFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def run(self) -> None: ...

class WaterDewPointEquilibriumLine(ConstantDutyTemperatureFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface, double: float, double2: float): ...
    def getPoints(self, int: int) -> typing.MutableSequence[typing.MutableSequence[float]]: ...
    def run(self) -> None: ...

class WaterDewPointTemperatureFlash(ConstantDutyTemperatureFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def run(self) -> None: ...

class WaterDewPointTemperatureMultiphaseFlash(ConstantDutyTemperatureFlash):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def printToFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def run(self) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.thermodynamicoperations.flashops.saturationops")``.

    AddIonToScaleSaturation: typing.Type[AddIonToScaleSaturation]
    BubblePointPressureFlash: typing.Type[BubblePointPressureFlash]
    BubblePointPressureFlashDer: typing.Type[BubblePointPressureFlashDer]
    BubblePointTemperatureFlash: typing.Type[BubblePointTemperatureFlash]
    BubblePointTemperatureNoDer: typing.Type[BubblePointTemperatureNoDer]
    CalcSaltSatauration: typing.Type[CalcSaltSatauration]
    CheckScalePotential: typing.Type[CheckScalePotential]
    ConstantDutyFlash: typing.Type[ConstantDutyFlash]
    ConstantDutyFlashInterface: typing.Type[ConstantDutyFlashInterface]
    ConstantDutyPressureFlash: typing.Type[ConstantDutyPressureFlash]
    ConstantDutyTemperatureFlash: typing.Type[ConstantDutyTemperatureFlash]
    CricondebarFlash: typing.Type[CricondebarFlash]
    CricondenBarTemp: typing.Type[CricondenBarTemp]
    CricondenBarTemp1: typing.Type[CricondenBarTemp1]
    DewPointPressureFlash: typing.Type[DewPointPressureFlash]
    DewPointTemperatureFlash: typing.Type[DewPointTemperatureFlash]
    DewPointTemperatureFlashDer: typing.Type[DewPointTemperatureFlashDer]
    FreezeOut: typing.Type[FreezeOut]
    FreezingPointTemperatureFlash: typing.Type[FreezingPointTemperatureFlash]
    FreezingPointTemperatureFlashOld: typing.Type[FreezingPointTemperatureFlashOld]
    FreezingPointTemperatureFlashTR: typing.Type[FreezingPointTemperatureFlashTR]
    FugTestConstP: typing.Type[FugTestConstP]
    HCdewPointPressureFlash: typing.Type[HCdewPointPressureFlash]
    HydrateEquilibriumLine: typing.Type[HydrateEquilibriumLine]
    HydrateFormationPressureFlash: typing.Type[HydrateFormationPressureFlash]
    HydrateFormationTemperatureFlash: typing.Type[HydrateFormationTemperatureFlash]
    HydrateInhibitorConcentrationFlash: typing.Type[HydrateInhibitorConcentrationFlash]
    HydrateInhibitorwtFlash: typing.Type[HydrateInhibitorwtFlash]
    SolidComplexTemperatureCalc: typing.Type[SolidComplexTemperatureCalc]
    WATcalc: typing.Type[WATcalc]
    WaterDewPointEquilibriumLine: typing.Type[WaterDewPointEquilibriumLine]
    WaterDewPointTemperatureFlash: typing.Type[WaterDewPointTemperatureFlash]
    WaterDewPointTemperatureMultiphaseFlash: typing.Type[WaterDewPointTemperatureMultiphaseFlash]
