
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import jpype
import jneqsim.neqsim.thermo.system
import jneqsim.neqsim.thermodynamicoperations
import typing



class OLGApropertyTableGenerator(jneqsim.neqsim.thermodynamicoperations.BaseOperation):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calcPhaseEnvelope(self) -> None: ...
    def displayResult(self) -> None: ...
    def run(self) -> None: ...
    def setPressureRange(self, double: float, double2: float, int: int) -> None: ...
    def setTemperatureRange(self, double: float, double2: float, int: int) -> None: ...
    def writeOLGAinpFile(self, string: typing.Union[java.lang.String, str]) -> None: ...

class OLGApropertyTableGeneratorKeywordFormat(jneqsim.neqsim.thermodynamicoperations.BaseOperation):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calcBubP(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> typing.MutableSequence[float]: ...
    def calcBubT(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> typing.MutableSequence[float]: ...
    def calcDewP(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> typing.MutableSequence[float]: ...
    def calcPhaseEnvelope(self) -> None: ...
    def displayResult(self) -> None: ...
    def initCalc(self) -> None: ...
    def run(self) -> None: ...
    def setPressureRange(self, double: float, double2: float, int: int) -> None: ...
    def setTemperatureRange(self, double: float, double2: float, int: int) -> None: ...
    def writeOLGAinpFile(self, string: typing.Union[java.lang.String, str]) -> None: ...

class OLGApropertyTableGeneratorWater(jneqsim.neqsim.thermodynamicoperations.BaseOperation):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calcBubP(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> typing.MutableSequence[float]: ...
    def calcBubT(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> typing.MutableSequence[float]: ...
    def calcDewP(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> typing.MutableSequence[float]: ...
    def calcPhaseEnvelope(self) -> None: ...
    def calcRSWTOB(self) -> None: ...
    def displayResult(self) -> None: ...
    def extrapolateTable(self) -> None: ...
    def initCalc(self) -> None: ...
    def run(self) -> None: ...
    def setFileName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setPressureRange(self, double: float, double2: float, int: int) -> None: ...
    def setTemperatureRange(self, double: float, double2: float, int: int) -> None: ...
    def writeOLGAinpFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def writeOLGAinpFile2(self, string: typing.Union[java.lang.String, str]) -> None: ...

class OLGApropertyTableGeneratorWaterEven(jneqsim.neqsim.thermodynamicoperations.BaseOperation):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calcBubP(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> typing.MutableSequence[float]: ...
    def calcBubT(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> typing.MutableSequence[float]: ...
    def calcDewP(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> typing.MutableSequence[float]: ...
    def calcPhaseEnvelope(self) -> None: ...
    def calcRSWTOB(self) -> None: ...
    def displayResult(self) -> None: ...
    def extrapolateTable(self) -> None: ...
    def initCalc(self) -> None: ...
    def run(self) -> None: ...
    def setFileName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setPressureRange(self, double: float, double2: float, int: int) -> None: ...
    def setTemperatureRange(self, double: float, double2: float, int: int) -> None: ...
    def writeOLGAinpFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def writeOLGAinpFile2(self, string: typing.Union[java.lang.String, str]) -> None: ...

class OLGApropertyTableGeneratorWaterKeywordFormat(jneqsim.neqsim.thermodynamicoperations.BaseOperation):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calcBubP(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> typing.MutableSequence[float]: ...
    def calcBubT(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> typing.MutableSequence[float]: ...
    def calcDewP(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> typing.MutableSequence[float]: ...
    def calcPhaseEnvelope(self) -> None: ...
    def calcRSWTOB(self) -> None: ...
    def displayResult(self) -> None: ...
    def initCalc(self) -> None: ...
    def run(self) -> None: ...
    def setPressureRange(self, double: float, double2: float, int: int) -> None: ...
    def setTemperatureRange(self, double: float, double2: float, int: int) -> None: ...
    def writeOLGAinpFile(self, string: typing.Union[java.lang.String, str]) -> None: ...

class OLGApropertyTableGeneratorWaterStudents(jneqsim.neqsim.thermodynamicoperations.BaseOperation):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calcBubP(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> typing.MutableSequence[float]: ...
    def calcBubT(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> typing.MutableSequence[float]: ...
    def calcDewP(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> typing.MutableSequence[float]: ...
    def calcPhaseEnvelope(self) -> None: ...
    def calcRSWTOB(self) -> None: ...
    def displayResult(self) -> None: ...
    def extrapolateTable(self) -> None: ...
    def initCalc(self) -> None: ...
    def run(self) -> None: ...
    def setFileName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setPressureRange(self, double: float, double2: float, int: int) -> None: ...
    def setTemperatureRange(self, double: float, double2: float, int: int) -> None: ...
    def writeOLGAinpFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def writeOLGAinpFile2(self, string: typing.Union[java.lang.String, str]) -> None: ...

class OLGApropertyTableGeneratorWaterStudentsPH(jneqsim.neqsim.thermodynamicoperations.BaseOperation):
    def __init__(self, systemInterface: jneqsim.neqsim.thermo.system.SystemInterface): ...
    def calcBubP(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> typing.MutableSequence[float]: ...
    def calcBubT(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> typing.MutableSequence[float]: ...
    def calcDewP(self, doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> typing.MutableSequence[float]: ...
    def calcPhaseEnvelope(self) -> None: ...
    def calcRSWTOB(self) -> None: ...
    def displayResult(self) -> None: ...
    def extrapolateTable(self) -> None: ...
    def initCalc(self) -> None: ...
    def run(self) -> None: ...
    def setEnthalpyRange(self, double: float, double2: float, int: int) -> None: ...
    def setFileName(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def setPressureRange(self, double: float, double2: float, int: int) -> None: ...
    def writeOLGAinpFile(self, string: typing.Union[java.lang.String, str]) -> None: ...
    def writeOLGAinpFile2(self, string: typing.Union[java.lang.String, str]) -> None: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("jneqsim.neqsim.thermodynamicoperations.propertygenerator")``.

    OLGApropertyTableGenerator: typing.Type[OLGApropertyTableGenerator]
    OLGApropertyTableGeneratorKeywordFormat: typing.Type[OLGApropertyTableGeneratorKeywordFormat]
    OLGApropertyTableGeneratorWater: typing.Type[OLGApropertyTableGeneratorWater]
    OLGApropertyTableGeneratorWaterEven: typing.Type[OLGApropertyTableGeneratorWaterEven]
    OLGApropertyTableGeneratorWaterKeywordFormat: typing.Type[OLGApropertyTableGeneratorWaterKeywordFormat]
    OLGApropertyTableGeneratorWaterStudents: typing.Type[OLGApropertyTableGeneratorWaterStudents]
    OLGApropertyTableGeneratorWaterStudentsPH: typing.Type[OLGApropertyTableGeneratorWaterStudentsPH]
