kPROTOCOL_VERSION = 1

kWALLET_ADDR_SIZE = 33
kNODE_ADDR_SIZE = 49
kWALLET_ADDR_BUF_SIZE = kWALLET_ADDR_SIZE + 1
kNODE_ADDR_BUF_SIZE = kNODE_ADDR_SIZE + 1

kWALLET_SIG_SIZE = 73
kNODE_SIG_SIZE = 105
kWALLET_SIG_BUF_SIZE = kWALLET_SIG_SIZE + 1
kNODE_SIG_BUF_SIZE = kNODE_SIG_SIZE + 1

kUINT_SIZE = 1
kUINT32_SIZE = 4
kUINT64_SIZE = 8

kBLOCK_MIN_SIZE = 117  # TODO: this must be incorrect
kTX_MIN_SIZE = 150
kENVELOPE_SIZE = 34
kLEGACY_ENVELOPE_SIZE = 17
kSIGNER_LENGTH_OFFSET = 34
kMIN_PAYLOAD_SIZE = 8
kFLAGS_OFFSET = 24
kOPERATION_OFFSET = 25
kLEGACY_OPERATION_OFFSET = 16
kTIMESTAMP_OFFSET = 26

kTRANSFER_NONADDR_DATA_SIZE = kUINT64_SIZE * 3
kMERKLE_SIZE = 32
kPREV_HASH_SIZE = 32

kPEM_PREFIX = "-----BEGIN ENCRYPTED PRIVATE KEY-----\n"
kPEM_SUFFIX = "\n-----END ENCRYPTED PRIVATE KEY-----"
kPEM_PREFIX_SIZE = len(kPEM_PREFIX)
kPEM_SUFFIX_SIZE = len(kPEM_SUFFIX)

VALID_BLOCK_VERSIONS = [0, 1]


class OpType:
    CREATE = 0
    MODIFY = 1
    SEND = 2
    DELETE = 3
    REVERT = 4
    CONFIRM = 5
    SUMMARIZE = 6
    RECOVER = 7
    RESERVE = 8
    FREE = 9
    NUM_OPS = 10

    def get(self, op: str) -> int:
        try:
            return self.__getattribute__(op)
        except Exception:
            raise Exception(f"Invalid op string {op}")
