"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventNotify = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const events = require("@aws-cdk/aws-events");
const target = require("@aws-cdk/aws-events-targets");
const _lambda = require("@aws-cdk/aws-lambda");
const logs = require("@aws-cdk/aws-logs");
const cdk = require("@aws-cdk/core");
/**
 * Event Notfiy Construct Class.
 */
class EventNotify extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        if (!props?.lineNotifyToken && !props?.slack) {
            throw new Error('Please input lineNotifyToken or slack options');
        }
        const lambdaFun = new _lambda.Function(this, 'lambda_fun', {
            handler: 'linenotify.lambda_handler',
            code: _lambda.Code.fromAsset(path.join(__dirname, '../function')),
            runtime: _lambda.Runtime.PYTHON_3_8,
            timeout: cdk.Duration.minutes(3),
            logRetention: logs.RetentionDays.THREE_DAYS,
            environment: {
                LINE_NOTIFY_TOKEN: props?.lineNotifyToken ? props?.lineNotifyToken : 'none',
                SLACK_WEBHOOK_URL: props?.slack?.slackWebhookUrl ? props?.slack?.slackWebhookUrl : 'none',
                SLACK_CHANNEL_NAME: props?.slack?.slackChannelName ? props?.slack?.slackChannelName : 'none',
            },
        });
        const eventNotifyTarget = new target.LambdaFunction(lambdaFun);
        new events.Rule(this, 'EventBusConsoleLoginEvent', {
            ruleName: 'EventBusConsoleLoginEvent',
            description: 'Console login in specific region',
            targets: [eventNotifyTarget],
            eventPattern: {
                detailType: ['AWS Console Sign In via CloudTrail'],
            },
        });
    }
}
exports.EventNotify = EventNotify;
_a = JSII_RTTI_SYMBOL_1;
EventNotify[_a] = { fqn: "cdk-events-notify.EventNotify", version: "1.0.168" };
//# sourceMappingURL=data:application/json;base64,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