import pytest

from novita_sandbox.core import AsyncSandbox, SandboxQuery


@pytest.mark.skip_debug()
async def test_start(template):
    sbx = await AsyncSandbox.create(template, timeout=5)
    try:
        assert await sbx.is_running()
        assert sbx._envd_version is not None
    finally:
        await sbx.kill()


@pytest.mark.skip_debug()
async def test_metadata(template):
    sbx = await AsyncSandbox.create(
        template, timeout=5, metadata={"test-key": "test-value"}
    )

    try:
        paginator = AsyncSandbox.list(
            query=SandboxQuery(metadata={"test-key": "test-value"})
        )
        sandboxes = await paginator.next_items()

        for sbx_info in sandboxes:
            if sbx.sandbox_id == sbx_info.sandbox_id:
                assert sbx_info.metadata is not None
                assert sbx_info.metadata["test-key"] == "test-value"
                break
        else:
            assert False, "Sandbox not found"
    finally:
        await sbx.kill()
