/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag.next;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.nwdiag.next.NBar;
import net.sourceforge.plantuml.nwdiag.next.NStage;
import net.sourceforge.plantuml.nwdiag.next.NTetris;
import net.sourceforge.plantuml.nwdiag.next.Staged;

public class NBox
implements Staged {
    private final List<NBar> bars = new ArrayList<NBar>();
    private final NTetris<NBar> tetris = new NTetris();

    public void add(NBar bar) {
        if (this.bars.contains(bar)) {
            throw new IllegalStateException();
        }
        this.bars.add(bar);
        this.tetris.add(bar);
    }

    @Override
    public NStage getStart() {
        NStage result = this.bars.get(0).getStart();
        for (int i = 1; i < this.bars.size(); ++i) {
            result = NStage.getMin(result, this.bars.get(i).getStart());
        }
        return result;
    }

    @Override
    public NStage getEnd() {
        NStage result = this.bars.get(0).getEnd();
        for (int i = 1; i < this.bars.size(); ++i) {
            result = NStage.getMax(result, this.bars.get(i).getEnd());
        }
        return result;
    }

    @Override
    public int getNWidth() {
        return this.tetris.getNWidth();
    }

    public Map<NBar, Integer> getPositions() {
        return this.tetris.getPositions();
    }

    @Override
    public boolean contains(NStage stage) {
        return stage.compareTo(this.getStart()) >= 0 && stage.compareTo(this.getEnd()) <= 0;
    }
}

