/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.awt.geom.Dimension2D;
import java.math.BigDecimal;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingFormat;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.timingdiagram.graphic.IntricatedPoint;
import net.sourceforge.plantuml.timingdiagram.graphic.PlayerFrame;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class PlayerClock
extends Player {
    private final int period;
    private final int pulse;
    private final int offset;
    private final double ymargin = 8.0;
    private final boolean displayTitle;

    public PlayerClock(String title, ISkinParam skinParam, TimingRuler ruler, int period, int pulse, int offset, boolean compact) {
        super(title, skinParam, ruler, compact);
        this.displayTitle = title.length() > 0;
        this.period = period;
        this.pulse = pulse;
        this.offset = offset;
        this.suggestedHeight = 30;
    }

    @Override
    public double getFullHeight(StringBounder stringBounder) {
        return (double)this.suggestedHeight + this.getTitleHeight(stringBounder);
    }

    private double getLineHeight(StringBounder stringBounder) {
        return (double)this.suggestedHeight - 16.0;
    }

    private double getTitleHeight(StringBounder stringBounder) {
        if (this.displayTitle) {
            return this.getTitle().calculateDimension(stringBounder).getHeight();
        }
        return 0.0;
    }

    private SymbolContext getContext() {
        return new SymbolContext(HColorUtils.COL_D7E0F2, HColorUtils.COL_038048).withStroke(new UStroke(1.5));
    }

    @Override
    public IntricatedPoint getTimeProjection(StringBounder stringBounder, TimeTick tick) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addNote(TimeTick now, Display note, Position position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void defineState(String stateCode, String label) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setState(TimeTick now, String comment, Colors color, String ... states) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createConstraint(TimeTick tick1, TimeTick tick2, String message) {
        throw new UnsupportedOperationException();
    }

    private double getPulseCoef() {
        if (this.pulse == 0) {
            return 0.5;
        }
        return 1.0 * (double)this.pulse / (double)this.period;
    }

    private double getOffsetCoef() {
        return 1.0 * (double)this.offset / (double)this.period;
    }

    public final int getPeriod() {
        return this.period;
    }

    @Override
    public TextBlock getPart1(double fullAvailableWidth, double specialVSpace) {
        if (this.displayTitle) {
            return new AbstractTextBlock(){

                @Override
                public void drawU(UGraphic ug) {
                    new PlayerFrame(PlayerClock.this.getTitle()).drawFrameTitle(ug);
                }

                @Override
                public Dimension2D calculateDimension(StringBounder stringBounder) {
                    return PlayerClock.this.getTitle().calculateDimension(stringBounder);
                }
            };
        }
        return TextBlockUtils.empty(0.0, 0.0);
    }

    @Override
    public UDrawable getPart2() {
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                ug = PlayerClock.this.getContext().apply(ug);
                ug = ug.apply(UTranslate.dy(PlayerClock.this.getTitleHeight(ug.getStringBounder())));
                ULine vline = ULine.vline(PlayerClock.this.getLineHeight(ug.getStringBounder()));
                int i = 0;
                double lastx = -1.7976931348623157E308;
                while (i < 1000) {
                    double x = PlayerClock.this.ruler.getPosInPixel(new TimeTick(new BigDecimal(i * PlayerClock.this.period), TimingFormat.DECIMAL));
                    if (x > PlayerClock.this.ruler.getWidth()) {
                        return;
                    }
                    ++i;
                    if (x > lastx) {
                        double dx = x - lastx;
                        ULine hline1 = ULine.hline(dx * PlayerClock.this.getOffsetCoef());
                        ULine hline2 = ULine.hline(dx * PlayerClock.this.getPulseCoef());
                        ULine hline3 = ULine.hline(dx * (1.0 - PlayerClock.this.getPulseCoef() - PlayerClock.this.getOffsetCoef()));
                        double x2 = lastx + dx * PlayerClock.this.getOffsetCoef();
                        double x3 = lastx + dx * (PlayerClock.this.getOffsetCoef() + PlayerClock.this.getPulseCoef());
                        if (PlayerClock.this.offset > 0) {
                            ug.apply(new UTranslate(lastx, 8.0 + vline.getDY())).draw(hline1);
                        }
                        ug.apply(new UTranslate(x2, 8.0)).draw(hline2);
                        ug.apply(new UTranslate(x3, 8.0 + vline.getDY())).draw(hline3);
                        ug.apply(new UTranslate(x2, 8.0)).draw(vline);
                        ug.apply(new UTranslate(x3, 8.0)).draw(vline);
                    }
                    lastx = x;
                }
            }
        };
    }
}

