# This file was auto-generated by Fern from our API Definition.

import typing

import httpx

from ..environment import VellumEnvironment
from ..types.api_version_enum import ApiVersionEnum
from .http_client import AsyncHttpClient, HttpClient


class BaseClientWrapper:
    def __init__(
        self,
        *,
        api_version: typing.Optional[ApiVersionEnum] = None,
        api_key: str,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        environment: VellumEnvironment,
        timeout: typing.Optional[float] = None,
    ):
        self._api_version = api_version
        self.api_key = api_key
        self._headers = headers
        self._environment = environment
        self._timeout = timeout

    def get_headers(self) -> typing.Dict[str, str]:
        headers: typing.Dict[str, str] = {
            "User-Agent": "vellum-ai/1.8.4",
            "X-Fern-Language": "Python",
            "X-Fern-SDK-Name": "vellum-ai",
            "X-Fern-SDK-Version": "1.8.4",
            **(self.get_custom_headers() or {}),
        }
        if self._api_version is not None:
            headers["X-API-Version"] = self._api_version
        headers["X-API-KEY"] = self.api_key
        return headers

    def get_custom_headers(self) -> typing.Optional[typing.Dict[str, str]]:
        return self._headers

    def get_environment(self) -> VellumEnvironment:
        return self._environment

    def get_timeout(self) -> typing.Optional[float]:
        return self._timeout


class SyncClientWrapper(BaseClientWrapper):
    def __init__(
        self,
        *,
        api_version: typing.Optional[ApiVersionEnum] = None,
        api_key: str,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        environment: VellumEnvironment,
        timeout: typing.Optional[float] = None,
        httpx_client: httpx.Client,
    ):
        super().__init__(
            api_version=api_version, api_key=api_key, headers=headers, environment=environment, timeout=timeout
        )
        self.httpx_client = HttpClient(
            httpx_client=httpx_client, base_headers=self.get_headers, base_timeout=self.get_timeout
        )


class AsyncClientWrapper(BaseClientWrapper):
    def __init__(
        self,
        *,
        api_version: typing.Optional[ApiVersionEnum] = None,
        api_key: str,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        environment: VellumEnvironment,
        timeout: typing.Optional[float] = None,
        httpx_client: httpx.AsyncClient,
    ):
        super().__init__(
            api_version=api_version, api_key=api_key, headers=headers, environment=environment, timeout=timeout
        )
        self.httpx_client = AsyncHttpClient(
            httpx_client=httpx_client, base_headers=self.get_headers, base_timeout=self.get_timeout
        )
