# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...types.components_schemas_composio_tool_definition import ComponentsSchemasComposioToolDefinition
from ...types.paginated_slim_tool_definition_list import PaginatedSlimToolDefinitionList


class RawIntegrationProvidersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def retrieve_integration_provider_tool_definition(
        self,
        integration_name: str,
        integration_provider: str,
        tool_name: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ComponentsSchemasComposioToolDefinition]:
        """
        Retrieve a specific integration tool definition.

        Parameters
        ----------
        integration_name : str
            The integration name

        integration_provider : str
            The integration provider name

        tool_name : str
            The tool's unique name, as specified by the integration provider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ComponentsSchemasComposioToolDefinition]

        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/integration-providers/{jsonable_encoder(integration_provider)}/integrations/{jsonable_encoder(integration_name)}/tools/{jsonable_encoder(tool_name)}",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ComponentsSchemasComposioToolDefinition,
                    parse_obj_as(
                        type_=ComponentsSchemasComposioToolDefinition,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def list_integration_tools(
        self,
        integration_provider: str,
        *,
        important: typing.Optional[bool] = None,
        include_deprecated: typing.Optional[bool] = None,
        integration_name: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        search: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PaginatedSlimToolDefinitionList]:
        """
        List all integration tools for a given provider and integration.

        Parameters
        ----------
        integration_provider : str
            The integration provider name

        important : typing.Optional[bool]
            Whether to filter the tools by important

        include_deprecated : typing.Optional[bool]
            Whether to include deprecated tools

        integration_name : typing.Optional[str]
            The Vellum Integration name

        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        search : typing.Optional[str]
            The search term to filter the tools by

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PaginatedSlimToolDefinitionList]

        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/integration-providers/{jsonable_encoder(integration_provider)}/tools",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            params={
                "important": important,
                "include_deprecated": include_deprecated,
                "integration_name": integration_name,
                "limit": limit,
                "offset": offset,
                "search": search,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedSlimToolDefinitionList,
                    parse_obj_as(
                        type_=PaginatedSlimToolDefinitionList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawIntegrationProvidersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def retrieve_integration_provider_tool_definition(
        self,
        integration_name: str,
        integration_provider: str,
        tool_name: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ComponentsSchemasComposioToolDefinition]:
        """
        Retrieve a specific integration tool definition.

        Parameters
        ----------
        integration_name : str
            The integration name

        integration_provider : str
            The integration provider name

        tool_name : str
            The tool's unique name, as specified by the integration provider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ComponentsSchemasComposioToolDefinition]

        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/integration-providers/{jsonable_encoder(integration_provider)}/integrations/{jsonable_encoder(integration_name)}/tools/{jsonable_encoder(tool_name)}",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ComponentsSchemasComposioToolDefinition,
                    parse_obj_as(
                        type_=ComponentsSchemasComposioToolDefinition,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def list_integration_tools(
        self,
        integration_provider: str,
        *,
        important: typing.Optional[bool] = None,
        include_deprecated: typing.Optional[bool] = None,
        integration_name: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        search: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PaginatedSlimToolDefinitionList]:
        """
        List all integration tools for a given provider and integration.

        Parameters
        ----------
        integration_provider : str
            The integration provider name

        important : typing.Optional[bool]
            Whether to filter the tools by important

        include_deprecated : typing.Optional[bool]
            Whether to include deprecated tools

        integration_name : typing.Optional[str]
            The Vellum Integration name

        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        search : typing.Optional[str]
            The search term to filter the tools by

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PaginatedSlimToolDefinitionList]

        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/integration-providers/{jsonable_encoder(integration_provider)}/tools",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            params={
                "important": important,
                "include_deprecated": include_deprecated,
                "integration_name": integration_name,
                "limit": limit,
                "offset": offset,
                "search": search,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedSlimToolDefinitionList,
                    parse_obj_as(
                        type_=PaginatedSlimToolDefinitionList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
