# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.workflow_execution_detail import WorkflowExecutionDetail
from .raw_client import AsyncRawWorkflowExecutionsClient, RawWorkflowExecutionsClient


class WorkflowExecutionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWorkflowExecutionsClient(client_wrapper=client_wrapper)

    @property
    def _client_wrapper(self) -> SyncClientWrapper:
        return self._raw_client._client_wrapper

    @property
    def with_raw_response(self) -> RawWorkflowExecutionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWorkflowExecutionsClient
        """
        return self._raw_client

    def retrieve_workflow_execution_detail(
        self,
        execution_id: str,
        *,
        prev_span_id: typing.Optional[str] = None,
        span_limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowExecutionDetail:
        """
        Parameters
        ----------
        execution_id : str

        prev_span_id : typing.Optional[str]
            Optional keyset cursor span_id to continue from (exclusive)

        span_limit : typing.Optional[int]
            Maximum number of spans to return (for lazy loading)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowExecutionDetail


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.workflow_executions.retrieve_workflow_execution_detail(
            execution_id="execution_id",
        )
        """
        _response = self._raw_client.retrieve_workflow_execution_detail(
            execution_id, prev_span_id=prev_span_id, span_limit=span_limit, request_options=request_options
        )
        return _response.data


class AsyncWorkflowExecutionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWorkflowExecutionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawWorkflowExecutionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWorkflowExecutionsClient
        """
        return self._raw_client

    async def retrieve_workflow_execution_detail(
        self,
        execution_id: str,
        *,
        prev_span_id: typing.Optional[str] = None,
        span_limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowExecutionDetail:
        """
        Parameters
        ----------
        execution_id : str

        prev_span_id : typing.Optional[str]
            Optional keyset cursor span_id to continue from (exclusive)

        span_limit : typing.Optional[int]
            Maximum number of spans to return (for lazy loading)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowExecutionDetail


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflow_executions.retrieve_workflow_execution_detail(
                execution_id="execution_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve_workflow_execution_detail(
            execution_id, prev_span_id=prev_span_id, span_limit=span_limit, request_options=request_options
        )
        return _response.data
