# This file was auto-generated by Fern from our API Definition.

import contextlib
import typing
from json.decoder import JSONDecodeError

from ... import core
from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...errors.bad_request_error import BadRequestError
from ...types.dataset_row_push_request import DatasetRowPushRequest
from ...types.workflow_push_deployment_config_request import WorkflowPushDeploymentConfigRequest
from ...types.workflow_push_exec_config import WorkflowPushExecConfig
from ...types.workflow_push_response import WorkflowPushResponse
from ...types.workflow_resolved_state import WorkflowResolvedState

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawWorkflowsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    @contextlib.contextmanager
    def pull(
        self,
        id: str,
        *,
        exclude_code: typing.Optional[bool] = None,
        exclude_display: typing.Optional[bool] = None,
        include_json: typing.Optional[bool] = None,
        include_sandbox: typing.Optional[bool] = None,
        release_tag: typing.Optional[str] = None,
        strict: typing.Optional[bool] = None,
        version: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[HttpResponse[typing.Iterator[bytes]]]:
        """
        Parameters
        ----------
        id : str
            The ID of the Workflow to pull from

        exclude_code : typing.Optional[bool]

        exclude_display : typing.Optional[bool]

        include_json : typing.Optional[bool]

        include_sandbox : typing.Optional[bool]

        release_tag : typing.Optional[str]
            Release tag to use when pulling from deployment (implies deployment-only lookup)

        strict : typing.Optional[bool]

        version : typing.Optional[str]
            Semantic version range to validate against the Workflow SDK version (e.g., '>=1.0.0,<1.2.3')

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[HttpResponse[typing.Iterator[bytes]]]

        """
        with self._client_wrapper.httpx_client.stream(
            f"v1/workflows/{jsonable_encoder(id)}/pull",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            params={
                "exclude_code": exclude_code,
                "exclude_display": exclude_display,
                "include_json": include_json,
                "include_sandbox": include_sandbox,
                "release_tag": release_tag,
                "strict": strict,
                "version": version,
            },
            request_options=request_options,
        ) as _response:

            def _stream() -> HttpResponse[typing.Iterator[bytes]]:
                try:
                    if 200 <= _response.status_code < 300:
                        _chunk_size = request_options.get("chunk_size", None) if request_options is not None else None
                        return HttpResponse(
                            response=_response, data=(_chunk for _chunk in _response.iter_bytes(chunk_size=_chunk_size))
                        )
                    _response.read()
                    if _response.status_code == 400:
                        raise BadRequestError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                typing.Optional[typing.Any],
                                parse_obj_as(
                                    type_=typing.Optional[typing.Any],  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield _stream()

    def retrieve_state(
        self, span_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[WorkflowResolvedState]:
        """
        Retrieve the current state of a workflow execution.

        **Note:** Uses a base url of `https://predict.vellum.ai`.

        Parameters
        ----------
        span_id : str
            The span ID of the workflow execution to retrieve state for

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[WorkflowResolvedState]

        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/workflows/{jsonable_encoder(span_id)}/state",
            base_url=self._client_wrapper.get_environment().predict,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WorkflowResolvedState,
                    parse_obj_as(
                        type_=WorkflowResolvedState,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def push(
        self,
        *,
        exec_config: WorkflowPushExecConfig,
        workflow_sandbox_id: typing.Optional[str] = OMIT,
        deployment_config: typing.Optional[WorkflowPushDeploymentConfigRequest] = OMIT,
        artifact: typing.Optional[core.File] = OMIT,
        dataset: typing.Optional[typing.List[DatasetRowPushRequest]] = OMIT,
        dry_run: typing.Optional[bool] = OMIT,
        strict: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[WorkflowPushResponse]:
        """
        Parameters
        ----------
        exec_config : WorkflowPushExecConfig
            The execution configuration of the workflow.

        workflow_sandbox_id : typing.Optional[str]

        deployment_config : typing.Optional[WorkflowPushDeploymentConfigRequest]

        artifact : typing.Optional[core.File]
            See core.File for more documentation

        dataset : typing.Optional[typing.List[DatasetRowPushRequest]]
            List of dataset rows with inputs for scenarios.

        dry_run : typing.Optional[bool]

        strict : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[WorkflowPushResponse]

        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/workflows/push",
            base_url=self._client_wrapper.get_environment().default,
            method="POST",
            data={
                "exec_config": exec_config,
                "workflow_sandbox_id": workflow_sandbox_id,
                "deployment_config": deployment_config,
                "dataset": dataset,
                "dry_run": dry_run,
                "strict": strict,
            },
            files={
                **({"artifact": artifact} if artifact is not None else {}),
            },
            request_options=request_options,
            omit=OMIT,
            force_multipart=True,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WorkflowPushResponse,
                    parse_obj_as(
                        type_=WorkflowPushResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def serialize_workflow_files(
        self,
        *,
        files: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.Dict[str, typing.Optional[typing.Any]]]:
        """
        Serialize files

        Parameters
        ----------
        files : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Dict[str, typing.Optional[typing.Any]]]

        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/workflows/serialize",
            base_url=self._client_wrapper.get_environment().default,
            method="POST",
            json={
                "files": files,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Dict[str, typing.Optional[typing.Any]],
                    parse_obj_as(
                        type_=typing.Dict[str, typing.Optional[typing.Any]],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawWorkflowsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    @contextlib.asynccontextmanager
    async def pull(
        self,
        id: str,
        *,
        exclude_code: typing.Optional[bool] = None,
        exclude_display: typing.Optional[bool] = None,
        include_json: typing.Optional[bool] = None,
        include_sandbox: typing.Optional[bool] = None,
        release_tag: typing.Optional[str] = None,
        strict: typing.Optional[bool] = None,
        version: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[bytes]]]:
        """
        Parameters
        ----------
        id : str
            The ID of the Workflow to pull from

        exclude_code : typing.Optional[bool]

        exclude_display : typing.Optional[bool]

        include_json : typing.Optional[bool]

        include_sandbox : typing.Optional[bool]

        release_tag : typing.Optional[str]
            Release tag to use when pulling from deployment (implies deployment-only lookup)

        strict : typing.Optional[bool]

        version : typing.Optional[str]
            Semantic version range to validate against the Workflow SDK version (e.g., '>=1.0.0,<1.2.3')

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[bytes]]]

        """
        async with self._client_wrapper.httpx_client.stream(
            f"v1/workflows/{jsonable_encoder(id)}/pull",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            params={
                "exclude_code": exclude_code,
                "exclude_display": exclude_display,
                "include_json": include_json,
                "include_sandbox": include_sandbox,
                "release_tag": release_tag,
                "strict": strict,
                "version": version,
            },
            request_options=request_options,
        ) as _response:

            async def _stream() -> AsyncHttpResponse[typing.AsyncIterator[bytes]]:
                try:
                    if 200 <= _response.status_code < 300:
                        _chunk_size = request_options.get("chunk_size", None) if request_options is not None else None
                        return AsyncHttpResponse(
                            response=_response,
                            data=(_chunk async for _chunk in _response.aiter_bytes(chunk_size=_chunk_size)),
                        )
                    await _response.aread()
                    if _response.status_code == 400:
                        raise BadRequestError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                typing.Optional[typing.Any],
                                parse_obj_as(
                                    type_=typing.Optional[typing.Any],  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield await _stream()

    async def retrieve_state(
        self, span_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[WorkflowResolvedState]:
        """
        Retrieve the current state of a workflow execution.

        **Note:** Uses a base url of `https://predict.vellum.ai`.

        Parameters
        ----------
        span_id : str
            The span ID of the workflow execution to retrieve state for

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[WorkflowResolvedState]

        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/workflows/{jsonable_encoder(span_id)}/state",
            base_url=self._client_wrapper.get_environment().predict,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WorkflowResolvedState,
                    parse_obj_as(
                        type_=WorkflowResolvedState,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def push(
        self,
        *,
        exec_config: WorkflowPushExecConfig,
        workflow_sandbox_id: typing.Optional[str] = OMIT,
        deployment_config: typing.Optional[WorkflowPushDeploymentConfigRequest] = OMIT,
        artifact: typing.Optional[core.File] = OMIT,
        dataset: typing.Optional[typing.List[DatasetRowPushRequest]] = OMIT,
        dry_run: typing.Optional[bool] = OMIT,
        strict: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[WorkflowPushResponse]:
        """
        Parameters
        ----------
        exec_config : WorkflowPushExecConfig
            The execution configuration of the workflow.

        workflow_sandbox_id : typing.Optional[str]

        deployment_config : typing.Optional[WorkflowPushDeploymentConfigRequest]

        artifact : typing.Optional[core.File]
            See core.File for more documentation

        dataset : typing.Optional[typing.List[DatasetRowPushRequest]]
            List of dataset rows with inputs for scenarios.

        dry_run : typing.Optional[bool]

        strict : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[WorkflowPushResponse]

        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/workflows/push",
            base_url=self._client_wrapper.get_environment().default,
            method="POST",
            data={
                "exec_config": exec_config,
                "workflow_sandbox_id": workflow_sandbox_id,
                "deployment_config": deployment_config,
                "dataset": dataset,
                "dry_run": dry_run,
                "strict": strict,
            },
            files={
                **({"artifact": artifact} if artifact is not None else {}),
            },
            request_options=request_options,
            omit=OMIT,
            force_multipart=True,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WorkflowPushResponse,
                    parse_obj_as(
                        type_=WorkflowPushResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def serialize_workflow_files(
        self,
        *,
        files: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.Dict[str, typing.Optional[typing.Any]]]:
        """
        Serialize files

        Parameters
        ----------
        files : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Dict[str, typing.Optional[typing.Any]]]

        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/workflows/serialize",
            base_url=self._client_wrapper.get_environment().default,
            method="POST",
            json={
                "files": files,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Dict[str, typing.Optional[typing.Any]],
                    parse_obj_as(
                        type_=typing.Dict[str, typing.Optional[typing.Any]],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
