# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.workspace_secret_read import WorkspaceSecretRead
from .raw_client import AsyncRawWorkspaceSecretsClient, RawWorkspaceSecretsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class WorkspaceSecretsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWorkspaceSecretsClient(client_wrapper=client_wrapper)

    @property
    def _client_wrapper(self) -> SyncClientWrapper:
        return self._raw_client._client_wrapper

    @property
    def with_raw_response(self) -> RawWorkspaceSecretsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWorkspaceSecretsClient
        """
        return self._raw_client

    def retrieve(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> WorkspaceSecretRead:
        """
        Used to retrieve a Workspace Secret given its ID or name.

        Parameters
        ----------
        id : str
            Either the Workspace Secret's ID or its unique name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkspaceSecretRead


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.workspace_secrets.retrieve(
            id="id",
        )
        """
        _response = self._raw_client.retrieve(id, request_options=request_options)
        return _response.data

    def partial_update(
        self,
        id: str,
        *,
        label: typing.Optional[str] = OMIT,
        value: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkspaceSecretRead:
        """
        Used to update a Workspace Secret given its ID or name.

        Parameters
        ----------
        id : str
            Either the Workspace Secret's ID or its unique name

        label : typing.Optional[str]

        value : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkspaceSecretRead


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.workspace_secrets.partial_update(
            id="id",
        )
        """
        _response = self._raw_client.partial_update(id, label=label, value=value, request_options=request_options)
        return _response.data


class AsyncWorkspaceSecretsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWorkspaceSecretsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawWorkspaceSecretsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWorkspaceSecretsClient
        """
        return self._raw_client

    async def retrieve(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkspaceSecretRead:
        """
        Used to retrieve a Workspace Secret given its ID or name.

        Parameters
        ----------
        id : str
            Either the Workspace Secret's ID or its unique name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkspaceSecretRead


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workspace_secrets.retrieve(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(id, request_options=request_options)
        return _response.data

    async def partial_update(
        self,
        id: str,
        *,
        label: typing.Optional[str] = OMIT,
        value: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkspaceSecretRead:
        """
        Used to update a Workspace Secret given its ID or name.

        Parameters
        ----------
        id : str
            Either the Workspace Secret's ID or its unique name

        label : typing.Optional[str]

        value : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkspaceSecretRead


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workspace_secrets.partial_update(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.partial_update(id, label=label, value=value, request_options=request_options)
        return _response.data
