# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from .vellum_variable import VellumVariable


class WorkflowDeploymentHistoryItem(UniversalBaseModel):
    id: str
    workflow_deployment_id: str
    timestamp: dt.datetime
    label: str = pydantic.Field()
    """
    A human-readable label for the workflow deployment
    """

    name: str = pydantic.Field()
    """
    A name that uniquely identifies this workflow deployment within its workspace
    """

    input_variables: typing.List[VellumVariable]
    output_variables: typing.List[VellumVariable]
    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    A human-readable description of the workflow deployment
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .array_vellum_value import ArrayVellumValue  # noqa: E402, F401, I001

update_forward_refs(WorkflowDeploymentHistoryItem)
