import os, re
from agentmake import PACKAGE_PATH, AGENTMAKE_USER_DIR, readTextFile
from pathlib import Path

# set up user_directory for customisation
user_directory = os.path.join(AGENTMAKE_USER_DIR, "biblemate")
Path(user_directory).mkdir(parents=True, exist_ok=True)

def get_system_progress(original_request: str, master_plan: str) -> str:
    """
    create system prompt for checking the progress
    """
    possible_system_file_path_2 = os.path.join(PACKAGE_PATH, "systems", "biblemate", "supervisor.md")
    possible_system_file_path_1 = os.path.join(AGENTMAKE_USER_DIR, "systems", "biblemate", "supervisor.md")
    system_progress = readTextFile(possible_system_file_path_2 if os.path.isfile(possible_system_file_path_2) else possible_system_file_path_1).format(original_request=original_request, master_plan=master_plan)
    if not "Preliminary Action Plan" in master_plan: # custom mcp prompts
        system_progress = system_progress.replace("\n# Master Plan", "\n# Preliminary Action Plan")
    return system_progress

def get_system_make_suggestion(original_request: str, master_plan: str) -> str:
    """
    create system prompt for makding suggestion
    """
    action_plan = re.sub("[# ]*?Measurable Outcome.*?$", "", master_plan, flags=re.DOTALL)
    action_plan = re.sub("[# ]*?Preliminary Action Plan", "", action_plan)
    possible_system_file_path_2 = os.path.join(PACKAGE_PATH, "systems", "biblemate", "make_suggestions.md")
    possible_system_file_path_1 = os.path.join(AGENTMAKE_USER_DIR, "systems", "biblemate", "make_suggestions.md")
    return readTextFile(possible_system_file_path_2 if os.path.isfile(possible_system_file_path_2) else possible_system_file_path_1).format(action_plan=action_plan)

def get_system_tool_instruction(tool: str, tool_description: str = "") -> str:
    """
    create system prompt for tool instruction
    """
    possible_system_file_path_2 = os.path.join(PACKAGE_PATH, "systems", "biblemate", "tool_instruction.md")
    possible_system_file_path_1 = os.path.join(AGENTMAKE_USER_DIR, "systems", "biblemate", "tool_instruction.md")
    return readTextFile(possible_system_file_path_2 if os.path.isfile(possible_system_file_path_2) else possible_system_file_path_1).format(tool=tool, tool_description=tool_description)

def get_system_tool_selection(available_tools: list, tool_descriptions: str) -> str:
    """
    create system prompt for tool selection
    """
    possible_system_file_path_2 = os.path.join(PACKAGE_PATH, "systems", "biblemate", "tool_selection.md")
    possible_system_file_path_1 = os.path.join(AGENTMAKE_USER_DIR, "systems", "biblemate", "tool_selection.md")
    return readTextFile(possible_system_file_path_2 if os.path.isfile(possible_system_file_path_2) else possible_system_file_path_1).format(available_tools=available_tools, tool_descriptions=tool_descriptions)
