# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AgTokenArgs', 'AgToken']

@pulumi.input_type
class AgTokenArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 expiration_date: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 seed: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a AgToken resource.
        :param pulumi.Input[builtins.str] type: The type of the ActiveGate for which the token is valid. Possible values are `ENVIRONMENT` or `CLUSTER`
        :param pulumi.Input[builtins.str] expiration_date: The expiration date of the token. You can use one of the following formats: * Timestamp in UTC milliseconds. *
               Human-readable format of 2021-01-25T05:57:01.123+01:00. If no time zone is specified, UTC is used. You can use a space
               character instead of the T. Seconds and fractions of a second are optional. * Relative timeframe, back from now. The
               format is now-NU/A, where N is the amount of time, U is the unit of time, and A is an alignment. The alignment rounds
               all the smaller values to the nearest zero in the past. For example, now-1y/w is one year back, aligned by a week. You
               can also specify relative timeframe without an alignment: now-NU. Supported time units for the relative timeframe are: -
               m: minutes - h: hours - d: days - w: weeks - M: months - y: years
        :param pulumi.Input[builtins.str] name: The name of the token.
        :param pulumi.Input[builtins.bool] seed: The token is a seed token (true) or an individual token (false). We recommend the individual token option (false)
        """
        pulumi.set(__self__, "type", type)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if seed is not None:
            pulumi.set(__self__, "seed", seed)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of the ActiveGate for which the token is valid. Possible values are `ENVIRONMENT` or `CLUSTER`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The expiration date of the token. You can use one of the following formats: * Timestamp in UTC milliseconds. *
        Human-readable format of 2021-01-25T05:57:01.123+01:00. If no time zone is specified, UTC is used. You can use a space
        character instead of the T. Seconds and fractions of a second are optional. * Relative timeframe, back from now. The
        format is now-NU/A, where N is the amount of time, U is the unit of time, and A is an alignment. The alignment rounds
        all the smaller values to the nearest zero in the past. For example, now-1y/w is one year back, aligned by a week. You
        can also specify relative timeframe without an alignment: now-NU. Supported time units for the relative timeframe are: -
        m: minutes - h: hours - d: days - w: weeks - M: months - y: years
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the token.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def seed(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The token is a seed token (true) or an individual token (false). We recommend the individual token option (false)
        """
        return pulumi.get(self, "seed")

    @seed.setter
    def seed(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "seed", value)


@pulumi.input_type
class _AgTokenState:
    def __init__(__self__, *,
                 expiration_date: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 seed: Optional[pulumi.Input[builtins.bool]] = None,
                 tenant_token: Optional[pulumi.Input[builtins.str]] = None,
                 token: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AgToken resources.
        :param pulumi.Input[builtins.str] expiration_date: The expiration date of the token. You can use one of the following formats: * Timestamp in UTC milliseconds. *
               Human-readable format of 2021-01-25T05:57:01.123+01:00. If no time zone is specified, UTC is used. You can use a space
               character instead of the T. Seconds and fractions of a second are optional. * Relative timeframe, back from now. The
               format is now-NU/A, where N is the amount of time, U is the unit of time, and A is an alignment. The alignment rounds
               all the smaller values to the nearest zero in the past. For example, now-1y/w is one year back, aligned by a week. You
               can also specify relative timeframe without an alignment: now-NU. Supported time units for the relative timeframe are: -
               m: minutes - h: hours - d: days - w: weeks - M: months - y: years
        :param pulumi.Input[builtins.str] name: The name of the token.
        :param pulumi.Input[builtins.bool] seed: The token is a seed token (true) or an individual token (false). We recommend the individual token option (false)
        :param pulumi.Input[builtins.str] tenant_token: The tenant token. This information isn't directly related to the Active Gate Token. It's included for convenience. You
               require the permission `InstallerDownload` for that attribute to get populated
        :param pulumi.Input[builtins.str] token: The secret of the token.
        :param pulumi.Input[builtins.str] type: The type of the ActiveGate for which the token is valid. Possible values are `ENVIRONMENT` or `CLUSTER`
        """
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if seed is not None:
            pulumi.set(__self__, "seed", seed)
        if tenant_token is not None:
            pulumi.set(__self__, "tenant_token", tenant_token)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The expiration date of the token. You can use one of the following formats: * Timestamp in UTC milliseconds. *
        Human-readable format of 2021-01-25T05:57:01.123+01:00. If no time zone is specified, UTC is used. You can use a space
        character instead of the T. Seconds and fractions of a second are optional. * Relative timeframe, back from now. The
        format is now-NU/A, where N is the amount of time, U is the unit of time, and A is an alignment. The alignment rounds
        all the smaller values to the nearest zero in the past. For example, now-1y/w is one year back, aligned by a week. You
        can also specify relative timeframe without an alignment: now-NU. Supported time units for the relative timeframe are: -
        m: minutes - h: hours - d: days - w: weeks - M: months - y: years
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the token.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def seed(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The token is a seed token (true) or an individual token (false). We recommend the individual token option (false)
        """
        return pulumi.get(self, "seed")

    @seed.setter
    def seed(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "seed", value)

    @property
    @pulumi.getter(name="tenantToken")
    def tenant_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The tenant token. This information isn't directly related to the Active Gate Token. It's included for convenience. You
        require the permission `InstallerDownload` for that attribute to get populated
        """
        return pulumi.get(self, "tenant_token")

    @tenant_token.setter
    def tenant_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_token", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The secret of the token.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the ActiveGate for which the token is valid. Possible values are `ENVIRONMENT` or `CLUSTER`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("dynatrace:index/agToken:AgToken")
class AgToken(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expiration_date: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 seed: Optional[pulumi.Input[builtins.bool]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a AgToken resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] expiration_date: The expiration date of the token. You can use one of the following formats: * Timestamp in UTC milliseconds. *
               Human-readable format of 2021-01-25T05:57:01.123+01:00. If no time zone is specified, UTC is used. You can use a space
               character instead of the T. Seconds and fractions of a second are optional. * Relative timeframe, back from now. The
               format is now-NU/A, where N is the amount of time, U is the unit of time, and A is an alignment. The alignment rounds
               all the smaller values to the nearest zero in the past. For example, now-1y/w is one year back, aligned by a week. You
               can also specify relative timeframe without an alignment: now-NU. Supported time units for the relative timeframe are: -
               m: minutes - h: hours - d: days - w: weeks - M: months - y: years
        :param pulumi.Input[builtins.str] name: The name of the token.
        :param pulumi.Input[builtins.bool] seed: The token is a seed token (true) or an individual token (false). We recommend the individual token option (false)
        :param pulumi.Input[builtins.str] type: The type of the ActiveGate for which the token is valid. Possible values are `ENVIRONMENT` or `CLUSTER`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AgTokenArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AgToken resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AgTokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgTokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expiration_date: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 seed: Optional[pulumi.Input[builtins.bool]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgTokenArgs.__new__(AgTokenArgs)

            __props__.__dict__["expiration_date"] = expiration_date
            __props__.__dict__["name"] = name
            __props__.__dict__["seed"] = seed
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["tenant_token"] = None
            __props__.__dict__["token"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["tenantToken", "token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AgToken, __self__).__init__(
            'dynatrace:index/agToken:AgToken',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            expiration_date: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            seed: Optional[pulumi.Input[builtins.bool]] = None,
            tenant_token: Optional[pulumi.Input[builtins.str]] = None,
            token: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'AgToken':
        """
        Get an existing AgToken resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] expiration_date: The expiration date of the token. You can use one of the following formats: * Timestamp in UTC milliseconds. *
               Human-readable format of 2021-01-25T05:57:01.123+01:00. If no time zone is specified, UTC is used. You can use a space
               character instead of the T. Seconds and fractions of a second are optional. * Relative timeframe, back from now. The
               format is now-NU/A, where N is the amount of time, U is the unit of time, and A is an alignment. The alignment rounds
               all the smaller values to the nearest zero in the past. For example, now-1y/w is one year back, aligned by a week. You
               can also specify relative timeframe without an alignment: now-NU. Supported time units for the relative timeframe are: -
               m: minutes - h: hours - d: days - w: weeks - M: months - y: years
        :param pulumi.Input[builtins.str] name: The name of the token.
        :param pulumi.Input[builtins.bool] seed: The token is a seed token (true) or an individual token (false). We recommend the individual token option (false)
        :param pulumi.Input[builtins.str] tenant_token: The tenant token. This information isn't directly related to the Active Gate Token. It's included for convenience. You
               require the permission `InstallerDownload` for that attribute to get populated
        :param pulumi.Input[builtins.str] token: The secret of the token.
        :param pulumi.Input[builtins.str] type: The type of the ActiveGate for which the token is valid. Possible values are `ENVIRONMENT` or `CLUSTER`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AgTokenState.__new__(_AgTokenState)

        __props__.__dict__["expiration_date"] = expiration_date
        __props__.__dict__["name"] = name
        __props__.__dict__["seed"] = seed
        __props__.__dict__["tenant_token"] = tenant_token
        __props__.__dict__["token"] = token
        __props__.__dict__["type"] = type
        return AgToken(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The expiration date of the token. You can use one of the following formats: * Timestamp in UTC milliseconds. *
        Human-readable format of 2021-01-25T05:57:01.123+01:00. If no time zone is specified, UTC is used. You can use a space
        character instead of the T. Seconds and fractions of a second are optional. * Relative timeframe, back from now. The
        format is now-NU/A, where N is the amount of time, U is the unit of time, and A is an alignment. The alignment rounds
        all the smaller values to the nearest zero in the past. For example, now-1y/w is one year back, aligned by a week. You
        can also specify relative timeframe without an alignment: now-NU. Supported time units for the relative timeframe are: -
        m: minutes - h: hours - d: days - w: weeks - M: months - y: years
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the token.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def seed(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        The token is a seed token (true) or an individual token (false). We recommend the individual token option (false)
        """
        return pulumi.get(self, "seed")

    @property
    @pulumi.getter(name="tenantToken")
    def tenant_token(self) -> pulumi.Output[builtins.str]:
        """
        The tenant token. This information isn't directly related to the Active Gate Token. It's included for convenience. You
        require the permission `InstallerDownload` for that attribute to get populated
        """
        return pulumi.get(self, "tenant_token")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[builtins.str]:
        """
        The secret of the token.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The type of the ActiveGate for which the token is valid. Possible values are `ENVIRONMENT` or `CLUSTER`
        """
        return pulumi.get(self, "type")

