# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlertingProfileArgs', 'AlertingProfile']

@pulumi.input_type
class AlertingProfileArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 event_type_filters: Optional[pulumi.Input[Sequence[pulumi.Input['AlertingProfileEventTypeFilterArgs']]]] = None,
                 metadata: Optional[pulumi.Input['AlertingProfileMetadataArgs']] = None,
                 mz_id: Optional[pulumi.Input[builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['AlertingProfileRuleArgs']]]] = None,
                 unknowns: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AlertingProfile resource.
        :param pulumi.Input[builtins.str] display_name: The name of the alerting profile, displayed in the UI
        :param pulumi.Input[Sequence[pulumi.Input['AlertingProfileEventTypeFilterArgs']]] event_type_filters: The list of event filters.  For all filters that are *negated* inside of these event filters, that is all `Predefined` as well as `Custom` (Title and/or Description) ones the AND logic applies. For all *non-negated* ones the OR logic applies. Between these two groups, negated and non-negated, the AND logic applies.  If you specify both severity rule and event filter, the AND logic applies
        :param pulumi.Input['AlertingProfileMetadataArgs'] metadata: `metadata` exists for backwards compatibility but shouldn't get specified anymore
        :param pulumi.Input[builtins.str] mz_id: The ID of the management zone to which the alerting profile applies
        :param pulumi.Input[Sequence[pulumi.Input['AlertingProfileRuleArgs']]] rules: A list of rules for management zone usage.  Each rule is evaluated independently of all other rules
        :param pulumi.Input[builtins.str] unknowns: allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        pulumi.set(__self__, "display_name", display_name)
        if event_type_filters is not None:
            pulumi.set(__self__, "event_type_filters", event_type_filters)
        if metadata is not None:
            warnings.warn("""`metadata` exists for backwards compatibility but shouldn't get specified anymore""", DeprecationWarning)
            pulumi.log.warn("""metadata is deprecated: `metadata` exists for backwards compatibility but shouldn't get specified anymore""")
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if mz_id is not None:
            pulumi.set(__self__, "mz_id", mz_id)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if unknowns is not None:
            pulumi.set(__self__, "unknowns", unknowns)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the alerting profile, displayed in the UI
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="eventTypeFilters")
    def event_type_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertingProfileEventTypeFilterArgs']]]]:
        """
        The list of event filters.  For all filters that are *negated* inside of these event filters, that is all `Predefined` as well as `Custom` (Title and/or Description) ones the AND logic applies. For all *non-negated* ones the OR logic applies. Between these two groups, negated and non-negated, the AND logic applies.  If you specify both severity rule and event filter, the AND logic applies
        """
        return pulumi.get(self, "event_type_filters")

    @event_type_filters.setter
    def event_type_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertingProfileEventTypeFilterArgs']]]]):
        pulumi.set(self, "event_type_filters", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""`metadata` exists for backwards compatibility but shouldn't get specified anymore""")
    def metadata(self) -> Optional[pulumi.Input['AlertingProfileMetadataArgs']]:
        """
        `metadata` exists for backwards compatibility but shouldn't get specified anymore
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['AlertingProfileMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="mzId")
    def mz_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the management zone to which the alerting profile applies
        """
        return pulumi.get(self, "mz_id")

    @mz_id.setter
    def mz_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mz_id", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertingProfileRuleArgs']]]]:
        """
        A list of rules for management zone usage.  Each rule is evaluated independently of all other rules
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertingProfileRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def unknowns(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        return pulumi.get(self, "unknowns")

    @unknowns.setter
    def unknowns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "unknowns", value)


@pulumi.input_type
class _AlertingProfileState:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 event_type_filters: Optional[pulumi.Input[Sequence[pulumi.Input['AlertingProfileEventTypeFilterArgs']]]] = None,
                 metadata: Optional[pulumi.Input['AlertingProfileMetadataArgs']] = None,
                 mz_id: Optional[pulumi.Input[builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['AlertingProfileRuleArgs']]]] = None,
                 unknowns: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AlertingProfile resources.
        :param pulumi.Input[builtins.str] display_name: The name of the alerting profile, displayed in the UI
        :param pulumi.Input[Sequence[pulumi.Input['AlertingProfileEventTypeFilterArgs']]] event_type_filters: The list of event filters.  For all filters that are *negated* inside of these event filters, that is all `Predefined` as well as `Custom` (Title and/or Description) ones the AND logic applies. For all *non-negated* ones the OR logic applies. Between these two groups, negated and non-negated, the AND logic applies.  If you specify both severity rule and event filter, the AND logic applies
        :param pulumi.Input['AlertingProfileMetadataArgs'] metadata: `metadata` exists for backwards compatibility but shouldn't get specified anymore
        :param pulumi.Input[builtins.str] mz_id: The ID of the management zone to which the alerting profile applies
        :param pulumi.Input[Sequence[pulumi.Input['AlertingProfileRuleArgs']]] rules: A list of rules for management zone usage.  Each rule is evaluated independently of all other rules
        :param pulumi.Input[builtins.str] unknowns: allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if event_type_filters is not None:
            pulumi.set(__self__, "event_type_filters", event_type_filters)
        if metadata is not None:
            warnings.warn("""`metadata` exists for backwards compatibility but shouldn't get specified anymore""", DeprecationWarning)
            pulumi.log.warn("""metadata is deprecated: `metadata` exists for backwards compatibility but shouldn't get specified anymore""")
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if mz_id is not None:
            pulumi.set(__self__, "mz_id", mz_id)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if unknowns is not None:
            pulumi.set(__self__, "unknowns", unknowns)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the alerting profile, displayed in the UI
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="eventTypeFilters")
    def event_type_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertingProfileEventTypeFilterArgs']]]]:
        """
        The list of event filters.  For all filters that are *negated* inside of these event filters, that is all `Predefined` as well as `Custom` (Title and/or Description) ones the AND logic applies. For all *non-negated* ones the OR logic applies. Between these two groups, negated and non-negated, the AND logic applies.  If you specify both severity rule and event filter, the AND logic applies
        """
        return pulumi.get(self, "event_type_filters")

    @event_type_filters.setter
    def event_type_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertingProfileEventTypeFilterArgs']]]]):
        pulumi.set(self, "event_type_filters", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""`metadata` exists for backwards compatibility but shouldn't get specified anymore""")
    def metadata(self) -> Optional[pulumi.Input['AlertingProfileMetadataArgs']]:
        """
        `metadata` exists for backwards compatibility but shouldn't get specified anymore
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['AlertingProfileMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="mzId")
    def mz_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the management zone to which the alerting profile applies
        """
        return pulumi.get(self, "mz_id")

    @mz_id.setter
    def mz_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mz_id", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertingProfileRuleArgs']]]]:
        """
        A list of rules for management zone usage.  Each rule is evaluated independently of all other rules
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertingProfileRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def unknowns(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        return pulumi.get(self, "unknowns")

    @unknowns.setter
    def unknowns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "unknowns", value)


@pulumi.type_token("dynatrace:index/alertingProfile:AlertingProfile")
class AlertingProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 event_type_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertingProfileEventTypeFilterArgs', 'AlertingProfileEventTypeFilterArgsDict']]]]] = None,
                 metadata: Optional[pulumi.Input[Union['AlertingProfileMetadataArgs', 'AlertingProfileMetadataArgsDict']]] = None,
                 mz_id: Optional[pulumi.Input[builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertingProfileRuleArgs', 'AlertingProfileRuleArgsDict']]]]] = None,
                 unknowns: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        !> This resource API endpoint has been deprecated, please use Alerting instead.

        > This resource requires the API token scopes **Read configuration** (`ReadConfig`) and **Write configuration** (`WriteConfig`)

        ## Dynatrace Documentation

        - Alerting profiles - https://www.dynatrace.com/support/help/how-to-use-dynatrace/problem-detection-and-analysis/notifications-and-alerting/alerting-profiles

        - Alerting profiles API - https://www.dynatrace.com/support/help/dynatrace-api/configuration-api/alerting-profiles-api

        ## Resource Example Usage

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        _name_ = dynatrace.AlertingProfile("#name#",
            display_name="#name#",
            mz_id="",
            rules=[
                {
                    "delay_in_minutes": 0,
                    "severity_level": "AVAILABILITY",
                    "tag_filters": [{
                        "include_mode": "INCLUDE_ALL",
                        "tag_filters": [
                            {
                                "context": "CONTEXTLESS",
                                "key": "EnvironmentA",
                                "value": "production",
                            },
                            {
                                "context": "CONTEXTLESS",
                                "key": "Team",
                                "value": "test",
                            },
                        ],
                    }],
                },
                {
                    "delay_in_minutes": 0,
                    "severity_level": "CUSTOM_ALERT",
                    "tag_filters": [{
                        "include_mode": "INCLUDE_ALL",
                        "tag_filters": [
                            {
                                "context": "CONTEXTLESS",
                                "key": "EnvironmentB",
                                "value": "production",
                            },
                            {
                                "context": "CONTEXTLESS",
                                "key": "Team",
                                "value": "test",
                            },
                        ],
                    }],
                },
                {
                    "delay_in_minutes": 0,
                    "severity_level": "ERROR",
                    "tag_filters": [{
                        "include_mode": "INCLUDE_ALL",
                        "tag_filters": [
                            {
                                "context": "CONTEXTLESS",
                                "key": "EnvironmentC",
                                "value": "production",
                            },
                            {
                                "context": "CONTEXTLESS",
                                "key": "Team",
                                "value": "test",
                            },
                        ],
                    }],
                },
                {
                    "delay_in_minutes": 0,
                    "severity_level": "MONITORING_UNAVAILABLE",
                    "tag_filters": [{
                        "include_mode": "INCLUDE_ALL",
                        "tag_filters": [
                            {
                                "context": "CONTEXTLESS",
                                "key": "EnvironmentD",
                                "value": "production",
                            },
                            {
                                "context": "CONTEXTLESS",
                                "key": "Team",
                                "value": "test",
                            },
                        ],
                    }],
                },
                {
                    "delay_in_minutes": 0,
                    "severity_level": "PERFORMANCE",
                    "tag_filters": [{
                        "include_mode": "INCLUDE_ALL",
                        "tag_filters": [
                            {
                                "context": "CONTEXTLESS",
                                "key": "EnvironmentE",
                                "value": "production",
                            },
                            {
                                "context": "CONTEXTLESS",
                                "key": "Team",
                                "value": "test",
                            },
                        ],
                    }],
                },
                {
                    "delay_in_minutes": 0,
                    "severity_level": "RESOURCE_CONTENTION",
                    "tag_filters": [{
                        "include_mode": "INCLUDE_ALL",
                        "tag_filters": [
                            {
                                "context": "CONTEXTLESS",
                                "key": "EnvironmentF",
                                "value": "production",
                            },
                            {
                                "context": "CONTEXTLESS",
                                "key": "Team",
                                "value": "test",
                            },
                        ],
                    }],
                },
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] display_name: The name of the alerting profile, displayed in the UI
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertingProfileEventTypeFilterArgs', 'AlertingProfileEventTypeFilterArgsDict']]]] event_type_filters: The list of event filters.  For all filters that are *negated* inside of these event filters, that is all `Predefined` as well as `Custom` (Title and/or Description) ones the AND logic applies. For all *non-negated* ones the OR logic applies. Between these two groups, negated and non-negated, the AND logic applies.  If you specify both severity rule and event filter, the AND logic applies
        :param pulumi.Input[Union['AlertingProfileMetadataArgs', 'AlertingProfileMetadataArgsDict']] metadata: `metadata` exists for backwards compatibility but shouldn't get specified anymore
        :param pulumi.Input[builtins.str] mz_id: The ID of the management zone to which the alerting profile applies
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertingProfileRuleArgs', 'AlertingProfileRuleArgsDict']]]] rules: A list of rules for management zone usage.  Each rule is evaluated independently of all other rules
        :param pulumi.Input[builtins.str] unknowns: allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlertingProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        !> This resource API endpoint has been deprecated, please use Alerting instead.

        > This resource requires the API token scopes **Read configuration** (`ReadConfig`) and **Write configuration** (`WriteConfig`)

        ## Dynatrace Documentation

        - Alerting profiles - https://www.dynatrace.com/support/help/how-to-use-dynatrace/problem-detection-and-analysis/notifications-and-alerting/alerting-profiles

        - Alerting profiles API - https://www.dynatrace.com/support/help/dynatrace-api/configuration-api/alerting-profiles-api

        ## Resource Example Usage

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        _name_ = dynatrace.AlertingProfile("#name#",
            display_name="#name#",
            mz_id="",
            rules=[
                {
                    "delay_in_minutes": 0,
                    "severity_level": "AVAILABILITY",
                    "tag_filters": [{
                        "include_mode": "INCLUDE_ALL",
                        "tag_filters": [
                            {
                                "context": "CONTEXTLESS",
                                "key": "EnvironmentA",
                                "value": "production",
                            },
                            {
                                "context": "CONTEXTLESS",
                                "key": "Team",
                                "value": "test",
                            },
                        ],
                    }],
                },
                {
                    "delay_in_minutes": 0,
                    "severity_level": "CUSTOM_ALERT",
                    "tag_filters": [{
                        "include_mode": "INCLUDE_ALL",
                        "tag_filters": [
                            {
                                "context": "CONTEXTLESS",
                                "key": "EnvironmentB",
                                "value": "production",
                            },
                            {
                                "context": "CONTEXTLESS",
                                "key": "Team",
                                "value": "test",
                            },
                        ],
                    }],
                },
                {
                    "delay_in_minutes": 0,
                    "severity_level": "ERROR",
                    "tag_filters": [{
                        "include_mode": "INCLUDE_ALL",
                        "tag_filters": [
                            {
                                "context": "CONTEXTLESS",
                                "key": "EnvironmentC",
                                "value": "production",
                            },
                            {
                                "context": "CONTEXTLESS",
                                "key": "Team",
                                "value": "test",
                            },
                        ],
                    }],
                },
                {
                    "delay_in_minutes": 0,
                    "severity_level": "MONITORING_UNAVAILABLE",
                    "tag_filters": [{
                        "include_mode": "INCLUDE_ALL",
                        "tag_filters": [
                            {
                                "context": "CONTEXTLESS",
                                "key": "EnvironmentD",
                                "value": "production",
                            },
                            {
                                "context": "CONTEXTLESS",
                                "key": "Team",
                                "value": "test",
                            },
                        ],
                    }],
                },
                {
                    "delay_in_minutes": 0,
                    "severity_level": "PERFORMANCE",
                    "tag_filters": [{
                        "include_mode": "INCLUDE_ALL",
                        "tag_filters": [
                            {
                                "context": "CONTEXTLESS",
                                "key": "EnvironmentE",
                                "value": "production",
                            },
                            {
                                "context": "CONTEXTLESS",
                                "key": "Team",
                                "value": "test",
                            },
                        ],
                    }],
                },
                {
                    "delay_in_minutes": 0,
                    "severity_level": "RESOURCE_CONTENTION",
                    "tag_filters": [{
                        "include_mode": "INCLUDE_ALL",
                        "tag_filters": [
                            {
                                "context": "CONTEXTLESS",
                                "key": "EnvironmentF",
                                "value": "production",
                            },
                            {
                                "context": "CONTEXTLESS",
                                "key": "Team",
                                "value": "test",
                            },
                        ],
                    }],
                },
            ])
        ```

        :param str resource_name: The name of the resource.
        :param AlertingProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlertingProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 event_type_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertingProfileEventTypeFilterArgs', 'AlertingProfileEventTypeFilterArgsDict']]]]] = None,
                 metadata: Optional[pulumi.Input[Union['AlertingProfileMetadataArgs', 'AlertingProfileMetadataArgsDict']]] = None,
                 mz_id: Optional[pulumi.Input[builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertingProfileRuleArgs', 'AlertingProfileRuleArgsDict']]]]] = None,
                 unknowns: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlertingProfileArgs.__new__(AlertingProfileArgs)

            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["event_type_filters"] = event_type_filters
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["mz_id"] = mz_id
            __props__.__dict__["rules"] = rules
            __props__.__dict__["unknowns"] = unknowns
        super(AlertingProfile, __self__).__init__(
            'dynatrace:index/alertingProfile:AlertingProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            event_type_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertingProfileEventTypeFilterArgs', 'AlertingProfileEventTypeFilterArgsDict']]]]] = None,
            metadata: Optional[pulumi.Input[Union['AlertingProfileMetadataArgs', 'AlertingProfileMetadataArgsDict']]] = None,
            mz_id: Optional[pulumi.Input[builtins.str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertingProfileRuleArgs', 'AlertingProfileRuleArgsDict']]]]] = None,
            unknowns: Optional[pulumi.Input[builtins.str]] = None) -> 'AlertingProfile':
        """
        Get an existing AlertingProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] display_name: The name of the alerting profile, displayed in the UI
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertingProfileEventTypeFilterArgs', 'AlertingProfileEventTypeFilterArgsDict']]]] event_type_filters: The list of event filters.  For all filters that are *negated* inside of these event filters, that is all `Predefined` as well as `Custom` (Title and/or Description) ones the AND logic applies. For all *non-negated* ones the OR logic applies. Between these two groups, negated and non-negated, the AND logic applies.  If you specify both severity rule and event filter, the AND logic applies
        :param pulumi.Input[Union['AlertingProfileMetadataArgs', 'AlertingProfileMetadataArgsDict']] metadata: `metadata` exists for backwards compatibility but shouldn't get specified anymore
        :param pulumi.Input[builtins.str] mz_id: The ID of the management zone to which the alerting profile applies
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertingProfileRuleArgs', 'AlertingProfileRuleArgsDict']]]] rules: A list of rules for management zone usage.  Each rule is evaluated independently of all other rules
        :param pulumi.Input[builtins.str] unknowns: allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlertingProfileState.__new__(_AlertingProfileState)

        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["event_type_filters"] = event_type_filters
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["mz_id"] = mz_id
        __props__.__dict__["rules"] = rules
        __props__.__dict__["unknowns"] = unknowns
        return AlertingProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the alerting profile, displayed in the UI
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="eventTypeFilters")
    def event_type_filters(self) -> pulumi.Output[Optional[Sequence['outputs.AlertingProfileEventTypeFilter']]]:
        """
        The list of event filters.  For all filters that are *negated* inside of these event filters, that is all `Predefined` as well as `Custom` (Title and/or Description) ones the AND logic applies. For all *non-negated* ones the OR logic applies. Between these two groups, negated and non-negated, the AND logic applies.  If you specify both severity rule and event filter, the AND logic applies
        """
        return pulumi.get(self, "event_type_filters")

    @property
    @pulumi.getter
    @_utilities.deprecated("""`metadata` exists for backwards compatibility but shouldn't get specified anymore""")
    def metadata(self) -> pulumi.Output[Optional['outputs.AlertingProfileMetadata']]:
        """
        `metadata` exists for backwards compatibility but shouldn't get specified anymore
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="mzId")
    def mz_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the management zone to which the alerting profile applies
        """
        return pulumi.get(self, "mz_id")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.AlertingProfileRule']]]:
        """
        A list of rules for management zone usage.  Each rule is evaluated independently of all other rules
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def unknowns(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        return pulumi.get(self, "unknowns")

