# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppMonitoringArgs', 'AppMonitoring']

@pulumi.input_type
class AppMonitoringArgs:
    def __init__(__self__, *,
                 default_log_level: pulumi.Input[builtins.str],
                 app_monitoring: Optional[pulumi.Input['AppMonitoringAppMonitoringArgs']] = None,
                 default_trace_level: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AppMonitoring resource.
        :param pulumi.Input[builtins.str] default_log_level: Possible Values: `debug`, `error`, `info`, `off`, `warn`
        :param pulumi.Input['AppMonitoringAppMonitoringArgs'] app_monitoring: You can override the default monitoring setting for each app separately
        :param pulumi.Input[builtins.str] default_trace_level: Possible Values: `off`, `on`
        """
        pulumi.set(__self__, "default_log_level", default_log_level)
        if app_monitoring is not None:
            pulumi.set(__self__, "app_monitoring", app_monitoring)
        if default_trace_level is not None:
            pulumi.set(__self__, "default_trace_level", default_trace_level)

    @property
    @pulumi.getter(name="defaultLogLevel")
    def default_log_level(self) -> pulumi.Input[builtins.str]:
        """
        Possible Values: `debug`, `error`, `info`, `off`, `warn`
        """
        return pulumi.get(self, "default_log_level")

    @default_log_level.setter
    def default_log_level(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "default_log_level", value)

    @property
    @pulumi.getter(name="appMonitoring")
    def app_monitoring(self) -> Optional[pulumi.Input['AppMonitoringAppMonitoringArgs']]:
        """
        You can override the default monitoring setting for each app separately
        """
        return pulumi.get(self, "app_monitoring")

    @app_monitoring.setter
    def app_monitoring(self, value: Optional[pulumi.Input['AppMonitoringAppMonitoringArgs']]):
        pulumi.set(self, "app_monitoring", value)

    @property
    @pulumi.getter(name="defaultTraceLevel")
    def default_trace_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Possible Values: `off`, `on`
        """
        return pulumi.get(self, "default_trace_level")

    @default_trace_level.setter
    def default_trace_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_trace_level", value)


@pulumi.input_type
class _AppMonitoringState:
    def __init__(__self__, *,
                 app_monitoring: Optional[pulumi.Input['AppMonitoringAppMonitoringArgs']] = None,
                 default_log_level: Optional[pulumi.Input[builtins.str]] = None,
                 default_trace_level: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppMonitoring resources.
        :param pulumi.Input['AppMonitoringAppMonitoringArgs'] app_monitoring: You can override the default monitoring setting for each app separately
        :param pulumi.Input[builtins.str] default_log_level: Possible Values: `debug`, `error`, `info`, `off`, `warn`
        :param pulumi.Input[builtins.str] default_trace_level: Possible Values: `off`, `on`
        """
        if app_monitoring is not None:
            pulumi.set(__self__, "app_monitoring", app_monitoring)
        if default_log_level is not None:
            pulumi.set(__self__, "default_log_level", default_log_level)
        if default_trace_level is not None:
            pulumi.set(__self__, "default_trace_level", default_trace_level)

    @property
    @pulumi.getter(name="appMonitoring")
    def app_monitoring(self) -> Optional[pulumi.Input['AppMonitoringAppMonitoringArgs']]:
        """
        You can override the default monitoring setting for each app separately
        """
        return pulumi.get(self, "app_monitoring")

    @app_monitoring.setter
    def app_monitoring(self, value: Optional[pulumi.Input['AppMonitoringAppMonitoringArgs']]):
        pulumi.set(self, "app_monitoring", value)

    @property
    @pulumi.getter(name="defaultLogLevel")
    def default_log_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Possible Values: `debug`, `error`, `info`, `off`, `warn`
        """
        return pulumi.get(self, "default_log_level")

    @default_log_level.setter
    def default_log_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_log_level", value)

    @property
    @pulumi.getter(name="defaultTraceLevel")
    def default_trace_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Possible Values: `off`, `on`
        """
        return pulumi.get(self, "default_trace_level")

    @default_trace_level.setter
    def default_trace_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_trace_level", value)


@pulumi.type_token("dynatrace:index/appMonitoring:AppMonitoring")
class AppMonitoring(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_monitoring: Optional[pulumi.Input[Union['AppMonitoringAppMonitoringArgs', 'AppMonitoringAppMonitoringArgsDict']]] = None,
                 default_log_level: Optional[pulumi.Input[builtins.str]] = None,
                 default_trace_level: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a AppMonitoring resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AppMonitoringAppMonitoringArgs', 'AppMonitoringAppMonitoringArgsDict']] app_monitoring: You can override the default monitoring setting for each app separately
        :param pulumi.Input[builtins.str] default_log_level: Possible Values: `debug`, `error`, `info`, `off`, `warn`
        :param pulumi.Input[builtins.str] default_trace_level: Possible Values: `off`, `on`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppMonitoringArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AppMonitoring resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AppMonitoringArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppMonitoringArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_monitoring: Optional[pulumi.Input[Union['AppMonitoringAppMonitoringArgs', 'AppMonitoringAppMonitoringArgsDict']]] = None,
                 default_log_level: Optional[pulumi.Input[builtins.str]] = None,
                 default_trace_level: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppMonitoringArgs.__new__(AppMonitoringArgs)

            __props__.__dict__["app_monitoring"] = app_monitoring
            if default_log_level is None and not opts.urn:
                raise TypeError("Missing required property 'default_log_level'")
            __props__.__dict__["default_log_level"] = default_log_level
            __props__.__dict__["default_trace_level"] = default_trace_level
        super(AppMonitoring, __self__).__init__(
            'dynatrace:index/appMonitoring:AppMonitoring',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_monitoring: Optional[pulumi.Input[Union['AppMonitoringAppMonitoringArgs', 'AppMonitoringAppMonitoringArgsDict']]] = None,
            default_log_level: Optional[pulumi.Input[builtins.str]] = None,
            default_trace_level: Optional[pulumi.Input[builtins.str]] = None) -> 'AppMonitoring':
        """
        Get an existing AppMonitoring resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AppMonitoringAppMonitoringArgs', 'AppMonitoringAppMonitoringArgsDict']] app_monitoring: You can override the default monitoring setting for each app separately
        :param pulumi.Input[builtins.str] default_log_level: Possible Values: `debug`, `error`, `info`, `off`, `warn`
        :param pulumi.Input[builtins.str] default_trace_level: Possible Values: `off`, `on`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppMonitoringState.__new__(_AppMonitoringState)

        __props__.__dict__["app_monitoring"] = app_monitoring
        __props__.__dict__["default_log_level"] = default_log_level
        __props__.__dict__["default_trace_level"] = default_trace_level
        return AppMonitoring(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appMonitoring")
    def app_monitoring(self) -> pulumi.Output[Optional['outputs.AppMonitoringAppMonitoring']]:
        """
        You can override the default monitoring setting for each app separately
        """
        return pulumi.get(self, "app_monitoring")

    @property
    @pulumi.getter(name="defaultLogLevel")
    def default_log_level(self) -> pulumi.Output[builtins.str]:
        """
        Possible Values: `debug`, `error`, `info`, `off`, `warn`
        """
        return pulumi.get(self, "default_log_level")

    @property
    @pulumi.getter(name="defaultTraceLevel")
    def default_trace_level(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Possible Values: `off`, `on`
        """
        return pulumi.get(self, "default_trace_level")

