# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplicationDataPrivacyArgs', 'ApplicationDataPrivacy']

@pulumi.input_type
class ApplicationDataPrivacyArgs:
    def __init__(__self__, *,
                 do_not_track_behaviour: pulumi.Input[builtins.str],
                 session_replay_data_privacy: pulumi.Input['ApplicationDataPrivacySessionReplayDataPrivacyArgs'],
                 web_application_id: pulumi.Input[builtins.str],
                 data_capture_opt_in: Optional[pulumi.Input[builtins.bool]] = None,
                 persistent_cookie_for_user_tracking: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a ApplicationDataPrivacy resource.
        :param pulumi.Input[builtins.str] do_not_track_behaviour: (Field has overlap with `DataPrivacy`) How to handle the "Do Not Track" header:
        :param pulumi.Input['ApplicationDataPrivacySessionReplayDataPrivacyArgs'] session_replay_data_privacy: (Field has overlap with `SessionReplayWebPrivacy`) Data privacy settings for Session Replay
        :param pulumi.Input[builtins.str] web_application_id: Dynatrace entity ID of the web application
        :param pulumi.Input[builtins.bool] data_capture_opt_in: (Field has overlap with `DataPrivacy`) Set to `true` to disable data capture and cookies until JavaScriptAPI `dtrum.enable()` is called
        :param pulumi.Input[builtins.bool] persistent_cookie_for_user_tracking: (Field has overlap with `DataPrivacy`) Set to `true` to set persistent cookie in order to recognize returning devices
        """
        pulumi.set(__self__, "do_not_track_behaviour", do_not_track_behaviour)
        pulumi.set(__self__, "session_replay_data_privacy", session_replay_data_privacy)
        pulumi.set(__self__, "web_application_id", web_application_id)
        if data_capture_opt_in is not None:
            pulumi.set(__self__, "data_capture_opt_in", data_capture_opt_in)
        if persistent_cookie_for_user_tracking is not None:
            pulumi.set(__self__, "persistent_cookie_for_user_tracking", persistent_cookie_for_user_tracking)

    @property
    @pulumi.getter(name="doNotTrackBehaviour")
    def do_not_track_behaviour(self) -> pulumi.Input[builtins.str]:
        """
        (Field has overlap with `DataPrivacy`) How to handle the "Do Not Track" header:
        """
        return pulumi.get(self, "do_not_track_behaviour")

    @do_not_track_behaviour.setter
    def do_not_track_behaviour(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "do_not_track_behaviour", value)

    @property
    @pulumi.getter(name="sessionReplayDataPrivacy")
    def session_replay_data_privacy(self) -> pulumi.Input['ApplicationDataPrivacySessionReplayDataPrivacyArgs']:
        """
        (Field has overlap with `SessionReplayWebPrivacy`) Data privacy settings for Session Replay
        """
        return pulumi.get(self, "session_replay_data_privacy")

    @session_replay_data_privacy.setter
    def session_replay_data_privacy(self, value: pulumi.Input['ApplicationDataPrivacySessionReplayDataPrivacyArgs']):
        pulumi.set(self, "session_replay_data_privacy", value)

    @property
    @pulumi.getter(name="webApplicationId")
    def web_application_id(self) -> pulumi.Input[builtins.str]:
        """
        Dynatrace entity ID of the web application
        """
        return pulumi.get(self, "web_application_id")

    @web_application_id.setter
    def web_application_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "web_application_id", value)

    @property
    @pulumi.getter(name="dataCaptureOptIn")
    def data_capture_opt_in(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Field has overlap with `DataPrivacy`) Set to `true` to disable data capture and cookies until JavaScriptAPI `dtrum.enable()` is called
        """
        return pulumi.get(self, "data_capture_opt_in")

    @data_capture_opt_in.setter
    def data_capture_opt_in(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "data_capture_opt_in", value)

    @property
    @pulumi.getter(name="persistentCookieForUserTracking")
    def persistent_cookie_for_user_tracking(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Field has overlap with `DataPrivacy`) Set to `true` to set persistent cookie in order to recognize returning devices
        """
        return pulumi.get(self, "persistent_cookie_for_user_tracking")

    @persistent_cookie_for_user_tracking.setter
    def persistent_cookie_for_user_tracking(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "persistent_cookie_for_user_tracking", value)


@pulumi.input_type
class _ApplicationDataPrivacyState:
    def __init__(__self__, *,
                 data_capture_opt_in: Optional[pulumi.Input[builtins.bool]] = None,
                 do_not_track_behaviour: Optional[pulumi.Input[builtins.str]] = None,
                 persistent_cookie_for_user_tracking: Optional[pulumi.Input[builtins.bool]] = None,
                 session_replay_data_privacy: Optional[pulumi.Input['ApplicationDataPrivacySessionReplayDataPrivacyArgs']] = None,
                 web_application_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApplicationDataPrivacy resources.
        :param pulumi.Input[builtins.bool] data_capture_opt_in: (Field has overlap with `DataPrivacy`) Set to `true` to disable data capture and cookies until JavaScriptAPI `dtrum.enable()` is called
        :param pulumi.Input[builtins.str] do_not_track_behaviour: (Field has overlap with `DataPrivacy`) How to handle the "Do Not Track" header:
        :param pulumi.Input[builtins.bool] persistent_cookie_for_user_tracking: (Field has overlap with `DataPrivacy`) Set to `true` to set persistent cookie in order to recognize returning devices
        :param pulumi.Input['ApplicationDataPrivacySessionReplayDataPrivacyArgs'] session_replay_data_privacy: (Field has overlap with `SessionReplayWebPrivacy`) Data privacy settings for Session Replay
        :param pulumi.Input[builtins.str] web_application_id: Dynatrace entity ID of the web application
        """
        if data_capture_opt_in is not None:
            pulumi.set(__self__, "data_capture_opt_in", data_capture_opt_in)
        if do_not_track_behaviour is not None:
            pulumi.set(__self__, "do_not_track_behaviour", do_not_track_behaviour)
        if persistent_cookie_for_user_tracking is not None:
            pulumi.set(__self__, "persistent_cookie_for_user_tracking", persistent_cookie_for_user_tracking)
        if session_replay_data_privacy is not None:
            pulumi.set(__self__, "session_replay_data_privacy", session_replay_data_privacy)
        if web_application_id is not None:
            pulumi.set(__self__, "web_application_id", web_application_id)

    @property
    @pulumi.getter(name="dataCaptureOptIn")
    def data_capture_opt_in(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Field has overlap with `DataPrivacy`) Set to `true` to disable data capture and cookies until JavaScriptAPI `dtrum.enable()` is called
        """
        return pulumi.get(self, "data_capture_opt_in")

    @data_capture_opt_in.setter
    def data_capture_opt_in(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "data_capture_opt_in", value)

    @property
    @pulumi.getter(name="doNotTrackBehaviour")
    def do_not_track_behaviour(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Field has overlap with `DataPrivacy`) How to handle the "Do Not Track" header:
        """
        return pulumi.get(self, "do_not_track_behaviour")

    @do_not_track_behaviour.setter
    def do_not_track_behaviour(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "do_not_track_behaviour", value)

    @property
    @pulumi.getter(name="persistentCookieForUserTracking")
    def persistent_cookie_for_user_tracking(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Field has overlap with `DataPrivacy`) Set to `true` to set persistent cookie in order to recognize returning devices
        """
        return pulumi.get(self, "persistent_cookie_for_user_tracking")

    @persistent_cookie_for_user_tracking.setter
    def persistent_cookie_for_user_tracking(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "persistent_cookie_for_user_tracking", value)

    @property
    @pulumi.getter(name="sessionReplayDataPrivacy")
    def session_replay_data_privacy(self) -> Optional[pulumi.Input['ApplicationDataPrivacySessionReplayDataPrivacyArgs']]:
        """
        (Field has overlap with `SessionReplayWebPrivacy`) Data privacy settings for Session Replay
        """
        return pulumi.get(self, "session_replay_data_privacy")

    @session_replay_data_privacy.setter
    def session_replay_data_privacy(self, value: Optional[pulumi.Input['ApplicationDataPrivacySessionReplayDataPrivacyArgs']]):
        pulumi.set(self, "session_replay_data_privacy", value)

    @property
    @pulumi.getter(name="webApplicationId")
    def web_application_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Dynatrace entity ID of the web application
        """
        return pulumi.get(self, "web_application_id")

    @web_application_id.setter
    def web_application_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "web_application_id", value)


@pulumi.type_token("dynatrace:index/applicationDataPrivacy:ApplicationDataPrivacy")
class ApplicationDataPrivacy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_capture_opt_in: Optional[pulumi.Input[builtins.bool]] = None,
                 do_not_track_behaviour: Optional[pulumi.Input[builtins.str]] = None,
                 persistent_cookie_for_user_tracking: Optional[pulumi.Input[builtins.bool]] = None,
                 session_replay_data_privacy: Optional[pulumi.Input[Union['ApplicationDataPrivacySessionReplayDataPrivacyArgs', 'ApplicationDataPrivacySessionReplayDataPrivacyArgsDict']]] = None,
                 web_application_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a ApplicationDataPrivacy resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] data_capture_opt_in: (Field has overlap with `DataPrivacy`) Set to `true` to disable data capture and cookies until JavaScriptAPI `dtrum.enable()` is called
        :param pulumi.Input[builtins.str] do_not_track_behaviour: (Field has overlap with `DataPrivacy`) How to handle the "Do Not Track" header:
        :param pulumi.Input[builtins.bool] persistent_cookie_for_user_tracking: (Field has overlap with `DataPrivacy`) Set to `true` to set persistent cookie in order to recognize returning devices
        :param pulumi.Input[Union['ApplicationDataPrivacySessionReplayDataPrivacyArgs', 'ApplicationDataPrivacySessionReplayDataPrivacyArgsDict']] session_replay_data_privacy: (Field has overlap with `SessionReplayWebPrivacy`) Data privacy settings for Session Replay
        :param pulumi.Input[builtins.str] web_application_id: Dynatrace entity ID of the web application
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationDataPrivacyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ApplicationDataPrivacy resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ApplicationDataPrivacyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationDataPrivacyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_capture_opt_in: Optional[pulumi.Input[builtins.bool]] = None,
                 do_not_track_behaviour: Optional[pulumi.Input[builtins.str]] = None,
                 persistent_cookie_for_user_tracking: Optional[pulumi.Input[builtins.bool]] = None,
                 session_replay_data_privacy: Optional[pulumi.Input[Union['ApplicationDataPrivacySessionReplayDataPrivacyArgs', 'ApplicationDataPrivacySessionReplayDataPrivacyArgsDict']]] = None,
                 web_application_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationDataPrivacyArgs.__new__(ApplicationDataPrivacyArgs)

            __props__.__dict__["data_capture_opt_in"] = data_capture_opt_in
            if do_not_track_behaviour is None and not opts.urn:
                raise TypeError("Missing required property 'do_not_track_behaviour'")
            __props__.__dict__["do_not_track_behaviour"] = do_not_track_behaviour
            __props__.__dict__["persistent_cookie_for_user_tracking"] = persistent_cookie_for_user_tracking
            if session_replay_data_privacy is None and not opts.urn:
                raise TypeError("Missing required property 'session_replay_data_privacy'")
            __props__.__dict__["session_replay_data_privacy"] = session_replay_data_privacy
            if web_application_id is None and not opts.urn:
                raise TypeError("Missing required property 'web_application_id'")
            __props__.__dict__["web_application_id"] = web_application_id
        super(ApplicationDataPrivacy, __self__).__init__(
            'dynatrace:index/applicationDataPrivacy:ApplicationDataPrivacy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data_capture_opt_in: Optional[pulumi.Input[builtins.bool]] = None,
            do_not_track_behaviour: Optional[pulumi.Input[builtins.str]] = None,
            persistent_cookie_for_user_tracking: Optional[pulumi.Input[builtins.bool]] = None,
            session_replay_data_privacy: Optional[pulumi.Input[Union['ApplicationDataPrivacySessionReplayDataPrivacyArgs', 'ApplicationDataPrivacySessionReplayDataPrivacyArgsDict']]] = None,
            web_application_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ApplicationDataPrivacy':
        """
        Get an existing ApplicationDataPrivacy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] data_capture_opt_in: (Field has overlap with `DataPrivacy`) Set to `true` to disable data capture and cookies until JavaScriptAPI `dtrum.enable()` is called
        :param pulumi.Input[builtins.str] do_not_track_behaviour: (Field has overlap with `DataPrivacy`) How to handle the "Do Not Track" header:
        :param pulumi.Input[builtins.bool] persistent_cookie_for_user_tracking: (Field has overlap with `DataPrivacy`) Set to `true` to set persistent cookie in order to recognize returning devices
        :param pulumi.Input[Union['ApplicationDataPrivacySessionReplayDataPrivacyArgs', 'ApplicationDataPrivacySessionReplayDataPrivacyArgsDict']] session_replay_data_privacy: (Field has overlap with `SessionReplayWebPrivacy`) Data privacy settings for Session Replay
        :param pulumi.Input[builtins.str] web_application_id: Dynatrace entity ID of the web application
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplicationDataPrivacyState.__new__(_ApplicationDataPrivacyState)

        __props__.__dict__["data_capture_opt_in"] = data_capture_opt_in
        __props__.__dict__["do_not_track_behaviour"] = do_not_track_behaviour
        __props__.__dict__["persistent_cookie_for_user_tracking"] = persistent_cookie_for_user_tracking
        __props__.__dict__["session_replay_data_privacy"] = session_replay_data_privacy
        __props__.__dict__["web_application_id"] = web_application_id
        return ApplicationDataPrivacy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dataCaptureOptIn")
    def data_capture_opt_in(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        (Field has overlap with `DataPrivacy`) Set to `true` to disable data capture and cookies until JavaScriptAPI `dtrum.enable()` is called
        """
        return pulumi.get(self, "data_capture_opt_in")

    @property
    @pulumi.getter(name="doNotTrackBehaviour")
    def do_not_track_behaviour(self) -> pulumi.Output[builtins.str]:
        """
        (Field has overlap with `DataPrivacy`) How to handle the "Do Not Track" header:
        """
        return pulumi.get(self, "do_not_track_behaviour")

    @property
    @pulumi.getter(name="persistentCookieForUserTracking")
    def persistent_cookie_for_user_tracking(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        (Field has overlap with `DataPrivacy`) Set to `true` to set persistent cookie in order to recognize returning devices
        """
        return pulumi.get(self, "persistent_cookie_for_user_tracking")

    @property
    @pulumi.getter(name="sessionReplayDataPrivacy")
    def session_replay_data_privacy(self) -> pulumi.Output['outputs.ApplicationDataPrivacySessionReplayDataPrivacy']:
        """
        (Field has overlap with `SessionReplayWebPrivacy`) Data privacy settings for Session Replay
        """
        return pulumi.get(self, "session_replay_data_privacy")

    @property
    @pulumi.getter(name="webApplicationId")
    def web_application_id(self) -> pulumi.Output[builtins.str]:
        """
        Dynatrace entity ID of the web application
        """
        return pulumi.get(self, "web_application_id")

