# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplicationDetectionRuleArgs', 'ApplicationDetectionRule']

@pulumi.input_type
class ApplicationDetectionRuleArgs:
    def __init__(__self__, *,
                 application_identifier: pulumi.Input[builtins.str],
                 filter_config: pulumi.Input['ApplicationDetectionRuleFilterConfigArgs'],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 order: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ApplicationDetectionRule resource.
        :param pulumi.Input[builtins.str] application_identifier: The Dynatrace entity ID of the application, for example APPLICATION-4A3B43
        :param pulumi.Input['ApplicationDetectionRuleFilterConfigArgs'] filter_config: The condition of an application detection rule
        :param pulumi.Input[builtins.str] name: The unique name of the Application detection rule
        :param pulumi.Input[builtins.str] order: The order of the rule in the rules list
        """
        pulumi.set(__self__, "application_identifier", application_identifier)
        pulumi.set(__self__, "filter_config", filter_config)
        if name is not None:
            warnings.warn("""Dynatrace computes that value automatically. Any attempts to specify that value will are getting ignored.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Dynatrace computes that value automatically. Any attempts to specify that value will are getting ignored.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if order is not None:
            pulumi.set(__self__, "order", order)

    @property
    @pulumi.getter(name="applicationIdentifier")
    def application_identifier(self) -> pulumi.Input[builtins.str]:
        """
        The Dynatrace entity ID of the application, for example APPLICATION-4A3B43
        """
        return pulumi.get(self, "application_identifier")

    @application_identifier.setter
    def application_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "application_identifier", value)

    @property
    @pulumi.getter(name="filterConfig")
    def filter_config(self) -> pulumi.Input['ApplicationDetectionRuleFilterConfigArgs']:
        """
        The condition of an application detection rule
        """
        return pulumi.get(self, "filter_config")

    @filter_config.setter
    def filter_config(self, value: pulumi.Input['ApplicationDetectionRuleFilterConfigArgs']):
        pulumi.set(self, "filter_config", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""Dynatrace computes that value automatically. Any attempts to specify that value will are getting ignored.""")
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique name of the Application detection rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def order(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The order of the rule in the rules list
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "order", value)


@pulumi.input_type
class _ApplicationDetectionRuleState:
    def __init__(__self__, *,
                 application_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 filter_config: Optional[pulumi.Input['ApplicationDetectionRuleFilterConfigArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 order: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApplicationDetectionRule resources.
        :param pulumi.Input[builtins.str] application_identifier: The Dynatrace entity ID of the application, for example APPLICATION-4A3B43
        :param pulumi.Input['ApplicationDetectionRuleFilterConfigArgs'] filter_config: The condition of an application detection rule
        :param pulumi.Input[builtins.str] name: The unique name of the Application detection rule
        :param pulumi.Input[builtins.str] order: The order of the rule in the rules list
        """
        if application_identifier is not None:
            pulumi.set(__self__, "application_identifier", application_identifier)
        if filter_config is not None:
            pulumi.set(__self__, "filter_config", filter_config)
        if name is not None:
            warnings.warn("""Dynatrace computes that value automatically. Any attempts to specify that value will are getting ignored.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Dynatrace computes that value automatically. Any attempts to specify that value will are getting ignored.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if order is not None:
            pulumi.set(__self__, "order", order)

    @property
    @pulumi.getter(name="applicationIdentifier")
    def application_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Dynatrace entity ID of the application, for example APPLICATION-4A3B43
        """
        return pulumi.get(self, "application_identifier")

    @application_identifier.setter
    def application_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_identifier", value)

    @property
    @pulumi.getter(name="filterConfig")
    def filter_config(self) -> Optional[pulumi.Input['ApplicationDetectionRuleFilterConfigArgs']]:
        """
        The condition of an application detection rule
        """
        return pulumi.get(self, "filter_config")

    @filter_config.setter
    def filter_config(self, value: Optional[pulumi.Input['ApplicationDetectionRuleFilterConfigArgs']]):
        pulumi.set(self, "filter_config", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""Dynatrace computes that value automatically. Any attempts to specify that value will are getting ignored.""")
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique name of the Application detection rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def order(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The order of the rule in the rules list
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "order", value)


@pulumi.type_token("dynatrace:index/applicationDetectionRule:ApplicationDetectionRule")
class ApplicationDetectionRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 filter_config: Optional[pulumi.Input[Union['ApplicationDetectionRuleFilterConfigArgs', 'ApplicationDetectionRuleFilterConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 order: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a ApplicationDetectionRule resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_identifier: The Dynatrace entity ID of the application, for example APPLICATION-4A3B43
        :param pulumi.Input[Union['ApplicationDetectionRuleFilterConfigArgs', 'ApplicationDetectionRuleFilterConfigArgsDict']] filter_config: The condition of an application detection rule
        :param pulumi.Input[builtins.str] name: The unique name of the Application detection rule
        :param pulumi.Input[builtins.str] order: The order of the rule in the rules list
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationDetectionRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ApplicationDetectionRule resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ApplicationDetectionRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationDetectionRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 filter_config: Optional[pulumi.Input[Union['ApplicationDetectionRuleFilterConfigArgs', 'ApplicationDetectionRuleFilterConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 order: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationDetectionRuleArgs.__new__(ApplicationDetectionRuleArgs)

            if application_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'application_identifier'")
            __props__.__dict__["application_identifier"] = application_identifier
            if filter_config is None and not opts.urn:
                raise TypeError("Missing required property 'filter_config'")
            __props__.__dict__["filter_config"] = filter_config
            __props__.__dict__["name"] = name
            __props__.__dict__["order"] = order
        super(ApplicationDetectionRule, __self__).__init__(
            'dynatrace:index/applicationDetectionRule:ApplicationDetectionRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_identifier: Optional[pulumi.Input[builtins.str]] = None,
            filter_config: Optional[pulumi.Input[Union['ApplicationDetectionRuleFilterConfigArgs', 'ApplicationDetectionRuleFilterConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            order: Optional[pulumi.Input[builtins.str]] = None) -> 'ApplicationDetectionRule':
        """
        Get an existing ApplicationDetectionRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_identifier: The Dynatrace entity ID of the application, for example APPLICATION-4A3B43
        :param pulumi.Input[Union['ApplicationDetectionRuleFilterConfigArgs', 'ApplicationDetectionRuleFilterConfigArgsDict']] filter_config: The condition of an application detection rule
        :param pulumi.Input[builtins.str] name: The unique name of the Application detection rule
        :param pulumi.Input[builtins.str] order: The order of the rule in the rules list
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplicationDetectionRuleState.__new__(_ApplicationDetectionRuleState)

        __props__.__dict__["application_identifier"] = application_identifier
        __props__.__dict__["filter_config"] = filter_config
        __props__.__dict__["name"] = name
        __props__.__dict__["order"] = order
        return ApplicationDetectionRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationIdentifier")
    def application_identifier(self) -> pulumi.Output[builtins.str]:
        """
        The Dynatrace entity ID of the application, for example APPLICATION-4A3B43
        """
        return pulumi.get(self, "application_identifier")

    @property
    @pulumi.getter(name="filterConfig")
    def filter_config(self) -> pulumi.Output['outputs.ApplicationDetectionRuleFilterConfig']:
        """
        The condition of an application detection rule
        """
        return pulumi.get(self, "filter_config")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Dynatrace computes that value automatically. Any attempts to specify that value will are getting ignored.""")
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The unique name of the Application detection rule
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def order(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The order of the rule in the rules list
        """
        return pulumi.get(self, "order")

