# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppsecNotificationArgs', 'AppsecNotification']

@pulumi.input_type
class AppsecNotificationArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 enabled: pulumi.Input[builtins.bool],
                 trigger: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 attack_candidate_based_alerting_profile: Optional[pulumi.Input[builtins.str]] = None,
                 attack_candidate_based_email_payload: Optional[pulumi.Input['AppsecNotificationAttackCandidateBasedEmailPayloadArgs']] = None,
                 attack_candidate_based_jira_payload: Optional[pulumi.Input['AppsecNotificationAttackCandidateBasedJiraPayloadArgs']] = None,
                 attack_candidate_based_webhook_payload: Optional[pulumi.Input['AppsecNotificationAttackCandidateBasedWebhookPayloadArgs']] = None,
                 email_configuration: Optional[pulumi.Input['AppsecNotificationEmailConfigurationArgs']] = None,
                 jira_configuration: Optional[pulumi.Input['AppsecNotificationJiraConfigurationArgs']] = None,
                 security_problem_based_alerting_profile: Optional[pulumi.Input[builtins.str]] = None,
                 security_problem_based_email_payload: Optional[pulumi.Input['AppsecNotificationSecurityProblemBasedEmailPayloadArgs']] = None,
                 security_problem_based_jira_payload: Optional[pulumi.Input['AppsecNotificationSecurityProblemBasedJiraPayloadArgs']] = None,
                 security_problem_based_webhook_payload: Optional[pulumi.Input['AppsecNotificationSecurityProblemBasedWebhookPayloadArgs']] = None,
                 webhook_configuration: Optional[pulumi.Input['AppsecNotificationWebhookConfigurationArgs']] = None):
        """
        The set of arguments for constructing a AppsecNotification resource.
        :param pulumi.Input[builtins.str] display_name: Display name of the security notification
        :param pulumi.Input[builtins.bool] enabled: Enable/Disable the security notification, enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] trigger: Security alert type, possible Values: `ATTACK_CANDIDATE`, `SECURITY_PROBLEM`
        :param pulumi.Input[builtins.str] type: Notification type, possible Values: `EMAIL`, `JIRA`, `WEBHOOK`
        :param pulumi.Input[builtins.str] attack_candidate_based_alerting_profile: For attack candidate alerts, select an [alerting
               profile](https://www.terraform.io/ui/settings/builtin:appsec.notification-attack-alerting-profile) to control the
               delivery of security notifications related to this integration.
        :param pulumi.Input['AppsecNotificationAttackCandidateBasedEmailPayloadArgs'] attack_candidate_based_email_payload: Attack candidate based email payload, required when `trigger` equals `ATTACK_CANDIDATE` and `type` equals `EMAIL`
        :param pulumi.Input['AppsecNotificationAttackCandidateBasedJiraPayloadArgs'] attack_candidate_based_jira_payload: Attack candidate based Jira payload, required when `trigger` equals `ATTACK_CANDIDATE` and `type` equals `JIRA`
        :param pulumi.Input['AppsecNotificationAttackCandidateBasedWebhookPayloadArgs'] attack_candidate_based_webhook_payload: Attack candidate based webhook payload, required when `trigger` equals `ATTACK_CANDIDATE` and `type` equals `WEBHOOK`
        :param pulumi.Input['AppsecNotificationEmailConfigurationArgs'] email_configuration: Email configuration, required when `type` equals `EMAIL`
        :param pulumi.Input['AppsecNotificationJiraConfigurationArgs'] jira_configuration: Jira configuration, required when `type` equals `JIRA`
        :param pulumi.Input[builtins.str] security_problem_based_alerting_profile: For security problem alerts, select an [alerting
               profile](https://www.terraform.io/ui/settings/builtin:appsec.notification-alerting-profile) to control the delivery of
               security notifications related to this integration.
        :param pulumi.Input['AppsecNotificationSecurityProblemBasedEmailPayloadArgs'] security_problem_based_email_payload: Security problem based email payload, required when `trigger` equals `SECURITY_PROBLEM` and `type` equals `EMAIL`
        :param pulumi.Input['AppsecNotificationSecurityProblemBasedJiraPayloadArgs'] security_problem_based_jira_payload: Security problem based Jira payload, required when `trigger` equals `SECURITY_PROBLEM` and `type` equals `JIRA`
        :param pulumi.Input['AppsecNotificationSecurityProblemBasedWebhookPayloadArgs'] security_problem_based_webhook_payload: Security problem based webhook payload, required when `trigger` equals `SECURITY_PROBLEM` and `type` equals `WEBHOOK`
        :param pulumi.Input['AppsecNotificationWebhookConfigurationArgs'] webhook_configuration: Webhook configuration, required when `type` equals `WEBHOOK`
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "trigger", trigger)
        pulumi.set(__self__, "type", type)
        if attack_candidate_based_alerting_profile is not None:
            pulumi.set(__self__, "attack_candidate_based_alerting_profile", attack_candidate_based_alerting_profile)
        if attack_candidate_based_email_payload is not None:
            pulumi.set(__self__, "attack_candidate_based_email_payload", attack_candidate_based_email_payload)
        if attack_candidate_based_jira_payload is not None:
            pulumi.set(__self__, "attack_candidate_based_jira_payload", attack_candidate_based_jira_payload)
        if attack_candidate_based_webhook_payload is not None:
            pulumi.set(__self__, "attack_candidate_based_webhook_payload", attack_candidate_based_webhook_payload)
        if email_configuration is not None:
            pulumi.set(__self__, "email_configuration", email_configuration)
        if jira_configuration is not None:
            pulumi.set(__self__, "jira_configuration", jira_configuration)
        if security_problem_based_alerting_profile is not None:
            pulumi.set(__self__, "security_problem_based_alerting_profile", security_problem_based_alerting_profile)
        if security_problem_based_email_payload is not None:
            pulumi.set(__self__, "security_problem_based_email_payload", security_problem_based_email_payload)
        if security_problem_based_jira_payload is not None:
            pulumi.set(__self__, "security_problem_based_jira_payload", security_problem_based_jira_payload)
        if security_problem_based_webhook_payload is not None:
            pulumi.set(__self__, "security_problem_based_webhook_payload", security_problem_based_webhook_payload)
        if webhook_configuration is not None:
            pulumi.set(__self__, "webhook_configuration", webhook_configuration)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        Display name of the security notification
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Enable/Disable the security notification, enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def trigger(self) -> pulumi.Input[builtins.str]:
        """
        Security alert type, possible Values: `ATTACK_CANDIDATE`, `SECURITY_PROBLEM`
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "trigger", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Notification type, possible Values: `EMAIL`, `JIRA`, `WEBHOOK`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="attackCandidateBasedAlertingProfile")
    def attack_candidate_based_alerting_profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        For attack candidate alerts, select an [alerting
        profile](https://www.terraform.io/ui/settings/builtin:appsec.notification-attack-alerting-profile) to control the
        delivery of security notifications related to this integration.
        """
        return pulumi.get(self, "attack_candidate_based_alerting_profile")

    @attack_candidate_based_alerting_profile.setter
    def attack_candidate_based_alerting_profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "attack_candidate_based_alerting_profile", value)

    @property
    @pulumi.getter(name="attackCandidateBasedEmailPayload")
    def attack_candidate_based_email_payload(self) -> Optional[pulumi.Input['AppsecNotificationAttackCandidateBasedEmailPayloadArgs']]:
        """
        Attack candidate based email payload, required when `trigger` equals `ATTACK_CANDIDATE` and `type` equals `EMAIL`
        """
        return pulumi.get(self, "attack_candidate_based_email_payload")

    @attack_candidate_based_email_payload.setter
    def attack_candidate_based_email_payload(self, value: Optional[pulumi.Input['AppsecNotificationAttackCandidateBasedEmailPayloadArgs']]):
        pulumi.set(self, "attack_candidate_based_email_payload", value)

    @property
    @pulumi.getter(name="attackCandidateBasedJiraPayload")
    def attack_candidate_based_jira_payload(self) -> Optional[pulumi.Input['AppsecNotificationAttackCandidateBasedJiraPayloadArgs']]:
        """
        Attack candidate based Jira payload, required when `trigger` equals `ATTACK_CANDIDATE` and `type` equals `JIRA`
        """
        return pulumi.get(self, "attack_candidate_based_jira_payload")

    @attack_candidate_based_jira_payload.setter
    def attack_candidate_based_jira_payload(self, value: Optional[pulumi.Input['AppsecNotificationAttackCandidateBasedJiraPayloadArgs']]):
        pulumi.set(self, "attack_candidate_based_jira_payload", value)

    @property
    @pulumi.getter(name="attackCandidateBasedWebhookPayload")
    def attack_candidate_based_webhook_payload(self) -> Optional[pulumi.Input['AppsecNotificationAttackCandidateBasedWebhookPayloadArgs']]:
        """
        Attack candidate based webhook payload, required when `trigger` equals `ATTACK_CANDIDATE` and `type` equals `WEBHOOK`
        """
        return pulumi.get(self, "attack_candidate_based_webhook_payload")

    @attack_candidate_based_webhook_payload.setter
    def attack_candidate_based_webhook_payload(self, value: Optional[pulumi.Input['AppsecNotificationAttackCandidateBasedWebhookPayloadArgs']]):
        pulumi.set(self, "attack_candidate_based_webhook_payload", value)

    @property
    @pulumi.getter(name="emailConfiguration")
    def email_configuration(self) -> Optional[pulumi.Input['AppsecNotificationEmailConfigurationArgs']]:
        """
        Email configuration, required when `type` equals `EMAIL`
        """
        return pulumi.get(self, "email_configuration")

    @email_configuration.setter
    def email_configuration(self, value: Optional[pulumi.Input['AppsecNotificationEmailConfigurationArgs']]):
        pulumi.set(self, "email_configuration", value)

    @property
    @pulumi.getter(name="jiraConfiguration")
    def jira_configuration(self) -> Optional[pulumi.Input['AppsecNotificationJiraConfigurationArgs']]:
        """
        Jira configuration, required when `type` equals `JIRA`
        """
        return pulumi.get(self, "jira_configuration")

    @jira_configuration.setter
    def jira_configuration(self, value: Optional[pulumi.Input['AppsecNotificationJiraConfigurationArgs']]):
        pulumi.set(self, "jira_configuration", value)

    @property
    @pulumi.getter(name="securityProblemBasedAlertingProfile")
    def security_problem_based_alerting_profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        For security problem alerts, select an [alerting
        profile](https://www.terraform.io/ui/settings/builtin:appsec.notification-alerting-profile) to control the delivery of
        security notifications related to this integration.
        """
        return pulumi.get(self, "security_problem_based_alerting_profile")

    @security_problem_based_alerting_profile.setter
    def security_problem_based_alerting_profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_problem_based_alerting_profile", value)

    @property
    @pulumi.getter(name="securityProblemBasedEmailPayload")
    def security_problem_based_email_payload(self) -> Optional[pulumi.Input['AppsecNotificationSecurityProblemBasedEmailPayloadArgs']]:
        """
        Security problem based email payload, required when `trigger` equals `SECURITY_PROBLEM` and `type` equals `EMAIL`
        """
        return pulumi.get(self, "security_problem_based_email_payload")

    @security_problem_based_email_payload.setter
    def security_problem_based_email_payload(self, value: Optional[pulumi.Input['AppsecNotificationSecurityProblemBasedEmailPayloadArgs']]):
        pulumi.set(self, "security_problem_based_email_payload", value)

    @property
    @pulumi.getter(name="securityProblemBasedJiraPayload")
    def security_problem_based_jira_payload(self) -> Optional[pulumi.Input['AppsecNotificationSecurityProblemBasedJiraPayloadArgs']]:
        """
        Security problem based Jira payload, required when `trigger` equals `SECURITY_PROBLEM` and `type` equals `JIRA`
        """
        return pulumi.get(self, "security_problem_based_jira_payload")

    @security_problem_based_jira_payload.setter
    def security_problem_based_jira_payload(self, value: Optional[pulumi.Input['AppsecNotificationSecurityProblemBasedJiraPayloadArgs']]):
        pulumi.set(self, "security_problem_based_jira_payload", value)

    @property
    @pulumi.getter(name="securityProblemBasedWebhookPayload")
    def security_problem_based_webhook_payload(self) -> Optional[pulumi.Input['AppsecNotificationSecurityProblemBasedWebhookPayloadArgs']]:
        """
        Security problem based webhook payload, required when `trigger` equals `SECURITY_PROBLEM` and `type` equals `WEBHOOK`
        """
        return pulumi.get(self, "security_problem_based_webhook_payload")

    @security_problem_based_webhook_payload.setter
    def security_problem_based_webhook_payload(self, value: Optional[pulumi.Input['AppsecNotificationSecurityProblemBasedWebhookPayloadArgs']]):
        pulumi.set(self, "security_problem_based_webhook_payload", value)

    @property
    @pulumi.getter(name="webhookConfiguration")
    def webhook_configuration(self) -> Optional[pulumi.Input['AppsecNotificationWebhookConfigurationArgs']]:
        """
        Webhook configuration, required when `type` equals `WEBHOOK`
        """
        return pulumi.get(self, "webhook_configuration")

    @webhook_configuration.setter
    def webhook_configuration(self, value: Optional[pulumi.Input['AppsecNotificationWebhookConfigurationArgs']]):
        pulumi.set(self, "webhook_configuration", value)


@pulumi.input_type
class _AppsecNotificationState:
    def __init__(__self__, *,
                 attack_candidate_based_alerting_profile: Optional[pulumi.Input[builtins.str]] = None,
                 attack_candidate_based_email_payload: Optional[pulumi.Input['AppsecNotificationAttackCandidateBasedEmailPayloadArgs']] = None,
                 attack_candidate_based_jira_payload: Optional[pulumi.Input['AppsecNotificationAttackCandidateBasedJiraPayloadArgs']] = None,
                 attack_candidate_based_webhook_payload: Optional[pulumi.Input['AppsecNotificationAttackCandidateBasedWebhookPayloadArgs']] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 email_configuration: Optional[pulumi.Input['AppsecNotificationEmailConfigurationArgs']] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 jira_configuration: Optional[pulumi.Input['AppsecNotificationJiraConfigurationArgs']] = None,
                 security_problem_based_alerting_profile: Optional[pulumi.Input[builtins.str]] = None,
                 security_problem_based_email_payload: Optional[pulumi.Input['AppsecNotificationSecurityProblemBasedEmailPayloadArgs']] = None,
                 security_problem_based_jira_payload: Optional[pulumi.Input['AppsecNotificationSecurityProblemBasedJiraPayloadArgs']] = None,
                 security_problem_based_webhook_payload: Optional[pulumi.Input['AppsecNotificationSecurityProblemBasedWebhookPayloadArgs']] = None,
                 trigger: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 webhook_configuration: Optional[pulumi.Input['AppsecNotificationWebhookConfigurationArgs']] = None):
        """
        Input properties used for looking up and filtering AppsecNotification resources.
        :param pulumi.Input[builtins.str] attack_candidate_based_alerting_profile: For attack candidate alerts, select an [alerting
               profile](https://www.terraform.io/ui/settings/builtin:appsec.notification-attack-alerting-profile) to control the
               delivery of security notifications related to this integration.
        :param pulumi.Input['AppsecNotificationAttackCandidateBasedEmailPayloadArgs'] attack_candidate_based_email_payload: Attack candidate based email payload, required when `trigger` equals `ATTACK_CANDIDATE` and `type` equals `EMAIL`
        :param pulumi.Input['AppsecNotificationAttackCandidateBasedJiraPayloadArgs'] attack_candidate_based_jira_payload: Attack candidate based Jira payload, required when `trigger` equals `ATTACK_CANDIDATE` and `type` equals `JIRA`
        :param pulumi.Input['AppsecNotificationAttackCandidateBasedWebhookPayloadArgs'] attack_candidate_based_webhook_payload: Attack candidate based webhook payload, required when `trigger` equals `ATTACK_CANDIDATE` and `type` equals `WEBHOOK`
        :param pulumi.Input[builtins.str] display_name: Display name of the security notification
        :param pulumi.Input['AppsecNotificationEmailConfigurationArgs'] email_configuration: Email configuration, required when `type` equals `EMAIL`
        :param pulumi.Input[builtins.bool] enabled: Enable/Disable the security notification, enabled (`true`) or disabled (`false`)
        :param pulumi.Input['AppsecNotificationJiraConfigurationArgs'] jira_configuration: Jira configuration, required when `type` equals `JIRA`
        :param pulumi.Input[builtins.str] security_problem_based_alerting_profile: For security problem alerts, select an [alerting
               profile](https://www.terraform.io/ui/settings/builtin:appsec.notification-alerting-profile) to control the delivery of
               security notifications related to this integration.
        :param pulumi.Input['AppsecNotificationSecurityProblemBasedEmailPayloadArgs'] security_problem_based_email_payload: Security problem based email payload, required when `trigger` equals `SECURITY_PROBLEM` and `type` equals `EMAIL`
        :param pulumi.Input['AppsecNotificationSecurityProblemBasedJiraPayloadArgs'] security_problem_based_jira_payload: Security problem based Jira payload, required when `trigger` equals `SECURITY_PROBLEM` and `type` equals `JIRA`
        :param pulumi.Input['AppsecNotificationSecurityProblemBasedWebhookPayloadArgs'] security_problem_based_webhook_payload: Security problem based webhook payload, required when `trigger` equals `SECURITY_PROBLEM` and `type` equals `WEBHOOK`
        :param pulumi.Input[builtins.str] trigger: Security alert type, possible Values: `ATTACK_CANDIDATE`, `SECURITY_PROBLEM`
        :param pulumi.Input[builtins.str] type: Notification type, possible Values: `EMAIL`, `JIRA`, `WEBHOOK`
        :param pulumi.Input['AppsecNotificationWebhookConfigurationArgs'] webhook_configuration: Webhook configuration, required when `type` equals `WEBHOOK`
        """
        if attack_candidate_based_alerting_profile is not None:
            pulumi.set(__self__, "attack_candidate_based_alerting_profile", attack_candidate_based_alerting_profile)
        if attack_candidate_based_email_payload is not None:
            pulumi.set(__self__, "attack_candidate_based_email_payload", attack_candidate_based_email_payload)
        if attack_candidate_based_jira_payload is not None:
            pulumi.set(__self__, "attack_candidate_based_jira_payload", attack_candidate_based_jira_payload)
        if attack_candidate_based_webhook_payload is not None:
            pulumi.set(__self__, "attack_candidate_based_webhook_payload", attack_candidate_based_webhook_payload)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if email_configuration is not None:
            pulumi.set(__self__, "email_configuration", email_configuration)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if jira_configuration is not None:
            pulumi.set(__self__, "jira_configuration", jira_configuration)
        if security_problem_based_alerting_profile is not None:
            pulumi.set(__self__, "security_problem_based_alerting_profile", security_problem_based_alerting_profile)
        if security_problem_based_email_payload is not None:
            pulumi.set(__self__, "security_problem_based_email_payload", security_problem_based_email_payload)
        if security_problem_based_jira_payload is not None:
            pulumi.set(__self__, "security_problem_based_jira_payload", security_problem_based_jira_payload)
        if security_problem_based_webhook_payload is not None:
            pulumi.set(__self__, "security_problem_based_webhook_payload", security_problem_based_webhook_payload)
        if trigger is not None:
            pulumi.set(__self__, "trigger", trigger)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if webhook_configuration is not None:
            pulumi.set(__self__, "webhook_configuration", webhook_configuration)

    @property
    @pulumi.getter(name="attackCandidateBasedAlertingProfile")
    def attack_candidate_based_alerting_profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        For attack candidate alerts, select an [alerting
        profile](https://www.terraform.io/ui/settings/builtin:appsec.notification-attack-alerting-profile) to control the
        delivery of security notifications related to this integration.
        """
        return pulumi.get(self, "attack_candidate_based_alerting_profile")

    @attack_candidate_based_alerting_profile.setter
    def attack_candidate_based_alerting_profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "attack_candidate_based_alerting_profile", value)

    @property
    @pulumi.getter(name="attackCandidateBasedEmailPayload")
    def attack_candidate_based_email_payload(self) -> Optional[pulumi.Input['AppsecNotificationAttackCandidateBasedEmailPayloadArgs']]:
        """
        Attack candidate based email payload, required when `trigger` equals `ATTACK_CANDIDATE` and `type` equals `EMAIL`
        """
        return pulumi.get(self, "attack_candidate_based_email_payload")

    @attack_candidate_based_email_payload.setter
    def attack_candidate_based_email_payload(self, value: Optional[pulumi.Input['AppsecNotificationAttackCandidateBasedEmailPayloadArgs']]):
        pulumi.set(self, "attack_candidate_based_email_payload", value)

    @property
    @pulumi.getter(name="attackCandidateBasedJiraPayload")
    def attack_candidate_based_jira_payload(self) -> Optional[pulumi.Input['AppsecNotificationAttackCandidateBasedJiraPayloadArgs']]:
        """
        Attack candidate based Jira payload, required when `trigger` equals `ATTACK_CANDIDATE` and `type` equals `JIRA`
        """
        return pulumi.get(self, "attack_candidate_based_jira_payload")

    @attack_candidate_based_jira_payload.setter
    def attack_candidate_based_jira_payload(self, value: Optional[pulumi.Input['AppsecNotificationAttackCandidateBasedJiraPayloadArgs']]):
        pulumi.set(self, "attack_candidate_based_jira_payload", value)

    @property
    @pulumi.getter(name="attackCandidateBasedWebhookPayload")
    def attack_candidate_based_webhook_payload(self) -> Optional[pulumi.Input['AppsecNotificationAttackCandidateBasedWebhookPayloadArgs']]:
        """
        Attack candidate based webhook payload, required when `trigger` equals `ATTACK_CANDIDATE` and `type` equals `WEBHOOK`
        """
        return pulumi.get(self, "attack_candidate_based_webhook_payload")

    @attack_candidate_based_webhook_payload.setter
    def attack_candidate_based_webhook_payload(self, value: Optional[pulumi.Input['AppsecNotificationAttackCandidateBasedWebhookPayloadArgs']]):
        pulumi.set(self, "attack_candidate_based_webhook_payload", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Display name of the security notification
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="emailConfiguration")
    def email_configuration(self) -> Optional[pulumi.Input['AppsecNotificationEmailConfigurationArgs']]:
        """
        Email configuration, required when `type` equals `EMAIL`
        """
        return pulumi.get(self, "email_configuration")

    @email_configuration.setter
    def email_configuration(self, value: Optional[pulumi.Input['AppsecNotificationEmailConfigurationArgs']]):
        pulumi.set(self, "email_configuration", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable/Disable the security notification, enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="jiraConfiguration")
    def jira_configuration(self) -> Optional[pulumi.Input['AppsecNotificationJiraConfigurationArgs']]:
        """
        Jira configuration, required when `type` equals `JIRA`
        """
        return pulumi.get(self, "jira_configuration")

    @jira_configuration.setter
    def jira_configuration(self, value: Optional[pulumi.Input['AppsecNotificationJiraConfigurationArgs']]):
        pulumi.set(self, "jira_configuration", value)

    @property
    @pulumi.getter(name="securityProblemBasedAlertingProfile")
    def security_problem_based_alerting_profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        For security problem alerts, select an [alerting
        profile](https://www.terraform.io/ui/settings/builtin:appsec.notification-alerting-profile) to control the delivery of
        security notifications related to this integration.
        """
        return pulumi.get(self, "security_problem_based_alerting_profile")

    @security_problem_based_alerting_profile.setter
    def security_problem_based_alerting_profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_problem_based_alerting_profile", value)

    @property
    @pulumi.getter(name="securityProblemBasedEmailPayload")
    def security_problem_based_email_payload(self) -> Optional[pulumi.Input['AppsecNotificationSecurityProblemBasedEmailPayloadArgs']]:
        """
        Security problem based email payload, required when `trigger` equals `SECURITY_PROBLEM` and `type` equals `EMAIL`
        """
        return pulumi.get(self, "security_problem_based_email_payload")

    @security_problem_based_email_payload.setter
    def security_problem_based_email_payload(self, value: Optional[pulumi.Input['AppsecNotificationSecurityProblemBasedEmailPayloadArgs']]):
        pulumi.set(self, "security_problem_based_email_payload", value)

    @property
    @pulumi.getter(name="securityProblemBasedJiraPayload")
    def security_problem_based_jira_payload(self) -> Optional[pulumi.Input['AppsecNotificationSecurityProblemBasedJiraPayloadArgs']]:
        """
        Security problem based Jira payload, required when `trigger` equals `SECURITY_PROBLEM` and `type` equals `JIRA`
        """
        return pulumi.get(self, "security_problem_based_jira_payload")

    @security_problem_based_jira_payload.setter
    def security_problem_based_jira_payload(self, value: Optional[pulumi.Input['AppsecNotificationSecurityProblemBasedJiraPayloadArgs']]):
        pulumi.set(self, "security_problem_based_jira_payload", value)

    @property
    @pulumi.getter(name="securityProblemBasedWebhookPayload")
    def security_problem_based_webhook_payload(self) -> Optional[pulumi.Input['AppsecNotificationSecurityProblemBasedWebhookPayloadArgs']]:
        """
        Security problem based webhook payload, required when `trigger` equals `SECURITY_PROBLEM` and `type` equals `WEBHOOK`
        """
        return pulumi.get(self, "security_problem_based_webhook_payload")

    @security_problem_based_webhook_payload.setter
    def security_problem_based_webhook_payload(self, value: Optional[pulumi.Input['AppsecNotificationSecurityProblemBasedWebhookPayloadArgs']]):
        pulumi.set(self, "security_problem_based_webhook_payload", value)

    @property
    @pulumi.getter
    def trigger(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Security alert type, possible Values: `ATTACK_CANDIDATE`, `SECURITY_PROBLEM`
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trigger", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Notification type, possible Values: `EMAIL`, `JIRA`, `WEBHOOK`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="webhookConfiguration")
    def webhook_configuration(self) -> Optional[pulumi.Input['AppsecNotificationWebhookConfigurationArgs']]:
        """
        Webhook configuration, required when `type` equals `WEBHOOK`
        """
        return pulumi.get(self, "webhook_configuration")

    @webhook_configuration.setter
    def webhook_configuration(self, value: Optional[pulumi.Input['AppsecNotificationWebhookConfigurationArgs']]):
        pulumi.set(self, "webhook_configuration", value)


@pulumi.type_token("dynatrace:index/appsecNotification:AppsecNotification")
class AppsecNotification(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attack_candidate_based_alerting_profile: Optional[pulumi.Input[builtins.str]] = None,
                 attack_candidate_based_email_payload: Optional[pulumi.Input[Union['AppsecNotificationAttackCandidateBasedEmailPayloadArgs', 'AppsecNotificationAttackCandidateBasedEmailPayloadArgsDict']]] = None,
                 attack_candidate_based_jira_payload: Optional[pulumi.Input[Union['AppsecNotificationAttackCandidateBasedJiraPayloadArgs', 'AppsecNotificationAttackCandidateBasedJiraPayloadArgsDict']]] = None,
                 attack_candidate_based_webhook_payload: Optional[pulumi.Input[Union['AppsecNotificationAttackCandidateBasedWebhookPayloadArgs', 'AppsecNotificationAttackCandidateBasedWebhookPayloadArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 email_configuration: Optional[pulumi.Input[Union['AppsecNotificationEmailConfigurationArgs', 'AppsecNotificationEmailConfigurationArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 jira_configuration: Optional[pulumi.Input[Union['AppsecNotificationJiraConfigurationArgs', 'AppsecNotificationJiraConfigurationArgsDict']]] = None,
                 security_problem_based_alerting_profile: Optional[pulumi.Input[builtins.str]] = None,
                 security_problem_based_email_payload: Optional[pulumi.Input[Union['AppsecNotificationSecurityProblemBasedEmailPayloadArgs', 'AppsecNotificationSecurityProblemBasedEmailPayloadArgsDict']]] = None,
                 security_problem_based_jira_payload: Optional[pulumi.Input[Union['AppsecNotificationSecurityProblemBasedJiraPayloadArgs', 'AppsecNotificationSecurityProblemBasedJiraPayloadArgsDict']]] = None,
                 security_problem_based_webhook_payload: Optional[pulumi.Input[Union['AppsecNotificationSecurityProblemBasedWebhookPayloadArgs', 'AppsecNotificationSecurityProblemBasedWebhookPayloadArgsDict']]] = None,
                 trigger: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 webhook_configuration: Optional[pulumi.Input[Union['AppsecNotificationWebhookConfigurationArgs', 'AppsecNotificationWebhookConfigurationArgsDict']]] = None,
                 __props__=None):
        """
        Create a AppsecNotification resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] attack_candidate_based_alerting_profile: For attack candidate alerts, select an [alerting
               profile](https://www.terraform.io/ui/settings/builtin:appsec.notification-attack-alerting-profile) to control the
               delivery of security notifications related to this integration.
        :param pulumi.Input[Union['AppsecNotificationAttackCandidateBasedEmailPayloadArgs', 'AppsecNotificationAttackCandidateBasedEmailPayloadArgsDict']] attack_candidate_based_email_payload: Attack candidate based email payload, required when `trigger` equals `ATTACK_CANDIDATE` and `type` equals `EMAIL`
        :param pulumi.Input[Union['AppsecNotificationAttackCandidateBasedJiraPayloadArgs', 'AppsecNotificationAttackCandidateBasedJiraPayloadArgsDict']] attack_candidate_based_jira_payload: Attack candidate based Jira payload, required when `trigger` equals `ATTACK_CANDIDATE` and `type` equals `JIRA`
        :param pulumi.Input[Union['AppsecNotificationAttackCandidateBasedWebhookPayloadArgs', 'AppsecNotificationAttackCandidateBasedWebhookPayloadArgsDict']] attack_candidate_based_webhook_payload: Attack candidate based webhook payload, required when `trigger` equals `ATTACK_CANDIDATE` and `type` equals `WEBHOOK`
        :param pulumi.Input[builtins.str] display_name: Display name of the security notification
        :param pulumi.Input[Union['AppsecNotificationEmailConfigurationArgs', 'AppsecNotificationEmailConfigurationArgsDict']] email_configuration: Email configuration, required when `type` equals `EMAIL`
        :param pulumi.Input[builtins.bool] enabled: Enable/Disable the security notification, enabled (`true`) or disabled (`false`)
        :param pulumi.Input[Union['AppsecNotificationJiraConfigurationArgs', 'AppsecNotificationJiraConfigurationArgsDict']] jira_configuration: Jira configuration, required when `type` equals `JIRA`
        :param pulumi.Input[builtins.str] security_problem_based_alerting_profile: For security problem alerts, select an [alerting
               profile](https://www.terraform.io/ui/settings/builtin:appsec.notification-alerting-profile) to control the delivery of
               security notifications related to this integration.
        :param pulumi.Input[Union['AppsecNotificationSecurityProblemBasedEmailPayloadArgs', 'AppsecNotificationSecurityProblemBasedEmailPayloadArgsDict']] security_problem_based_email_payload: Security problem based email payload, required when `trigger` equals `SECURITY_PROBLEM` and `type` equals `EMAIL`
        :param pulumi.Input[Union['AppsecNotificationSecurityProblemBasedJiraPayloadArgs', 'AppsecNotificationSecurityProblemBasedJiraPayloadArgsDict']] security_problem_based_jira_payload: Security problem based Jira payload, required when `trigger` equals `SECURITY_PROBLEM` and `type` equals `JIRA`
        :param pulumi.Input[Union['AppsecNotificationSecurityProblemBasedWebhookPayloadArgs', 'AppsecNotificationSecurityProblemBasedWebhookPayloadArgsDict']] security_problem_based_webhook_payload: Security problem based webhook payload, required when `trigger` equals `SECURITY_PROBLEM` and `type` equals `WEBHOOK`
        :param pulumi.Input[builtins.str] trigger: Security alert type, possible Values: `ATTACK_CANDIDATE`, `SECURITY_PROBLEM`
        :param pulumi.Input[builtins.str] type: Notification type, possible Values: `EMAIL`, `JIRA`, `WEBHOOK`
        :param pulumi.Input[Union['AppsecNotificationWebhookConfigurationArgs', 'AppsecNotificationWebhookConfigurationArgsDict']] webhook_configuration: Webhook configuration, required when `type` equals `WEBHOOK`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppsecNotificationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AppsecNotification resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AppsecNotificationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppsecNotificationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attack_candidate_based_alerting_profile: Optional[pulumi.Input[builtins.str]] = None,
                 attack_candidate_based_email_payload: Optional[pulumi.Input[Union['AppsecNotificationAttackCandidateBasedEmailPayloadArgs', 'AppsecNotificationAttackCandidateBasedEmailPayloadArgsDict']]] = None,
                 attack_candidate_based_jira_payload: Optional[pulumi.Input[Union['AppsecNotificationAttackCandidateBasedJiraPayloadArgs', 'AppsecNotificationAttackCandidateBasedJiraPayloadArgsDict']]] = None,
                 attack_candidate_based_webhook_payload: Optional[pulumi.Input[Union['AppsecNotificationAttackCandidateBasedWebhookPayloadArgs', 'AppsecNotificationAttackCandidateBasedWebhookPayloadArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 email_configuration: Optional[pulumi.Input[Union['AppsecNotificationEmailConfigurationArgs', 'AppsecNotificationEmailConfigurationArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 jira_configuration: Optional[pulumi.Input[Union['AppsecNotificationJiraConfigurationArgs', 'AppsecNotificationJiraConfigurationArgsDict']]] = None,
                 security_problem_based_alerting_profile: Optional[pulumi.Input[builtins.str]] = None,
                 security_problem_based_email_payload: Optional[pulumi.Input[Union['AppsecNotificationSecurityProblemBasedEmailPayloadArgs', 'AppsecNotificationSecurityProblemBasedEmailPayloadArgsDict']]] = None,
                 security_problem_based_jira_payload: Optional[pulumi.Input[Union['AppsecNotificationSecurityProblemBasedJiraPayloadArgs', 'AppsecNotificationSecurityProblemBasedJiraPayloadArgsDict']]] = None,
                 security_problem_based_webhook_payload: Optional[pulumi.Input[Union['AppsecNotificationSecurityProblemBasedWebhookPayloadArgs', 'AppsecNotificationSecurityProblemBasedWebhookPayloadArgsDict']]] = None,
                 trigger: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 webhook_configuration: Optional[pulumi.Input[Union['AppsecNotificationWebhookConfigurationArgs', 'AppsecNotificationWebhookConfigurationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppsecNotificationArgs.__new__(AppsecNotificationArgs)

            __props__.__dict__["attack_candidate_based_alerting_profile"] = attack_candidate_based_alerting_profile
            __props__.__dict__["attack_candidate_based_email_payload"] = attack_candidate_based_email_payload
            __props__.__dict__["attack_candidate_based_jira_payload"] = attack_candidate_based_jira_payload
            __props__.__dict__["attack_candidate_based_webhook_payload"] = attack_candidate_based_webhook_payload
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["email_configuration"] = email_configuration
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["jira_configuration"] = jira_configuration
            __props__.__dict__["security_problem_based_alerting_profile"] = security_problem_based_alerting_profile
            __props__.__dict__["security_problem_based_email_payload"] = security_problem_based_email_payload
            __props__.__dict__["security_problem_based_jira_payload"] = security_problem_based_jira_payload
            __props__.__dict__["security_problem_based_webhook_payload"] = security_problem_based_webhook_payload
            if trigger is None and not opts.urn:
                raise TypeError("Missing required property 'trigger'")
            __props__.__dict__["trigger"] = trigger
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["webhook_configuration"] = webhook_configuration
        super(AppsecNotification, __self__).__init__(
            'dynatrace:index/appsecNotification:AppsecNotification',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attack_candidate_based_alerting_profile: Optional[pulumi.Input[builtins.str]] = None,
            attack_candidate_based_email_payload: Optional[pulumi.Input[Union['AppsecNotificationAttackCandidateBasedEmailPayloadArgs', 'AppsecNotificationAttackCandidateBasedEmailPayloadArgsDict']]] = None,
            attack_candidate_based_jira_payload: Optional[pulumi.Input[Union['AppsecNotificationAttackCandidateBasedJiraPayloadArgs', 'AppsecNotificationAttackCandidateBasedJiraPayloadArgsDict']]] = None,
            attack_candidate_based_webhook_payload: Optional[pulumi.Input[Union['AppsecNotificationAttackCandidateBasedWebhookPayloadArgs', 'AppsecNotificationAttackCandidateBasedWebhookPayloadArgsDict']]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            email_configuration: Optional[pulumi.Input[Union['AppsecNotificationEmailConfigurationArgs', 'AppsecNotificationEmailConfigurationArgsDict']]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            jira_configuration: Optional[pulumi.Input[Union['AppsecNotificationJiraConfigurationArgs', 'AppsecNotificationJiraConfigurationArgsDict']]] = None,
            security_problem_based_alerting_profile: Optional[pulumi.Input[builtins.str]] = None,
            security_problem_based_email_payload: Optional[pulumi.Input[Union['AppsecNotificationSecurityProblemBasedEmailPayloadArgs', 'AppsecNotificationSecurityProblemBasedEmailPayloadArgsDict']]] = None,
            security_problem_based_jira_payload: Optional[pulumi.Input[Union['AppsecNotificationSecurityProblemBasedJiraPayloadArgs', 'AppsecNotificationSecurityProblemBasedJiraPayloadArgsDict']]] = None,
            security_problem_based_webhook_payload: Optional[pulumi.Input[Union['AppsecNotificationSecurityProblemBasedWebhookPayloadArgs', 'AppsecNotificationSecurityProblemBasedWebhookPayloadArgsDict']]] = None,
            trigger: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            webhook_configuration: Optional[pulumi.Input[Union['AppsecNotificationWebhookConfigurationArgs', 'AppsecNotificationWebhookConfigurationArgsDict']]] = None) -> 'AppsecNotification':
        """
        Get an existing AppsecNotification resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] attack_candidate_based_alerting_profile: For attack candidate alerts, select an [alerting
               profile](https://www.terraform.io/ui/settings/builtin:appsec.notification-attack-alerting-profile) to control the
               delivery of security notifications related to this integration.
        :param pulumi.Input[Union['AppsecNotificationAttackCandidateBasedEmailPayloadArgs', 'AppsecNotificationAttackCandidateBasedEmailPayloadArgsDict']] attack_candidate_based_email_payload: Attack candidate based email payload, required when `trigger` equals `ATTACK_CANDIDATE` and `type` equals `EMAIL`
        :param pulumi.Input[Union['AppsecNotificationAttackCandidateBasedJiraPayloadArgs', 'AppsecNotificationAttackCandidateBasedJiraPayloadArgsDict']] attack_candidate_based_jira_payload: Attack candidate based Jira payload, required when `trigger` equals `ATTACK_CANDIDATE` and `type` equals `JIRA`
        :param pulumi.Input[Union['AppsecNotificationAttackCandidateBasedWebhookPayloadArgs', 'AppsecNotificationAttackCandidateBasedWebhookPayloadArgsDict']] attack_candidate_based_webhook_payload: Attack candidate based webhook payload, required when `trigger` equals `ATTACK_CANDIDATE` and `type` equals `WEBHOOK`
        :param pulumi.Input[builtins.str] display_name: Display name of the security notification
        :param pulumi.Input[Union['AppsecNotificationEmailConfigurationArgs', 'AppsecNotificationEmailConfigurationArgsDict']] email_configuration: Email configuration, required when `type` equals `EMAIL`
        :param pulumi.Input[builtins.bool] enabled: Enable/Disable the security notification, enabled (`true`) or disabled (`false`)
        :param pulumi.Input[Union['AppsecNotificationJiraConfigurationArgs', 'AppsecNotificationJiraConfigurationArgsDict']] jira_configuration: Jira configuration, required when `type` equals `JIRA`
        :param pulumi.Input[builtins.str] security_problem_based_alerting_profile: For security problem alerts, select an [alerting
               profile](https://www.terraform.io/ui/settings/builtin:appsec.notification-alerting-profile) to control the delivery of
               security notifications related to this integration.
        :param pulumi.Input[Union['AppsecNotificationSecurityProblemBasedEmailPayloadArgs', 'AppsecNotificationSecurityProblemBasedEmailPayloadArgsDict']] security_problem_based_email_payload: Security problem based email payload, required when `trigger` equals `SECURITY_PROBLEM` and `type` equals `EMAIL`
        :param pulumi.Input[Union['AppsecNotificationSecurityProblemBasedJiraPayloadArgs', 'AppsecNotificationSecurityProblemBasedJiraPayloadArgsDict']] security_problem_based_jira_payload: Security problem based Jira payload, required when `trigger` equals `SECURITY_PROBLEM` and `type` equals `JIRA`
        :param pulumi.Input[Union['AppsecNotificationSecurityProblemBasedWebhookPayloadArgs', 'AppsecNotificationSecurityProblemBasedWebhookPayloadArgsDict']] security_problem_based_webhook_payload: Security problem based webhook payload, required when `trigger` equals `SECURITY_PROBLEM` and `type` equals `WEBHOOK`
        :param pulumi.Input[builtins.str] trigger: Security alert type, possible Values: `ATTACK_CANDIDATE`, `SECURITY_PROBLEM`
        :param pulumi.Input[builtins.str] type: Notification type, possible Values: `EMAIL`, `JIRA`, `WEBHOOK`
        :param pulumi.Input[Union['AppsecNotificationWebhookConfigurationArgs', 'AppsecNotificationWebhookConfigurationArgsDict']] webhook_configuration: Webhook configuration, required when `type` equals `WEBHOOK`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppsecNotificationState.__new__(_AppsecNotificationState)

        __props__.__dict__["attack_candidate_based_alerting_profile"] = attack_candidate_based_alerting_profile
        __props__.__dict__["attack_candidate_based_email_payload"] = attack_candidate_based_email_payload
        __props__.__dict__["attack_candidate_based_jira_payload"] = attack_candidate_based_jira_payload
        __props__.__dict__["attack_candidate_based_webhook_payload"] = attack_candidate_based_webhook_payload
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["email_configuration"] = email_configuration
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["jira_configuration"] = jira_configuration
        __props__.__dict__["security_problem_based_alerting_profile"] = security_problem_based_alerting_profile
        __props__.__dict__["security_problem_based_email_payload"] = security_problem_based_email_payload
        __props__.__dict__["security_problem_based_jira_payload"] = security_problem_based_jira_payload
        __props__.__dict__["security_problem_based_webhook_payload"] = security_problem_based_webhook_payload
        __props__.__dict__["trigger"] = trigger
        __props__.__dict__["type"] = type
        __props__.__dict__["webhook_configuration"] = webhook_configuration
        return AppsecNotification(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="attackCandidateBasedAlertingProfile")
    def attack_candidate_based_alerting_profile(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        For attack candidate alerts, select an [alerting
        profile](https://www.terraform.io/ui/settings/builtin:appsec.notification-attack-alerting-profile) to control the
        delivery of security notifications related to this integration.
        """
        return pulumi.get(self, "attack_candidate_based_alerting_profile")

    @property
    @pulumi.getter(name="attackCandidateBasedEmailPayload")
    def attack_candidate_based_email_payload(self) -> pulumi.Output[Optional['outputs.AppsecNotificationAttackCandidateBasedEmailPayload']]:
        """
        Attack candidate based email payload, required when `trigger` equals `ATTACK_CANDIDATE` and `type` equals `EMAIL`
        """
        return pulumi.get(self, "attack_candidate_based_email_payload")

    @property
    @pulumi.getter(name="attackCandidateBasedJiraPayload")
    def attack_candidate_based_jira_payload(self) -> pulumi.Output[Optional['outputs.AppsecNotificationAttackCandidateBasedJiraPayload']]:
        """
        Attack candidate based Jira payload, required when `trigger` equals `ATTACK_CANDIDATE` and `type` equals `JIRA`
        """
        return pulumi.get(self, "attack_candidate_based_jira_payload")

    @property
    @pulumi.getter(name="attackCandidateBasedWebhookPayload")
    def attack_candidate_based_webhook_payload(self) -> pulumi.Output[Optional['outputs.AppsecNotificationAttackCandidateBasedWebhookPayload']]:
        """
        Attack candidate based webhook payload, required when `trigger` equals `ATTACK_CANDIDATE` and `type` equals `WEBHOOK`
        """
        return pulumi.get(self, "attack_candidate_based_webhook_payload")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        Display name of the security notification
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="emailConfiguration")
    def email_configuration(self) -> pulumi.Output[Optional['outputs.AppsecNotificationEmailConfiguration']]:
        """
        Email configuration, required when `type` equals `EMAIL`
        """
        return pulumi.get(self, "email_configuration")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Enable/Disable the security notification, enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="jiraConfiguration")
    def jira_configuration(self) -> pulumi.Output[Optional['outputs.AppsecNotificationJiraConfiguration']]:
        """
        Jira configuration, required when `type` equals `JIRA`
        """
        return pulumi.get(self, "jira_configuration")

    @property
    @pulumi.getter(name="securityProblemBasedAlertingProfile")
    def security_problem_based_alerting_profile(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        For security problem alerts, select an [alerting
        profile](https://www.terraform.io/ui/settings/builtin:appsec.notification-alerting-profile) to control the delivery of
        security notifications related to this integration.
        """
        return pulumi.get(self, "security_problem_based_alerting_profile")

    @property
    @pulumi.getter(name="securityProblemBasedEmailPayload")
    def security_problem_based_email_payload(self) -> pulumi.Output[Optional['outputs.AppsecNotificationSecurityProblemBasedEmailPayload']]:
        """
        Security problem based email payload, required when `trigger` equals `SECURITY_PROBLEM` and `type` equals `EMAIL`
        """
        return pulumi.get(self, "security_problem_based_email_payload")

    @property
    @pulumi.getter(name="securityProblemBasedJiraPayload")
    def security_problem_based_jira_payload(self) -> pulumi.Output[Optional['outputs.AppsecNotificationSecurityProblemBasedJiraPayload']]:
        """
        Security problem based Jira payload, required when `trigger` equals `SECURITY_PROBLEM` and `type` equals `JIRA`
        """
        return pulumi.get(self, "security_problem_based_jira_payload")

    @property
    @pulumi.getter(name="securityProblemBasedWebhookPayload")
    def security_problem_based_webhook_payload(self) -> pulumi.Output[Optional['outputs.AppsecNotificationSecurityProblemBasedWebhookPayload']]:
        """
        Security problem based webhook payload, required when `trigger` equals `SECURITY_PROBLEM` and `type` equals `WEBHOOK`
        """
        return pulumi.get(self, "security_problem_based_webhook_payload")

    @property
    @pulumi.getter
    def trigger(self) -> pulumi.Output[builtins.str]:
        """
        Security alert type, possible Values: `ATTACK_CANDIDATE`, `SECURITY_PROBLEM`
        """
        return pulumi.get(self, "trigger")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        Notification type, possible Values: `EMAIL`, `JIRA`, `WEBHOOK`
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="webhookConfiguration")
    def webhook_configuration(self) -> pulumi.Output[Optional['outputs.AppsecNotificationWebhookConfiguration']]:
        """
        Webhook configuration, required when `type` equals `WEBHOOK`
        """
        return pulumi.get(self, "webhook_configuration")

