# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AutomationSchedulingRuleArgs', 'AutomationSchedulingRule']

@pulumi.input_type
class AutomationSchedulingRuleArgs:
    def __init__(__self__, *,
                 title: pulumi.Input[builtins.str],
                 business_calendar: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 fixed_offset: Optional[pulumi.Input['AutomationSchedulingRuleFixedOffsetArgs']] = None,
                 grouping: Optional[pulumi.Input['AutomationSchedulingRuleGroupingArgs']] = None,
                 recurrence: Optional[pulumi.Input['AutomationSchedulingRuleRecurrenceArgs']] = None,
                 relative_offset: Optional[pulumi.Input['AutomationSchedulingRuleRelativeOffsetArgs']] = None):
        """
        The set of arguments for constructing a AutomationSchedulingRule resource.
        :param pulumi.Input[builtins.str] title: The title / name of the scheduling rule
        :param pulumi.Input[builtins.str] description: An optional description for the scheduling rule
        """
        pulumi.set(__self__, "title", title)
        if business_calendar is not None:
            pulumi.set(__self__, "business_calendar", business_calendar)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fixed_offset is not None:
            pulumi.set(__self__, "fixed_offset", fixed_offset)
        if grouping is not None:
            pulumi.set(__self__, "grouping", grouping)
        if recurrence is not None:
            pulumi.set(__self__, "recurrence", recurrence)
        if relative_offset is not None:
            pulumi.set(__self__, "relative_offset", relative_offset)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[builtins.str]:
        """
        The title / name of the scheduling rule
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter(name="businessCalendar")
    def business_calendar(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "business_calendar")

    @business_calendar.setter
    def business_calendar(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "business_calendar", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description for the scheduling rule
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fixedOffset")
    def fixed_offset(self) -> Optional[pulumi.Input['AutomationSchedulingRuleFixedOffsetArgs']]:
        return pulumi.get(self, "fixed_offset")

    @fixed_offset.setter
    def fixed_offset(self, value: Optional[pulumi.Input['AutomationSchedulingRuleFixedOffsetArgs']]):
        pulumi.set(self, "fixed_offset", value)

    @property
    @pulumi.getter
    def grouping(self) -> Optional[pulumi.Input['AutomationSchedulingRuleGroupingArgs']]:
        return pulumi.get(self, "grouping")

    @grouping.setter
    def grouping(self, value: Optional[pulumi.Input['AutomationSchedulingRuleGroupingArgs']]):
        pulumi.set(self, "grouping", value)

    @property
    @pulumi.getter
    def recurrence(self) -> Optional[pulumi.Input['AutomationSchedulingRuleRecurrenceArgs']]:
        return pulumi.get(self, "recurrence")

    @recurrence.setter
    def recurrence(self, value: Optional[pulumi.Input['AutomationSchedulingRuleRecurrenceArgs']]):
        pulumi.set(self, "recurrence", value)

    @property
    @pulumi.getter(name="relativeOffset")
    def relative_offset(self) -> Optional[pulumi.Input['AutomationSchedulingRuleRelativeOffsetArgs']]:
        return pulumi.get(self, "relative_offset")

    @relative_offset.setter
    def relative_offset(self, value: Optional[pulumi.Input['AutomationSchedulingRuleRelativeOffsetArgs']]):
        pulumi.set(self, "relative_offset", value)


@pulumi.input_type
class _AutomationSchedulingRuleState:
    def __init__(__self__, *,
                 business_calendar: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 fixed_offset: Optional[pulumi.Input['AutomationSchedulingRuleFixedOffsetArgs']] = None,
                 grouping: Optional[pulumi.Input['AutomationSchedulingRuleGroupingArgs']] = None,
                 recurrence: Optional[pulumi.Input['AutomationSchedulingRuleRecurrenceArgs']] = None,
                 relative_offset: Optional[pulumi.Input['AutomationSchedulingRuleRelativeOffsetArgs']] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AutomationSchedulingRule resources.
        :param pulumi.Input[builtins.str] description: An optional description for the scheduling rule
        :param pulumi.Input[builtins.str] title: The title / name of the scheduling rule
        """
        if business_calendar is not None:
            pulumi.set(__self__, "business_calendar", business_calendar)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fixed_offset is not None:
            pulumi.set(__self__, "fixed_offset", fixed_offset)
        if grouping is not None:
            pulumi.set(__self__, "grouping", grouping)
        if recurrence is not None:
            pulumi.set(__self__, "recurrence", recurrence)
        if relative_offset is not None:
            pulumi.set(__self__, "relative_offset", relative_offset)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="businessCalendar")
    def business_calendar(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "business_calendar")

    @business_calendar.setter
    def business_calendar(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "business_calendar", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description for the scheduling rule
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fixedOffset")
    def fixed_offset(self) -> Optional[pulumi.Input['AutomationSchedulingRuleFixedOffsetArgs']]:
        return pulumi.get(self, "fixed_offset")

    @fixed_offset.setter
    def fixed_offset(self, value: Optional[pulumi.Input['AutomationSchedulingRuleFixedOffsetArgs']]):
        pulumi.set(self, "fixed_offset", value)

    @property
    @pulumi.getter
    def grouping(self) -> Optional[pulumi.Input['AutomationSchedulingRuleGroupingArgs']]:
        return pulumi.get(self, "grouping")

    @grouping.setter
    def grouping(self, value: Optional[pulumi.Input['AutomationSchedulingRuleGroupingArgs']]):
        pulumi.set(self, "grouping", value)

    @property
    @pulumi.getter
    def recurrence(self) -> Optional[pulumi.Input['AutomationSchedulingRuleRecurrenceArgs']]:
        return pulumi.get(self, "recurrence")

    @recurrence.setter
    def recurrence(self, value: Optional[pulumi.Input['AutomationSchedulingRuleRecurrenceArgs']]):
        pulumi.set(self, "recurrence", value)

    @property
    @pulumi.getter(name="relativeOffset")
    def relative_offset(self) -> Optional[pulumi.Input['AutomationSchedulingRuleRelativeOffsetArgs']]:
        return pulumi.get(self, "relative_offset")

    @relative_offset.setter
    def relative_offset(self, value: Optional[pulumi.Input['AutomationSchedulingRuleRelativeOffsetArgs']]):
        pulumi.set(self, "relative_offset", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The title / name of the scheduling rule
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "title", value)


@pulumi.type_token("dynatrace:index/automationSchedulingRule:AutomationSchedulingRule")
class AutomationSchedulingRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 business_calendar: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 fixed_offset: Optional[pulumi.Input[Union['AutomationSchedulingRuleFixedOffsetArgs', 'AutomationSchedulingRuleFixedOffsetArgsDict']]] = None,
                 grouping: Optional[pulumi.Input[Union['AutomationSchedulingRuleGroupingArgs', 'AutomationSchedulingRuleGroupingArgsDict']]] = None,
                 recurrence: Optional[pulumi.Input[Union['AutomationSchedulingRuleRecurrenceArgs', 'AutomationSchedulingRuleRecurrenceArgsDict']]] = None,
                 relative_offset: Optional[pulumi.Input[Union['AutomationSchedulingRuleRelativeOffsetArgs', 'AutomationSchedulingRuleRelativeOffsetArgsDict']]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        > **Dynatrace SaaS only**

        > To utilize this resource, please define the environment variables `DT_CLIENT_ID`, `DT_CLIENT_SECRET`, `DT_ACCOUNT_ID` with an OAuth client including the following permissions: **View rules** (`automation:rules:read`) and **Create and edit rules** (`automation:rules:write`).

        > This resource is excluded by default in the export utility, please explicitly specify the resource to retrieve existing configuration.

        ## Dynatrace Documentation

        - Dynatrace Workflows - https://www.dynatrace.com/support/help/platform-modules/cloud-automation/workflows

        ## Resource Examples

        ### Recurrence Rule

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        calendar = dynatrace.AutomationBusinessCalendar("calendar",
            description="#name#",
            title="#name#",
            valid_from="2023-07-31",
            valid_to="2033-07-31",
            week_days=[
                1,
                2,
                3,
                4,
                5,
            ],
            week_start=1,
            holidays={
                "holidays": [
                    {
                        "date": "2023-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2023-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2023-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2023-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2023-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2023-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2024-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2024-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2024-04-01",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2024-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2024-05-09",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2024-05-20",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2024-05-30",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2024-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2024-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2024-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2024-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2024-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2024-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2025-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2025-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2025-04-21",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2025-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2025-05-29",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2025-06-09",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2025-06-19",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2025-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2025-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2025-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2025-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2025-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2025-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2026-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2026-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2026-04-06",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2026-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2026-05-14",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2026-05-25",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2026-06-04",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2026-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2026-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2026-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2026-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2026-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2026-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2027-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2027-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2027-03-29",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2027-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2027-05-06",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2027-05-17",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2027-05-27",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2027-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2027-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2027-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2027-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2027-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2027-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2028-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2028-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2028-04-17",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2028-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2028-05-25",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2028-06-05",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2028-06-15",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2028-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2028-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2028-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2028-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2028-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2028-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2029-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2029-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2029-04-02",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2029-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2029-05-10",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2029-05-21",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2029-05-31",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2029-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2029-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2029-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2029-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2029-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2029-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2030-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2030-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2030-04-22",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2030-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2030-05-30",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2030-06-10",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2030-06-20",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2030-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2030-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2030-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2030-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2030-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2030-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2031-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2031-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2031-04-14",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2031-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2031-05-22",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2031-06-02",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2031-06-12",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2031-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2031-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2031-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2031-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2031-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2031-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2032-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2032-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2032-03-29",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2032-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2032-05-06",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2032-05-17",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2032-05-27",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2032-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2032-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2032-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2032-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2032-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2032-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2033-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2033-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2033-04-18",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2033-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2033-05-26",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2033-06-06",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2033-06-16",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2023-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2024-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2025-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2026-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2027-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2028-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2029-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2030-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2031-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2032-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2033-07-31",
                        "title": "Reini Day",
                    },
                ],
            })
        _name_ = dynatrace.AutomationSchedulingRule("#name#",
            business_calendar=calendar.id,
            title="#name#",
            recurrence={
                "datestart": "2023-07-31",
                "days_in_months": [-1],
                "days_in_years": [
                    -2,
                    -1,
                    1,
                    2,
                    3,
                ],
                "frequency": "WEEKLY",
                "interval": 33,
                "months": [
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                ],
                "weekdays": [
                    "MO",
                    "TU",
                    "WE",
                ],
                "weeks": [
                    -2,
                    -1,
                    1,
                    2,
                    3,
                ],
                "workdays": "WORKING",
            })
        ```

        ### Fixed Offset Rule

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        calendar = dynatrace.AutomationBusinessCalendar("calendar",
            description="#name#",
            title="#name#",
            valid_from="2023-07-31",
            valid_to="2033-07-31",
            week_days=[
                1,
                2,
                3,
                4,
                5,
            ],
            week_start=1,
            holidays={
                "holidays": [
                    {
                        "date": "2023-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2023-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2023-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2023-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2023-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2023-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2024-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2024-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2024-04-01",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2024-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2024-05-09",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2024-05-20",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2024-05-30",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2024-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2024-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2024-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2024-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2024-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2024-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2025-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2025-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2025-04-21",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2025-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2025-05-29",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2025-06-09",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2025-06-19",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2025-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2025-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2025-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2025-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2025-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2025-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2026-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2026-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2026-04-06",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2026-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2026-05-14",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2026-05-25",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2026-06-04",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2026-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2026-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2026-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2026-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2026-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2026-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2027-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2027-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2027-03-29",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2027-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2027-05-06",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2027-05-17",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2027-05-27",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2027-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2027-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2027-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2027-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2027-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2027-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2028-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2028-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2028-04-17",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2028-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2028-05-25",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2028-06-05",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2028-06-15",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2028-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2028-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2028-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2028-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2028-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2028-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2029-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2029-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2029-04-02",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2029-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2029-05-10",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2029-05-21",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2029-05-31",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2029-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2029-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2029-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2029-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2029-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2029-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2030-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2030-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2030-04-22",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2030-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2030-05-30",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2030-06-10",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2030-06-20",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2030-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2030-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2030-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2030-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2030-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2030-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2031-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2031-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2031-04-14",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2031-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2031-05-22",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2031-06-02",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2031-06-12",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2031-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2031-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2031-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2031-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2031-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2031-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2032-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2032-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2032-03-29",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2032-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2032-05-06",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2032-05-17",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2032-05-27",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2032-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2032-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2032-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2032-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2032-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2032-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2033-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2033-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2033-04-18",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2033-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2033-05-26",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2033-06-06",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2033-06-16",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2023-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2024-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2025-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2026-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2027-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2028-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2029-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2030-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2031-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2032-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2033-07-31",
                        "title": "Reini Day",
                    },
                ],
            })
        base = dynatrace.AutomationSchedulingRule("base",
            business_calendar=calendar.id,
            title="#name#",
            recurrence={
                "datestart": "2023-07-31",
                "days_in_months": [-1],
                "days_in_years": [
                    -2,
                    -1,
                    1,
                    2,
                    3,
                ],
                "frequency": "WEEKLY",
                "interval": 33,
                "months": [
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                ],
                "weekdays": [
                    "MO",
                    "TU",
                    "WE",
                ],
                "weeks": [
                    -2,
                    -1,
                    1,
                    2,
                    3,
                ],
                "workdays": "WORKING",
            })
        _name_ = dynatrace.AutomationSchedulingRule("#name#",
            title="#name#",
            fixed_offset={
                "offset": 50,
                "rule": base.id,
            })
        ```

        ### Relative Offset rule

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        calendar = dynatrace.AutomationBusinessCalendar("calendar",
            description="#name#",
            title="#name#",
            valid_from="2023-07-31",
            valid_to="2033-07-31",
            week_days=[
                1,
                2,
                3,
                4,
                5,
            ],
            week_start=1,
            holidays={
                "holidays": [
                    {
                        "date": "2023-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2023-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2023-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2023-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2023-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2023-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2024-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2024-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2024-04-01",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2024-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2024-05-09",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2024-05-20",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2024-05-30",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2024-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2024-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2024-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2024-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2024-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2024-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2025-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2025-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2025-04-21",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2025-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2025-05-29",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2025-06-09",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2025-06-19",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2025-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2025-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2025-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2025-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2025-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2025-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2026-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2026-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2026-04-06",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2026-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2026-05-14",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2026-05-25",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2026-06-04",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2026-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2026-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2026-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2026-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2026-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2026-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2027-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2027-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2027-03-29",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2027-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2027-05-06",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2027-05-17",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2027-05-27",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2027-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2027-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2027-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2027-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2027-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2027-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2028-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2028-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2028-04-17",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2028-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2028-05-25",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2028-06-05",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2028-06-15",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2028-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2028-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2028-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2028-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2028-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2028-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2029-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2029-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2029-04-02",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2029-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2029-05-10",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2029-05-21",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2029-05-31",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2029-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2029-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2029-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2029-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2029-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2029-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2030-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2030-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2030-04-22",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2030-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2030-05-30",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2030-06-10",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2030-06-20",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2030-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2030-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2030-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2030-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2030-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2030-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2031-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2031-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2031-04-14",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2031-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2031-05-22",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2031-06-02",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2031-06-12",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2031-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2031-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2031-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2031-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2031-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2031-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2032-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2032-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2032-03-29",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2032-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2032-05-06",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2032-05-17",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2032-05-27",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2032-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2032-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2032-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2032-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2032-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2032-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2033-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2033-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2033-04-18",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2033-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2033-05-26",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2033-06-06",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2033-06-16",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2023-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2024-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2025-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2026-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2027-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2028-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2029-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2030-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2031-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2032-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2033-07-31",
                        "title": "Reini Day",
                    },
                ],
            })
        base = dynatrace.AutomationSchedulingRule("base",
            business_calendar=calendar.id,
            title="#name#",
            recurrence={
                "datestart": "2023-07-31",
                "days_in_months": [-1],
                "days_in_years": [
                    -2,
                    -1,
                    1,
                    2,
                    3,
                ],
                "frequency": "WEEKLY",
                "interval": 33,
                "months": [
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                ],
                "weekdays": [
                    "MO",
                    "TU",
                    "WE",
                ],
                "weeks": [
                    -2,
                    -1,
                    1,
                    2,
                    3,
                ],
                "workdays": "WORKING",
            })
        source = dynatrace.AutomationSchedulingRule("source",
            business_calendar=calendar.id,
            title="#name#",
            recurrence={
                "datestart": "2023-07-31",
                "days_in_months": [-1],
                "days_in_years": [
                    -2,
                    -1,
                    1,
                    2,
                    3,
                ],
                "frequency": "WEEKLY",
                "interval": 33,
                "months": [
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                ],
                "weekdays": [
                    "MO",
                    "TU",
                    "WE",
                ],
                "weeks": [
                    -2,
                    -1,
                    1,
                    2,
                    3,
                ],
                "workdays": "WORKING",
            })
        target = dynatrace.AutomationSchedulingRule("target",
            title="#name#",
            fixed_offset={
                "offset": 50,
                "rule": base.id,
            })
        _name_ = dynatrace.AutomationSchedulingRule("#name#",
            title="#name#",
            relative_offset={
                "direction": "previous",
                "source_rule": source.id,
                "target_rule": target.id,
            })
        ```

        ### Grouping Rule

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        calendar = dynatrace.AutomationBusinessCalendar("calendar",
            description="#name#",
            title="#name#",
            valid_from="2023-07-31",
            valid_to="2033-07-31",
            week_days=[
                1,
                2,
                3,
                4,
                5,
            ],
            week_start=1,
            holidays={
                "holidays": [
                    {
                        "date": "2023-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2023-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2023-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2023-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2023-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2023-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2024-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2024-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2024-04-01",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2024-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2024-05-09",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2024-05-20",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2024-05-30",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2024-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2024-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2024-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2024-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2024-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2024-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2025-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2025-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2025-04-21",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2025-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2025-05-29",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2025-06-09",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2025-06-19",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2025-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2025-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2025-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2025-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2025-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2025-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2026-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2026-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2026-04-06",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2026-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2026-05-14",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2026-05-25",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2026-06-04",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2026-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2026-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2026-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2026-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2026-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2026-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2027-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2027-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2027-03-29",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2027-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2027-05-06",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2027-05-17",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2027-05-27",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2027-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2027-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2027-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2027-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2027-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2027-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2028-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2028-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2028-04-17",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2028-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2028-05-25",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2028-06-05",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2028-06-15",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2028-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2028-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2028-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2028-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2028-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2028-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2029-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2029-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2029-04-02",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2029-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2029-05-10",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2029-05-21",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2029-05-31",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2029-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2029-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2029-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2029-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2029-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2029-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2030-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2030-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2030-04-22",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2030-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2030-05-30",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2030-06-10",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2030-06-20",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2030-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2030-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2030-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2030-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2030-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2030-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2031-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2031-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2031-04-14",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2031-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2031-05-22",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2031-06-02",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2031-06-12",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2031-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2031-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2031-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2031-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2031-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2031-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2032-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2032-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2032-03-29",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2032-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2032-05-06",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2032-05-17",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2032-05-27",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2032-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2032-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2032-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2032-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2032-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2032-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2033-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2033-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2033-04-18",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2033-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2033-05-26",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2033-06-06",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2033-06-16",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2023-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2024-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2025-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2026-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2027-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2028-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2029-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2030-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2031-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2032-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2033-07-31",
                        "title": "Reini Day",
                    },
                ],
            })
        subtract = dynatrace.AutomationSchedulingRule("subtract",
            business_calendar=calendar.id,
            title="#name#",
            recurrence={
                "datestart": "2029-07-31",
                "frequency": "DAILY",
                "interval": 1,
                "workdays": "WORKING",
            })
        comba = dynatrace.AutomationSchedulingRule("comba",
            business_calendar=calendar.id,
            title="#name#",
            recurrence={
                "datestart": "2023-07-31",
                "frequency": "DAILY",
                "interval": 1,
                "workdays": "WORKING",
            })
        combb = dynatrace.AutomationSchedulingRule("combb",
            business_calendar=calendar.id,
            title="#name#",
            recurrence={
                "datestart": "2023-07-31",
                "frequency": "DAILY",
                "interval": 1,
                "workdays": "WORKING",
            })
        intersect = dynatrace.AutomationSchedulingRule("intersect",
            business_calendar=calendar.id,
            title="#name#",
            recurrence={
                "datestart": "2023-07-31",
                "frequency": "DAILY",
                "interval": 1,
                "workdays": "WORKING",
            })
        _name_ = dynatrace.AutomationSchedulingRule("#name#",
            title="#name#",
            grouping={
                "combines": [
                    comba.id,
                    combb.id,
                ],
                "intersects": [intersect.id],
                "subtracts": [subtract.id],
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: An optional description for the scheduling rule
        :param pulumi.Input[builtins.str] title: The title / name of the scheduling rule
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutomationSchedulingRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **Dynatrace SaaS only**

        > To utilize this resource, please define the environment variables `DT_CLIENT_ID`, `DT_CLIENT_SECRET`, `DT_ACCOUNT_ID` with an OAuth client including the following permissions: **View rules** (`automation:rules:read`) and **Create and edit rules** (`automation:rules:write`).

        > This resource is excluded by default in the export utility, please explicitly specify the resource to retrieve existing configuration.

        ## Dynatrace Documentation

        - Dynatrace Workflows - https://www.dynatrace.com/support/help/platform-modules/cloud-automation/workflows

        ## Resource Examples

        ### Recurrence Rule

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        calendar = dynatrace.AutomationBusinessCalendar("calendar",
            description="#name#",
            title="#name#",
            valid_from="2023-07-31",
            valid_to="2033-07-31",
            week_days=[
                1,
                2,
                3,
                4,
                5,
            ],
            week_start=1,
            holidays={
                "holidays": [
                    {
                        "date": "2023-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2023-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2023-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2023-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2023-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2023-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2024-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2024-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2024-04-01",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2024-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2024-05-09",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2024-05-20",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2024-05-30",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2024-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2024-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2024-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2024-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2024-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2024-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2025-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2025-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2025-04-21",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2025-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2025-05-29",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2025-06-09",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2025-06-19",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2025-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2025-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2025-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2025-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2025-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2025-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2026-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2026-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2026-04-06",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2026-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2026-05-14",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2026-05-25",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2026-06-04",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2026-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2026-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2026-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2026-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2026-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2026-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2027-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2027-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2027-03-29",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2027-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2027-05-06",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2027-05-17",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2027-05-27",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2027-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2027-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2027-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2027-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2027-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2027-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2028-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2028-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2028-04-17",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2028-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2028-05-25",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2028-06-05",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2028-06-15",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2028-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2028-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2028-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2028-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2028-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2028-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2029-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2029-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2029-04-02",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2029-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2029-05-10",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2029-05-21",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2029-05-31",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2029-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2029-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2029-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2029-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2029-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2029-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2030-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2030-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2030-04-22",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2030-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2030-05-30",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2030-06-10",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2030-06-20",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2030-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2030-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2030-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2030-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2030-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2030-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2031-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2031-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2031-04-14",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2031-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2031-05-22",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2031-06-02",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2031-06-12",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2031-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2031-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2031-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2031-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2031-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2031-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2032-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2032-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2032-03-29",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2032-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2032-05-06",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2032-05-17",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2032-05-27",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2032-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2032-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2032-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2032-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2032-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2032-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2033-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2033-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2033-04-18",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2033-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2033-05-26",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2033-06-06",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2033-06-16",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2023-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2024-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2025-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2026-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2027-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2028-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2029-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2030-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2031-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2032-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2033-07-31",
                        "title": "Reini Day",
                    },
                ],
            })
        _name_ = dynatrace.AutomationSchedulingRule("#name#",
            business_calendar=calendar.id,
            title="#name#",
            recurrence={
                "datestart": "2023-07-31",
                "days_in_months": [-1],
                "days_in_years": [
                    -2,
                    -1,
                    1,
                    2,
                    3,
                ],
                "frequency": "WEEKLY",
                "interval": 33,
                "months": [
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                ],
                "weekdays": [
                    "MO",
                    "TU",
                    "WE",
                ],
                "weeks": [
                    -2,
                    -1,
                    1,
                    2,
                    3,
                ],
                "workdays": "WORKING",
            })
        ```

        ### Fixed Offset Rule

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        calendar = dynatrace.AutomationBusinessCalendar("calendar",
            description="#name#",
            title="#name#",
            valid_from="2023-07-31",
            valid_to="2033-07-31",
            week_days=[
                1,
                2,
                3,
                4,
                5,
            ],
            week_start=1,
            holidays={
                "holidays": [
                    {
                        "date": "2023-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2023-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2023-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2023-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2023-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2023-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2024-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2024-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2024-04-01",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2024-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2024-05-09",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2024-05-20",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2024-05-30",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2024-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2024-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2024-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2024-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2024-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2024-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2025-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2025-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2025-04-21",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2025-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2025-05-29",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2025-06-09",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2025-06-19",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2025-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2025-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2025-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2025-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2025-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2025-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2026-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2026-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2026-04-06",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2026-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2026-05-14",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2026-05-25",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2026-06-04",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2026-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2026-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2026-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2026-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2026-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2026-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2027-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2027-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2027-03-29",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2027-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2027-05-06",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2027-05-17",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2027-05-27",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2027-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2027-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2027-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2027-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2027-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2027-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2028-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2028-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2028-04-17",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2028-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2028-05-25",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2028-06-05",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2028-06-15",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2028-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2028-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2028-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2028-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2028-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2028-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2029-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2029-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2029-04-02",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2029-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2029-05-10",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2029-05-21",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2029-05-31",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2029-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2029-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2029-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2029-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2029-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2029-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2030-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2030-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2030-04-22",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2030-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2030-05-30",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2030-06-10",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2030-06-20",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2030-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2030-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2030-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2030-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2030-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2030-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2031-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2031-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2031-04-14",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2031-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2031-05-22",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2031-06-02",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2031-06-12",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2031-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2031-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2031-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2031-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2031-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2031-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2032-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2032-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2032-03-29",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2032-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2032-05-06",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2032-05-17",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2032-05-27",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2032-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2032-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2032-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2032-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2032-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2032-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2033-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2033-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2033-04-18",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2033-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2033-05-26",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2033-06-06",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2033-06-16",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2023-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2024-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2025-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2026-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2027-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2028-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2029-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2030-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2031-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2032-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2033-07-31",
                        "title": "Reini Day",
                    },
                ],
            })
        base = dynatrace.AutomationSchedulingRule("base",
            business_calendar=calendar.id,
            title="#name#",
            recurrence={
                "datestart": "2023-07-31",
                "days_in_months": [-1],
                "days_in_years": [
                    -2,
                    -1,
                    1,
                    2,
                    3,
                ],
                "frequency": "WEEKLY",
                "interval": 33,
                "months": [
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                ],
                "weekdays": [
                    "MO",
                    "TU",
                    "WE",
                ],
                "weeks": [
                    -2,
                    -1,
                    1,
                    2,
                    3,
                ],
                "workdays": "WORKING",
            })
        _name_ = dynatrace.AutomationSchedulingRule("#name#",
            title="#name#",
            fixed_offset={
                "offset": 50,
                "rule": base.id,
            })
        ```

        ### Relative Offset rule

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        calendar = dynatrace.AutomationBusinessCalendar("calendar",
            description="#name#",
            title="#name#",
            valid_from="2023-07-31",
            valid_to="2033-07-31",
            week_days=[
                1,
                2,
                3,
                4,
                5,
            ],
            week_start=1,
            holidays={
                "holidays": [
                    {
                        "date": "2023-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2023-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2023-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2023-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2023-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2023-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2024-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2024-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2024-04-01",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2024-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2024-05-09",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2024-05-20",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2024-05-30",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2024-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2024-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2024-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2024-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2024-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2024-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2025-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2025-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2025-04-21",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2025-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2025-05-29",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2025-06-09",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2025-06-19",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2025-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2025-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2025-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2025-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2025-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2025-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2026-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2026-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2026-04-06",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2026-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2026-05-14",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2026-05-25",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2026-06-04",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2026-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2026-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2026-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2026-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2026-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2026-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2027-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2027-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2027-03-29",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2027-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2027-05-06",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2027-05-17",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2027-05-27",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2027-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2027-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2027-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2027-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2027-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2027-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2028-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2028-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2028-04-17",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2028-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2028-05-25",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2028-06-05",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2028-06-15",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2028-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2028-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2028-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2028-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2028-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2028-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2029-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2029-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2029-04-02",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2029-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2029-05-10",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2029-05-21",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2029-05-31",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2029-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2029-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2029-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2029-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2029-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2029-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2030-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2030-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2030-04-22",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2030-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2030-05-30",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2030-06-10",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2030-06-20",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2030-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2030-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2030-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2030-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2030-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2030-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2031-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2031-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2031-04-14",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2031-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2031-05-22",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2031-06-02",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2031-06-12",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2031-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2031-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2031-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2031-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2031-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2031-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2032-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2032-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2032-03-29",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2032-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2032-05-06",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2032-05-17",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2032-05-27",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2032-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2032-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2032-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2032-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2032-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2032-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2033-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2033-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2033-04-18",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2033-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2033-05-26",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2033-06-06",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2033-06-16",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2023-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2024-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2025-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2026-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2027-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2028-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2029-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2030-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2031-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2032-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2033-07-31",
                        "title": "Reini Day",
                    },
                ],
            })
        base = dynatrace.AutomationSchedulingRule("base",
            business_calendar=calendar.id,
            title="#name#",
            recurrence={
                "datestart": "2023-07-31",
                "days_in_months": [-1],
                "days_in_years": [
                    -2,
                    -1,
                    1,
                    2,
                    3,
                ],
                "frequency": "WEEKLY",
                "interval": 33,
                "months": [
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                ],
                "weekdays": [
                    "MO",
                    "TU",
                    "WE",
                ],
                "weeks": [
                    -2,
                    -1,
                    1,
                    2,
                    3,
                ],
                "workdays": "WORKING",
            })
        source = dynatrace.AutomationSchedulingRule("source",
            business_calendar=calendar.id,
            title="#name#",
            recurrence={
                "datestart": "2023-07-31",
                "days_in_months": [-1],
                "days_in_years": [
                    -2,
                    -1,
                    1,
                    2,
                    3,
                ],
                "frequency": "WEEKLY",
                "interval": 33,
                "months": [
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                ],
                "weekdays": [
                    "MO",
                    "TU",
                    "WE",
                ],
                "weeks": [
                    -2,
                    -1,
                    1,
                    2,
                    3,
                ],
                "workdays": "WORKING",
            })
        target = dynatrace.AutomationSchedulingRule("target",
            title="#name#",
            fixed_offset={
                "offset": 50,
                "rule": base.id,
            })
        _name_ = dynatrace.AutomationSchedulingRule("#name#",
            title="#name#",
            relative_offset={
                "direction": "previous",
                "source_rule": source.id,
                "target_rule": target.id,
            })
        ```

        ### Grouping Rule

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        calendar = dynatrace.AutomationBusinessCalendar("calendar",
            description="#name#",
            title="#name#",
            valid_from="2023-07-31",
            valid_to="2033-07-31",
            week_days=[
                1,
                2,
                3,
                4,
                5,
            ],
            week_start=1,
            holidays={
                "holidays": [
                    {
                        "date": "2023-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2023-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2023-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2023-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2023-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2023-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2024-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2024-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2024-04-01",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2024-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2024-05-09",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2024-05-20",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2024-05-30",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2024-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2024-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2024-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2024-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2024-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2024-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2025-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2025-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2025-04-21",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2025-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2025-05-29",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2025-06-09",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2025-06-19",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2025-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2025-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2025-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2025-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2025-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2025-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2026-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2026-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2026-04-06",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2026-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2026-05-14",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2026-05-25",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2026-06-04",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2026-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2026-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2026-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2026-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2026-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2026-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2027-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2027-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2027-03-29",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2027-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2027-05-06",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2027-05-17",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2027-05-27",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2027-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2027-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2027-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2027-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2027-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2027-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2028-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2028-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2028-04-17",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2028-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2028-05-25",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2028-06-05",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2028-06-15",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2028-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2028-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2028-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2028-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2028-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2028-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2029-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2029-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2029-04-02",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2029-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2029-05-10",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2029-05-21",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2029-05-31",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2029-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2029-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2029-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2029-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2029-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2029-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2030-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2030-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2030-04-22",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2030-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2030-05-30",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2030-06-10",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2030-06-20",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2030-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2030-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2030-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2030-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2030-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2030-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2031-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2031-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2031-04-14",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2031-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2031-05-22",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2031-06-02",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2031-06-12",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2031-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2031-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2031-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2031-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2031-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2031-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2032-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2032-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2032-03-29",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2032-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2032-05-06",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2032-05-17",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2032-05-27",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2032-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2032-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2032-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2032-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2032-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2032-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2033-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2033-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2033-04-18",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2033-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2033-05-26",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2033-06-06",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2033-06-16",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2023-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2024-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2025-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2026-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2027-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2028-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2029-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2030-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2031-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2032-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2033-07-31",
                        "title": "Reini Day",
                    },
                ],
            })
        subtract = dynatrace.AutomationSchedulingRule("subtract",
            business_calendar=calendar.id,
            title="#name#",
            recurrence={
                "datestart": "2029-07-31",
                "frequency": "DAILY",
                "interval": 1,
                "workdays": "WORKING",
            })
        comba = dynatrace.AutomationSchedulingRule("comba",
            business_calendar=calendar.id,
            title="#name#",
            recurrence={
                "datestart": "2023-07-31",
                "frequency": "DAILY",
                "interval": 1,
                "workdays": "WORKING",
            })
        combb = dynatrace.AutomationSchedulingRule("combb",
            business_calendar=calendar.id,
            title="#name#",
            recurrence={
                "datestart": "2023-07-31",
                "frequency": "DAILY",
                "interval": 1,
                "workdays": "WORKING",
            })
        intersect = dynatrace.AutomationSchedulingRule("intersect",
            business_calendar=calendar.id,
            title="#name#",
            recurrence={
                "datestart": "2023-07-31",
                "frequency": "DAILY",
                "interval": 1,
                "workdays": "WORKING",
            })
        _name_ = dynatrace.AutomationSchedulingRule("#name#",
            title="#name#",
            grouping={
                "combines": [
                    comba.id,
                    combb.id,
                ],
                "intersects": [intersect.id],
                "subtracts": [subtract.id],
            })
        ```

        :param str resource_name: The name of the resource.
        :param AutomationSchedulingRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutomationSchedulingRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 business_calendar: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 fixed_offset: Optional[pulumi.Input[Union['AutomationSchedulingRuleFixedOffsetArgs', 'AutomationSchedulingRuleFixedOffsetArgsDict']]] = None,
                 grouping: Optional[pulumi.Input[Union['AutomationSchedulingRuleGroupingArgs', 'AutomationSchedulingRuleGroupingArgsDict']]] = None,
                 recurrence: Optional[pulumi.Input[Union['AutomationSchedulingRuleRecurrenceArgs', 'AutomationSchedulingRuleRecurrenceArgsDict']]] = None,
                 relative_offset: Optional[pulumi.Input[Union['AutomationSchedulingRuleRelativeOffsetArgs', 'AutomationSchedulingRuleRelativeOffsetArgsDict']]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutomationSchedulingRuleArgs.__new__(AutomationSchedulingRuleArgs)

            __props__.__dict__["business_calendar"] = business_calendar
            __props__.__dict__["description"] = description
            __props__.__dict__["fixed_offset"] = fixed_offset
            __props__.__dict__["grouping"] = grouping
            __props__.__dict__["recurrence"] = recurrence
            __props__.__dict__["relative_offset"] = relative_offset
            if title is None and not opts.urn:
                raise TypeError("Missing required property 'title'")
            __props__.__dict__["title"] = title
        super(AutomationSchedulingRule, __self__).__init__(
            'dynatrace:index/automationSchedulingRule:AutomationSchedulingRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            business_calendar: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            fixed_offset: Optional[pulumi.Input[Union['AutomationSchedulingRuleFixedOffsetArgs', 'AutomationSchedulingRuleFixedOffsetArgsDict']]] = None,
            grouping: Optional[pulumi.Input[Union['AutomationSchedulingRuleGroupingArgs', 'AutomationSchedulingRuleGroupingArgsDict']]] = None,
            recurrence: Optional[pulumi.Input[Union['AutomationSchedulingRuleRecurrenceArgs', 'AutomationSchedulingRuleRecurrenceArgsDict']]] = None,
            relative_offset: Optional[pulumi.Input[Union['AutomationSchedulingRuleRelativeOffsetArgs', 'AutomationSchedulingRuleRelativeOffsetArgsDict']]] = None,
            title: Optional[pulumi.Input[builtins.str]] = None) -> 'AutomationSchedulingRule':
        """
        Get an existing AutomationSchedulingRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: An optional description for the scheduling rule
        :param pulumi.Input[builtins.str] title: The title / name of the scheduling rule
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutomationSchedulingRuleState.__new__(_AutomationSchedulingRuleState)

        __props__.__dict__["business_calendar"] = business_calendar
        __props__.__dict__["description"] = description
        __props__.__dict__["fixed_offset"] = fixed_offset
        __props__.__dict__["grouping"] = grouping
        __props__.__dict__["recurrence"] = recurrence
        __props__.__dict__["relative_offset"] = relative_offset
        __props__.__dict__["title"] = title
        return AutomationSchedulingRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="businessCalendar")
    def business_calendar(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "business_calendar")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional description for the scheduling rule
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fixedOffset")
    def fixed_offset(self) -> pulumi.Output[Optional['outputs.AutomationSchedulingRuleFixedOffset']]:
        return pulumi.get(self, "fixed_offset")

    @property
    @pulumi.getter
    def grouping(self) -> pulumi.Output[Optional['outputs.AutomationSchedulingRuleGrouping']]:
        return pulumi.get(self, "grouping")

    @property
    @pulumi.getter
    def recurrence(self) -> pulumi.Output[Optional['outputs.AutomationSchedulingRuleRecurrence']]:
        return pulumi.get(self, "recurrence")

    @property
    @pulumi.getter(name="relativeOffset")
    def relative_offset(self) -> pulumi.Output[Optional['outputs.AutomationSchedulingRuleRelativeOffset']]:
        return pulumi.get(self, "relative_offset")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[builtins.str]:
        """
        The title / name of the scheduling rule
        """
        return pulumi.get(self, "title")

