# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AutomationWorkflowArgs', 'AutomationWorkflow']

@pulumi.input_type
class AutomationWorkflowArgs:
    def __init__(__self__, *,
                 tasks: pulumi.Input['AutomationWorkflowTasksArgs'],
                 title: pulumi.Input[builtins.str],
                 actor: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 owner: Optional[pulumi.Input[builtins.str]] = None,
                 private: Optional[pulumi.Input[builtins.bool]] = None,
                 trigger: Optional[pulumi.Input['AutomationWorkflowTriggerArgs']] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AutomationWorkflow resource.
        :param pulumi.Input['AutomationWorkflowTasksArgs'] tasks: The tasks to run for every execution of this workflow
        :param pulumi.Input[builtins.str] title: The title / name of the workflow
        :param pulumi.Input[builtins.str] actor: The user context the executions of the workflow will happen with
        :param pulumi.Input[builtins.str] description: An optional description for the workflow
        :param pulumi.Input[builtins.str] owner: The ID of the owner of this workflow
        :param pulumi.Input[builtins.bool] private: Defines whether this workflow is private to the owner or not. Default is `true`
        :param pulumi.Input['AutomationWorkflowTriggerArgs'] trigger: Configures how executions of the workflows are getting triggered. If no trigger is specified it means the workflow is getting manually triggered
        :param pulumi.Input[builtins.str] type: The type of the workflow. Possible values are `STANDARD` and `SIMPLE`. Defaults to `STANDARD`. Workflows of type `SIMPLE` are allowed to contain only one action
        """
        pulumi.set(__self__, "tasks", tasks)
        pulumi.set(__self__, "title", title)
        if actor is not None:
            pulumi.set(__self__, "actor", actor)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if private is not None:
            pulumi.set(__self__, "private", private)
        if trigger is not None:
            pulumi.set(__self__, "trigger", trigger)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def tasks(self) -> pulumi.Input['AutomationWorkflowTasksArgs']:
        """
        The tasks to run for every execution of this workflow
        """
        return pulumi.get(self, "tasks")

    @tasks.setter
    def tasks(self, value: pulumi.Input['AutomationWorkflowTasksArgs']):
        pulumi.set(self, "tasks", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[builtins.str]:
        """
        The title / name of the workflow
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def actor(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user context the executions of the workflow will happen with
        """
        return pulumi.get(self, "actor")

    @actor.setter
    def actor(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "actor", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description for the workflow
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the owner of this workflow
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def private(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Defines whether this workflow is private to the owner or not. Default is `true`
        """
        return pulumi.get(self, "private")

    @private.setter
    def private(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "private", value)

    @property
    @pulumi.getter
    def trigger(self) -> Optional[pulumi.Input['AutomationWorkflowTriggerArgs']]:
        """
        Configures how executions of the workflows are getting triggered. If no trigger is specified it means the workflow is getting manually triggered
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: Optional[pulumi.Input['AutomationWorkflowTriggerArgs']]):
        pulumi.set(self, "trigger", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the workflow. Possible values are `STANDARD` and `SIMPLE`. Defaults to `STANDARD`. Workflows of type `SIMPLE` are allowed to contain only one action
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _AutomationWorkflowState:
    def __init__(__self__, *,
                 actor: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 owner: Optional[pulumi.Input[builtins.str]] = None,
                 private: Optional[pulumi.Input[builtins.bool]] = None,
                 tasks: Optional[pulumi.Input['AutomationWorkflowTasksArgs']] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None,
                 trigger: Optional[pulumi.Input['AutomationWorkflowTriggerArgs']] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AutomationWorkflow resources.
        :param pulumi.Input[builtins.str] actor: The user context the executions of the workflow will happen with
        :param pulumi.Input[builtins.str] description: An optional description for the workflow
        :param pulumi.Input[builtins.str] owner: The ID of the owner of this workflow
        :param pulumi.Input[builtins.bool] private: Defines whether this workflow is private to the owner or not. Default is `true`
        :param pulumi.Input['AutomationWorkflowTasksArgs'] tasks: The tasks to run for every execution of this workflow
        :param pulumi.Input[builtins.str] title: The title / name of the workflow
        :param pulumi.Input['AutomationWorkflowTriggerArgs'] trigger: Configures how executions of the workflows are getting triggered. If no trigger is specified it means the workflow is getting manually triggered
        :param pulumi.Input[builtins.str] type: The type of the workflow. Possible values are `STANDARD` and `SIMPLE`. Defaults to `STANDARD`. Workflows of type `SIMPLE` are allowed to contain only one action
        """
        if actor is not None:
            pulumi.set(__self__, "actor", actor)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if private is not None:
            pulumi.set(__self__, "private", private)
        if tasks is not None:
            pulumi.set(__self__, "tasks", tasks)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if trigger is not None:
            pulumi.set(__self__, "trigger", trigger)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def actor(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user context the executions of the workflow will happen with
        """
        return pulumi.get(self, "actor")

    @actor.setter
    def actor(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "actor", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description for the workflow
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the owner of this workflow
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def private(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Defines whether this workflow is private to the owner or not. Default is `true`
        """
        return pulumi.get(self, "private")

    @private.setter
    def private(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "private", value)

    @property
    @pulumi.getter
    def tasks(self) -> Optional[pulumi.Input['AutomationWorkflowTasksArgs']]:
        """
        The tasks to run for every execution of this workflow
        """
        return pulumi.get(self, "tasks")

    @tasks.setter
    def tasks(self, value: Optional[pulumi.Input['AutomationWorkflowTasksArgs']]):
        pulumi.set(self, "tasks", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The title / name of the workflow
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def trigger(self) -> Optional[pulumi.Input['AutomationWorkflowTriggerArgs']]:
        """
        Configures how executions of the workflows are getting triggered. If no trigger is specified it means the workflow is getting manually triggered
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: Optional[pulumi.Input['AutomationWorkflowTriggerArgs']]):
        pulumi.set(self, "trigger", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the workflow. Possible values are `STANDARD` and `SIMPLE`. Defaults to `STANDARD`. Workflows of type `SIMPLE` are allowed to contain only one action
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("dynatrace:index/automationWorkflow:AutomationWorkflow")
class AutomationWorkflow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actor: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 owner: Optional[pulumi.Input[builtins.str]] = None,
                 private: Optional[pulumi.Input[builtins.bool]] = None,
                 tasks: Optional[pulumi.Input[Union['AutomationWorkflowTasksArgs', 'AutomationWorkflowTasksArgsDict']]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None,
                 trigger: Optional[pulumi.Input[Union['AutomationWorkflowTriggerArgs', 'AutomationWorkflowTriggerArgsDict']]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        > **Dynatrace SaaS only**

        > To utilize this resource, please define the environment variables `DT_CLIENT_ID`, `DT_CLIENT_SECRET`, `DT_ACCOUNT_ID` with an OAuth client including the following permissions: **View workflows** (`automation:workflows:read`) and **Create and edit workflows** (`automation:workflows:write`).

        > This resource is excluded by default in the export utility, please explicitly specify the resource to retrieve existing configuration.

        ## Dynatrace Documentation

        - Dynatrace Workflows - https://www.dynatrace.com/support/help/platform-modules/cloud-automation/workflows

        ## Resource Example Usage

        ```python
        import pulumi
        import json
        import pulumiverse_dynatrace as dynatrace

        sample_worklow_tf = dynatrace.AutomationWorkflow("sampleWorklowTF",
            description="Desc",
            actor="########-####-####-####-############",
            title="Sample Worklow TF1",
            owner="########-####-####-####-############",
            private=True,
            tasks={
                "tasks": [
                    {
                        "name": "http_request_1",
                        "description": "Issue an HTTP request to any API",
                        "action": "dynatrace.automations:http-function",
                        "active": True,
                        "input": json.dumps({
                            "method": "GET",
                            "url": "https://www.google.at/",
                        }),
                        "position": {
                            "x": 0,
                            "y": 1,
                        },
                    },
                    {
                        "name": "http_request_2",
                        "description": "Issue an HTTP request to any API",
                        "action": "dynatrace.automations:http-function",
                        "active": False,
                        "input": json.dumps({
                            "method": "GET",
                            "url": "https://www.second-task.com/",
                        }),
                        "conditions": {
                            "states": {
                                "http_request_1": "SUCCESS",
                                "run_javascript_1": "OK",
                            },
                            "custom": "",
                        },
                        "position": {
                            "x": -1,
                            "y": 2,
                        },
                        "timeout": "50000",
                    },
                    {
                        "name": "http_request_3",
                        "description": "Issue an HTTP request to any API",
                        "action": "dynatrace.automations:http-function",
                        "active": False,
                        "input": json.dumps({
                            "method": "GET",
                            "url": "https://www.third-task.com",
                        }),
                        "conditions": {
                            "states": {
                                "http_request_2": "OK",
                            },
                            "custom": "{{http_request_1}}",
                        },
                        "position": {
                            "x": 0,
                            "y": 3,
                        },
                    },
                    {
                        "name": "run_javascript_1",
                        "description": "Build a custom task running js Code",
                        "action": "dynatrace.automations:run-javascript",
                        "active": False,
                        "input": json.dumps({
                            "script": \"\"\"// optional import of sdk modules
        import { execution } from '@dynatrace-sdk/automation-utils';

        export default async function ({ execution_id }) {
          // your code goes here
          // e.g. get the current execution
          const ex = await execution(execution_id);
          console.log('Automated script execution on behalf of', ex.trigger);
          
          return { triggeredBy: ex.trigger };
        }\"\"\",
                        }),
                        "position": {
                            "x": -2,
                            "y": 1,
                        },
                    },
                ],
            },
            trigger={
                "event": {
                    "active": False,
                    "config": {
                        "davis_event": {
                            "entity_tags_match": "all",
                            "entity_tags": {
                                "asdf": "",
                            },
                            "on_problem_close": False,
                            "types": ["CUSTOM_ANNOTATION"],
                        },
                    },
                },
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] actor: The user context the executions of the workflow will happen with
        :param pulumi.Input[builtins.str] description: An optional description for the workflow
        :param pulumi.Input[builtins.str] owner: The ID of the owner of this workflow
        :param pulumi.Input[builtins.bool] private: Defines whether this workflow is private to the owner or not. Default is `true`
        :param pulumi.Input[Union['AutomationWorkflowTasksArgs', 'AutomationWorkflowTasksArgsDict']] tasks: The tasks to run for every execution of this workflow
        :param pulumi.Input[builtins.str] title: The title / name of the workflow
        :param pulumi.Input[Union['AutomationWorkflowTriggerArgs', 'AutomationWorkflowTriggerArgsDict']] trigger: Configures how executions of the workflows are getting triggered. If no trigger is specified it means the workflow is getting manually triggered
        :param pulumi.Input[builtins.str] type: The type of the workflow. Possible values are `STANDARD` and `SIMPLE`. Defaults to `STANDARD`. Workflows of type `SIMPLE` are allowed to contain only one action
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutomationWorkflowArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **Dynatrace SaaS only**

        > To utilize this resource, please define the environment variables `DT_CLIENT_ID`, `DT_CLIENT_SECRET`, `DT_ACCOUNT_ID` with an OAuth client including the following permissions: **View workflows** (`automation:workflows:read`) and **Create and edit workflows** (`automation:workflows:write`).

        > This resource is excluded by default in the export utility, please explicitly specify the resource to retrieve existing configuration.

        ## Dynatrace Documentation

        - Dynatrace Workflows - https://www.dynatrace.com/support/help/platform-modules/cloud-automation/workflows

        ## Resource Example Usage

        ```python
        import pulumi
        import json
        import pulumiverse_dynatrace as dynatrace

        sample_worklow_tf = dynatrace.AutomationWorkflow("sampleWorklowTF",
            description="Desc",
            actor="########-####-####-####-############",
            title="Sample Worklow TF1",
            owner="########-####-####-####-############",
            private=True,
            tasks={
                "tasks": [
                    {
                        "name": "http_request_1",
                        "description": "Issue an HTTP request to any API",
                        "action": "dynatrace.automations:http-function",
                        "active": True,
                        "input": json.dumps({
                            "method": "GET",
                            "url": "https://www.google.at/",
                        }),
                        "position": {
                            "x": 0,
                            "y": 1,
                        },
                    },
                    {
                        "name": "http_request_2",
                        "description": "Issue an HTTP request to any API",
                        "action": "dynatrace.automations:http-function",
                        "active": False,
                        "input": json.dumps({
                            "method": "GET",
                            "url": "https://www.second-task.com/",
                        }),
                        "conditions": {
                            "states": {
                                "http_request_1": "SUCCESS",
                                "run_javascript_1": "OK",
                            },
                            "custom": "",
                        },
                        "position": {
                            "x": -1,
                            "y": 2,
                        },
                        "timeout": "50000",
                    },
                    {
                        "name": "http_request_3",
                        "description": "Issue an HTTP request to any API",
                        "action": "dynatrace.automations:http-function",
                        "active": False,
                        "input": json.dumps({
                            "method": "GET",
                            "url": "https://www.third-task.com",
                        }),
                        "conditions": {
                            "states": {
                                "http_request_2": "OK",
                            },
                            "custom": "{{http_request_1}}",
                        },
                        "position": {
                            "x": 0,
                            "y": 3,
                        },
                    },
                    {
                        "name": "run_javascript_1",
                        "description": "Build a custom task running js Code",
                        "action": "dynatrace.automations:run-javascript",
                        "active": False,
                        "input": json.dumps({
                            "script": \"\"\"// optional import of sdk modules
        import { execution } from '@dynatrace-sdk/automation-utils';

        export default async function ({ execution_id }) {
          // your code goes here
          // e.g. get the current execution
          const ex = await execution(execution_id);
          console.log('Automated script execution on behalf of', ex.trigger);
          
          return { triggeredBy: ex.trigger };
        }\"\"\",
                        }),
                        "position": {
                            "x": -2,
                            "y": 1,
                        },
                    },
                ],
            },
            trigger={
                "event": {
                    "active": False,
                    "config": {
                        "davis_event": {
                            "entity_tags_match": "all",
                            "entity_tags": {
                                "asdf": "",
                            },
                            "on_problem_close": False,
                            "types": ["CUSTOM_ANNOTATION"],
                        },
                    },
                },
            })
        ```

        :param str resource_name: The name of the resource.
        :param AutomationWorkflowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutomationWorkflowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actor: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 owner: Optional[pulumi.Input[builtins.str]] = None,
                 private: Optional[pulumi.Input[builtins.bool]] = None,
                 tasks: Optional[pulumi.Input[Union['AutomationWorkflowTasksArgs', 'AutomationWorkflowTasksArgsDict']]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None,
                 trigger: Optional[pulumi.Input[Union['AutomationWorkflowTriggerArgs', 'AutomationWorkflowTriggerArgsDict']]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutomationWorkflowArgs.__new__(AutomationWorkflowArgs)

            __props__.__dict__["actor"] = actor
            __props__.__dict__["description"] = description
            __props__.__dict__["owner"] = owner
            __props__.__dict__["private"] = private
            if tasks is None and not opts.urn:
                raise TypeError("Missing required property 'tasks'")
            __props__.__dict__["tasks"] = tasks
            if title is None and not opts.urn:
                raise TypeError("Missing required property 'title'")
            __props__.__dict__["title"] = title
            __props__.__dict__["trigger"] = trigger
            __props__.__dict__["type"] = type
        super(AutomationWorkflow, __self__).__init__(
            'dynatrace:index/automationWorkflow:AutomationWorkflow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actor: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            owner: Optional[pulumi.Input[builtins.str]] = None,
            private: Optional[pulumi.Input[builtins.bool]] = None,
            tasks: Optional[pulumi.Input[Union['AutomationWorkflowTasksArgs', 'AutomationWorkflowTasksArgsDict']]] = None,
            title: Optional[pulumi.Input[builtins.str]] = None,
            trigger: Optional[pulumi.Input[Union['AutomationWorkflowTriggerArgs', 'AutomationWorkflowTriggerArgsDict']]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'AutomationWorkflow':
        """
        Get an existing AutomationWorkflow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] actor: The user context the executions of the workflow will happen with
        :param pulumi.Input[builtins.str] description: An optional description for the workflow
        :param pulumi.Input[builtins.str] owner: The ID of the owner of this workflow
        :param pulumi.Input[builtins.bool] private: Defines whether this workflow is private to the owner or not. Default is `true`
        :param pulumi.Input[Union['AutomationWorkflowTasksArgs', 'AutomationWorkflowTasksArgsDict']] tasks: The tasks to run for every execution of this workflow
        :param pulumi.Input[builtins.str] title: The title / name of the workflow
        :param pulumi.Input[Union['AutomationWorkflowTriggerArgs', 'AutomationWorkflowTriggerArgsDict']] trigger: Configures how executions of the workflows are getting triggered. If no trigger is specified it means the workflow is getting manually triggered
        :param pulumi.Input[builtins.str] type: The type of the workflow. Possible values are `STANDARD` and `SIMPLE`. Defaults to `STANDARD`. Workflows of type `SIMPLE` are allowed to contain only one action
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutomationWorkflowState.__new__(_AutomationWorkflowState)

        __props__.__dict__["actor"] = actor
        __props__.__dict__["description"] = description
        __props__.__dict__["owner"] = owner
        __props__.__dict__["private"] = private
        __props__.__dict__["tasks"] = tasks
        __props__.__dict__["title"] = title
        __props__.__dict__["trigger"] = trigger
        __props__.__dict__["type"] = type
        return AutomationWorkflow(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def actor(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The user context the executions of the workflow will happen with
        """
        return pulumi.get(self, "actor")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional description for the workflow
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the owner of this workflow
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def private(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Defines whether this workflow is private to the owner or not. Default is `true`
        """
        return pulumi.get(self, "private")

    @property
    @pulumi.getter
    def tasks(self) -> pulumi.Output['outputs.AutomationWorkflowTasks']:
        """
        The tasks to run for every execution of this workflow
        """
        return pulumi.get(self, "tasks")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[builtins.str]:
        """
        The title / name of the workflow
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def trigger(self) -> pulumi.Output[Optional['outputs.AutomationWorkflowTrigger']]:
        """
        Configures how executions of the workflows are getting triggered. If no trigger is specified it means the workflow is getting manually triggered
        """
        return pulumi.get(self, "trigger")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The type of the workflow. Possible values are `STANDARD` and `SIMPLE`. Defaults to `STANDARD`. Workflows of type `SIMPLE` are allowed to contain only one action
        """
        return pulumi.get(self, "type")

