# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AutomationWorkflowSlackArgs', 'AutomationWorkflowSlack']

@pulumi.input_type
class AutomationWorkflowSlackArgs:
    def __init__(__self__, *,
                 token: pulumi.Input[builtins.str],
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AutomationWorkflowSlack resource.
        :param pulumi.Input[builtins.str] token: The bot token obtained from the Slack App Management UI
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[builtins.str] name: The name of the Slack connection
        """
        pulumi.set(__self__, "token", token)
        if insert_after is not None:
            warnings.warn("""This resource is no longer ordered, please remove this attribute from the configuration""", DeprecationWarning)
            pulumi.log.warn("""insert_after is deprecated: This resource is no longer ordered, please remove this attribute from the configuration""")
        if insert_after is not None:
            pulumi.set(__self__, "insert_after", insert_after)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[builtins.str]:
        """
        The bot token obtained from the Slack App Management UI
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter(name="insertAfter")
    @_utilities.deprecated("""This resource is no longer ordered, please remove this attribute from the configuration""")
    def insert_after(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @insert_after.setter
    def insert_after(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "insert_after", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Slack connection
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _AutomationWorkflowSlackState:
    def __init__(__self__, *,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 token: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AutomationWorkflowSlack resources.
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[builtins.str] name: The name of the Slack connection
        :param pulumi.Input[builtins.str] token: The bot token obtained from the Slack App Management UI
        """
        if insert_after is not None:
            warnings.warn("""This resource is no longer ordered, please remove this attribute from the configuration""", DeprecationWarning)
            pulumi.log.warn("""insert_after is deprecated: This resource is no longer ordered, please remove this attribute from the configuration""")
        if insert_after is not None:
            pulumi.set(__self__, "insert_after", insert_after)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="insertAfter")
    @_utilities.deprecated("""This resource is no longer ordered, please remove this attribute from the configuration""")
    def insert_after(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @insert_after.setter
    def insert_after(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "insert_after", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Slack connection
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The bot token obtained from the Slack App Management UI
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "token", value)


@pulumi.type_token("dynatrace:index/automationWorkflowSlack:AutomationWorkflowSlack")
class AutomationWorkflowSlack(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 token: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a AutomationWorkflowSlack resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[builtins.str] name: The name of the Slack connection
        :param pulumi.Input[builtins.str] token: The bot token obtained from the Slack App Management UI
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutomationWorkflowSlackArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AutomationWorkflowSlack resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AutomationWorkflowSlackArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutomationWorkflowSlackArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 token: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutomationWorkflowSlackArgs.__new__(AutomationWorkflowSlackArgs)

            __props__.__dict__["insert_after"] = insert_after
            __props__.__dict__["name"] = name
            if token is None and not opts.urn:
                raise TypeError("Missing required property 'token'")
            __props__.__dict__["token"] = None if token is None else pulumi.Output.secret(token)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AutomationWorkflowSlack, __self__).__init__(
            'dynatrace:index/automationWorkflowSlack:AutomationWorkflowSlack',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            insert_after: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            token: Optional[pulumi.Input[builtins.str]] = None) -> 'AutomationWorkflowSlack':
        """
        Get an existing AutomationWorkflowSlack resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[builtins.str] name: The name of the Slack connection
        :param pulumi.Input[builtins.str] token: The bot token obtained from the Slack App Management UI
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutomationWorkflowSlackState.__new__(_AutomationWorkflowSlackState)

        __props__.__dict__["insert_after"] = insert_after
        __props__.__dict__["name"] = name
        __props__.__dict__["token"] = token
        return AutomationWorkflowSlack(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="insertAfter")
    @_utilities.deprecated("""This resource is no longer ordered, please remove this attribute from the configuration""")
    def insert_after(self) -> pulumi.Output[builtins.str]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Slack connection
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[builtins.str]:
        """
        The bot token obtained from the Slack App Management UI
        """
        return pulumi.get(self, "token")

