# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AutotagArgs', 'Autotag']

@pulumi.input_type
class AutotagArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 entity_selector_based_rules: Optional[pulumi.Input[Sequence[pulumi.Input['AutotagEntitySelectorBasedRuleArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['AutotagRuleArgs']]]] = None,
                 unknowns: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Autotag resource.
        :param pulumi.Input[builtins.str] description: The description of the auto-tag.
        :param pulumi.Input[Sequence[pulumi.Input['AutotagEntitySelectorBasedRuleArgs']]] entity_selector_based_rules: A list of entity-selector based rules for management zone usage. If several rules are specified, the `or` logic applies
        :param pulumi.Input[builtins.str] name: The name of the auto-tag, which is applied to entities. Additionally you can specify a **valueFormat** in the tag rule.
               In that case the tag is used in the `name:valueFormat` format. For example you can extend the `Infrastructure` tag to
               `Infrastructure:Windows` and `Infrastructure:Linux`.
        :param pulumi.Input[Sequence[pulumi.Input['AutotagRuleArgs']]] rules: A list of rules for management zone usage. Each rule is evaluated independently of all other rules
        :param pulumi.Input[builtins.str] unknowns: allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entity_selector_based_rules is not None:
            pulumi.set(__self__, "entity_selector_based_rules", entity_selector_based_rules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if unknowns is not None:
            pulumi.set(__self__, "unknowns", unknowns)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the auto-tag.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="entitySelectorBasedRules")
    def entity_selector_based_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutotagEntitySelectorBasedRuleArgs']]]]:
        """
        A list of entity-selector based rules for management zone usage. If several rules are specified, the `or` logic applies
        """
        return pulumi.get(self, "entity_selector_based_rules")

    @entity_selector_based_rules.setter
    def entity_selector_based_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutotagEntitySelectorBasedRuleArgs']]]]):
        pulumi.set(self, "entity_selector_based_rules", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the auto-tag, which is applied to entities. Additionally you can specify a **valueFormat** in the tag rule.
        In that case the tag is used in the `name:valueFormat` format. For example you can extend the `Infrastructure` tag to
        `Infrastructure:Windows` and `Infrastructure:Linux`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutotagRuleArgs']]]]:
        """
        A list of rules for management zone usage. Each rule is evaluated independently of all other rules
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutotagRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def unknowns(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        return pulumi.get(self, "unknowns")

    @unknowns.setter
    def unknowns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "unknowns", value)


@pulumi.input_type
class _AutotagState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 entity_selector_based_rules: Optional[pulumi.Input[Sequence[pulumi.Input['AutotagEntitySelectorBasedRuleArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['AutotagRuleArgs']]]] = None,
                 unknowns: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Autotag resources.
        :param pulumi.Input[builtins.str] description: The description of the auto-tag.
        :param pulumi.Input[Sequence[pulumi.Input['AutotagEntitySelectorBasedRuleArgs']]] entity_selector_based_rules: A list of entity-selector based rules for management zone usage. If several rules are specified, the `or` logic applies
        :param pulumi.Input[builtins.str] name: The name of the auto-tag, which is applied to entities. Additionally you can specify a **valueFormat** in the tag rule.
               In that case the tag is used in the `name:valueFormat` format. For example you can extend the `Infrastructure` tag to
               `Infrastructure:Windows` and `Infrastructure:Linux`.
        :param pulumi.Input[Sequence[pulumi.Input['AutotagRuleArgs']]] rules: A list of rules for management zone usage. Each rule is evaluated independently of all other rules
        :param pulumi.Input[builtins.str] unknowns: allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entity_selector_based_rules is not None:
            pulumi.set(__self__, "entity_selector_based_rules", entity_selector_based_rules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if unknowns is not None:
            pulumi.set(__self__, "unknowns", unknowns)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the auto-tag.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="entitySelectorBasedRules")
    def entity_selector_based_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutotagEntitySelectorBasedRuleArgs']]]]:
        """
        A list of entity-selector based rules for management zone usage. If several rules are specified, the `or` logic applies
        """
        return pulumi.get(self, "entity_selector_based_rules")

    @entity_selector_based_rules.setter
    def entity_selector_based_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutotagEntitySelectorBasedRuleArgs']]]]):
        pulumi.set(self, "entity_selector_based_rules", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the auto-tag, which is applied to entities. Additionally you can specify a **valueFormat** in the tag rule.
        In that case the tag is used in the `name:valueFormat` format. For example you can extend the `Infrastructure` tag to
        `Infrastructure:Windows` and `Infrastructure:Linux`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutotagRuleArgs']]]]:
        """
        A list of rules for management zone usage. Each rule is evaluated independently of all other rules
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutotagRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def unknowns(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        return pulumi.get(self, "unknowns")

    @unknowns.setter
    def unknowns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "unknowns", value)


@pulumi.type_token("dynatrace:index/autotag:Autotag")
class Autotag(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 entity_selector_based_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutotagEntitySelectorBasedRuleArgs', 'AutotagEntitySelectorBasedRuleArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutotagRuleArgs', 'AutotagRuleArgsDict']]]]] = None,
                 unknowns: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a Autotag resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the auto-tag.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutotagEntitySelectorBasedRuleArgs', 'AutotagEntitySelectorBasedRuleArgsDict']]]] entity_selector_based_rules: A list of entity-selector based rules for management zone usage. If several rules are specified, the `or` logic applies
        :param pulumi.Input[builtins.str] name: The name of the auto-tag, which is applied to entities. Additionally you can specify a **valueFormat** in the tag rule.
               In that case the tag is used in the `name:valueFormat` format. For example you can extend the `Infrastructure` tag to
               `Infrastructure:Windows` and `Infrastructure:Linux`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutotagRuleArgs', 'AutotagRuleArgsDict']]]] rules: A list of rules for management zone usage. Each rule is evaluated independently of all other rules
        :param pulumi.Input[builtins.str] unknowns: allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AutotagArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Autotag resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AutotagArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutotagArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 entity_selector_based_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutotagEntitySelectorBasedRuleArgs', 'AutotagEntitySelectorBasedRuleArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutotagRuleArgs', 'AutotagRuleArgsDict']]]]] = None,
                 unknowns: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutotagArgs.__new__(AutotagArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["entity_selector_based_rules"] = entity_selector_based_rules
            __props__.__dict__["name"] = name
            __props__.__dict__["rules"] = rules
            __props__.__dict__["unknowns"] = unknowns
        super(Autotag, __self__).__init__(
            'dynatrace:index/autotag:Autotag',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            entity_selector_based_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutotagEntitySelectorBasedRuleArgs', 'AutotagEntitySelectorBasedRuleArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutotagRuleArgs', 'AutotagRuleArgsDict']]]]] = None,
            unknowns: Optional[pulumi.Input[builtins.str]] = None) -> 'Autotag':
        """
        Get an existing Autotag resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the auto-tag.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutotagEntitySelectorBasedRuleArgs', 'AutotagEntitySelectorBasedRuleArgsDict']]]] entity_selector_based_rules: A list of entity-selector based rules for management zone usage. If several rules are specified, the `or` logic applies
        :param pulumi.Input[builtins.str] name: The name of the auto-tag, which is applied to entities. Additionally you can specify a **valueFormat** in the tag rule.
               In that case the tag is used in the `name:valueFormat` format. For example you can extend the `Infrastructure` tag to
               `Infrastructure:Windows` and `Infrastructure:Linux`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutotagRuleArgs', 'AutotagRuleArgsDict']]]] rules: A list of rules for management zone usage. Each rule is evaluated independently of all other rules
        :param pulumi.Input[builtins.str] unknowns: allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutotagState.__new__(_AutotagState)

        __props__.__dict__["description"] = description
        __props__.__dict__["entity_selector_based_rules"] = entity_selector_based_rules
        __props__.__dict__["name"] = name
        __props__.__dict__["rules"] = rules
        __props__.__dict__["unknowns"] = unknowns
        return Autotag(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the auto-tag.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="entitySelectorBasedRules")
    def entity_selector_based_rules(self) -> pulumi.Output[Optional[Sequence['outputs.AutotagEntitySelectorBasedRule']]]:
        """
        A list of entity-selector based rules for management zone usage. If several rules are specified, the `or` logic applies
        """
        return pulumi.get(self, "entity_selector_based_rules")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the auto-tag, which is applied to entities. Additionally you can specify a **valueFormat** in the tag rule.
        In that case the tag is used in the `name:valueFormat` format. For example you can extend the `Infrastructure` tag to
        `Infrastructure:Windows` and `Infrastructure:Linux`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.AutotagRule']]]:
        """
        A list of rules for management zone usage. Each rule is evaluated independently of all other rules
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def unknowns(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        return pulumi.get(self, "unknowns")

