# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsServiceArgs', 'AwsService']

@pulumi.input_type
class AwsServiceArgs:
    def __init__(__self__, *,
                 credentials_id: pulumi.Input[builtins.str],
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input['AwsServiceMetricArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 use_recommended_metrics: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a AwsService resource.
        :param pulumi.Input[builtins.str] credentials_id: the ID of the azure credentials this supported service belongs to
        :param pulumi.Input[builtins.str] name: The name of the supporting service.
        """
        pulumi.set(__self__, "credentials_id", credentials_id)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if use_recommended_metrics is not None:
            pulumi.set(__self__, "use_recommended_metrics", use_recommended_metrics)

    @property
    @pulumi.getter(name="credentialsId")
    def credentials_id(self) -> pulumi.Input[builtins.str]:
        """
        the ID of the azure credentials this supported service belongs to
        """
        return pulumi.get(self, "credentials_id")

    @credentials_id.setter
    def credentials_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "credentials_id", value)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsServiceMetricArgs']]]]:
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsServiceMetricArgs']]]]):
        pulumi.set(self, "metrics", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the supporting service.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="useRecommendedMetrics")
    def use_recommended_metrics(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "use_recommended_metrics")

    @use_recommended_metrics.setter
    def use_recommended_metrics(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_recommended_metrics", value)


@pulumi.input_type
class _AwsServiceState:
    def __init__(__self__, *,
                 built_in: Optional[pulumi.Input[builtins.bool]] = None,
                 credentials_id: Optional[pulumi.Input[builtins.str]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input['AwsServiceMetricArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 required_metrics: Optional[pulumi.Input[builtins.str]] = None,
                 use_recommended_metrics: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering AwsService resources.
        :param pulumi.Input[builtins.bool] built_in: This attribute is automatically set to `true` if Dynatrace considers the supporting service with the given name to be a built-in service
        :param pulumi.Input[builtins.str] credentials_id: the ID of the azure credentials this supported service belongs to
        :param pulumi.Input[builtins.str] name: The name of the supporting service.
        """
        if built_in is not None:
            pulumi.set(__self__, "built_in", built_in)
        if credentials_id is not None:
            pulumi.set(__self__, "credentials_id", credentials_id)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if required_metrics is not None:
            pulumi.set(__self__, "required_metrics", required_metrics)
        if use_recommended_metrics is not None:
            pulumi.set(__self__, "use_recommended_metrics", use_recommended_metrics)

    @property
    @pulumi.getter(name="builtIn")
    def built_in(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This attribute is automatically set to `true` if Dynatrace considers the supporting service with the given name to be a built-in service
        """
        return pulumi.get(self, "built_in")

    @built_in.setter
    def built_in(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "built_in", value)

    @property
    @pulumi.getter(name="credentialsId")
    def credentials_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        the ID of the azure credentials this supported service belongs to
        """
        return pulumi.get(self, "credentials_id")

    @credentials_id.setter
    def credentials_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "credentials_id", value)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsServiceMetricArgs']]]]:
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsServiceMetricArgs']]]]):
        pulumi.set(self, "metrics", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the supporting service.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="requiredMetrics")
    def required_metrics(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "required_metrics")

    @required_metrics.setter
    def required_metrics(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "required_metrics", value)

    @property
    @pulumi.getter(name="useRecommendedMetrics")
    def use_recommended_metrics(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "use_recommended_metrics")

    @use_recommended_metrics.setter
    def use_recommended_metrics(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_recommended_metrics", value)


@pulumi.type_token("dynatrace:index/awsService:AwsService")
class AwsService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credentials_id: Optional[pulumi.Input[builtins.str]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsServiceMetricArgs', 'AwsServiceMetricArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 use_recommended_metrics: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        > This resource is excluded by default in the export utility.

        > This resource requires the API token scopes **Read configuration** (`ReadConfig`) and **Write configuration** (`WriteConfig`)

        ## Dynatrace Documentation

        - Amazon Web Services - https://www.dynatrace.com/support/help/setup-and-configuration/setup-on-cloud-platforms/amazon-web-services/amazon-web-services-integrations/aws-service-metrics

        - AWS credentials API - https://www.dynatrace.com/support/help/dynatrace-api/configuration-api/aws-credentials-api

        ## Resource Example Usage

        This example utilizes the data source `get_aws_supported_services` in order to query for a full list of all supported services.
        The `for_each` loop within the resource `AwsService` configures each of these services to get utilized with the default metrics recommended by Dynatrace (`use_recommended_metrics`).

        If you want to configure a different set of metrics for a specific service, a separate resource `AwsService` will be necessary for that. That allows you to configure the `metric` blocks according to your wishes.
        Just be aware of the fact, that Dynatrace enforces for most services a recommended set of metrics. All of them need to be part of your configuration in order to end up with a non-empty plan.

        ```python
        import pulumi
        import pulumi_dynatrace as dynatrace
        import pulumiverse_dynatrace as dynatrace

        t_erraformsample = dynatrace.AwsCredentials("tERRAFORMSAMPLE",
            label="TERRAFORM-TEST-001",
            partition_type="AWS_DEFAULT",
            tagged_only=False,
            authentication_data={
                "account_id": "246186168471",
                "iam_role": "Dynatrace_monitoring_role_demo1",
            },
            remove_defaults=True)
        supported_services = dynatrace.get_aws_supported_services()
        t_erraformsample_services = []
        for range in [{"key": k, "value": v} for [k, v] in enumerate(supported_services.services)]:
            t_erraformsample_services.append(dynatrace.AwsService(f"tERRAFORMSAMPLEServices-{range['key']}",
                credentials_id=t_erraformsample.id,
                use_recommended_metrics=True))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] credentials_id: the ID of the azure credentials this supported service belongs to
        :param pulumi.Input[builtins.str] name: The name of the supporting service.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > This resource is excluded by default in the export utility.

        > This resource requires the API token scopes **Read configuration** (`ReadConfig`) and **Write configuration** (`WriteConfig`)

        ## Dynatrace Documentation

        - Amazon Web Services - https://www.dynatrace.com/support/help/setup-and-configuration/setup-on-cloud-platforms/amazon-web-services/amazon-web-services-integrations/aws-service-metrics

        - AWS credentials API - https://www.dynatrace.com/support/help/dynatrace-api/configuration-api/aws-credentials-api

        ## Resource Example Usage

        This example utilizes the data source `get_aws_supported_services` in order to query for a full list of all supported services.
        The `for_each` loop within the resource `AwsService` configures each of these services to get utilized with the default metrics recommended by Dynatrace (`use_recommended_metrics`).

        If you want to configure a different set of metrics for a specific service, a separate resource `AwsService` will be necessary for that. That allows you to configure the `metric` blocks according to your wishes.
        Just be aware of the fact, that Dynatrace enforces for most services a recommended set of metrics. All of them need to be part of your configuration in order to end up with a non-empty plan.

        ```python
        import pulumi
        import pulumi_dynatrace as dynatrace
        import pulumiverse_dynatrace as dynatrace

        t_erraformsample = dynatrace.AwsCredentials("tERRAFORMSAMPLE",
            label="TERRAFORM-TEST-001",
            partition_type="AWS_DEFAULT",
            tagged_only=False,
            authentication_data={
                "account_id": "246186168471",
                "iam_role": "Dynatrace_monitoring_role_demo1",
            },
            remove_defaults=True)
        supported_services = dynatrace.get_aws_supported_services()
        t_erraformsample_services = []
        for range in [{"key": k, "value": v} for [k, v] in enumerate(supported_services.services)]:
            t_erraformsample_services.append(dynatrace.AwsService(f"tERRAFORMSAMPLEServices-{range['key']}",
                credentials_id=t_erraformsample.id,
                use_recommended_metrics=True))
        ```

        :param str resource_name: The name of the resource.
        :param AwsServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credentials_id: Optional[pulumi.Input[builtins.str]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsServiceMetricArgs', 'AwsServiceMetricArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 use_recommended_metrics: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsServiceArgs.__new__(AwsServiceArgs)

            if credentials_id is None and not opts.urn:
                raise TypeError("Missing required property 'credentials_id'")
            __props__.__dict__["credentials_id"] = credentials_id
            __props__.__dict__["metrics"] = metrics
            __props__.__dict__["name"] = name
            __props__.__dict__["use_recommended_metrics"] = use_recommended_metrics
            __props__.__dict__["built_in"] = None
            __props__.__dict__["required_metrics"] = None
        super(AwsService, __self__).__init__(
            'dynatrace:index/awsService:AwsService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            built_in: Optional[pulumi.Input[builtins.bool]] = None,
            credentials_id: Optional[pulumi.Input[builtins.str]] = None,
            metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsServiceMetricArgs', 'AwsServiceMetricArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            required_metrics: Optional[pulumi.Input[builtins.str]] = None,
            use_recommended_metrics: Optional[pulumi.Input[builtins.bool]] = None) -> 'AwsService':
        """
        Get an existing AwsService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] built_in: This attribute is automatically set to `true` if Dynatrace considers the supporting service with the given name to be a built-in service
        :param pulumi.Input[builtins.str] credentials_id: the ID of the azure credentials this supported service belongs to
        :param pulumi.Input[builtins.str] name: The name of the supporting service.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsServiceState.__new__(_AwsServiceState)

        __props__.__dict__["built_in"] = built_in
        __props__.__dict__["credentials_id"] = credentials_id
        __props__.__dict__["metrics"] = metrics
        __props__.__dict__["name"] = name
        __props__.__dict__["required_metrics"] = required_metrics
        __props__.__dict__["use_recommended_metrics"] = use_recommended_metrics
        return AwsService(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="builtIn")
    def built_in(self) -> pulumi.Output[builtins.bool]:
        """
        This attribute is automatically set to `true` if Dynatrace considers the supporting service with the given name to be a built-in service
        """
        return pulumi.get(self, "built_in")

    @property
    @pulumi.getter(name="credentialsId")
    def credentials_id(self) -> pulumi.Output[builtins.str]:
        """
        the ID of the azure credentials this supported service belongs to
        """
        return pulumi.get(self, "credentials_id")

    @property
    @pulumi.getter
    def metrics(self) -> pulumi.Output[Optional[Sequence['outputs.AwsServiceMetric']]]:
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the supporting service.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="requiredMetrics")
    def required_metrics(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "required_metrics")

    @property
    @pulumi.getter(name="useRecommendedMetrics")
    def use_recommended_metrics(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "use_recommended_metrics")

