# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AzureCredentialsArgs', 'AzureCredentials']

@pulumi.input_type
class AzureCredentialsArgs:
    def __init__(__self__, *,
                 active: pulumi.Input[builtins.bool],
                 label: pulumi.Input[builtins.str],
                 monitor_only_tagged_entities: pulumi.Input[builtins.bool],
                 app_id: Optional[pulumi.Input[builtins.str]] = None,
                 auto_tagging: Optional[pulumi.Input[builtins.bool]] = None,
                 directory_id: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 monitor_only_excluding_tag_pairs: Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialsMonitorOnlyExcludingTagPairArgs']]]] = None,
                 monitor_only_tag_pairs: Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialsMonitorOnlyTagPairArgs']]]] = None,
                 remove_defaults: Optional[pulumi.Input[builtins.bool]] = None,
                 supporting_services: Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialsSupportingServiceArgs']]]] = None,
                 supporting_services_managed_in_dynatrace: Optional[pulumi.Input[builtins.bool]] = None,
                 unknowns: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AzureCredentials resource.
        :param pulumi.Input[builtins.bool] active: The monitoring is enabled (`true`) or disabled (`false`).  If not set on creation, the `true` value is used.  If the field is omitted during an update, the old value remains unaffected
        :param pulumi.Input[builtins.str] label: The unique name of the Azure credentials configuration.  Allowed characters are letters, numbers, and spaces. Also the special characters `.+-_` are allowed
        :param pulumi.Input[builtins.bool] monitor_only_tagged_entities: Monitor only resources that have specified Azure tags (`true`) or all resources (`false`).
        :param pulumi.Input[builtins.str] app_id: The Application ID (also referred to as Client ID)  The combination of Application ID and Directory ID must be unique
        :param pulumi.Input[builtins.bool] auto_tagging: The automatic capture of Azure tags is on (`true`) or off (`false`)
        :param pulumi.Input[builtins.str] directory_id: The Directory ID (also referred to as Tenant ID)  The combination of Application ID and Directory ID must be unique
        :param pulumi.Input[builtins.str] key: The secret key associated with the Application ID.  For security reasons, GET requests return this field as `null`. Submit your key on creation or update of the configuration. If the field is omitted during an update, the old value remains unaffected.
        :param pulumi.Input[Sequence[pulumi.Input['AzureCredentialsMonitorOnlyExcludingTagPairArgs']]] monitor_only_excluding_tag_pairs: A list of Azure tags to be excluded from monitoring.  You can specify up to 20 tags. A resource tagged with *any* of the specified tags is monitored.  Only applicable when the **monitorOnlyTaggedEntities** parameter is set to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['AzureCredentialsMonitorOnlyTagPairArgs']]] monitor_only_tag_pairs: A list of Azure tags to be monitored.  You can specify up to 20 tags. A resource tagged with *any* of the specified tags is monitored.  Only applicable when the **monitorOnlyTaggedEntities** parameter is set to `true`
        :param pulumi.Input[builtins.bool] remove_defaults: Instructs the provider to remove the supporting services Dynatrace applies by default to newly created Azure Credentials. Supporting Services applied by via `AzureService` subsequently won't get touched.
        :param pulumi.Input[Sequence[pulumi.Input['AzureCredentialsSupportingServiceArgs']]] supporting_services: A list of Azure supporting services to be monitored. For each service there's a sublist of its metrics and the metrics' dimensions that should be monitored. All of these elements (services, metrics, dimensions) must have corresponding static definitions on the server.
        :param pulumi.Input[builtins.str] unknowns: Any attributes that aren't yet supported by this provider
        """
        pulumi.set(__self__, "active", active)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "monitor_only_tagged_entities", monitor_only_tagged_entities)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if auto_tagging is not None:
            pulumi.set(__self__, "auto_tagging", auto_tagging)
        if directory_id is not None:
            pulumi.set(__self__, "directory_id", directory_id)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if monitor_only_excluding_tag_pairs is not None:
            pulumi.set(__self__, "monitor_only_excluding_tag_pairs", monitor_only_excluding_tag_pairs)
        if monitor_only_tag_pairs is not None:
            pulumi.set(__self__, "monitor_only_tag_pairs", monitor_only_tag_pairs)
        if remove_defaults is not None:
            pulumi.set(__self__, "remove_defaults", remove_defaults)
        if supporting_services is not None:
            warnings.warn("""Assigning supported services directly when creating Azure Credentials is deprecated. Use the resource `AzureService` instead.""", DeprecationWarning)
            pulumi.log.warn("""supporting_services is deprecated: Assigning supported services directly when creating Azure Credentials is deprecated. Use the resource `AzureService` instead.""")
        if supporting_services is not None:
            pulumi.set(__self__, "supporting_services", supporting_services)
        if supporting_services_managed_in_dynatrace is not None:
            warnings.warn("""This attribute is deprecated and has no effect any more. It always defaults to `true`.""", DeprecationWarning)
            pulumi.log.warn("""supporting_services_managed_in_dynatrace is deprecated: This attribute is deprecated and has no effect any more. It always defaults to `true`.""")
        if supporting_services_managed_in_dynatrace is not None:
            pulumi.set(__self__, "supporting_services_managed_in_dynatrace", supporting_services_managed_in_dynatrace)
        if unknowns is not None:
            pulumi.set(__self__, "unknowns", unknowns)

    @property
    @pulumi.getter
    def active(self) -> pulumi.Input[builtins.bool]:
        """
        The monitoring is enabled (`true`) or disabled (`false`).  If not set on creation, the `true` value is used.  If the field is omitted during an update, the old value remains unaffected
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[builtins.str]:
        """
        The unique name of the Azure credentials configuration.  Allowed characters are letters, numbers, and spaces. Also the special characters `.+-_` are allowed
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="monitorOnlyTaggedEntities")
    def monitor_only_tagged_entities(self) -> pulumi.Input[builtins.bool]:
        """
        Monitor only resources that have specified Azure tags (`true`) or all resources (`false`).
        """
        return pulumi.get(self, "monitor_only_tagged_entities")

    @monitor_only_tagged_entities.setter
    def monitor_only_tagged_entities(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "monitor_only_tagged_entities", value)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Application ID (also referred to as Client ID)  The combination of Application ID and Directory ID must be unique
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="autoTagging")
    def auto_tagging(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The automatic capture of Azure tags is on (`true`) or off (`false`)
        """
        return pulumi.get(self, "auto_tagging")

    @auto_tagging.setter
    def auto_tagging(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_tagging", value)

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Directory ID (also referred to as Tenant ID)  The combination of Application ID and Directory ID must be unique
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "directory_id", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The secret key associated with the Application ID.  For security reasons, GET requests return this field as `null`. Submit your key on creation or update of the configuration. If the field is omitted during an update, the old value remains unaffected.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="monitorOnlyExcludingTagPairs")
    def monitor_only_excluding_tag_pairs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialsMonitorOnlyExcludingTagPairArgs']]]]:
        """
        A list of Azure tags to be excluded from monitoring.  You can specify up to 20 tags. A resource tagged with *any* of the specified tags is monitored.  Only applicable when the **monitorOnlyTaggedEntities** parameter is set to `true`.
        """
        return pulumi.get(self, "monitor_only_excluding_tag_pairs")

    @monitor_only_excluding_tag_pairs.setter
    def monitor_only_excluding_tag_pairs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialsMonitorOnlyExcludingTagPairArgs']]]]):
        pulumi.set(self, "monitor_only_excluding_tag_pairs", value)

    @property
    @pulumi.getter(name="monitorOnlyTagPairs")
    def monitor_only_tag_pairs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialsMonitorOnlyTagPairArgs']]]]:
        """
        A list of Azure tags to be monitored.  You can specify up to 20 tags. A resource tagged with *any* of the specified tags is monitored.  Only applicable when the **monitorOnlyTaggedEntities** parameter is set to `true`
        """
        return pulumi.get(self, "monitor_only_tag_pairs")

    @monitor_only_tag_pairs.setter
    def monitor_only_tag_pairs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialsMonitorOnlyTagPairArgs']]]]):
        pulumi.set(self, "monitor_only_tag_pairs", value)

    @property
    @pulumi.getter(name="removeDefaults")
    def remove_defaults(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Instructs the provider to remove the supporting services Dynatrace applies by default to newly created Azure Credentials. Supporting Services applied by via `AzureService` subsequently won't get touched.
        """
        return pulumi.get(self, "remove_defaults")

    @remove_defaults.setter
    def remove_defaults(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "remove_defaults", value)

    @property
    @pulumi.getter(name="supportingServices")
    @_utilities.deprecated("""Assigning supported services directly when creating Azure Credentials is deprecated. Use the resource `AzureService` instead.""")
    def supporting_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialsSupportingServiceArgs']]]]:
        """
        A list of Azure supporting services to be monitored. For each service there's a sublist of its metrics and the metrics' dimensions that should be monitored. All of these elements (services, metrics, dimensions) must have corresponding static definitions on the server.
        """
        return pulumi.get(self, "supporting_services")

    @supporting_services.setter
    def supporting_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialsSupportingServiceArgs']]]]):
        pulumi.set(self, "supporting_services", value)

    @property
    @pulumi.getter(name="supportingServicesManagedInDynatrace")
    @_utilities.deprecated("""This attribute is deprecated and has no effect any more. It always defaults to `true`.""")
    def supporting_services_managed_in_dynatrace(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "supporting_services_managed_in_dynatrace")

    @supporting_services_managed_in_dynatrace.setter
    def supporting_services_managed_in_dynatrace(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "supporting_services_managed_in_dynatrace", value)

    @property
    @pulumi.getter
    def unknowns(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Any attributes that aren't yet supported by this provider
        """
        return pulumi.get(self, "unknowns")

    @unknowns.setter
    def unknowns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "unknowns", value)


@pulumi.input_type
class _AzureCredentialsState:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 app_id: Optional[pulumi.Input[builtins.str]] = None,
                 auto_tagging: Optional[pulumi.Input[builtins.bool]] = None,
                 directory_id: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 label: Optional[pulumi.Input[builtins.str]] = None,
                 monitor_only_excluding_tag_pairs: Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialsMonitorOnlyExcludingTagPairArgs']]]] = None,
                 monitor_only_tag_pairs: Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialsMonitorOnlyTagPairArgs']]]] = None,
                 monitor_only_tagged_entities: Optional[pulumi.Input[builtins.bool]] = None,
                 remove_defaults: Optional[pulumi.Input[builtins.bool]] = None,
                 supporting_services: Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialsSupportingServiceArgs']]]] = None,
                 supporting_services_managed_in_dynatrace: Optional[pulumi.Input[builtins.bool]] = None,
                 unknowns: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AzureCredentials resources.
        :param pulumi.Input[builtins.bool] active: The monitoring is enabled (`true`) or disabled (`false`).  If not set on creation, the `true` value is used.  If the field is omitted during an update, the old value remains unaffected
        :param pulumi.Input[builtins.str] app_id: The Application ID (also referred to as Client ID)  The combination of Application ID and Directory ID must be unique
        :param pulumi.Input[builtins.bool] auto_tagging: The automatic capture of Azure tags is on (`true`) or off (`false`)
        :param pulumi.Input[builtins.str] directory_id: The Directory ID (also referred to as Tenant ID)  The combination of Application ID and Directory ID must be unique
        :param pulumi.Input[builtins.str] key: The secret key associated with the Application ID.  For security reasons, GET requests return this field as `null`. Submit your key on creation or update of the configuration. If the field is omitted during an update, the old value remains unaffected.
        :param pulumi.Input[builtins.str] label: The unique name of the Azure credentials configuration.  Allowed characters are letters, numbers, and spaces. Also the special characters `.+-_` are allowed
        :param pulumi.Input[Sequence[pulumi.Input['AzureCredentialsMonitorOnlyExcludingTagPairArgs']]] monitor_only_excluding_tag_pairs: A list of Azure tags to be excluded from monitoring.  You can specify up to 20 tags. A resource tagged with *any* of the specified tags is monitored.  Only applicable when the **monitorOnlyTaggedEntities** parameter is set to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['AzureCredentialsMonitorOnlyTagPairArgs']]] monitor_only_tag_pairs: A list of Azure tags to be monitored.  You can specify up to 20 tags. A resource tagged with *any* of the specified tags is monitored.  Only applicable when the **monitorOnlyTaggedEntities** parameter is set to `true`
        :param pulumi.Input[builtins.bool] monitor_only_tagged_entities: Monitor only resources that have specified Azure tags (`true`) or all resources (`false`).
        :param pulumi.Input[builtins.bool] remove_defaults: Instructs the provider to remove the supporting services Dynatrace applies by default to newly created Azure Credentials. Supporting Services applied by via `AzureService` subsequently won't get touched.
        :param pulumi.Input[Sequence[pulumi.Input['AzureCredentialsSupportingServiceArgs']]] supporting_services: A list of Azure supporting services to be monitored. For each service there's a sublist of its metrics and the metrics' dimensions that should be monitored. All of these elements (services, metrics, dimensions) must have corresponding static definitions on the server.
        :param pulumi.Input[builtins.str] unknowns: Any attributes that aren't yet supported by this provider
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if auto_tagging is not None:
            pulumi.set(__self__, "auto_tagging", auto_tagging)
        if directory_id is not None:
            pulumi.set(__self__, "directory_id", directory_id)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if monitor_only_excluding_tag_pairs is not None:
            pulumi.set(__self__, "monitor_only_excluding_tag_pairs", monitor_only_excluding_tag_pairs)
        if monitor_only_tag_pairs is not None:
            pulumi.set(__self__, "monitor_only_tag_pairs", monitor_only_tag_pairs)
        if monitor_only_tagged_entities is not None:
            pulumi.set(__self__, "monitor_only_tagged_entities", monitor_only_tagged_entities)
        if remove_defaults is not None:
            pulumi.set(__self__, "remove_defaults", remove_defaults)
        if supporting_services is not None:
            warnings.warn("""Assigning supported services directly when creating Azure Credentials is deprecated. Use the resource `AzureService` instead.""", DeprecationWarning)
            pulumi.log.warn("""supporting_services is deprecated: Assigning supported services directly when creating Azure Credentials is deprecated. Use the resource `AzureService` instead.""")
        if supporting_services is not None:
            pulumi.set(__self__, "supporting_services", supporting_services)
        if supporting_services_managed_in_dynatrace is not None:
            warnings.warn("""This attribute is deprecated and has no effect any more. It always defaults to `true`.""", DeprecationWarning)
            pulumi.log.warn("""supporting_services_managed_in_dynatrace is deprecated: This attribute is deprecated and has no effect any more. It always defaults to `true`.""")
        if supporting_services_managed_in_dynatrace is not None:
            pulumi.set(__self__, "supporting_services_managed_in_dynatrace", supporting_services_managed_in_dynatrace)
        if unknowns is not None:
            pulumi.set(__self__, "unknowns", unknowns)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The monitoring is enabled (`true`) or disabled (`false`).  If not set on creation, the `true` value is used.  If the field is omitted during an update, the old value remains unaffected
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Application ID (also referred to as Client ID)  The combination of Application ID and Directory ID must be unique
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="autoTagging")
    def auto_tagging(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The automatic capture of Azure tags is on (`true`) or off (`false`)
        """
        return pulumi.get(self, "auto_tagging")

    @auto_tagging.setter
    def auto_tagging(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_tagging", value)

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Directory ID (also referred to as Tenant ID)  The combination of Application ID and Directory ID must be unique
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "directory_id", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The secret key associated with the Application ID.  For security reasons, GET requests return this field as `null`. Submit your key on creation or update of the configuration. If the field is omitted during an update, the old value remains unaffected.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique name of the Azure credentials configuration.  Allowed characters are letters, numbers, and spaces. Also the special characters `.+-_` are allowed
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="monitorOnlyExcludingTagPairs")
    def monitor_only_excluding_tag_pairs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialsMonitorOnlyExcludingTagPairArgs']]]]:
        """
        A list of Azure tags to be excluded from monitoring.  You can specify up to 20 tags. A resource tagged with *any* of the specified tags is monitored.  Only applicable when the **monitorOnlyTaggedEntities** parameter is set to `true`.
        """
        return pulumi.get(self, "monitor_only_excluding_tag_pairs")

    @monitor_only_excluding_tag_pairs.setter
    def monitor_only_excluding_tag_pairs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialsMonitorOnlyExcludingTagPairArgs']]]]):
        pulumi.set(self, "monitor_only_excluding_tag_pairs", value)

    @property
    @pulumi.getter(name="monitorOnlyTagPairs")
    def monitor_only_tag_pairs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialsMonitorOnlyTagPairArgs']]]]:
        """
        A list of Azure tags to be monitored.  You can specify up to 20 tags. A resource tagged with *any* of the specified tags is monitored.  Only applicable when the **monitorOnlyTaggedEntities** parameter is set to `true`
        """
        return pulumi.get(self, "monitor_only_tag_pairs")

    @monitor_only_tag_pairs.setter
    def monitor_only_tag_pairs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialsMonitorOnlyTagPairArgs']]]]):
        pulumi.set(self, "monitor_only_tag_pairs", value)

    @property
    @pulumi.getter(name="monitorOnlyTaggedEntities")
    def monitor_only_tagged_entities(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Monitor only resources that have specified Azure tags (`true`) or all resources (`false`).
        """
        return pulumi.get(self, "monitor_only_tagged_entities")

    @monitor_only_tagged_entities.setter
    def monitor_only_tagged_entities(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "monitor_only_tagged_entities", value)

    @property
    @pulumi.getter(name="removeDefaults")
    def remove_defaults(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Instructs the provider to remove the supporting services Dynatrace applies by default to newly created Azure Credentials. Supporting Services applied by via `AzureService` subsequently won't get touched.
        """
        return pulumi.get(self, "remove_defaults")

    @remove_defaults.setter
    def remove_defaults(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "remove_defaults", value)

    @property
    @pulumi.getter(name="supportingServices")
    @_utilities.deprecated("""Assigning supported services directly when creating Azure Credentials is deprecated. Use the resource `AzureService` instead.""")
    def supporting_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialsSupportingServiceArgs']]]]:
        """
        A list of Azure supporting services to be monitored. For each service there's a sublist of its metrics and the metrics' dimensions that should be monitored. All of these elements (services, metrics, dimensions) must have corresponding static definitions on the server.
        """
        return pulumi.get(self, "supporting_services")

    @supporting_services.setter
    def supporting_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialsSupportingServiceArgs']]]]):
        pulumi.set(self, "supporting_services", value)

    @property
    @pulumi.getter(name="supportingServicesManagedInDynatrace")
    @_utilities.deprecated("""This attribute is deprecated and has no effect any more. It always defaults to `true`.""")
    def supporting_services_managed_in_dynatrace(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "supporting_services_managed_in_dynatrace")

    @supporting_services_managed_in_dynatrace.setter
    def supporting_services_managed_in_dynatrace(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "supporting_services_managed_in_dynatrace", value)

    @property
    @pulumi.getter
    def unknowns(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Any attributes that aren't yet supported by this provider
        """
        return pulumi.get(self, "unknowns")

    @unknowns.setter
    def unknowns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "unknowns", value)


@pulumi.type_token("dynatrace:index/azureCredentials:AzureCredentials")
class AzureCredentials(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 app_id: Optional[pulumi.Input[builtins.str]] = None,
                 auto_tagging: Optional[pulumi.Input[builtins.bool]] = None,
                 directory_id: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 label: Optional[pulumi.Input[builtins.str]] = None,
                 monitor_only_excluding_tag_pairs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureCredentialsMonitorOnlyExcludingTagPairArgs', 'AzureCredentialsMonitorOnlyExcludingTagPairArgsDict']]]]] = None,
                 monitor_only_tag_pairs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureCredentialsMonitorOnlyTagPairArgs', 'AzureCredentialsMonitorOnlyTagPairArgsDict']]]]] = None,
                 monitor_only_tagged_entities: Optional[pulumi.Input[builtins.bool]] = None,
                 remove_defaults: Optional[pulumi.Input[builtins.bool]] = None,
                 supporting_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureCredentialsSupportingServiceArgs', 'AzureCredentialsSupportingServiceArgsDict']]]]] = None,
                 supporting_services_managed_in_dynatrace: Optional[pulumi.Input[builtins.bool]] = None,
                 unknowns: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a AzureCredentials resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] active: The monitoring is enabled (`true`) or disabled (`false`).  If not set on creation, the `true` value is used.  If the field is omitted during an update, the old value remains unaffected
        :param pulumi.Input[builtins.str] app_id: The Application ID (also referred to as Client ID)  The combination of Application ID and Directory ID must be unique
        :param pulumi.Input[builtins.bool] auto_tagging: The automatic capture of Azure tags is on (`true`) or off (`false`)
        :param pulumi.Input[builtins.str] directory_id: The Directory ID (also referred to as Tenant ID)  The combination of Application ID and Directory ID must be unique
        :param pulumi.Input[builtins.str] key: The secret key associated with the Application ID.  For security reasons, GET requests return this field as `null`. Submit your key on creation or update of the configuration. If the field is omitted during an update, the old value remains unaffected.
        :param pulumi.Input[builtins.str] label: The unique name of the Azure credentials configuration.  Allowed characters are letters, numbers, and spaces. Also the special characters `.+-_` are allowed
        :param pulumi.Input[Sequence[pulumi.Input[Union['AzureCredentialsMonitorOnlyExcludingTagPairArgs', 'AzureCredentialsMonitorOnlyExcludingTagPairArgsDict']]]] monitor_only_excluding_tag_pairs: A list of Azure tags to be excluded from monitoring.  You can specify up to 20 tags. A resource tagged with *any* of the specified tags is monitored.  Only applicable when the **monitorOnlyTaggedEntities** parameter is set to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AzureCredentialsMonitorOnlyTagPairArgs', 'AzureCredentialsMonitorOnlyTagPairArgsDict']]]] monitor_only_tag_pairs: A list of Azure tags to be monitored.  You can specify up to 20 tags. A resource tagged with *any* of the specified tags is monitored.  Only applicable when the **monitorOnlyTaggedEntities** parameter is set to `true`
        :param pulumi.Input[builtins.bool] monitor_only_tagged_entities: Monitor only resources that have specified Azure tags (`true`) or all resources (`false`).
        :param pulumi.Input[builtins.bool] remove_defaults: Instructs the provider to remove the supporting services Dynatrace applies by default to newly created Azure Credentials. Supporting Services applied by via `AzureService` subsequently won't get touched.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AzureCredentialsSupportingServiceArgs', 'AzureCredentialsSupportingServiceArgsDict']]]] supporting_services: A list of Azure supporting services to be monitored. For each service there's a sublist of its metrics and the metrics' dimensions that should be monitored. All of these elements (services, metrics, dimensions) must have corresponding static definitions on the server.
        :param pulumi.Input[builtins.str] unknowns: Any attributes that aren't yet supported by this provider
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzureCredentialsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AzureCredentials resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AzureCredentialsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzureCredentialsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 app_id: Optional[pulumi.Input[builtins.str]] = None,
                 auto_tagging: Optional[pulumi.Input[builtins.bool]] = None,
                 directory_id: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 label: Optional[pulumi.Input[builtins.str]] = None,
                 monitor_only_excluding_tag_pairs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureCredentialsMonitorOnlyExcludingTagPairArgs', 'AzureCredentialsMonitorOnlyExcludingTagPairArgsDict']]]]] = None,
                 monitor_only_tag_pairs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureCredentialsMonitorOnlyTagPairArgs', 'AzureCredentialsMonitorOnlyTagPairArgsDict']]]]] = None,
                 monitor_only_tagged_entities: Optional[pulumi.Input[builtins.bool]] = None,
                 remove_defaults: Optional[pulumi.Input[builtins.bool]] = None,
                 supporting_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureCredentialsSupportingServiceArgs', 'AzureCredentialsSupportingServiceArgsDict']]]]] = None,
                 supporting_services_managed_in_dynatrace: Optional[pulumi.Input[builtins.bool]] = None,
                 unknowns: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzureCredentialsArgs.__new__(AzureCredentialsArgs)

            if active is None and not opts.urn:
                raise TypeError("Missing required property 'active'")
            __props__.__dict__["active"] = active
            __props__.__dict__["app_id"] = app_id
            __props__.__dict__["auto_tagging"] = auto_tagging
            __props__.__dict__["directory_id"] = directory_id
            __props__.__dict__["key"] = None if key is None else pulumi.Output.secret(key)
            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            __props__.__dict__["monitor_only_excluding_tag_pairs"] = monitor_only_excluding_tag_pairs
            __props__.__dict__["monitor_only_tag_pairs"] = monitor_only_tag_pairs
            if monitor_only_tagged_entities is None and not opts.urn:
                raise TypeError("Missing required property 'monitor_only_tagged_entities'")
            __props__.__dict__["monitor_only_tagged_entities"] = monitor_only_tagged_entities
            __props__.__dict__["remove_defaults"] = remove_defaults
            __props__.__dict__["supporting_services"] = supporting_services
            __props__.__dict__["supporting_services_managed_in_dynatrace"] = supporting_services_managed_in_dynatrace
            __props__.__dict__["unknowns"] = unknowns
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["key"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AzureCredentials, __self__).__init__(
            'dynatrace:index/azureCredentials:AzureCredentials',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active: Optional[pulumi.Input[builtins.bool]] = None,
            app_id: Optional[pulumi.Input[builtins.str]] = None,
            auto_tagging: Optional[pulumi.Input[builtins.bool]] = None,
            directory_id: Optional[pulumi.Input[builtins.str]] = None,
            key: Optional[pulumi.Input[builtins.str]] = None,
            label: Optional[pulumi.Input[builtins.str]] = None,
            monitor_only_excluding_tag_pairs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureCredentialsMonitorOnlyExcludingTagPairArgs', 'AzureCredentialsMonitorOnlyExcludingTagPairArgsDict']]]]] = None,
            monitor_only_tag_pairs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureCredentialsMonitorOnlyTagPairArgs', 'AzureCredentialsMonitorOnlyTagPairArgsDict']]]]] = None,
            monitor_only_tagged_entities: Optional[pulumi.Input[builtins.bool]] = None,
            remove_defaults: Optional[pulumi.Input[builtins.bool]] = None,
            supporting_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureCredentialsSupportingServiceArgs', 'AzureCredentialsSupportingServiceArgsDict']]]]] = None,
            supporting_services_managed_in_dynatrace: Optional[pulumi.Input[builtins.bool]] = None,
            unknowns: Optional[pulumi.Input[builtins.str]] = None) -> 'AzureCredentials':
        """
        Get an existing AzureCredentials resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] active: The monitoring is enabled (`true`) or disabled (`false`).  If not set on creation, the `true` value is used.  If the field is omitted during an update, the old value remains unaffected
        :param pulumi.Input[builtins.str] app_id: The Application ID (also referred to as Client ID)  The combination of Application ID and Directory ID must be unique
        :param pulumi.Input[builtins.bool] auto_tagging: The automatic capture of Azure tags is on (`true`) or off (`false`)
        :param pulumi.Input[builtins.str] directory_id: The Directory ID (also referred to as Tenant ID)  The combination of Application ID and Directory ID must be unique
        :param pulumi.Input[builtins.str] key: The secret key associated with the Application ID.  For security reasons, GET requests return this field as `null`. Submit your key on creation or update of the configuration. If the field is omitted during an update, the old value remains unaffected.
        :param pulumi.Input[builtins.str] label: The unique name of the Azure credentials configuration.  Allowed characters are letters, numbers, and spaces. Also the special characters `.+-_` are allowed
        :param pulumi.Input[Sequence[pulumi.Input[Union['AzureCredentialsMonitorOnlyExcludingTagPairArgs', 'AzureCredentialsMonitorOnlyExcludingTagPairArgsDict']]]] monitor_only_excluding_tag_pairs: A list of Azure tags to be excluded from monitoring.  You can specify up to 20 tags. A resource tagged with *any* of the specified tags is monitored.  Only applicable when the **monitorOnlyTaggedEntities** parameter is set to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AzureCredentialsMonitorOnlyTagPairArgs', 'AzureCredentialsMonitorOnlyTagPairArgsDict']]]] monitor_only_tag_pairs: A list of Azure tags to be monitored.  You can specify up to 20 tags. A resource tagged with *any* of the specified tags is monitored.  Only applicable when the **monitorOnlyTaggedEntities** parameter is set to `true`
        :param pulumi.Input[builtins.bool] monitor_only_tagged_entities: Monitor only resources that have specified Azure tags (`true`) or all resources (`false`).
        :param pulumi.Input[builtins.bool] remove_defaults: Instructs the provider to remove the supporting services Dynatrace applies by default to newly created Azure Credentials. Supporting Services applied by via `AzureService` subsequently won't get touched.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AzureCredentialsSupportingServiceArgs', 'AzureCredentialsSupportingServiceArgsDict']]]] supporting_services: A list of Azure supporting services to be monitored. For each service there's a sublist of its metrics and the metrics' dimensions that should be monitored. All of these elements (services, metrics, dimensions) must have corresponding static definitions on the server.
        :param pulumi.Input[builtins.str] unknowns: Any attributes that aren't yet supported by this provider
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzureCredentialsState.__new__(_AzureCredentialsState)

        __props__.__dict__["active"] = active
        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["auto_tagging"] = auto_tagging
        __props__.__dict__["directory_id"] = directory_id
        __props__.__dict__["key"] = key
        __props__.__dict__["label"] = label
        __props__.__dict__["monitor_only_excluding_tag_pairs"] = monitor_only_excluding_tag_pairs
        __props__.__dict__["monitor_only_tag_pairs"] = monitor_only_tag_pairs
        __props__.__dict__["monitor_only_tagged_entities"] = monitor_only_tagged_entities
        __props__.__dict__["remove_defaults"] = remove_defaults
        __props__.__dict__["supporting_services"] = supporting_services
        __props__.__dict__["supporting_services_managed_in_dynatrace"] = supporting_services_managed_in_dynatrace
        __props__.__dict__["unknowns"] = unknowns
        return AzureCredentials(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[builtins.bool]:
        """
        The monitoring is enabled (`true`) or disabled (`false`).  If not set on creation, the `true` value is used.  If the field is omitted during an update, the old value remains unaffected
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Application ID (also referred to as Client ID)  The combination of Application ID and Directory ID must be unique
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="autoTagging")
    def auto_tagging(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        The automatic capture of Azure tags is on (`true`) or off (`false`)
        """
        return pulumi.get(self, "auto_tagging")

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Directory ID (also referred to as Tenant ID)  The combination of Application ID and Directory ID must be unique
        """
        return pulumi.get(self, "directory_id")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The secret key associated with the Application ID.  For security reasons, GET requests return this field as `null`. Submit your key on creation or update of the configuration. If the field is omitted during an update, the old value remains unaffected.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def label(self) -> pulumi.Output[builtins.str]:
        """
        The unique name of the Azure credentials configuration.  Allowed characters are letters, numbers, and spaces. Also the special characters `.+-_` are allowed
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="monitorOnlyExcludingTagPairs")
    def monitor_only_excluding_tag_pairs(self) -> pulumi.Output[Optional[Sequence['outputs.AzureCredentialsMonitorOnlyExcludingTagPair']]]:
        """
        A list of Azure tags to be excluded from monitoring.  You can specify up to 20 tags. A resource tagged with *any* of the specified tags is monitored.  Only applicable when the **monitorOnlyTaggedEntities** parameter is set to `true`.
        """
        return pulumi.get(self, "monitor_only_excluding_tag_pairs")

    @property
    @pulumi.getter(name="monitorOnlyTagPairs")
    def monitor_only_tag_pairs(self) -> pulumi.Output[Optional[Sequence['outputs.AzureCredentialsMonitorOnlyTagPair']]]:
        """
        A list of Azure tags to be monitored.  You can specify up to 20 tags. A resource tagged with *any* of the specified tags is monitored.  Only applicable when the **monitorOnlyTaggedEntities** parameter is set to `true`
        """
        return pulumi.get(self, "monitor_only_tag_pairs")

    @property
    @pulumi.getter(name="monitorOnlyTaggedEntities")
    def monitor_only_tagged_entities(self) -> pulumi.Output[builtins.bool]:
        """
        Monitor only resources that have specified Azure tags (`true`) or all resources (`false`).
        """
        return pulumi.get(self, "monitor_only_tagged_entities")

    @property
    @pulumi.getter(name="removeDefaults")
    def remove_defaults(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Instructs the provider to remove the supporting services Dynatrace applies by default to newly created Azure Credentials. Supporting Services applied by via `AzureService` subsequently won't get touched.
        """
        return pulumi.get(self, "remove_defaults")

    @property
    @pulumi.getter(name="supportingServices")
    @_utilities.deprecated("""Assigning supported services directly when creating Azure Credentials is deprecated. Use the resource `AzureService` instead.""")
    def supporting_services(self) -> pulumi.Output[Optional[Sequence['outputs.AzureCredentialsSupportingService']]]:
        """
        A list of Azure supporting services to be monitored. For each service there's a sublist of its metrics and the metrics' dimensions that should be monitored. All of these elements (services, metrics, dimensions) must have corresponding static definitions on the server.
        """
        return pulumi.get(self, "supporting_services")

    @property
    @pulumi.getter(name="supportingServicesManagedInDynatrace")
    @_utilities.deprecated("""This attribute is deprecated and has no effect any more. It always defaults to `true`.""")
    def supporting_services_managed_in_dynatrace(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "supporting_services_managed_in_dynatrace")

    @property
    @pulumi.getter
    def unknowns(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Any attributes that aren't yet supported by this provider
        """
        return pulumi.get(self, "unknowns")

