# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CalculatedWebMetricArgs', 'CalculatedWebMetric']

@pulumi.input_type
class CalculatedWebMetricArgs:
    def __init__(__self__, *,
                 app_identifier: pulumi.Input[builtins.str],
                 enabled: pulumi.Input[builtins.bool],
                 metric_definition: pulumi.Input['CalculatedWebMetricMetricDefinitionArgs'],
                 metric_key: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['CalculatedWebMetricDimensionArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 user_action_filter: Optional[pulumi.Input['CalculatedWebMetricUserActionFilterArgs']] = None):
        """
        The set of arguments for constructing a CalculatedWebMetric resource.
        :param pulumi.Input[builtins.str] app_identifier: The Dynatrace entity ID of the application to which the metric belongs.
        :param pulumi.Input[builtins.bool] enabled: The metric is enabled (`true`) or disabled (`false`)
        :param pulumi.Input['CalculatedWebMetricMetricDefinitionArgs'] metric_definition: The definition of a calculated web metric.
        :param pulumi.Input[builtins.str] metric_key: The unique key of the calculated web metric.
        :param pulumi.Input[builtins.str] description: Descriptor of a calculated web metric.
        :param pulumi.Input[Sequence[pulumi.Input['CalculatedWebMetricDimensionArgs']]] dimensions: Parameters of a definition of a calculated web metric.
        :param pulumi.Input[builtins.str] name: The displayed name of the metric.
        :param pulumi.Input['CalculatedWebMetricUserActionFilterArgs'] user_action_filter: Parameters of a definition of a calculated web metric.
        """
        pulumi.set(__self__, "app_identifier", app_identifier)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "metric_definition", metric_definition)
        pulumi.set(__self__, "metric_key", metric_key)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if user_action_filter is not None:
            pulumi.set(__self__, "user_action_filter", user_action_filter)

    @property
    @pulumi.getter(name="appIdentifier")
    def app_identifier(self) -> pulumi.Input[builtins.str]:
        """
        The Dynatrace entity ID of the application to which the metric belongs.
        """
        return pulumi.get(self, "app_identifier")

    @app_identifier.setter
    def app_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "app_identifier", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        The metric is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="metricDefinition")
    def metric_definition(self) -> pulumi.Input['CalculatedWebMetricMetricDefinitionArgs']:
        """
        The definition of a calculated web metric.
        """
        return pulumi.get(self, "metric_definition")

    @metric_definition.setter
    def metric_definition(self, value: pulumi.Input['CalculatedWebMetricMetricDefinitionArgs']):
        pulumi.set(self, "metric_definition", value)

    @property
    @pulumi.getter(name="metricKey")
    def metric_key(self) -> pulumi.Input[builtins.str]:
        """
        The unique key of the calculated web metric.
        """
        return pulumi.get(self, "metric_key")

    @metric_key.setter
    def metric_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "metric_key", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Descriptor of a calculated web metric.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CalculatedWebMetricDimensionArgs']]]]:
        """
        Parameters of a definition of a calculated web metric.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CalculatedWebMetricDimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The displayed name of the metric.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="userActionFilter")
    def user_action_filter(self) -> Optional[pulumi.Input['CalculatedWebMetricUserActionFilterArgs']]:
        """
        Parameters of a definition of a calculated web metric.
        """
        return pulumi.get(self, "user_action_filter")

    @user_action_filter.setter
    def user_action_filter(self, value: Optional[pulumi.Input['CalculatedWebMetricUserActionFilterArgs']]):
        pulumi.set(self, "user_action_filter", value)


@pulumi.input_type
class _CalculatedWebMetricState:
    def __init__(__self__, *,
                 app_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['CalculatedWebMetricDimensionArgs']]]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 metric_definition: Optional[pulumi.Input['CalculatedWebMetricMetricDefinitionArgs']] = None,
                 metric_key: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 user_action_filter: Optional[pulumi.Input['CalculatedWebMetricUserActionFilterArgs']] = None):
        """
        Input properties used for looking up and filtering CalculatedWebMetric resources.
        :param pulumi.Input[builtins.str] app_identifier: The Dynatrace entity ID of the application to which the metric belongs.
        :param pulumi.Input[builtins.str] description: Descriptor of a calculated web metric.
        :param pulumi.Input[Sequence[pulumi.Input['CalculatedWebMetricDimensionArgs']]] dimensions: Parameters of a definition of a calculated web metric.
        :param pulumi.Input[builtins.bool] enabled: The metric is enabled (`true`) or disabled (`false`)
        :param pulumi.Input['CalculatedWebMetricMetricDefinitionArgs'] metric_definition: The definition of a calculated web metric.
        :param pulumi.Input[builtins.str] metric_key: The unique key of the calculated web metric.
        :param pulumi.Input[builtins.str] name: The displayed name of the metric.
        :param pulumi.Input['CalculatedWebMetricUserActionFilterArgs'] user_action_filter: Parameters of a definition of a calculated web metric.
        """
        if app_identifier is not None:
            pulumi.set(__self__, "app_identifier", app_identifier)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if metric_definition is not None:
            pulumi.set(__self__, "metric_definition", metric_definition)
        if metric_key is not None:
            pulumi.set(__self__, "metric_key", metric_key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if user_action_filter is not None:
            pulumi.set(__self__, "user_action_filter", user_action_filter)

    @property
    @pulumi.getter(name="appIdentifier")
    def app_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Dynatrace entity ID of the application to which the metric belongs.
        """
        return pulumi.get(self, "app_identifier")

    @app_identifier.setter
    def app_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "app_identifier", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Descriptor of a calculated web metric.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CalculatedWebMetricDimensionArgs']]]]:
        """
        Parameters of a definition of a calculated web metric.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CalculatedWebMetricDimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The metric is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="metricDefinition")
    def metric_definition(self) -> Optional[pulumi.Input['CalculatedWebMetricMetricDefinitionArgs']]:
        """
        The definition of a calculated web metric.
        """
        return pulumi.get(self, "metric_definition")

    @metric_definition.setter
    def metric_definition(self, value: Optional[pulumi.Input['CalculatedWebMetricMetricDefinitionArgs']]):
        pulumi.set(self, "metric_definition", value)

    @property
    @pulumi.getter(name="metricKey")
    def metric_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique key of the calculated web metric.
        """
        return pulumi.get(self, "metric_key")

    @metric_key.setter
    def metric_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "metric_key", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The displayed name of the metric.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="userActionFilter")
    def user_action_filter(self) -> Optional[pulumi.Input['CalculatedWebMetricUserActionFilterArgs']]:
        """
        Parameters of a definition of a calculated web metric.
        """
        return pulumi.get(self, "user_action_filter")

    @user_action_filter.setter
    def user_action_filter(self, value: Optional[pulumi.Input['CalculatedWebMetricUserActionFilterArgs']]):
        pulumi.set(self, "user_action_filter", value)


@pulumi.type_token("dynatrace:index/calculatedWebMetric:CalculatedWebMetric")
class CalculatedWebMetric(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CalculatedWebMetricDimensionArgs', 'CalculatedWebMetricDimensionArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 metric_definition: Optional[pulumi.Input[Union['CalculatedWebMetricMetricDefinitionArgs', 'CalculatedWebMetricMetricDefinitionArgsDict']]] = None,
                 metric_key: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 user_action_filter: Optional[pulumi.Input[Union['CalculatedWebMetricUserActionFilterArgs', 'CalculatedWebMetricUserActionFilterArgsDict']]] = None,
                 __props__=None):
        """
        Create a CalculatedWebMetric resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] app_identifier: The Dynatrace entity ID of the application to which the metric belongs.
        :param pulumi.Input[builtins.str] description: Descriptor of a calculated web metric.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CalculatedWebMetricDimensionArgs', 'CalculatedWebMetricDimensionArgsDict']]]] dimensions: Parameters of a definition of a calculated web metric.
        :param pulumi.Input[builtins.bool] enabled: The metric is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[Union['CalculatedWebMetricMetricDefinitionArgs', 'CalculatedWebMetricMetricDefinitionArgsDict']] metric_definition: The definition of a calculated web metric.
        :param pulumi.Input[builtins.str] metric_key: The unique key of the calculated web metric.
        :param pulumi.Input[builtins.str] name: The displayed name of the metric.
        :param pulumi.Input[Union['CalculatedWebMetricUserActionFilterArgs', 'CalculatedWebMetricUserActionFilterArgsDict']] user_action_filter: Parameters of a definition of a calculated web metric.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CalculatedWebMetricArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a CalculatedWebMetric resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param CalculatedWebMetricArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CalculatedWebMetricArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CalculatedWebMetricDimensionArgs', 'CalculatedWebMetricDimensionArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 metric_definition: Optional[pulumi.Input[Union['CalculatedWebMetricMetricDefinitionArgs', 'CalculatedWebMetricMetricDefinitionArgsDict']]] = None,
                 metric_key: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 user_action_filter: Optional[pulumi.Input[Union['CalculatedWebMetricUserActionFilterArgs', 'CalculatedWebMetricUserActionFilterArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CalculatedWebMetricArgs.__new__(CalculatedWebMetricArgs)

            if app_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'app_identifier'")
            __props__.__dict__["app_identifier"] = app_identifier
            __props__.__dict__["description"] = description
            __props__.__dict__["dimensions"] = dimensions
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if metric_definition is None and not opts.urn:
                raise TypeError("Missing required property 'metric_definition'")
            __props__.__dict__["metric_definition"] = metric_definition
            if metric_key is None and not opts.urn:
                raise TypeError("Missing required property 'metric_key'")
            __props__.__dict__["metric_key"] = metric_key
            __props__.__dict__["name"] = name
            __props__.__dict__["user_action_filter"] = user_action_filter
        super(CalculatedWebMetric, __self__).__init__(
            'dynatrace:index/calculatedWebMetric:CalculatedWebMetric',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_identifier: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CalculatedWebMetricDimensionArgs', 'CalculatedWebMetricDimensionArgsDict']]]]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            metric_definition: Optional[pulumi.Input[Union['CalculatedWebMetricMetricDefinitionArgs', 'CalculatedWebMetricMetricDefinitionArgsDict']]] = None,
            metric_key: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            user_action_filter: Optional[pulumi.Input[Union['CalculatedWebMetricUserActionFilterArgs', 'CalculatedWebMetricUserActionFilterArgsDict']]] = None) -> 'CalculatedWebMetric':
        """
        Get an existing CalculatedWebMetric resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] app_identifier: The Dynatrace entity ID of the application to which the metric belongs.
        :param pulumi.Input[builtins.str] description: Descriptor of a calculated web metric.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CalculatedWebMetricDimensionArgs', 'CalculatedWebMetricDimensionArgsDict']]]] dimensions: Parameters of a definition of a calculated web metric.
        :param pulumi.Input[builtins.bool] enabled: The metric is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[Union['CalculatedWebMetricMetricDefinitionArgs', 'CalculatedWebMetricMetricDefinitionArgsDict']] metric_definition: The definition of a calculated web metric.
        :param pulumi.Input[builtins.str] metric_key: The unique key of the calculated web metric.
        :param pulumi.Input[builtins.str] name: The displayed name of the metric.
        :param pulumi.Input[Union['CalculatedWebMetricUserActionFilterArgs', 'CalculatedWebMetricUserActionFilterArgsDict']] user_action_filter: Parameters of a definition of a calculated web metric.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CalculatedWebMetricState.__new__(_CalculatedWebMetricState)

        __props__.__dict__["app_identifier"] = app_identifier
        __props__.__dict__["description"] = description
        __props__.__dict__["dimensions"] = dimensions
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["metric_definition"] = metric_definition
        __props__.__dict__["metric_key"] = metric_key
        __props__.__dict__["name"] = name
        __props__.__dict__["user_action_filter"] = user_action_filter
        return CalculatedWebMetric(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appIdentifier")
    def app_identifier(self) -> pulumi.Output[builtins.str]:
        """
        The Dynatrace entity ID of the application to which the metric belongs.
        """
        return pulumi.get(self, "app_identifier")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Descriptor of a calculated web metric.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def dimensions(self) -> pulumi.Output[Optional[Sequence['outputs.CalculatedWebMetricDimension']]]:
        """
        Parameters of a definition of a calculated web metric.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        The metric is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="metricDefinition")
    def metric_definition(self) -> pulumi.Output['outputs.CalculatedWebMetricMetricDefinition']:
        """
        The definition of a calculated web metric.
        """
        return pulumi.get(self, "metric_definition")

    @property
    @pulumi.getter(name="metricKey")
    def metric_key(self) -> pulumi.Output[builtins.str]:
        """
        The unique key of the calculated web metric.
        """
        return pulumi.get(self, "metric_key")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The displayed name of the metric.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="userActionFilter")
    def user_action_filter(self) -> pulumi.Output[Optional['outputs.CalculatedWebMetricUserActionFilter']]:
        """
        Parameters of a definition of a calculated web metric.
        """
        return pulumi.get(self, "user_action_filter")

