# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CloudfoundryCredentialsArgs', 'CloudfoundryCredentials']

@pulumi.input_type
class CloudfoundryCredentialsArgs:
    def __init__(__self__, *,
                 api_url: pulumi.Input[builtins.str],
                 login_url: pulumi.Input[builtins.str],
                 username: pulumi.Input[builtins.str],
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 unknowns: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CloudfoundryCredentials resource.
        :param pulumi.Input[builtins.str] api_url: The URL of the Cloud Foundry foundation credentials.  The URL must be valid according to RFC 2396.  Leading or trailing whitespaces are not allowed.
        :param pulumi.Input[builtins.str] login_url: The login URL of the Cloud Foundry foundation credentials. The URL must be valid according to RFC 2396.  Leading or trailing whitespaces are not allowed.
        :param pulumi.Input[builtins.str] username: The username of the Cloud Foundry foundation credentials.  Leading and trailing whitespaces are not allowed.
        :param pulumi.Input[builtins.bool] active: The monitoring is enabled (`true`) or disabled (`false`) for given credentials configuration.  If not set on creation, the `true` value is used.  If the field is omitted during an update, the old value remains unaffected.
        :param pulumi.Input[builtins.str] name: The name of the Cloud Foundry foundation credentials.  Allowed characters are letters, numbers, whitespaces, and the following characters: `.+-_`. Leading or trailing whitespace is not allowed.
        :param pulumi.Input[builtins.str] password: The password of the Cloud Foundry foundation credentials.
        :param pulumi.Input[builtins.str] unknowns: Any attributes that aren't yet supported by this provider
        """
        pulumi.set(__self__, "api_url", api_url)
        pulumi.set(__self__, "login_url", login_url)
        pulumi.set(__self__, "username", username)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if unknowns is not None:
            pulumi.set(__self__, "unknowns", unknowns)

    @property
    @pulumi.getter(name="apiUrl")
    def api_url(self) -> pulumi.Input[builtins.str]:
        """
        The URL of the Cloud Foundry foundation credentials.  The URL must be valid according to RFC 2396.  Leading or trailing whitespaces are not allowed.
        """
        return pulumi.get(self, "api_url")

    @api_url.setter
    def api_url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "api_url", value)

    @property
    @pulumi.getter(name="loginUrl")
    def login_url(self) -> pulumi.Input[builtins.str]:
        """
        The login URL of the Cloud Foundry foundation credentials. The URL must be valid according to RFC 2396.  Leading or trailing whitespaces are not allowed.
        """
        return pulumi.get(self, "login_url")

    @login_url.setter
    def login_url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "login_url", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[builtins.str]:
        """
        The username of the Cloud Foundry foundation credentials.  Leading and trailing whitespaces are not allowed.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The monitoring is enabled (`true`) or disabled (`false`) for given credentials configuration.  If not set on creation, the `true` value is used.  If the field is omitted during an update, the old value remains unaffected.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Cloud Foundry foundation credentials.  Allowed characters are letters, numbers, whitespaces, and the following characters: `.+-_`. Leading or trailing whitespace is not allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password of the Cloud Foundry foundation credentials.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def unknowns(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Any attributes that aren't yet supported by this provider
        """
        return pulumi.get(self, "unknowns")

    @unknowns.setter
    def unknowns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "unknowns", value)


@pulumi.input_type
class _CloudfoundryCredentialsState:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 api_url: Optional[pulumi.Input[builtins.str]] = None,
                 login_url: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 unknowns: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CloudfoundryCredentials resources.
        :param pulumi.Input[builtins.bool] active: The monitoring is enabled (`true`) or disabled (`false`) for given credentials configuration.  If not set on creation, the `true` value is used.  If the field is omitted during an update, the old value remains unaffected.
        :param pulumi.Input[builtins.str] api_url: The URL of the Cloud Foundry foundation credentials.  The URL must be valid according to RFC 2396.  Leading or trailing whitespaces are not allowed.
        :param pulumi.Input[builtins.str] login_url: The login URL of the Cloud Foundry foundation credentials. The URL must be valid according to RFC 2396.  Leading or trailing whitespaces are not allowed.
        :param pulumi.Input[builtins.str] name: The name of the Cloud Foundry foundation credentials.  Allowed characters are letters, numbers, whitespaces, and the following characters: `.+-_`. Leading or trailing whitespace is not allowed.
        :param pulumi.Input[builtins.str] password: The password of the Cloud Foundry foundation credentials.
        :param pulumi.Input[builtins.str] unknowns: Any attributes that aren't yet supported by this provider
        :param pulumi.Input[builtins.str] username: The username of the Cloud Foundry foundation credentials.  Leading and trailing whitespaces are not allowed.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if api_url is not None:
            pulumi.set(__self__, "api_url", api_url)
        if login_url is not None:
            pulumi.set(__self__, "login_url", login_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if unknowns is not None:
            pulumi.set(__self__, "unknowns", unknowns)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The monitoring is enabled (`true`) or disabled (`false`) for given credentials configuration.  If not set on creation, the `true` value is used.  If the field is omitted during an update, the old value remains unaffected.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="apiUrl")
    def api_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL of the Cloud Foundry foundation credentials.  The URL must be valid according to RFC 2396.  Leading or trailing whitespaces are not allowed.
        """
        return pulumi.get(self, "api_url")

    @api_url.setter
    def api_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_url", value)

    @property
    @pulumi.getter(name="loginUrl")
    def login_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The login URL of the Cloud Foundry foundation credentials. The URL must be valid according to RFC 2396.  Leading or trailing whitespaces are not allowed.
        """
        return pulumi.get(self, "login_url")

    @login_url.setter
    def login_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "login_url", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Cloud Foundry foundation credentials.  Allowed characters are letters, numbers, whitespaces, and the following characters: `.+-_`. Leading or trailing whitespace is not allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password of the Cloud Foundry foundation credentials.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def unknowns(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Any attributes that aren't yet supported by this provider
        """
        return pulumi.get(self, "unknowns")

    @unknowns.setter
    def unknowns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "unknowns", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The username of the Cloud Foundry foundation credentials.  Leading and trailing whitespaces are not allowed.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("dynatrace:index/cloudfoundryCredentials:CloudfoundryCredentials")
class CloudfoundryCredentials(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 api_url: Optional[pulumi.Input[builtins.str]] = None,
                 login_url: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 unknowns: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a CloudfoundryCredentials resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] active: The monitoring is enabled (`true`) or disabled (`false`) for given credentials configuration.  If not set on creation, the `true` value is used.  If the field is omitted during an update, the old value remains unaffected.
        :param pulumi.Input[builtins.str] api_url: The URL of the Cloud Foundry foundation credentials.  The URL must be valid according to RFC 2396.  Leading or trailing whitespaces are not allowed.
        :param pulumi.Input[builtins.str] login_url: The login URL of the Cloud Foundry foundation credentials. The URL must be valid according to RFC 2396.  Leading or trailing whitespaces are not allowed.
        :param pulumi.Input[builtins.str] name: The name of the Cloud Foundry foundation credentials.  Allowed characters are letters, numbers, whitespaces, and the following characters: `.+-_`. Leading or trailing whitespace is not allowed.
        :param pulumi.Input[builtins.str] password: The password of the Cloud Foundry foundation credentials.
        :param pulumi.Input[builtins.str] unknowns: Any attributes that aren't yet supported by this provider
        :param pulumi.Input[builtins.str] username: The username of the Cloud Foundry foundation credentials.  Leading and trailing whitespaces are not allowed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudfoundryCredentialsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a CloudfoundryCredentials resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param CloudfoundryCredentialsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudfoundryCredentialsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 api_url: Optional[pulumi.Input[builtins.str]] = None,
                 login_url: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 unknowns: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudfoundryCredentialsArgs.__new__(CloudfoundryCredentialsArgs)

            __props__.__dict__["active"] = active
            if api_url is None and not opts.urn:
                raise TypeError("Missing required property 'api_url'")
            __props__.__dict__["api_url"] = api_url
            if login_url is None and not opts.urn:
                raise TypeError("Missing required property 'login_url'")
            __props__.__dict__["login_url"] = login_url
            __props__.__dict__["name"] = name
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["unknowns"] = unknowns
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(CloudfoundryCredentials, __self__).__init__(
            'dynatrace:index/cloudfoundryCredentials:CloudfoundryCredentials',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active: Optional[pulumi.Input[builtins.bool]] = None,
            api_url: Optional[pulumi.Input[builtins.str]] = None,
            login_url: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            password: Optional[pulumi.Input[builtins.str]] = None,
            unknowns: Optional[pulumi.Input[builtins.str]] = None,
            username: Optional[pulumi.Input[builtins.str]] = None) -> 'CloudfoundryCredentials':
        """
        Get an existing CloudfoundryCredentials resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] active: The monitoring is enabled (`true`) or disabled (`false`) for given credentials configuration.  If not set on creation, the `true` value is used.  If the field is omitted during an update, the old value remains unaffected.
        :param pulumi.Input[builtins.str] api_url: The URL of the Cloud Foundry foundation credentials.  The URL must be valid according to RFC 2396.  Leading or trailing whitespaces are not allowed.
        :param pulumi.Input[builtins.str] login_url: The login URL of the Cloud Foundry foundation credentials. The URL must be valid according to RFC 2396.  Leading or trailing whitespaces are not allowed.
        :param pulumi.Input[builtins.str] name: The name of the Cloud Foundry foundation credentials.  Allowed characters are letters, numbers, whitespaces, and the following characters: `.+-_`. Leading or trailing whitespace is not allowed.
        :param pulumi.Input[builtins.str] password: The password of the Cloud Foundry foundation credentials.
        :param pulumi.Input[builtins.str] unknowns: Any attributes that aren't yet supported by this provider
        :param pulumi.Input[builtins.str] username: The username of the Cloud Foundry foundation credentials.  Leading and trailing whitespaces are not allowed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudfoundryCredentialsState.__new__(_CloudfoundryCredentialsState)

        __props__.__dict__["active"] = active
        __props__.__dict__["api_url"] = api_url
        __props__.__dict__["login_url"] = login_url
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["unknowns"] = unknowns
        __props__.__dict__["username"] = username
        return CloudfoundryCredentials(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        The monitoring is enabled (`true`) or disabled (`false`) for given credentials configuration.  If not set on creation, the `true` value is used.  If the field is omitted during an update, the old value remains unaffected.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="apiUrl")
    def api_url(self) -> pulumi.Output[builtins.str]:
        """
        The URL of the Cloud Foundry foundation credentials.  The URL must be valid according to RFC 2396.  Leading or trailing whitespaces are not allowed.
        """
        return pulumi.get(self, "api_url")

    @property
    @pulumi.getter(name="loginUrl")
    def login_url(self) -> pulumi.Output[builtins.str]:
        """
        The login URL of the Cloud Foundry foundation credentials. The URL must be valid according to RFC 2396.  Leading or trailing whitespaces are not allowed.
        """
        return pulumi.get(self, "login_url")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Cloud Foundry foundation credentials.  Allowed characters are letters, numbers, whitespaces, and the following characters: `.+-_`. Leading or trailing whitespace is not allowed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The password of the Cloud Foundry foundation credentials.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def unknowns(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Any attributes that aren't yet supported by this provider
        """
        return pulumi.get(self, "unknowns")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[builtins.str]:
        """
        The username of the Cloud Foundry foundation credentials.  Leading and trailing whitespaces are not allowed.
        """
        return pulumi.get(self, "username")

