# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ContainerBuiltinRuleArgs', 'ContainerBuiltinRule']

@pulumi.input_type
class ContainerBuiltinRuleArgs:
    def __init__(__self__, *,
                 ignore_docker_pause_container: pulumi.Input[builtins.bool],
                 ignore_kubernetes_pause_container: pulumi.Input[builtins.bool],
                 ignore_open_shift_build_pod_name: pulumi.Input[builtins.bool],
                 ignore_open_shift_sdn_namespace: pulumi.Input[builtins.bool]):
        """
        The set of arguments for constructing a ContainerBuiltinRule resource.
        :param pulumi.Input[builtins.bool] ignore_docker_pause_container: Disable monitoring of platform internal pause containers in Kubernetes and OpenShift.
        :param pulumi.Input[builtins.bool] ignore_kubernetes_pause_container: Disable monitoring of platform internal pause containers in Kubernetes and OpenShift.
        :param pulumi.Input[builtins.bool] ignore_open_shift_build_pod_name: Disable monitoring of intermediate containers created during image build.
        :param pulumi.Input[builtins.bool] ignore_open_shift_sdn_namespace: Disable monitoring of platform internal containers in the openshift-sdn namespace.
        """
        pulumi.set(__self__, "ignore_docker_pause_container", ignore_docker_pause_container)
        pulumi.set(__self__, "ignore_kubernetes_pause_container", ignore_kubernetes_pause_container)
        pulumi.set(__self__, "ignore_open_shift_build_pod_name", ignore_open_shift_build_pod_name)
        pulumi.set(__self__, "ignore_open_shift_sdn_namespace", ignore_open_shift_sdn_namespace)

    @property
    @pulumi.getter(name="ignoreDockerPauseContainer")
    def ignore_docker_pause_container(self) -> pulumi.Input[builtins.bool]:
        """
        Disable monitoring of platform internal pause containers in Kubernetes and OpenShift.
        """
        return pulumi.get(self, "ignore_docker_pause_container")

    @ignore_docker_pause_container.setter
    def ignore_docker_pause_container(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "ignore_docker_pause_container", value)

    @property
    @pulumi.getter(name="ignoreKubernetesPauseContainer")
    def ignore_kubernetes_pause_container(self) -> pulumi.Input[builtins.bool]:
        """
        Disable monitoring of platform internal pause containers in Kubernetes and OpenShift.
        """
        return pulumi.get(self, "ignore_kubernetes_pause_container")

    @ignore_kubernetes_pause_container.setter
    def ignore_kubernetes_pause_container(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "ignore_kubernetes_pause_container", value)

    @property
    @pulumi.getter(name="ignoreOpenShiftBuildPodName")
    def ignore_open_shift_build_pod_name(self) -> pulumi.Input[builtins.bool]:
        """
        Disable monitoring of intermediate containers created during image build.
        """
        return pulumi.get(self, "ignore_open_shift_build_pod_name")

    @ignore_open_shift_build_pod_name.setter
    def ignore_open_shift_build_pod_name(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "ignore_open_shift_build_pod_name", value)

    @property
    @pulumi.getter(name="ignoreOpenShiftSdnNamespace")
    def ignore_open_shift_sdn_namespace(self) -> pulumi.Input[builtins.bool]:
        """
        Disable monitoring of platform internal containers in the openshift-sdn namespace.
        """
        return pulumi.get(self, "ignore_open_shift_sdn_namespace")

    @ignore_open_shift_sdn_namespace.setter
    def ignore_open_shift_sdn_namespace(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "ignore_open_shift_sdn_namespace", value)


@pulumi.input_type
class _ContainerBuiltinRuleState:
    def __init__(__self__, *,
                 ignore_docker_pause_container: Optional[pulumi.Input[builtins.bool]] = None,
                 ignore_kubernetes_pause_container: Optional[pulumi.Input[builtins.bool]] = None,
                 ignore_open_shift_build_pod_name: Optional[pulumi.Input[builtins.bool]] = None,
                 ignore_open_shift_sdn_namespace: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ContainerBuiltinRule resources.
        :param pulumi.Input[builtins.bool] ignore_docker_pause_container: Disable monitoring of platform internal pause containers in Kubernetes and OpenShift.
        :param pulumi.Input[builtins.bool] ignore_kubernetes_pause_container: Disable monitoring of platform internal pause containers in Kubernetes and OpenShift.
        :param pulumi.Input[builtins.bool] ignore_open_shift_build_pod_name: Disable monitoring of intermediate containers created during image build.
        :param pulumi.Input[builtins.bool] ignore_open_shift_sdn_namespace: Disable monitoring of platform internal containers in the openshift-sdn namespace.
        """
        if ignore_docker_pause_container is not None:
            pulumi.set(__self__, "ignore_docker_pause_container", ignore_docker_pause_container)
        if ignore_kubernetes_pause_container is not None:
            pulumi.set(__self__, "ignore_kubernetes_pause_container", ignore_kubernetes_pause_container)
        if ignore_open_shift_build_pod_name is not None:
            pulumi.set(__self__, "ignore_open_shift_build_pod_name", ignore_open_shift_build_pod_name)
        if ignore_open_shift_sdn_namespace is not None:
            pulumi.set(__self__, "ignore_open_shift_sdn_namespace", ignore_open_shift_sdn_namespace)

    @property
    @pulumi.getter(name="ignoreDockerPauseContainer")
    def ignore_docker_pause_container(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Disable monitoring of platform internal pause containers in Kubernetes and OpenShift.
        """
        return pulumi.get(self, "ignore_docker_pause_container")

    @ignore_docker_pause_container.setter
    def ignore_docker_pause_container(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ignore_docker_pause_container", value)

    @property
    @pulumi.getter(name="ignoreKubernetesPauseContainer")
    def ignore_kubernetes_pause_container(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Disable monitoring of platform internal pause containers in Kubernetes and OpenShift.
        """
        return pulumi.get(self, "ignore_kubernetes_pause_container")

    @ignore_kubernetes_pause_container.setter
    def ignore_kubernetes_pause_container(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ignore_kubernetes_pause_container", value)

    @property
    @pulumi.getter(name="ignoreOpenShiftBuildPodName")
    def ignore_open_shift_build_pod_name(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Disable monitoring of intermediate containers created during image build.
        """
        return pulumi.get(self, "ignore_open_shift_build_pod_name")

    @ignore_open_shift_build_pod_name.setter
    def ignore_open_shift_build_pod_name(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ignore_open_shift_build_pod_name", value)

    @property
    @pulumi.getter(name="ignoreOpenShiftSdnNamespace")
    def ignore_open_shift_sdn_namespace(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Disable monitoring of platform internal containers in the openshift-sdn namespace.
        """
        return pulumi.get(self, "ignore_open_shift_sdn_namespace")

    @ignore_open_shift_sdn_namespace.setter
    def ignore_open_shift_sdn_namespace(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ignore_open_shift_sdn_namespace", value)


@pulumi.type_token("dynatrace:index/containerBuiltinRule:ContainerBuiltinRule")
class ContainerBuiltinRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ignore_docker_pause_container: Optional[pulumi.Input[builtins.bool]] = None,
                 ignore_kubernetes_pause_container: Optional[pulumi.Input[builtins.bool]] = None,
                 ignore_open_shift_build_pod_name: Optional[pulumi.Input[builtins.bool]] = None,
                 ignore_open_shift_sdn_namespace: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        Create a ContainerBuiltinRule resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] ignore_docker_pause_container: Disable monitoring of platform internal pause containers in Kubernetes and OpenShift.
        :param pulumi.Input[builtins.bool] ignore_kubernetes_pause_container: Disable monitoring of platform internal pause containers in Kubernetes and OpenShift.
        :param pulumi.Input[builtins.bool] ignore_open_shift_build_pod_name: Disable monitoring of intermediate containers created during image build.
        :param pulumi.Input[builtins.bool] ignore_open_shift_sdn_namespace: Disable monitoring of platform internal containers in the openshift-sdn namespace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContainerBuiltinRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ContainerBuiltinRule resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ContainerBuiltinRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContainerBuiltinRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ignore_docker_pause_container: Optional[pulumi.Input[builtins.bool]] = None,
                 ignore_kubernetes_pause_container: Optional[pulumi.Input[builtins.bool]] = None,
                 ignore_open_shift_build_pod_name: Optional[pulumi.Input[builtins.bool]] = None,
                 ignore_open_shift_sdn_namespace: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContainerBuiltinRuleArgs.__new__(ContainerBuiltinRuleArgs)

            if ignore_docker_pause_container is None and not opts.urn:
                raise TypeError("Missing required property 'ignore_docker_pause_container'")
            __props__.__dict__["ignore_docker_pause_container"] = ignore_docker_pause_container
            if ignore_kubernetes_pause_container is None and not opts.urn:
                raise TypeError("Missing required property 'ignore_kubernetes_pause_container'")
            __props__.__dict__["ignore_kubernetes_pause_container"] = ignore_kubernetes_pause_container
            if ignore_open_shift_build_pod_name is None and not opts.urn:
                raise TypeError("Missing required property 'ignore_open_shift_build_pod_name'")
            __props__.__dict__["ignore_open_shift_build_pod_name"] = ignore_open_shift_build_pod_name
            if ignore_open_shift_sdn_namespace is None and not opts.urn:
                raise TypeError("Missing required property 'ignore_open_shift_sdn_namespace'")
            __props__.__dict__["ignore_open_shift_sdn_namespace"] = ignore_open_shift_sdn_namespace
        super(ContainerBuiltinRule, __self__).__init__(
            'dynatrace:index/containerBuiltinRule:ContainerBuiltinRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ignore_docker_pause_container: Optional[pulumi.Input[builtins.bool]] = None,
            ignore_kubernetes_pause_container: Optional[pulumi.Input[builtins.bool]] = None,
            ignore_open_shift_build_pod_name: Optional[pulumi.Input[builtins.bool]] = None,
            ignore_open_shift_sdn_namespace: Optional[pulumi.Input[builtins.bool]] = None) -> 'ContainerBuiltinRule':
        """
        Get an existing ContainerBuiltinRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] ignore_docker_pause_container: Disable monitoring of platform internal pause containers in Kubernetes and OpenShift.
        :param pulumi.Input[builtins.bool] ignore_kubernetes_pause_container: Disable monitoring of platform internal pause containers in Kubernetes and OpenShift.
        :param pulumi.Input[builtins.bool] ignore_open_shift_build_pod_name: Disable monitoring of intermediate containers created during image build.
        :param pulumi.Input[builtins.bool] ignore_open_shift_sdn_namespace: Disable monitoring of platform internal containers in the openshift-sdn namespace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContainerBuiltinRuleState.__new__(_ContainerBuiltinRuleState)

        __props__.__dict__["ignore_docker_pause_container"] = ignore_docker_pause_container
        __props__.__dict__["ignore_kubernetes_pause_container"] = ignore_kubernetes_pause_container
        __props__.__dict__["ignore_open_shift_build_pod_name"] = ignore_open_shift_build_pod_name
        __props__.__dict__["ignore_open_shift_sdn_namespace"] = ignore_open_shift_sdn_namespace
        return ContainerBuiltinRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="ignoreDockerPauseContainer")
    def ignore_docker_pause_container(self) -> pulumi.Output[builtins.bool]:
        """
        Disable monitoring of platform internal pause containers in Kubernetes and OpenShift.
        """
        return pulumi.get(self, "ignore_docker_pause_container")

    @property
    @pulumi.getter(name="ignoreKubernetesPauseContainer")
    def ignore_kubernetes_pause_container(self) -> pulumi.Output[builtins.bool]:
        """
        Disable monitoring of platform internal pause containers in Kubernetes and OpenShift.
        """
        return pulumi.get(self, "ignore_kubernetes_pause_container")

    @property
    @pulumi.getter(name="ignoreOpenShiftBuildPodName")
    def ignore_open_shift_build_pod_name(self) -> pulumi.Output[builtins.bool]:
        """
        Disable monitoring of intermediate containers created during image build.
        """
        return pulumi.get(self, "ignore_open_shift_build_pod_name")

    @property
    @pulumi.getter(name="ignoreOpenShiftSdnNamespace")
    def ignore_open_shift_sdn_namespace(self) -> pulumi.Output[builtins.bool]:
        """
        Disable monitoring of platform internal containers in the openshift-sdn namespace.
        """
        return pulumi.get(self, "ignore_open_shift_sdn_namespace")

