# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DashboardArgs', 'Dashboard']

@pulumi.input_type
class DashboardArgs:
    def __init__(__self__, *,
                 dashboard_metadata: Optional[pulumi.Input['DashboardDashboardMetadataArgs']] = None,
                 metadata: Optional[pulumi.Input['DashboardMetadataArgs']] = None,
                 tiles: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardTileArgs']]]] = None,
                 unknowns: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Dashboard resource.
        :param pulumi.Input['DashboardDashboardMetadataArgs'] dashboard_metadata: contains parameters of a dashboard
        :param pulumi.Input['DashboardMetadataArgs'] metadata: `metadata` exists for backwards compatibility but shouldn't get specified anymore
        :param pulumi.Input[Sequence[pulumi.Input['DashboardTileArgs']]] tiles: the tiles this Dashboard consist of
        :param pulumi.Input[builtins.str] unknowns: allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        if dashboard_metadata is not None:
            pulumi.set(__self__, "dashboard_metadata", dashboard_metadata)
        if metadata is not None:
            warnings.warn("""`metadata` exists for backwards compatibility but shouldn't get specified anymore""", DeprecationWarning)
            pulumi.log.warn("""metadata is deprecated: `metadata` exists for backwards compatibility but shouldn't get specified anymore""")
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if tiles is not None:
            pulumi.set(__self__, "tiles", tiles)
        if unknowns is not None:
            pulumi.set(__self__, "unknowns", unknowns)

    @property
    @pulumi.getter(name="dashboardMetadata")
    def dashboard_metadata(self) -> Optional[pulumi.Input['DashboardDashboardMetadataArgs']]:
        """
        contains parameters of a dashboard
        """
        return pulumi.get(self, "dashboard_metadata")

    @dashboard_metadata.setter
    def dashboard_metadata(self, value: Optional[pulumi.Input['DashboardDashboardMetadataArgs']]):
        pulumi.set(self, "dashboard_metadata", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""`metadata` exists for backwards compatibility but shouldn't get specified anymore""")
    def metadata(self) -> Optional[pulumi.Input['DashboardMetadataArgs']]:
        """
        `metadata` exists for backwards compatibility but shouldn't get specified anymore
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['DashboardMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def tiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardTileArgs']]]]:
        """
        the tiles this Dashboard consist of
        """
        return pulumi.get(self, "tiles")

    @tiles.setter
    def tiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardTileArgs']]]]):
        pulumi.set(self, "tiles", value)

    @property
    @pulumi.getter
    def unknowns(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        return pulumi.get(self, "unknowns")

    @unknowns.setter
    def unknowns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "unknowns", value)


@pulumi.input_type
class _DashboardState:
    def __init__(__self__, *,
                 dashboard_metadata: Optional[pulumi.Input['DashboardDashboardMetadataArgs']] = None,
                 metadata: Optional[pulumi.Input['DashboardMetadataArgs']] = None,
                 tiles: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardTileArgs']]]] = None,
                 unknowns: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Dashboard resources.
        :param pulumi.Input['DashboardDashboardMetadataArgs'] dashboard_metadata: contains parameters of a dashboard
        :param pulumi.Input['DashboardMetadataArgs'] metadata: `metadata` exists for backwards compatibility but shouldn't get specified anymore
        :param pulumi.Input[Sequence[pulumi.Input['DashboardTileArgs']]] tiles: the tiles this Dashboard consist of
        :param pulumi.Input[builtins.str] unknowns: allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        if dashboard_metadata is not None:
            pulumi.set(__self__, "dashboard_metadata", dashboard_metadata)
        if metadata is not None:
            warnings.warn("""`metadata` exists for backwards compatibility but shouldn't get specified anymore""", DeprecationWarning)
            pulumi.log.warn("""metadata is deprecated: `metadata` exists for backwards compatibility but shouldn't get specified anymore""")
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if tiles is not None:
            pulumi.set(__self__, "tiles", tiles)
        if unknowns is not None:
            pulumi.set(__self__, "unknowns", unknowns)

    @property
    @pulumi.getter(name="dashboardMetadata")
    def dashboard_metadata(self) -> Optional[pulumi.Input['DashboardDashboardMetadataArgs']]:
        """
        contains parameters of a dashboard
        """
        return pulumi.get(self, "dashboard_metadata")

    @dashboard_metadata.setter
    def dashboard_metadata(self, value: Optional[pulumi.Input['DashboardDashboardMetadataArgs']]):
        pulumi.set(self, "dashboard_metadata", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""`metadata` exists for backwards compatibility but shouldn't get specified anymore""")
    def metadata(self) -> Optional[pulumi.Input['DashboardMetadataArgs']]:
        """
        `metadata` exists for backwards compatibility but shouldn't get specified anymore
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['DashboardMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def tiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardTileArgs']]]]:
        """
        the tiles this Dashboard consist of
        """
        return pulumi.get(self, "tiles")

    @tiles.setter
    def tiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardTileArgs']]]]):
        pulumi.set(self, "tiles", value)

    @property
    @pulumi.getter
    def unknowns(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        return pulumi.get(self, "unknowns")

    @unknowns.setter
    def unknowns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "unknowns", value)


@pulumi.type_token("dynatrace:index/dashboard:Dashboard")
class Dashboard(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dashboard_metadata: Optional[pulumi.Input[Union['DashboardDashboardMetadataArgs', 'DashboardDashboardMetadataArgsDict']]] = None,
                 metadata: Optional[pulumi.Input[Union['DashboardMetadataArgs', 'DashboardMetadataArgsDict']]] = None,
                 tiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardTileArgs', 'DashboardTileArgsDict']]]]] = None,
                 unknowns: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a Dashboard resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DashboardDashboardMetadataArgs', 'DashboardDashboardMetadataArgsDict']] dashboard_metadata: contains parameters of a dashboard
        :param pulumi.Input[Union['DashboardMetadataArgs', 'DashboardMetadataArgsDict']] metadata: `metadata` exists for backwards compatibility but shouldn't get specified anymore
        :param pulumi.Input[Sequence[pulumi.Input[Union['DashboardTileArgs', 'DashboardTileArgsDict']]]] tiles: the tiles this Dashboard consist of
        :param pulumi.Input[builtins.str] unknowns: allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DashboardArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Dashboard resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param DashboardArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DashboardArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dashboard_metadata: Optional[pulumi.Input[Union['DashboardDashboardMetadataArgs', 'DashboardDashboardMetadataArgsDict']]] = None,
                 metadata: Optional[pulumi.Input[Union['DashboardMetadataArgs', 'DashboardMetadataArgsDict']]] = None,
                 tiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardTileArgs', 'DashboardTileArgsDict']]]]] = None,
                 unknowns: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DashboardArgs.__new__(DashboardArgs)

            __props__.__dict__["dashboard_metadata"] = dashboard_metadata
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["tiles"] = tiles
            __props__.__dict__["unknowns"] = unknowns
        super(Dashboard, __self__).__init__(
            'dynatrace:index/dashboard:Dashboard',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dashboard_metadata: Optional[pulumi.Input[Union['DashboardDashboardMetadataArgs', 'DashboardDashboardMetadataArgsDict']]] = None,
            metadata: Optional[pulumi.Input[Union['DashboardMetadataArgs', 'DashboardMetadataArgsDict']]] = None,
            tiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardTileArgs', 'DashboardTileArgsDict']]]]] = None,
            unknowns: Optional[pulumi.Input[builtins.str]] = None) -> 'Dashboard':
        """
        Get an existing Dashboard resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DashboardDashboardMetadataArgs', 'DashboardDashboardMetadataArgsDict']] dashboard_metadata: contains parameters of a dashboard
        :param pulumi.Input[Union['DashboardMetadataArgs', 'DashboardMetadataArgsDict']] metadata: `metadata` exists for backwards compatibility but shouldn't get specified anymore
        :param pulumi.Input[Sequence[pulumi.Input[Union['DashboardTileArgs', 'DashboardTileArgsDict']]]] tiles: the tiles this Dashboard consist of
        :param pulumi.Input[builtins.str] unknowns: allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DashboardState.__new__(_DashboardState)

        __props__.__dict__["dashboard_metadata"] = dashboard_metadata
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["tiles"] = tiles
        __props__.__dict__["unknowns"] = unknowns
        return Dashboard(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dashboardMetadata")
    def dashboard_metadata(self) -> pulumi.Output[Optional['outputs.DashboardDashboardMetadata']]:
        """
        contains parameters of a dashboard
        """
        return pulumi.get(self, "dashboard_metadata")

    @property
    @pulumi.getter
    @_utilities.deprecated("""`metadata` exists for backwards compatibility but shouldn't get specified anymore""")
    def metadata(self) -> pulumi.Output[Optional['outputs.DashboardMetadata']]:
        """
        `metadata` exists for backwards compatibility but shouldn't get specified anymore
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def tiles(self) -> pulumi.Output[Optional[Sequence['outputs.DashboardTile']]]:
        """
        the tiles this Dashboard consist of
        """
        return pulumi.get(self, "tiles")

    @property
    @pulumi.getter
    def unknowns(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        return pulumi.get(self, "unknowns")

