# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DashboardsGeneralArgs', 'DashboardsGeneral']

@pulumi.input_type
class DashboardsGeneralArgs:
    def __init__(__self__, *,
                 enable_public_sharing: pulumi.Input[builtins.bool],
                 default_dashboard_list: Optional[pulumi.Input['DashboardsGeneralDefaultDashboardListArgs']] = None):
        """
        The set of arguments for constructing a DashboardsGeneral resource.
        :param pulumi.Input[builtins.bool] enable_public_sharing: Allow users to grant anonymous access to dashboards. No sign-in will be required to view those dashboards read-only.
        :param pulumi.Input['DashboardsGeneralDefaultDashboardListArgs'] default_dashboard_list: Configure home dashboard for selected user group. The selected preset dashboard will be loaded as default landing page for this environment.
        """
        pulumi.set(__self__, "enable_public_sharing", enable_public_sharing)
        if default_dashboard_list is not None:
            pulumi.set(__self__, "default_dashboard_list", default_dashboard_list)

    @property
    @pulumi.getter(name="enablePublicSharing")
    def enable_public_sharing(self) -> pulumi.Input[builtins.bool]:
        """
        Allow users to grant anonymous access to dashboards. No sign-in will be required to view those dashboards read-only.
        """
        return pulumi.get(self, "enable_public_sharing")

    @enable_public_sharing.setter
    def enable_public_sharing(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enable_public_sharing", value)

    @property
    @pulumi.getter(name="defaultDashboardList")
    def default_dashboard_list(self) -> Optional[pulumi.Input['DashboardsGeneralDefaultDashboardListArgs']]:
        """
        Configure home dashboard for selected user group. The selected preset dashboard will be loaded as default landing page for this environment.
        """
        return pulumi.get(self, "default_dashboard_list")

    @default_dashboard_list.setter
    def default_dashboard_list(self, value: Optional[pulumi.Input['DashboardsGeneralDefaultDashboardListArgs']]):
        pulumi.set(self, "default_dashboard_list", value)


@pulumi.input_type
class _DashboardsGeneralState:
    def __init__(__self__, *,
                 default_dashboard_list: Optional[pulumi.Input['DashboardsGeneralDefaultDashboardListArgs']] = None,
                 enable_public_sharing: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering DashboardsGeneral resources.
        :param pulumi.Input['DashboardsGeneralDefaultDashboardListArgs'] default_dashboard_list: Configure home dashboard for selected user group. The selected preset dashboard will be loaded as default landing page for this environment.
        :param pulumi.Input[builtins.bool] enable_public_sharing: Allow users to grant anonymous access to dashboards. No sign-in will be required to view those dashboards read-only.
        """
        if default_dashboard_list is not None:
            pulumi.set(__self__, "default_dashboard_list", default_dashboard_list)
        if enable_public_sharing is not None:
            pulumi.set(__self__, "enable_public_sharing", enable_public_sharing)

    @property
    @pulumi.getter(name="defaultDashboardList")
    def default_dashboard_list(self) -> Optional[pulumi.Input['DashboardsGeneralDefaultDashboardListArgs']]:
        """
        Configure home dashboard for selected user group. The selected preset dashboard will be loaded as default landing page for this environment.
        """
        return pulumi.get(self, "default_dashboard_list")

    @default_dashboard_list.setter
    def default_dashboard_list(self, value: Optional[pulumi.Input['DashboardsGeneralDefaultDashboardListArgs']]):
        pulumi.set(self, "default_dashboard_list", value)

    @property
    @pulumi.getter(name="enablePublicSharing")
    def enable_public_sharing(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow users to grant anonymous access to dashboards. No sign-in will be required to view those dashboards read-only.
        """
        return pulumi.get(self, "enable_public_sharing")

    @enable_public_sharing.setter
    def enable_public_sharing(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_public_sharing", value)


@pulumi.type_token("dynatrace:index/dashboardsGeneral:DashboardsGeneral")
class DashboardsGeneral(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_dashboard_list: Optional[pulumi.Input[Union['DashboardsGeneralDefaultDashboardListArgs', 'DashboardsGeneralDefaultDashboardListArgsDict']]] = None,
                 enable_public_sharing: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        Create a DashboardsGeneral resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DashboardsGeneralDefaultDashboardListArgs', 'DashboardsGeneralDefaultDashboardListArgsDict']] default_dashboard_list: Configure home dashboard for selected user group. The selected preset dashboard will be loaded as default landing page for this environment.
        :param pulumi.Input[builtins.bool] enable_public_sharing: Allow users to grant anonymous access to dashboards. No sign-in will be required to view those dashboards read-only.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DashboardsGeneralArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a DashboardsGeneral resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param DashboardsGeneralArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DashboardsGeneralArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_dashboard_list: Optional[pulumi.Input[Union['DashboardsGeneralDefaultDashboardListArgs', 'DashboardsGeneralDefaultDashboardListArgsDict']]] = None,
                 enable_public_sharing: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DashboardsGeneralArgs.__new__(DashboardsGeneralArgs)

            __props__.__dict__["default_dashboard_list"] = default_dashboard_list
            if enable_public_sharing is None and not opts.urn:
                raise TypeError("Missing required property 'enable_public_sharing'")
            __props__.__dict__["enable_public_sharing"] = enable_public_sharing
        super(DashboardsGeneral, __self__).__init__(
            'dynatrace:index/dashboardsGeneral:DashboardsGeneral',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_dashboard_list: Optional[pulumi.Input[Union['DashboardsGeneralDefaultDashboardListArgs', 'DashboardsGeneralDefaultDashboardListArgsDict']]] = None,
            enable_public_sharing: Optional[pulumi.Input[builtins.bool]] = None) -> 'DashboardsGeneral':
        """
        Get an existing DashboardsGeneral resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DashboardsGeneralDefaultDashboardListArgs', 'DashboardsGeneralDefaultDashboardListArgsDict']] default_dashboard_list: Configure home dashboard for selected user group. The selected preset dashboard will be loaded as default landing page for this environment.
        :param pulumi.Input[builtins.bool] enable_public_sharing: Allow users to grant anonymous access to dashboards. No sign-in will be required to view those dashboards read-only.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DashboardsGeneralState.__new__(_DashboardsGeneralState)

        __props__.__dict__["default_dashboard_list"] = default_dashboard_list
        __props__.__dict__["enable_public_sharing"] = enable_public_sharing
        return DashboardsGeneral(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="defaultDashboardList")
    def default_dashboard_list(self) -> pulumi.Output[Optional['outputs.DashboardsGeneralDefaultDashboardList']]:
        """
        Configure home dashboard for selected user group. The selected preset dashboard will be loaded as default landing page for this environment.
        """
        return pulumi.get(self, "default_dashboard_list")

    @property
    @pulumi.getter(name="enablePublicSharing")
    def enable_public_sharing(self) -> pulumi.Output[builtins.bool]:
        """
        Allow users to grant anonymous access to dashboards. No sign-in will be required to view those dashboards read-only.
        """
        return pulumi.get(self, "enable_public_sharing")

