# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DeclarativeGroupingArgs', 'DeclarativeGrouping']

@pulumi.input_type
class DeclarativeGroupingArgs:
    def __init__(__self__, *,
                 detection: pulumi.Input['DeclarativeGroupingDetectionArgs'],
                 enabled: pulumi.Input[builtins.bool],
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a DeclarativeGrouping resource.
        :param pulumi.Input['DeclarativeGroupingDetectionArgs'] detection: Enter a descriptive process group display name and a unique identifier that Dynatrace can use to recognize this process
               group.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this
               instance regarding order. If not specified when creating the setting will be added to the end of the list. If not
               specified during update the order will remain untouched
        :param pulumi.Input[builtins.str] name: Monitored technology name
        :param pulumi.Input[builtins.str] scope: The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        pulumi.set(__self__, "detection", detection)
        pulumi.set(__self__, "enabled", enabled)
        if insert_after is not None:
            pulumi.set(__self__, "insert_after", insert_after)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def detection(self) -> pulumi.Input['DeclarativeGroupingDetectionArgs']:
        """
        Enter a descriptive process group display name and a unique identifier that Dynatrace can use to recognize this process
        group.
        """
        return pulumi.get(self, "detection")

    @detection.setter
    def detection(self, value: pulumi.Input['DeclarativeGroupingDetectionArgs']):
        pulumi.set(self, "detection", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this
        instance regarding order. If not specified when creating the setting will be added to the end of the list. If not
        specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @insert_after.setter
    def insert_after(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "insert_after", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Monitored technology name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class _DeclarativeGroupingState:
    def __init__(__self__, *,
                 detection: Optional[pulumi.Input['DeclarativeGroupingDetectionArgs']] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DeclarativeGrouping resources.
        :param pulumi.Input['DeclarativeGroupingDetectionArgs'] detection: Enter a descriptive process group display name and a unique identifier that Dynatrace can use to recognize this process
               group.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this
               instance regarding order. If not specified when creating the setting will be added to the end of the list. If not
               specified during update the order will remain untouched
        :param pulumi.Input[builtins.str] name: Monitored technology name
        :param pulumi.Input[builtins.str] scope: The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        if detection is not None:
            pulumi.set(__self__, "detection", detection)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if insert_after is not None:
            pulumi.set(__self__, "insert_after", insert_after)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def detection(self) -> Optional[pulumi.Input['DeclarativeGroupingDetectionArgs']]:
        """
        Enter a descriptive process group display name and a unique identifier that Dynatrace can use to recognize this process
        group.
        """
        return pulumi.get(self, "detection")

    @detection.setter
    def detection(self, value: Optional[pulumi.Input['DeclarativeGroupingDetectionArgs']]):
        pulumi.set(self, "detection", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this
        instance regarding order. If not specified when creating the setting will be added to the end of the list. If not
        specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @insert_after.setter
    def insert_after(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "insert_after", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Monitored technology name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)


@pulumi.type_token("dynatrace:index/declarativeGrouping:DeclarativeGrouping")
class DeclarativeGrouping(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 detection: Optional[pulumi.Input[Union['DeclarativeGroupingDetectionArgs', 'DeclarativeGroupingDetectionArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a DeclarativeGrouping resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DeclarativeGroupingDetectionArgs', 'DeclarativeGroupingDetectionArgsDict']] detection: Enter a descriptive process group display name and a unique identifier that Dynatrace can use to recognize this process
               group.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this
               instance regarding order. If not specified when creating the setting will be added to the end of the list. If not
               specified during update the order will remain untouched
        :param pulumi.Input[builtins.str] name: Monitored technology name
        :param pulumi.Input[builtins.str] scope: The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeclarativeGroupingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a DeclarativeGrouping resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param DeclarativeGroupingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeclarativeGroupingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 detection: Optional[pulumi.Input[Union['DeclarativeGroupingDetectionArgs', 'DeclarativeGroupingDetectionArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeclarativeGroupingArgs.__new__(DeclarativeGroupingArgs)

            if detection is None and not opts.urn:
                raise TypeError("Missing required property 'detection'")
            __props__.__dict__["detection"] = detection
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["insert_after"] = insert_after
            __props__.__dict__["name"] = name
            __props__.__dict__["scope"] = scope
        super(DeclarativeGrouping, __self__).__init__(
            'dynatrace:index/declarativeGrouping:DeclarativeGrouping',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            detection: Optional[pulumi.Input[Union['DeclarativeGroupingDetectionArgs', 'DeclarativeGroupingDetectionArgsDict']]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            insert_after: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            scope: Optional[pulumi.Input[builtins.str]] = None) -> 'DeclarativeGrouping':
        """
        Get an existing DeclarativeGrouping resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DeclarativeGroupingDetectionArgs', 'DeclarativeGroupingDetectionArgsDict']] detection: Enter a descriptive process group display name and a unique identifier that Dynatrace can use to recognize this process
               group.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this
               instance regarding order. If not specified when creating the setting will be added to the end of the list. If not
               specified during update the order will remain untouched
        :param pulumi.Input[builtins.str] name: Monitored technology name
        :param pulumi.Input[builtins.str] scope: The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeclarativeGroupingState.__new__(_DeclarativeGroupingState)

        __props__.__dict__["detection"] = detection
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["insert_after"] = insert_after
        __props__.__dict__["name"] = name
        __props__.__dict__["scope"] = scope
        return DeclarativeGrouping(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def detection(self) -> pulumi.Output['outputs.DeclarativeGroupingDetection']:
        """
        Enter a descriptive process group display name and a unique identifier that Dynatrace can use to recognize this process
        group.
        """
        return pulumi.get(self, "detection")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> pulumi.Output[builtins.str]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this
        instance regarding order. If not specified when creating the setting will be added to the end of the list. If not
        specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Monitored technology name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

