# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['EulaSettingsArgs', 'EulaSettings']

@pulumi.input_type
class EulaSettingsArgs:
    def __init__(__self__, *,
                 enable_eula: pulumi.Input[builtins.bool],
                 scope: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a EulaSettings resource.
        :param pulumi.Input[builtins.bool] enable_eula: Display end user terms to new users logging in to the environment
        :param pulumi.Input[builtins.str] scope: The scope of this setting (environment)
        """
        pulumi.set(__self__, "enable_eula", enable_eula)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="enableEula")
    def enable_eula(self) -> pulumi.Input[builtins.bool]:
        """
        Display end user terms to new users logging in to the environment
        """
        return pulumi.get(self, "enable_eula")

    @enable_eula.setter
    def enable_eula(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enable_eula", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of this setting (environment)
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class _EulaSettingsState:
    def __init__(__self__, *,
                 enable_eula: Optional[pulumi.Input[builtins.bool]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering EulaSettings resources.
        :param pulumi.Input[builtins.bool] enable_eula: Display end user terms to new users logging in to the environment
        :param pulumi.Input[builtins.str] scope: The scope of this setting (environment)
        """
        if enable_eula is not None:
            pulumi.set(__self__, "enable_eula", enable_eula)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="enableEula")
    def enable_eula(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Display end user terms to new users logging in to the environment
        """
        return pulumi.get(self, "enable_eula")

    @enable_eula.setter
    def enable_eula(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_eula", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of this setting (environment)
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)


@pulumi.type_token("dynatrace:index/eulaSettings:EulaSettings")
class EulaSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_eula: Optional[pulumi.Input[builtins.bool]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a EulaSettings resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enable_eula: Display end user terms to new users logging in to the environment
        :param pulumi.Input[builtins.str] scope: The scope of this setting (environment)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EulaSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a EulaSettings resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param EulaSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EulaSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_eula: Optional[pulumi.Input[builtins.bool]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EulaSettingsArgs.__new__(EulaSettingsArgs)

            if enable_eula is None and not opts.urn:
                raise TypeError("Missing required property 'enable_eula'")
            __props__.__dict__["enable_eula"] = enable_eula
            __props__.__dict__["scope"] = scope
        super(EulaSettings, __self__).__init__(
            'dynatrace:index/eulaSettings:EulaSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable_eula: Optional[pulumi.Input[builtins.bool]] = None,
            scope: Optional[pulumi.Input[builtins.str]] = None) -> 'EulaSettings':
        """
        Get an existing EulaSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enable_eula: Display end user terms to new users logging in to the environment
        :param pulumi.Input[builtins.str] scope: The scope of this setting (environment)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EulaSettingsState.__new__(_EulaSettingsState)

        __props__.__dict__["enable_eula"] = enable_eula
        __props__.__dict__["scope"] = scope
        return EulaSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="enableEula")
    def enable_eula(self) -> pulumi.Output[builtins.bool]:
        """
        Display end user terms to new users logging in to the environment
        """
        return pulumi.get(self, "enable_eula")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The scope of this setting (environment)
        """
        return pulumi.get(self, "scope")

