# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FailureDetectionParametersArgs', 'FailureDetectionParameters']

@pulumi.input_type
class FailureDetectionParametersArgs:
    def __init__(__self__, *,
                 broken_links: pulumi.Input['FailureDetectionParametersBrokenLinksArgs'],
                 exception_rules: pulumi.Input['FailureDetectionParametersExceptionRulesArgs'],
                 http_response_codes: pulumi.Input['FailureDetectionParametersHttpResponseCodesArgs'],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a FailureDetectionParameters resource.
        :param pulumi.Input['FailureDetectionParametersBrokenLinksArgs'] broken_links: HTTP 404 response codes are thrown when a web server can't find a certain page. 404s are classified as broken links on the client side and therefore aren't considered to be service failures. By enabling this setting, you can have 404s treated as server-side service failures.
        :param pulumi.Input['FailureDetectionParametersExceptionRulesArgs'] exception_rules: Customize failure detection for specific exceptions and errors
        :param pulumi.Input['FailureDetectionParametersHttpResponseCodesArgs'] http_response_codes: HTTP response codes
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] name: Name
        """
        pulumi.set(__self__, "broken_links", broken_links)
        pulumi.set(__self__, "exception_rules", exception_rules)
        pulumi.set(__self__, "http_response_codes", http_response_codes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="brokenLinks")
    def broken_links(self) -> pulumi.Input['FailureDetectionParametersBrokenLinksArgs']:
        """
        HTTP 404 response codes are thrown when a web server can't find a certain page. 404s are classified as broken links on the client side and therefore aren't considered to be service failures. By enabling this setting, you can have 404s treated as server-side service failures.
        """
        return pulumi.get(self, "broken_links")

    @broken_links.setter
    def broken_links(self, value: pulumi.Input['FailureDetectionParametersBrokenLinksArgs']):
        pulumi.set(self, "broken_links", value)

    @property
    @pulumi.getter(name="exceptionRules")
    def exception_rules(self) -> pulumi.Input['FailureDetectionParametersExceptionRulesArgs']:
        """
        Customize failure detection for specific exceptions and errors
        """
        return pulumi.get(self, "exception_rules")

    @exception_rules.setter
    def exception_rules(self, value: pulumi.Input['FailureDetectionParametersExceptionRulesArgs']):
        pulumi.set(self, "exception_rules", value)

    @property
    @pulumi.getter(name="httpResponseCodes")
    def http_response_codes(self) -> pulumi.Input['FailureDetectionParametersHttpResponseCodesArgs']:
        """
        HTTP response codes
        """
        return pulumi.get(self, "http_response_codes")

    @http_response_codes.setter
    def http_response_codes(self, value: pulumi.Input['FailureDetectionParametersHttpResponseCodesArgs']):
        pulumi.set(self, "http_response_codes", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _FailureDetectionParametersState:
    def __init__(__self__, *,
                 broken_links: Optional[pulumi.Input['FailureDetectionParametersBrokenLinksArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 exception_rules: Optional[pulumi.Input['FailureDetectionParametersExceptionRulesArgs']] = None,
                 http_response_codes: Optional[pulumi.Input['FailureDetectionParametersHttpResponseCodesArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering FailureDetectionParameters resources.
        :param pulumi.Input['FailureDetectionParametersBrokenLinksArgs'] broken_links: HTTP 404 response codes are thrown when a web server can't find a certain page. 404s are classified as broken links on the client side and therefore aren't considered to be service failures. By enabling this setting, you can have 404s treated as server-side service failures.
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input['FailureDetectionParametersExceptionRulesArgs'] exception_rules: Customize failure detection for specific exceptions and errors
        :param pulumi.Input['FailureDetectionParametersHttpResponseCodesArgs'] http_response_codes: HTTP response codes
        :param pulumi.Input[builtins.str] name: Name
        """
        if broken_links is not None:
            pulumi.set(__self__, "broken_links", broken_links)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exception_rules is not None:
            pulumi.set(__self__, "exception_rules", exception_rules)
        if http_response_codes is not None:
            pulumi.set(__self__, "http_response_codes", http_response_codes)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="brokenLinks")
    def broken_links(self) -> Optional[pulumi.Input['FailureDetectionParametersBrokenLinksArgs']]:
        """
        HTTP 404 response codes are thrown when a web server can't find a certain page. 404s are classified as broken links on the client side and therefore aren't considered to be service failures. By enabling this setting, you can have 404s treated as server-side service failures.
        """
        return pulumi.get(self, "broken_links")

    @broken_links.setter
    def broken_links(self, value: Optional[pulumi.Input['FailureDetectionParametersBrokenLinksArgs']]):
        pulumi.set(self, "broken_links", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="exceptionRules")
    def exception_rules(self) -> Optional[pulumi.Input['FailureDetectionParametersExceptionRulesArgs']]:
        """
        Customize failure detection for specific exceptions and errors
        """
        return pulumi.get(self, "exception_rules")

    @exception_rules.setter
    def exception_rules(self, value: Optional[pulumi.Input['FailureDetectionParametersExceptionRulesArgs']]):
        pulumi.set(self, "exception_rules", value)

    @property
    @pulumi.getter(name="httpResponseCodes")
    def http_response_codes(self) -> Optional[pulumi.Input['FailureDetectionParametersHttpResponseCodesArgs']]:
        """
        HTTP response codes
        """
        return pulumi.get(self, "http_response_codes")

    @http_response_codes.setter
    def http_response_codes(self, value: Optional[pulumi.Input['FailureDetectionParametersHttpResponseCodesArgs']]):
        pulumi.set(self, "http_response_codes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("dynatrace:index/failureDetectionParameters:FailureDetectionParameters")
class FailureDetectionParameters(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 broken_links: Optional[pulumi.Input[Union['FailureDetectionParametersBrokenLinksArgs', 'FailureDetectionParametersBrokenLinksArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 exception_rules: Optional[pulumi.Input[Union['FailureDetectionParametersExceptionRulesArgs', 'FailureDetectionParametersExceptionRulesArgsDict']]] = None,
                 http_response_codes: Optional[pulumi.Input[Union['FailureDetectionParametersHttpResponseCodesArgs', 'FailureDetectionParametersHttpResponseCodesArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a FailureDetectionParameters resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FailureDetectionParametersBrokenLinksArgs', 'FailureDetectionParametersBrokenLinksArgsDict']] broken_links: HTTP 404 response codes are thrown when a web server can't find a certain page. 404s are classified as broken links on the client side and therefore aren't considered to be service failures. By enabling this setting, you can have 404s treated as server-side service failures.
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[Union['FailureDetectionParametersExceptionRulesArgs', 'FailureDetectionParametersExceptionRulesArgsDict']] exception_rules: Customize failure detection for specific exceptions and errors
        :param pulumi.Input[Union['FailureDetectionParametersHttpResponseCodesArgs', 'FailureDetectionParametersHttpResponseCodesArgsDict']] http_response_codes: HTTP response codes
        :param pulumi.Input[builtins.str] name: Name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FailureDetectionParametersArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a FailureDetectionParameters resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param FailureDetectionParametersArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FailureDetectionParametersArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 broken_links: Optional[pulumi.Input[Union['FailureDetectionParametersBrokenLinksArgs', 'FailureDetectionParametersBrokenLinksArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 exception_rules: Optional[pulumi.Input[Union['FailureDetectionParametersExceptionRulesArgs', 'FailureDetectionParametersExceptionRulesArgsDict']]] = None,
                 http_response_codes: Optional[pulumi.Input[Union['FailureDetectionParametersHttpResponseCodesArgs', 'FailureDetectionParametersHttpResponseCodesArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FailureDetectionParametersArgs.__new__(FailureDetectionParametersArgs)

            if broken_links is None and not opts.urn:
                raise TypeError("Missing required property 'broken_links'")
            __props__.__dict__["broken_links"] = broken_links
            __props__.__dict__["description"] = description
            if exception_rules is None and not opts.urn:
                raise TypeError("Missing required property 'exception_rules'")
            __props__.__dict__["exception_rules"] = exception_rules
            if http_response_codes is None and not opts.urn:
                raise TypeError("Missing required property 'http_response_codes'")
            __props__.__dict__["http_response_codes"] = http_response_codes
            __props__.__dict__["name"] = name
        super(FailureDetectionParameters, __self__).__init__(
            'dynatrace:index/failureDetectionParameters:FailureDetectionParameters',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            broken_links: Optional[pulumi.Input[Union['FailureDetectionParametersBrokenLinksArgs', 'FailureDetectionParametersBrokenLinksArgsDict']]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            exception_rules: Optional[pulumi.Input[Union['FailureDetectionParametersExceptionRulesArgs', 'FailureDetectionParametersExceptionRulesArgsDict']]] = None,
            http_response_codes: Optional[pulumi.Input[Union['FailureDetectionParametersHttpResponseCodesArgs', 'FailureDetectionParametersHttpResponseCodesArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None) -> 'FailureDetectionParameters':
        """
        Get an existing FailureDetectionParameters resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FailureDetectionParametersBrokenLinksArgs', 'FailureDetectionParametersBrokenLinksArgsDict']] broken_links: HTTP 404 response codes are thrown when a web server can't find a certain page. 404s are classified as broken links on the client side and therefore aren't considered to be service failures. By enabling this setting, you can have 404s treated as server-side service failures.
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[Union['FailureDetectionParametersExceptionRulesArgs', 'FailureDetectionParametersExceptionRulesArgsDict']] exception_rules: Customize failure detection for specific exceptions and errors
        :param pulumi.Input[Union['FailureDetectionParametersHttpResponseCodesArgs', 'FailureDetectionParametersHttpResponseCodesArgsDict']] http_response_codes: HTTP response codes
        :param pulumi.Input[builtins.str] name: Name
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FailureDetectionParametersState.__new__(_FailureDetectionParametersState)

        __props__.__dict__["broken_links"] = broken_links
        __props__.__dict__["description"] = description
        __props__.__dict__["exception_rules"] = exception_rules
        __props__.__dict__["http_response_codes"] = http_response_codes
        __props__.__dict__["name"] = name
        return FailureDetectionParameters(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="brokenLinks")
    def broken_links(self) -> pulumi.Output['outputs.FailureDetectionParametersBrokenLinks']:
        """
        HTTP 404 response codes are thrown when a web server can't find a certain page. 404s are classified as broken links on the client side and therefore aren't considered to be service failures. By enabling this setting, you can have 404s treated as server-side service failures.
        """
        return pulumi.get(self, "broken_links")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="exceptionRules")
    def exception_rules(self) -> pulumi.Output['outputs.FailureDetectionParametersExceptionRules']:
        """
        Customize failure detection for specific exceptions and errors
        """
        return pulumi.get(self, "exception_rules")

    @property
    @pulumi.getter(name="httpResponseCodes")
    def http_response_codes(self) -> pulumi.Output['outputs.FailureDetectionParametersHttpResponseCodes']:
        """
        HTTP response codes
        """
        return pulumi.get(self, "http_response_codes")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name
        """
        return pulumi.get(self, "name")

