# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GeolocationArgs', 'Geolocation']

@pulumi.input_type
class GeolocationArgs:
    def __init__(__self__, *,
                 display_worldmap: pulumi.Input[builtins.bool],
                 scope: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Geolocation resource.
        :param pulumi.Input[builtins.bool] display_worldmap: Display the world map
        :param pulumi.Input[builtins.str] scope: The scope of this setting (environment-default). Omit this property if you want to cover the whole environment.
        """
        pulumi.set(__self__, "display_worldmap", display_worldmap)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="displayWorldmap")
    def display_worldmap(self) -> pulumi.Input[builtins.bool]:
        """
        Display the world map
        """
        return pulumi.get(self, "display_worldmap")

    @display_worldmap.setter
    def display_worldmap(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "display_worldmap", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of this setting (environment-default). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class _GeolocationState:
    def __init__(__self__, *,
                 display_worldmap: Optional[pulumi.Input[builtins.bool]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Geolocation resources.
        :param pulumi.Input[builtins.bool] display_worldmap: Display the world map
        :param pulumi.Input[builtins.str] scope: The scope of this setting (environment-default). Omit this property if you want to cover the whole environment.
        """
        if display_worldmap is not None:
            pulumi.set(__self__, "display_worldmap", display_worldmap)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="displayWorldmap")
    def display_worldmap(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Display the world map
        """
        return pulumi.get(self, "display_worldmap")

    @display_worldmap.setter
    def display_worldmap(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "display_worldmap", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of this setting (environment-default). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)


@pulumi.type_token("dynatrace:index/geolocation:Geolocation")
class Geolocation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_worldmap: Optional[pulumi.Input[builtins.bool]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a Geolocation resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] display_worldmap: Display the world map
        :param pulumi.Input[builtins.str] scope: The scope of this setting (environment-default). Omit this property if you want to cover the whole environment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GeolocationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Geolocation resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param GeolocationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GeolocationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_worldmap: Optional[pulumi.Input[builtins.bool]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GeolocationArgs.__new__(GeolocationArgs)

            if display_worldmap is None and not opts.urn:
                raise TypeError("Missing required property 'display_worldmap'")
            __props__.__dict__["display_worldmap"] = display_worldmap
            __props__.__dict__["scope"] = scope
        super(Geolocation, __self__).__init__(
            'dynatrace:index/geolocation:Geolocation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            display_worldmap: Optional[pulumi.Input[builtins.bool]] = None,
            scope: Optional[pulumi.Input[builtins.str]] = None) -> 'Geolocation':
        """
        Get an existing Geolocation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] display_worldmap: Display the world map
        :param pulumi.Input[builtins.str] scope: The scope of this setting (environment-default). Omit this property if you want to cover the whole environment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GeolocationState.__new__(_GeolocationState)

        __props__.__dict__["display_worldmap"] = display_worldmap
        __props__.__dict__["scope"] = scope
        return Geolocation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="displayWorldmap")
    def display_worldmap(self) -> pulumi.Output[builtins.bool]:
        """
        Display the world map
        """
        return pulumi.get(self, "display_worldmap")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The scope of this setting (environment-default). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

