# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetApiTokensResult',
    'AwaitableGetApiTokensResult',
    'get_api_tokens',
    'get_api_tokens_output',
]

@pulumi.output_type
class GetApiTokensResult:
    """
    A collection of values returned by getApiTokens.
    """
    def __init__(__self__, api_tokens=None, id=None):
        if api_tokens and not isinstance(api_tokens, list):
            raise TypeError("Expected argument 'api_tokens' to be a list")
        pulumi.set(__self__, "api_tokens", api_tokens)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="apiTokens")
    def api_tokens(self) -> Sequence['outputs.GetApiTokensApiTokenResult']:
        return pulumi.get(self, "api_tokens")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetApiTokensResult(GetApiTokensResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiTokensResult(
            api_tokens=self.api_tokens,
            id=self.id)


def get_api_tokens(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiTokensResult:
    """
    The API tokens data source allows all access tokens to be retrieved, note the token value is not included in the response.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dynatrace as dynatrace

    example_api_tokens = dynatrace.get_api_tokens()
    pulumi.export("example", example_api_tokens)
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dynatrace:index/getApiTokens:getApiTokens', __args__, opts=opts, typ=GetApiTokensResult).value

    return AwaitableGetApiTokensResult(
        api_tokens=pulumi.get(__ret__, 'api_tokens'),
        id=pulumi.get(__ret__, 'id'))
def get_api_tokens_output(opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApiTokensResult]:
    """
    The API tokens data source allows all access tokens to be retrieved, note the token value is not included in the response.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dynatrace as dynatrace

    example_api_tokens = dynatrace.get_api_tokens()
    pulumi.export("example", example_api_tokens)
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dynatrace:index/getApiTokens:getApiTokens', __args__, opts=opts, typ=GetApiTokensResult)
    return __ret__.apply(lambda __response__: GetApiTokensResult(
        api_tokens=pulumi.get(__response__, 'api_tokens'),
        id=pulumi.get(__response__, 'id')))
