# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAzureSupportedServicesResult',
    'AwaitableGetAzureSupportedServicesResult',
    'get_azure_supported_services',
    'get_azure_supported_services_output',
]

@pulumi.output_type
class GetAzureSupportedServicesResult:
    """
    A collection of values returned by getAzureSupportedServices.
    """
    def __init__(__self__, excepts=None, id=None, services=None):
        if excepts and not isinstance(excepts, list):
            raise TypeError("Expected argument 'excepts' to be a list")
        pulumi.set(__self__, "excepts", excepts)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if services and not isinstance(services, dict):
            raise TypeError("Expected argument 'services' to be a dict")
        pulumi.set(__self__, "services", services)

    @property
    @pulumi.getter
    def excepts(self) -> Optional[Sequence[builtins.str]]:
        """
        Services with the given names won't be included in the results
        """
        return pulumi.get(self, "excepts")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def services(self) -> Mapping[str, builtins.bool]:
        """
        The keys are the names of the supported services. The values provide information whether that service is built in or not.
        """
        return pulumi.get(self, "services")


class AwaitableGetAzureSupportedServicesResult(GetAzureSupportedServicesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAzureSupportedServicesResult(
            excepts=self.excepts,
            id=self.id,
            services=self.services)


def get_azure_supported_services(excepts: Optional[Sequence[builtins.str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAzureSupportedServicesResult:
    """
    The Azure supported service data source queries for a full list of all supported services.

    ## Example Usage

    For an example of this data source, please refer to the Resource Example Usage of the AzureService resource.


    :param Sequence[builtins.str] excepts: Services with the given names won't be included in the results
    """
    __args__ = dict()
    __args__['excepts'] = excepts
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dynatrace:index/getAzureSupportedServices:getAzureSupportedServices', __args__, opts=opts, typ=GetAzureSupportedServicesResult).value

    return AwaitableGetAzureSupportedServicesResult(
        excepts=pulumi.get(__ret__, 'excepts'),
        id=pulumi.get(__ret__, 'id'),
        services=pulumi.get(__ret__, 'services'))
def get_azure_supported_services_output(excepts: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAzureSupportedServicesResult]:
    """
    The Azure supported service data source queries for a full list of all supported services.

    ## Example Usage

    For an example of this data source, please refer to the Resource Example Usage of the AzureService resource.


    :param Sequence[builtins.str] excepts: Services with the given names won't be included in the results
    """
    __args__ = dict()
    __args__['excepts'] = excepts
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dynatrace:index/getAzureSupportedServices:getAzureSupportedServices', __args__, opts=opts, typ=GetAzureSupportedServicesResult)
    return __ret__.apply(lambda __response__: GetAzureSupportedServicesResult(
        excepts=pulumi.get(__response__, 'excepts'),
        id=pulumi.get(__response__, 'id'),
        services=pulumi.get(__response__, 'services')))
