# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetEntityResult',
    'AwaitableGetEntityResult',
    'get_entity',
    'get_entity_output',
]

@pulumi.output_type
class GetEntityResult:
    """
    A collection of values returned by getEntity.
    """
    def __init__(__self__, entity_selector=None, from_=None, id=None, name=None, properties=None, to=None, type=None):
        if entity_selector and not isinstance(entity_selector, str):
            raise TypeError("Expected argument 'entity_selector' to be a str")
        pulumi.set(__self__, "entity_selector", entity_selector)
        if from_ and not isinstance(from_, str):
            raise TypeError("Expected argument 'from_' to be a str")
        pulumi.set(__self__, "from_", from_)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if properties and not isinstance(properties, dict):
            raise TypeError("Expected argument 'properties' to be a dict")
        pulumi.set(__self__, "properties", properties)
        if to and not isinstance(to, str):
            raise TypeError("Expected argument 'to' to be a str")
        pulumi.set(__self__, "to", to)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="entitySelector")
    def entity_selector(self) -> Optional[builtins.str]:
        return pulumi.get(self, "entity_selector")

    @property
    @pulumi.getter(name="from")
    def from_(self) -> Optional[builtins.str]:
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def to(self) -> Optional[builtins.str]:
        return pulumi.get(self, "to")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        return pulumi.get(self, "type")


class AwaitableGetEntityResult(GetEntityResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEntityResult(
            entity_selector=self.entity_selector,
            from_=self.from_,
            id=self.id,
            name=self.name,
            properties=self.properties,
            to=self.to,
            type=self.type)


def get_entity(entity_selector: Optional[builtins.str] = None,
               from_: Optional[builtins.str] = None,
               name: Optional[builtins.str] = None,
               to: Optional[builtins.str] = None,
               type: Optional[builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEntityResult:
    """
    The entity data source allows the entity ID to be retrieved by its name and type.

    - `name` (String) Display name of the entity
    - `type` (String) Type of the entity, e.g. SERVICE. All available entity types can be retrieved with [/api/v2/entityTypes](https://www.dynatrace.com/support/help/dynatrace-api/environment-api/entity-v2/get-all-entity-types).

    If multiple services match the given criteria, the first result will be retrieved.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dynatrace as dynatrace

    test = dynatrace.get_entity(type="SERVICE",
        name="BookingService")
    pulumi.export("id", test.id)
    ```
    """
    __args__ = dict()
    __args__['entitySelector'] = entity_selector
    __args__['from'] = from_
    __args__['name'] = name
    __args__['to'] = to
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dynatrace:index/getEntity:getEntity', __args__, opts=opts, typ=GetEntityResult).value

    return AwaitableGetEntityResult(
        entity_selector=pulumi.get(__ret__, 'entity_selector'),
        from_=pulumi.get(__ret__, 'from_'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        properties=pulumi.get(__ret__, 'properties'),
        to=pulumi.get(__ret__, 'to'),
        type=pulumi.get(__ret__, 'type'))
def get_entity_output(entity_selector: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      from_: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      to: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEntityResult]:
    """
    The entity data source allows the entity ID to be retrieved by its name and type.

    - `name` (String) Display name of the entity
    - `type` (String) Type of the entity, e.g. SERVICE. All available entity types can be retrieved with [/api/v2/entityTypes](https://www.dynatrace.com/support/help/dynatrace-api/environment-api/entity-v2/get-all-entity-types).

    If multiple services match the given criteria, the first result will be retrieved.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dynatrace as dynatrace

    test = dynatrace.get_entity(type="SERVICE",
        name="BookingService")
    pulumi.export("id", test.id)
    ```
    """
    __args__ = dict()
    __args__['entitySelector'] = entity_selector
    __args__['from'] = from_
    __args__['name'] = name
    __args__['to'] = to
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dynatrace:index/getEntity:getEntity', __args__, opts=opts, typ=GetEntityResult)
    return __ret__.apply(lambda __response__: GetEntityResult(
        entity_selector=pulumi.get(__response__, 'entity_selector'),
        from_=pulumi.get(__response__, 'from_'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        properties=pulumi.get(__response__, 'properties'),
        to=pulumi.get(__response__, 'to'),
        type=pulumi.get(__response__, 'type')))
