# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetGenericSettingsResult',
    'AwaitableGetGenericSettingsResult',
    'get_generic_settings',
    'get_generic_settings_output',
]

@pulumi.output_type
class GetGenericSettingsResult:
    """
    A collection of values returned by getGenericSettings.
    """
    def __init__(__self__, filter=None, id=None, schema=None, scope=None, values=None):
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if schema and not isinstance(schema, str):
            raise TypeError("Expected argument 'schema' to be a str")
        pulumi.set(__self__, "schema", schema)
        if scope and not isinstance(scope, str):
            raise TypeError("Expected argument 'scope' to be a str")
        pulumi.set(__self__, "scope", scope)
        if values and not isinstance(values, list):
            raise TypeError("Expected argument 'values' to be a list")
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def filter(self) -> Optional[builtins.str]:
        """
        Filter of the requested objects
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def schema(self) -> builtins.str:
        """
        Schema IDs to which the requested objects belong
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter
    def scope(self) -> builtins.str:
        """
        Scope that the requested objects target
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def values(self) -> Sequence['outputs.GetGenericSettingsValueResult']:
        return pulumi.get(self, "values")


class AwaitableGetGenericSettingsResult(GetGenericSettingsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGenericSettingsResult(
            filter=self.filter,
            id=self.id,
            schema=self.schema,
            scope=self.scope,
            values=self.values)


def get_generic_settings(filter: Optional[builtins.str] = None,
                         schema: Optional[builtins.str] = None,
                         scope: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGenericSettingsResult:
    """
    The generic settings data source allows Settings 2.0 objects to be retrieved by its schema ID, scope, and/or filter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dynatrace as dynatrace

    example = dynatrace.get_generic_settings(schema="builtin:alerting.maintenance-window")
    pulumi.export("genericSettings", example)
    ```


    :param builtins.str filter: Filter of the requested objects
    :param builtins.str schema: Schema IDs to which the requested objects belong
    :param builtins.str scope: Scope that the requested objects target
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['schema'] = schema
    __args__['scope'] = scope
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dynatrace:index/getGenericSettings:getGenericSettings', __args__, opts=opts, typ=GetGenericSettingsResult).value

    return AwaitableGetGenericSettingsResult(
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        schema=pulumi.get(__ret__, 'schema'),
        scope=pulumi.get(__ret__, 'scope'),
        values=pulumi.get(__ret__, 'values'))
def get_generic_settings_output(filter: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                schema: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                scope: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGenericSettingsResult]:
    """
    The generic settings data source allows Settings 2.0 objects to be retrieved by its schema ID, scope, and/or filter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dynatrace as dynatrace

    example = dynatrace.get_generic_settings(schema="builtin:alerting.maintenance-window")
    pulumi.export("genericSettings", example)
    ```


    :param builtins.str filter: Filter of the requested objects
    :param builtins.str schema: Schema IDs to which the requested objects belong
    :param builtins.str scope: Scope that the requested objects target
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['schema'] = schema
    __args__['scope'] = scope
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dynatrace:index/getGenericSettings:getGenericSettings', __args__, opts=opts, typ=GetGenericSettingsResult)
    return __ret__.apply(lambda __response__: GetGenericSettingsResult(
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        schema=pulumi.get(__response__, 'schema'),
        scope=pulumi.get(__response__, 'scope'),
        values=pulumi.get(__response__, 'values')))
