# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetGeoRegionsResult',
    'AwaitableGetGeoRegionsResult',
    'get_geo_regions',
    'get_geo_regions_output',
]

@pulumi.output_type
class GetGeoRegionsResult:
    """
    A collection of values returned by getGeoRegions.
    """
    def __init__(__self__, country_code=None, id=None, regions=None):
        if country_code and not isinstance(country_code, str):
            raise TypeError("Expected argument 'country_code' to be a str")
        pulumi.set(__self__, "country_code", country_code)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if regions and not isinstance(regions, list):
            raise TypeError("Expected argument 'regions' to be a list")
        pulumi.set(__self__, "regions", regions)

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> builtins.str:
        """
        The ISO code of the required country
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def regions(self) -> Sequence['outputs.GetGeoRegionsRegionResult']:
        return pulumi.get(self, "regions")


class AwaitableGetGeoRegionsResult(GetGeoRegionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGeoRegionsResult(
            country_code=self.country_code,
            id=self.id,
            regions=self.regions)


def get_geo_regions(country_code: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGeoRegionsResult:
    """
    The `get_geo_regions` data source retrieves the list of regions and their codes based on country code.

    - `country_code` (String) - The ISO code of the required country

    Geographic regions API: GET regions of a country - https://docs.dynatrace.com/docs/shortlink/api-v2-rum-geographic-regions-get-regions-country

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dynatrace as dynatrace

    example = dynatrace.get_geo_regions(country_code="FR")
    pulumi.export("test", example)
    ```


    :param builtins.str country_code: The ISO code of the required country
    """
    __args__ = dict()
    __args__['countryCode'] = country_code
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dynatrace:index/getGeoRegions:getGeoRegions', __args__, opts=opts, typ=GetGeoRegionsResult).value

    return AwaitableGetGeoRegionsResult(
        country_code=pulumi.get(__ret__, 'country_code'),
        id=pulumi.get(__ret__, 'id'),
        regions=pulumi.get(__ret__, 'regions'))
def get_geo_regions_output(country_code: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGeoRegionsResult]:
    """
    The `get_geo_regions` data source retrieves the list of regions and their codes based on country code.

    - `country_code` (String) - The ISO code of the required country

    Geographic regions API: GET regions of a country - https://docs.dynatrace.com/docs/shortlink/api-v2-rum-geographic-regions-get-regions-country

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dynatrace as dynatrace

    example = dynatrace.get_geo_regions(country_code="FR")
    pulumi.export("test", example)
    ```


    :param builtins.str country_code: The ISO code of the required country
    """
    __args__ = dict()
    __args__['countryCode'] = country_code
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dynatrace:index/getGeoRegions:getGeoRegions', __args__, opts=opts, typ=GetGeoRegionsResult)
    return __ret__.apply(lambda __response__: GetGeoRegionsResult(
        country_code=pulumi.get(__response__, 'country_code'),
        id=pulumi.get(__response__, 'id'),
        regions=pulumi.get(__response__, 'regions')))
