# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetIamPolicyResult',
    'AwaitableGetIamPolicyResult',
    'get_iam_policy',
    'get_iam_policy_output',
]

@pulumi.output_type
class GetIamPolicyResult:
    """
    A collection of values returned by getIamPolicy.
    """
    def __init__(__self__, account=None, environment=None, id=None, name=None, uuid=None):
        if account and not isinstance(account, str):
            raise TypeError("Expected argument 'account' to be a str")
        pulumi.set(__self__, "account", account)
        if environment and not isinstance(environment, str):
            raise TypeError("Expected argument 'environment' to be a str")
        pulumi.set(__self__, "environment", environment)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if uuid and not isinstance(uuid, str):
            raise TypeError("Expected argument 'uuid' to be a str")
        pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter
    def account(self) -> Optional[builtins.str]:
        """
        The account that policiy is defined for. Omit if the policy is not defined for an account but for an environment or is global
        """
        return pulumi.get(self, "account")

    @property
    @pulumi.getter
    def environment(self) -> Optional[builtins.str]:
        """
        The environment that policiy is defined for. Omit if the policy is not defined for an environment but for an account or is global
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the policy
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def uuid(self) -> builtins.str:
        """
        The UUID of the policy
        """
        return pulumi.get(self, "uuid")


class AwaitableGetIamPolicyResult(GetIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIamPolicyResult(
            account=self.account,
            environment=self.environment,
            id=self.id,
            name=self.name,
            uuid=self.uuid)


def get_iam_policy(account: Optional[builtins.str] = None,
                   environment: Optional[builtins.str] = None,
                   name: Optional[builtins.str] = None,
                   uuid: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIamPolicyResult:
    """
    > **Dynatrace SaaS only**

    > To utilize this resource, please define the environment variables `DT_CLIENT_ID`, `DT_CLIENT_SECRET`, `DT_ACCOUNT_ID` with an OAuth client including the following permissions: **Allow IAM policy configuration for environments** (`iam-policies-management`) and **View environments** (`account-env-read`).

    The IAM policy data source allows the policy UUID to be retrieved by its name and account/environment (exclude for global).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dynatrace as dynatrace

    appengineadmin = dynatrace.get_iam_policy(name="AppEngine - Admin")
    pulumi.export("policies", appengineadmin)
    ```

    ## Example Output


    :param builtins.str account: The account that policiy is defined for. Omit if the policy is not defined for an account but for an environment or is global
    :param builtins.str environment: The environment that policiy is defined for. Omit if the policy is not defined for an environment but for an account or is global
    :param builtins.str name: The name of the policy
    :param builtins.str uuid: The UUID of the policy
    """
    __args__ = dict()
    __args__['account'] = account
    __args__['environment'] = environment
    __args__['name'] = name
    __args__['uuid'] = uuid
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dynatrace:index/getIamPolicy:getIamPolicy', __args__, opts=opts, typ=GetIamPolicyResult).value

    return AwaitableGetIamPolicyResult(
        account=pulumi.get(__ret__, 'account'),
        environment=pulumi.get(__ret__, 'environment'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        uuid=pulumi.get(__ret__, 'uuid'))
def get_iam_policy_output(account: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          environment: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          name: Optional[pulumi.Input[builtins.str]] = None,
                          uuid: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIamPolicyResult]:
    """
    > **Dynatrace SaaS only**

    > To utilize this resource, please define the environment variables `DT_CLIENT_ID`, `DT_CLIENT_SECRET`, `DT_ACCOUNT_ID` with an OAuth client including the following permissions: **Allow IAM policy configuration for environments** (`iam-policies-management`) and **View environments** (`account-env-read`).

    The IAM policy data source allows the policy UUID to be retrieved by its name and account/environment (exclude for global).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dynatrace as dynatrace

    appengineadmin = dynatrace.get_iam_policy(name="AppEngine - Admin")
    pulumi.export("policies", appengineadmin)
    ```

    ## Example Output


    :param builtins.str account: The account that policiy is defined for. Omit if the policy is not defined for an account but for an environment or is global
    :param builtins.str environment: The environment that policiy is defined for. Omit if the policy is not defined for an environment but for an account or is global
    :param builtins.str name: The name of the policy
    :param builtins.str uuid: The UUID of the policy
    """
    __args__ = dict()
    __args__['account'] = account
    __args__['environment'] = environment
    __args__['name'] = name
    __args__['uuid'] = uuid
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dynatrace:index/getIamPolicy:getIamPolicy', __args__, opts=opts, typ=GetIamPolicyResult)
    return __ret__.apply(lambda __response__: GetIamPolicyResult(
        account=pulumi.get(__response__, 'account'),
        environment=pulumi.get(__response__, 'environment'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        uuid=pulumi.get(__response__, 'uuid')))
